/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.ui;

import com.intellij.CommonBundle;
import com.intellij.icons.AllIcons;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.DefaultTreeExpander;
import com.intellij.ide.TreeExpander;
import com.intellij.ide.ui.search.SearchUtil;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.structuralsearch.MatchVariableConstraint;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.inspection.StructuralSearchProfileActionProvider;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.structuralsearch.plugin.ui.ConfigurationManager;
import com.intellij.structuralsearch.plugin.ui.ConfigurationUtil;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ui.GridBagConstraintHolder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.TextTransferable;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.datatransfer.Transferable;
import java.util.Enumeration;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import javax.swing.border.Border;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ExistingTemplatesComponent {
    private static final Pattern SPLIT = Pattern.compile("(?<!/)/(?!/)");
    private final Tree patternTree;
    private final DefaultTreeModel patternTreeModel;
    private final JComponent panel;
    private final JComponent myToolbar;
    private Supplier<? extends Configuration> myConfigurationProducer;
    private Supplier<? extends EditorTextField> mySearchEditorProducer;
    private Runnable myExportRunnable;
    private Runnable myImportRunnable;
    private final DefaultMutableTreeNode myDraftTemplateNode;
    private final DefaultMutableTreeNode myRecentNode;
    private final DefaultMutableTreeNode myUserTemplatesNode;
    private boolean myTemplateChanged = false;
    private boolean myDraftTemplateAutoselect = false;

    ExistingTemplatesComponent(final Project project) {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(null);
        this.patternTreeModel = new DefaultTreeModel(root);
        this.patternTree = ExistingTemplatesComponent.createTree(this.patternTreeModel);
        final ConfigurationManager configurationManager = ConfigurationManager.getInstance(project);
        this.myDraftTemplateNode = new DraftTemplateNode();
        root.add(this.myDraftTemplateNode);
        this.myRecentNode = new DefaultMutableTreeNode(SSRBundle.message("recent.category", new Object[0]));
        root.add(this.myRecentNode);
        for (Configuration config : configurationManager.getHistoryConfigurations()) {
            this.myRecentNode.add(new DefaultMutableTreeNode(config));
        }
        this.patternTree.expandPath(new TreePath(new Object[]{this.patternTreeModel.getRoot(), this.myRecentNode}));
        this.myUserTemplatesNode = new DefaultMutableTreeNode(SSRBundle.message("user.defined.category", new Object[0]));
        root.add(this.myUserTemplatesNode);
        this.reloadUserTemplates(configurationManager);
        for (Configuration info : StructuralSearchUtil.getPredefinedTemplates()) {
            ExistingTemplatesComponent.getOrCreateCategoryNode(root, SPLIT.split(info.getCategory())).add(new DefaultMutableTreeNode(info, false));
        }
        this.patternTreeModel.reload();
        TreeUtil.expandAll((JTree)this.patternTree);
        DefaultTreeExpander treeExpander = new DefaultTreeExpander((JTree)this.patternTree);
        CommonActionsManager actionManager = CommonActionsManager.getInstance();
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        DefaultActionGroup saveGroup = new DefaultActionGroup(SSRBundle.messagePointer("save.template", new Object[0]), SSRBundle.messagePointer("save.template.description.button", new Object[0]), AllIcons.Actions.MenuSaveall);
        DumbAwareAction saveTemplateAction = new DumbAwareAction(SSRBundle.message("save.template.action.text", new Object[0])){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                ConfigurationManager.getInstance(project).showSaveTemplateAsDialog(ExistingTemplatesComponent.this.myConfigurationProducer.get());
                ExistingTemplatesComponent.this.reloadUserTemplates(configurationManager);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/structuralsearch/plugin/ui/ExistingTemplatesComponent$1", "actionPerformed"));
            }
        };
        DumbAwareAction saveInspectionAction = new DumbAwareAction(SSRBundle.message("save.inspection.action.text", new Object[0])){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                StructuralSearchProfileActionProvider.createNewInspection(ExistingTemplatesComponent.this.myConfigurationProducer.get(), project);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/structuralsearch/plugin/ui/ExistingTemplatesComponent$2", "actionPerformed"));
            }
        };
        saveGroup.addAll(new AnAction[]{saveTemplateAction, saveInspectionAction});
        saveGroup.setPopup(true);
        DumbAwareAction removeAction = new DumbAwareAction(SSRBundle.messagePointer("remove.template", new Object[0]), AllIcons.General.Remove){

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                DefaultMutableTreeNode selectedNode = ExistingTemplatesComponent.this.getSelectedNode();
                e.getPresentation().setEnabled(selectedNode != null && selectedNode.isNodeAncestor(ExistingTemplatesComponent.this.myUserTemplatesNode));
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(1);
                }
                ExistingTemplatesComponent.this.removeTemplate(project);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/structuralsearch/plugin/ui/ExistingTemplatesComponent$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        DumbAwareAction exportAction = new DumbAwareAction(SSRBundle.messagePointer("export.template.action", new Object[0]), AllIcons.ToolbarDecorator.Export){

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (ExistingTemplatesComponent.this.mySearchEditorProducer != null) {
                    e.getPresentation().setEnabled(!StringUtil.isEmptyOrSpaces((String)ExistingTemplatesComponent.this.mySearchEditorProducer.get().getText()));
                }
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    4.$$$reportNull$$$0(1);
                }
                if (ExistingTemplatesComponent.this.myExportRunnable != null) {
                    ExistingTemplatesComponent.this.myExportRunnable.run();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/structuralsearch/plugin/ui/ExistingTemplatesComponent$4";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        DumbAwareAction importAction = new DumbAwareAction(SSRBundle.messagePointer("import.template.action", new Object[0]), AllIcons.ToolbarDecorator.Import){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    5.$$$reportNull$$$0(0);
                }
                if (ExistingTemplatesComponent.this.myImportRunnable != null) {
                    ExistingTemplatesComponent.this.myImportRunnable.run();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/structuralsearch/plugin/ui/ExistingTemplatesComponent$5", "actionPerformed"));
            }
        };
        actionGroup.add((AnAction)saveGroup);
        actionGroup.add((AnAction)removeAction);
        actionGroup.add((AnAction)Separator.getInstance());
        actionGroup.addAll(new AnAction[]{actionManager.createExpandAllAction((TreeExpander)treeExpander, (JComponent)this.patternTree), actionManager.createCollapseAllAction((TreeExpander)treeExpander, (JComponent)this.patternTree)});
        actionGroup.add((AnAction)Separator.getInstance());
        actionGroup.add((AnAction)exportAction);
        actionGroup.add((AnAction)importAction);
        ActionToolbarImpl optionsToolbar = (ActionToolbarImpl)ActionManager.getInstance().createActionToolbar("ExistingTemplatesComponent", (ActionGroup)actionGroup, true);
        optionsToolbar.setTargetComponent((JComponent)this.patternTree);
        optionsToolbar.setLayoutPolicy(0);
        optionsToolbar.setForceMinimumSize(true);
        this.myToolbar = optionsToolbar.getComponent();
        this.panel = new JPanel(new GridBagLayout());
        GridBagConstraintHolder constraints = new GridBagConstraintHolder();
        this.panel.add((Component)this.myToolbar, constraints.growX().fillX().get());
        JBScrollPane scrollPane = new JBScrollPane((Component)this.patternTree);
        scrollPane.setBorder((Border)JBUI.Borders.empty());
        this.panel.add((Component)scrollPane, constraints.newLine().growXY().fillXY().get());
        this.panel.setBorder((Border)JBUI.Borders.empty());
    }

    private void reloadUserTemplates(ConfigurationManager configurationManager) {
        this.myUserTemplatesNode.removeAllChildren();
        for (Configuration config : configurationManager.getConfigurations()) {
            this.myUserTemplatesNode.add(new DefaultMutableTreeNode(config));
        }
        this.patternTree.expandPath(new TreePath(new Object[]{this.patternTreeModel.getRoot(), this.myUserTemplatesNode}));
        this.patternTreeModel.reload(this.myUserTemplatesNode);
    }

    private void removeTemplate(Project project) {
        int[] rows;
        Object selection = this.patternTree.getLastSelectedPathComponent();
        if (!(selection instanceof DefaultMutableTreeNode)) {
            return;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)selection;
        if (!(node.getUserObject() instanceof Configuration)) {
            return;
        }
        Configuration configuration = (Configuration)node.getUserObject();
        if (configuration.isPredefined()) {
            return;
        }
        if (((DefaultMutableTreeNode)selection).isNodeAncestor(this.myRecentNode)) {
            return;
        }
        String configurationName = configuration.getName();
        for (Configuration otherConfiguration : ConfigurationManager.getInstance(project).getConfigurations()) {
            String within;
            MatchVariableConstraint constraint = otherConfiguration.getMatchOptions().getVariableConstraint("__context__");
            if (constraint == null || !configurationName.equals(within = constraint.getWithinConstraint())) continue;
            if (2 != Messages.showOkCancelDialog((Project)project, (String)SSRBundle.message("template.in.use.message", configurationName, otherConfiguration.getName()), (String)SSRBundle.message("template.in.use.title", configurationName), (String)CommonBundle.message((String)"button.remove", (Object[])new Object[0]), (String)Messages.getCancelButton(), (Icon)AllIcons.General.WarningDialog)) break;
            return;
        }
        if ((rows = this.patternTree.getSelectionRows()) != null && rows.length > 0) {
            this.patternTree.addSelectionRow(rows[0] - 1);
        }
        this.patternTreeModel.removeNodeFromParent(node);
        ConfigurationManager.getInstance(project).removeConfiguration(configuration);
    }

    public void selectFileType(String name) {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.patternTreeModel.getRoot();
        Enumeration<TreeNode> children = root.children();
        while (children.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)children.nextElement();
            for (String lang : node.toString().split("/")) {
                if (!lang.equals(name)) continue;
                TreeUtil.selectInTree((DefaultMutableTreeNode)node, (boolean)false, (JTree)this.patternTree, (boolean)true);
                return;
            }
        }
    }

    public void templateChanged() {
        if (!this.myTemplateChanged) {
            this.myTemplateChanged = true;
            if (!this.myDraftTemplateNode.equals(this.getSelectedNode())) {
                this.myDraftTemplateAutoselect = true;
                TreeUtil.selectInTree((DefaultMutableTreeNode)this.myDraftTemplateNode, (boolean)false, (JTree)this.patternTree, (boolean)true);
                this.myDraftTemplateAutoselect = false;
            }
        }
    }

    @NotNull
    private static DefaultMutableTreeNode getOrCreateCategoryNode(@NotNull DefaultMutableTreeNode root, String[] path) {
        if (root == null) {
            ExistingTemplatesComponent.$$$reportNull$$$0(0);
        }
        DefaultMutableTreeNode result = root;
        block0: for (String step : path) {
            DefaultMutableTreeNode child;
            step = StringUtil.replace((String)step, (String)"//", (String)"/");
            DefaultMutableTreeNode defaultMutableTreeNode = child = result.getChildCount() == 0 ? null : (DefaultMutableTreeNode)result.getLastChild();
            while (child != null) {
                if (step.equals(child.getUserObject())) {
                    result = child;
                    continue block0;
                }
                child = child.getPreviousSibling();
            }
            DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(step);
            result.add(newNode);
            result = newNode;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = result;
        if (defaultMutableTreeNode == null) {
            ExistingTemplatesComponent.$$$reportNull$$$0(1);
        }
        return defaultMutableTreeNode;
    }

    public void selectConfiguration(String name) {
        DefaultMutableTreeNode node = TreeUtil.findNode((DefaultMutableTreeNode)((DefaultMutableTreeNode)this.patternTreeModel.getRoot()), n -> {
            Object object = n.getUserObject();
            return object instanceof Configuration && name.equals(((Configuration)object).getName());
        });
        TreeUtil.selectInTree((DefaultMutableTreeNode)node, (boolean)false, (JTree)this.patternTree, (boolean)false);
    }

    public DefaultMutableTreeNode getSelectedNode() {
        Object selection = this.patternTree.getLastSelectedPathComponent();
        if (!(selection instanceof DefaultMutableTreeNode)) {
            return null;
        }
        return (DefaultMutableTreeNode)selection;
    }

    private static Tree createTree(TreeModel treeModel) {
        final Tree tree = new Tree(treeModel);
        tree.setRootVisible(false);
        tree.setShowsRootHandles(true);
        tree.setDragEnabled(false);
        tree.setEditable(false);
        tree.getSelectionModel().setSelectionMode(1);
        tree.setTransferHandler(new TransferHandler(){

            @Override
            @Nullable
            protected Transferable createTransferable(JComponent c) {
                Object selection = tree.getLastSelectedPathComponent();
                if (!(selection instanceof DefaultMutableTreeNode)) {
                    return null;
                }
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)selection;
                if (!(node.getUserObject() instanceof Configuration)) {
                    return null;
                }
                return new TextTransferable(ConfigurationUtil.toXml((Configuration)node.getUserObject()));
            }

            @Override
            public int getSourceActions(JComponent c) {
                return 1;
            }
        });
        TreeSpeedSearch speedSearch = new TreeSpeedSearch(tree, object -> {
            Object userObject = ((DefaultMutableTreeNode)object.getLastPathComponent()).getUserObject();
            return userObject instanceof Configuration ? ((Configuration)userObject).getName() : userObject.toString();
        });
        tree.setCellRenderer((TreeCellRenderer)((Object)new ExistingTemplatesTreeCellRenderer(speedSearch)));
        return tree;
    }

    public JComponent getTemplatesPanel() {
        return this.panel;
    }

    public void onConfigurationSelected(Consumer<Configuration> consumer) {
        this.patternTree.addTreeSelectionListener(event -> {
            Object configuration;
            Object selection = this.patternTree.getLastSelectedPathComponent();
            if (!(selection instanceof DefaultMutableTreeNode) || this.myDraftTemplateAutoselect) {
                return;
            }
            if (this.myTemplateChanged) {
                this.myDraftTemplateNode.setUserObject(this.myConfigurationProducer.get());
                this.myTemplateChanged = false;
            }
            if ((configuration = ((DefaultMutableTreeNode)selection).getUserObject()) instanceof Configuration) {
                consumer.accept((Configuration)configuration);
            }
        });
    }

    public void setConfigurationProducer(Supplier<? extends Configuration> configurationProducer) {
        this.myConfigurationProducer = configurationProducer;
    }

    public void setSearchEditorProducer(Supplier<? extends EditorTextField> editorProducer) {
        this.mySearchEditorProducer = editorProducer;
    }

    public void setExportRunnable(Runnable exportRunnable) {
        this.myExportRunnable = exportRunnable;
    }

    public void setImportRunnable(Runnable importRunnable) {
        this.myImportRunnable = importRunnable;
    }

    public void updateColors() {
        this.myToolbar.setBorder(JBUI.Borders.compound((Border)JBUI.Borders.customLineBottom((Color)JBUI.CurrentTheme.Editor.BORDER_COLOR), (Border)JBUI.Borders.empty((int)3)));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/structuralsearch/plugin/ui/ExistingTemplatesComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/structuralsearch/plugin/ui/ExistingTemplatesComponent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateCategoryNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateCategoryNode";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ExistingTemplatesTreeCellRenderer
    extends ColoredTreeCellRenderer {
        private final TreeSpeedSearch mySpeedSearch;

        ExistingTemplatesTreeCellRenderer(TreeSpeedSearch speedSearch) {
            this.mySpeedSearch = speedSearch;
        }

        public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            int style;
            String text;
            DefaultMutableTreeNode treeNode;
            Object userObject;
            if (tree == null) {
                ExistingTemplatesTreeCellRenderer.$$$reportNull$$$0(0);
            }
            if ((userObject = (treeNode = (DefaultMutableTreeNode)value).getUserObject()) == null && !(treeNode instanceof DraftTemplateNode)) {
                return;
            }
            Color background = UIUtil.getTreeBackground((boolean)selected, (boolean)hasFocus);
            Color foreground = UIUtil.getTreeForeground((boolean)selected, (boolean)hasFocus);
            if (treeNode instanceof DraftTemplateNode) {
                text = SSRBundle.message("draft.template.node", new Object[0]);
                style = 1;
            } else if (userObject instanceof Configuration) {
                text = ((Configuration)userObject).getName();
                style = 0;
            } else {
                text = userObject.toString();
                style = 1;
            }
            SearchUtil.appendFragments((String)this.mySpeedSearch.getEnteredPrefix(), (String)text, (int)style, (Color)foreground, (Color)background, (SimpleColoredComponent)this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/structuralsearch/plugin/ui/ExistingTemplatesComponent$ExistingTemplatesTreeCellRenderer", "customizeCellRenderer"));
        }
    }

    private static class DraftTemplateNode
    extends DefaultMutableTreeNode {
        private DraftTemplateNode() {
        }
    }
}

