/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.android.configure;

import com.android.ide.common.repository.GradleCoordinate;
import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.api.ProjectBuildModel;
import com.android.tools.idea.gradle.dsl.api.ext.GradlePropertyModel;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.projectsystem.DependencyManagementException;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ExternalLibraryDescriptor;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmSuppressWildcards;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.android.refactoring.MigrateToAndroidxUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.android.configure.KotlinAndroidGradleModuleConfigurator$WhenMappings;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.idea.configuration.BuildSystemType;
import org.jetbrains.kotlin.idea.configuration.BuildSystemTypeKt;
import org.jetbrains.kotlin.idea.extensions.gradle.GradleBuildScriptManipulator;
import org.jetbrains.kotlin.idea.extensions.gradle.KotlinGradleFacade;
import org.jetbrains.kotlin.idea.extensions.gradle.KotlinGradleFacadeKt;
import org.jetbrains.kotlin.idea.gradleJava.KotlinGradleFacadeImpl;
import org.jetbrains.kotlin.idea.gradleJava.configuration.KotlinWithGradleConfigurator;
import org.jetbrains.kotlin.idea.util.projectStructure.ProjectStructureUtilKt;
import org.jetbrains.kotlin.idea.versions.KotlinRuntimeLibraryUtilKt;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.jvm.JvmPlatforms;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 32\u00020\u0001:\u00013B\u0005\u00a2\u0006\u0002\u0010\u0002J,\u0010\u000f\u001a\u00020\u00102\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u00122\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0004H\u0002J \u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u0015\u001a\u00020\u0004H\u0014J0\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u001d2\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u00122\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u001fH\u0002J(\u0010 \u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0017H\u0016J\u001e\u0010&\u001a\u00020\u00102\u0006\u0010'\u001a\u00020(2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u001d0*H\u0017J\"\u0010+\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0004H\u0002J\u0010\u0010,\u001a\u00020\u00042\u0006\u0010-\u001a\u00020\u0017H\u0014J\u001a\u0010.\u001a\u00020\u00042\b\u0010/\u001a\u0004\u0018\u0001002\u0006\u0010\u0015\u001a\u00020\u0004H\u0014J\b\u0010\r\u001a\u000201H\u0016J\u0010\u00102\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001dH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u00064"}, d2={"Lorg/jetbrains/kotlin/android/configure/KotlinAndroidGradleModuleConfigurator;", "Lorg/jetbrains/kotlin/idea/gradleJava/configuration/KotlinWithGradleConfigurator;", "()V", "kotlinPluginName", "", "getKotlinPluginName", "()Ljava/lang/String;", "name", "getName", "presentableText", "getPresentableText", "targetPlatform", "Lorg/jetbrains/kotlin/platform/TargetPlatform;", "getTargetPlatform", "()Lorg/jetbrains/kotlin/platform/TargetPlatform;", "addDependency", "", "manipulator", "Lorg/jetbrains/kotlin/idea/extensions/gradle/GradleBuildScriptManipulator;", "groupId", "artifactId", "version", "addElementsToFile", "", "file", "Lcom/intellij/psi/PsiFile;", "isTopLevelProjectFile", "addKtxDependenciesFromMap", "module", "Lcom/intellij/openapi/module/Module;", "librayMap", "", "changeGeneralFeatureConfiguration", "feature", "Lorg/jetbrains/kotlin/config/LanguageFeature;", "state", "Lorg/jetbrains/kotlin/config/LanguageFeature$State;", "forTests", "configure", "project", "Lcom/intellij/openapi/project/Project;", "excludeModules", "", "getDependencyVersion", "getKotlinPluginExpression", "forKotlinDsl", "getStdlibArtifactName", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "Lorg/jetbrains/kotlin/resolve/TargetPlatform;", "isApplicable", "Companion", "intellij.android.kotlin.idea"})
public final class KotlinAndroidGradleModuleConfigurator
extends KotlinWithGradleConfigurator {
    @NotNull
    private final String name;
    @NotNull
    private final TargetPlatform targetPlatform = JvmPlatforms.INSTANCE.getDefaultJvmPlatform();
    @NotNull
    private final String presentableText;
    @NotNull
    private final String kotlinPluginName;
    private static final String NAME = "android-gradle";
    private static final String KOTLIN_ANDROID = "kotlin-android";
    private static final String ANDROIDX_CORE_GROUP = "androidx.core";
    private static final String CORE_KTX = "core-ktx";
    private static final Map<String, String> nonAndroidxKtxLibraryMap;
    private static final Map<String, String> androidxKtxLibraryMap;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public TargetPlatform getTargetPlatform() {
        return this.targetPlatform;
    }

    @NotNull
    public org.jetbrains.kotlin.resolve.TargetPlatform getTargetPlatform() {
        return (org.jetbrains.kotlin.resolve.TargetPlatform)JvmPlatforms.CompatJvmPlatform.INSTANCE;
    }

    @NotNull
    public String getPresentableText() {
        return this.presentableText;
    }

    public boolean isApplicable(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return BuildSystemTypeKt.getBuildSystemType((Module)module) == BuildSystemType.AndroidGradle;
    }

    @NotNull
    protected String getKotlinPluginName() {
        return this.kotlinPluginName;
    }

    @NotNull
    protected String getKotlinPluginExpression(boolean forKotlinDsl) {
        return forKotlinDsl ? "kotlin(\"android\")" : "id 'org.jetbrains.kotlin.android' ";
    }

    protected boolean addElementsToFile(@NotNull PsiFile file, boolean isTopLevelProjectFile, @NotNull String version) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        GradleBuildScriptManipulator manipulator = KotlinGradleFacadeKt.getManipulator((KotlinGradleFacade)((KotlinGradleFacade)KotlinGradleFacadeImpl.INSTANCE), (PsiFile)file, (boolean)false);
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)((PsiElement)file));
        if (module == null) {
            return false;
        }
        Intrinsics.checkNotNullExpressionValue((Object)module, (String)"ModuleUtil.findModuleFor\u2026ment(file)?: return false");
        Module module2 = module;
        ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module2);
        Intrinsics.checkNotNullExpressionValue((Object)moduleRootManager, (String)"ModuleRootManager.getInstance(module)");
        Sdk sdk = moduleRootManager.getSdk();
        String jvmTarget = this.getJvmTarget(sdk, version);
        if (isTopLevelProjectFile) {
            bl = manipulator.configureProjectBuildScript(this.getKotlinPluginName(), version);
        } else {
            Project project = file.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"file.project");
            if (MigrateToAndroidxUtil.isAndroidx((Project)project)) {
                this.addDependency(manipulator, ANDROIDX_CORE_GROUP, CORE_KTX, "+");
                this.addKtxDependenciesFromMap(module2, manipulator, androidxKtxLibraryMap);
            }
            this.addKtxDependenciesFromMap(module2, manipulator, nonAndroidxKtxLibraryMap);
            bl = manipulator.configureModuleBuildScript(this.getKotlinPluginName(), this.getKotlinPluginExpression(this.isKtDsl(file)), this.getStdlibArtifactName(sdk, version), version, jvmTarget);
        }
        return bl;
    }

    @NotNull
    protected String getStdlibArtifactName(@Nullable Sdk sdk, @NotNull String version) {
        JavaSdkVersion sdkVersion;
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        if (sdk != null && KotlinRuntimeLibraryUtilKt.hasJreSpecificRuntime((String)version) && (sdkVersion = ProjectStructureUtilKt.getVersion((Sdk)sdk)) != null && sdkVersion.isAtLeast(JavaSdkVersion.JDK_1_8)) {
            return "kotlin-stdlib-jdk7";
        }
        return super.getStdlibArtifactName(sdk, version);
    }

    @JvmSuppressWildcards
    public void configure(@NotNull Project project, @NotNull Collection<Module> excludeModules) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(excludeModules, (String)"excludeModules");
        super.configure(project, excludeModules);
        GradleSyncInvoker.getInstance().requestProjectSync(project, new GradleSyncInvoker.Request(GradleSyncStats.Trigger.TRIGGER_LANGUAGE_KOTLIN_CONFIGURED));
    }

    private final void addDependency(GradleBuildScriptManipulator<?> manipulator, String groupId, String artifactId, String version) {
        manipulator.addKotlinLibraryToModuleBuildScript(DependencyScope.COMPILE, new ExternalLibraryDescriptor(groupId, artifactId, version, version));
    }

    private final String getDependencyVersion(Module module, String groupId, String artifactId) {
        try {
            GradleCoordinate coordinate = new GradleCoordinate(groupId, artifactId, "+");
            GradleCoordinate gradleCoordinate = ProjectSystemUtil.getModuleSystem((Module)module).getResolvedDependency(coordinate);
            return gradleCoordinate != null ? gradleCoordinate.getRevision() : null;
        }
        catch (DependencyManagementException e) {
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void addKtxDependenciesFromMap(Module module, GradleBuildScriptManipulator<?> manipulator, Map<String, String> librayMap) {
        Object object = librayMap;
        Iterator<Map.Entry<String, String>> iterator = object.entrySet().iterator();
        while (iterator.hasNext()) {
            String string;
            void library;
            Map.Entry<String, String> entry;
            Map.Entry<String, String> entry2 = entry = iterator.next();
            object = entry2.getKey();
            entry2 = entry;
            String ktxLibrary = entry2.getValue();
            List ids = StringsKt.split$default((CharSequence)((CharSequence)library), (String[])new String[]{":"}, (boolean)false, (int)0, (int)6, null);
            List ktxIds = StringsKt.split$default((CharSequence)ktxLibrary, (String[])new String[]{":"}, (boolean)false, (int)0, (int)6, null);
            if (this.getDependencyVersion(module, (String)ids.get(0), (String)ids.get(1)) == null) continue;
            String it = string;
            boolean bl = false;
            this.addDependency(manipulator, (String)ktxIds.get(0), (String)ktxIds.get(1), it);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void changeGeneralFeatureConfiguration(@NotNull Module module, @NotNull LanguageFeature feature, @NotNull LanguageFeature.State state, boolean forTests) {
        block12: {
            PsiElement psiElement;
            Pair pair;
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            switch (KotlinAndroidGradleModuleConfigurator$WhenMappings.$EnumSwitchMapping$0[feature.ordinal()]) {
                case 1: {
                    pair = TuplesKt.to((Object)"-Xinline-classes", (Object)"-XXLanguage:-InlineClasses");
                    break;
                }
                default: {
                    pair = TuplesKt.to((Object)("-XXLanguage:+" + feature.name()), (Object)("-XXLanguage:-" + feature.name()));
                }
            }
            Pair pair2 = pair;
            String string = (String)pair2.component1();
            String disabledString = (String)pair2.component2();
            Project project = module.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"module.project");
            Project project2 = project;
            ProjectBuildModel projectBuildModel = ProjectBuildModel.get((Project)project2);
            Intrinsics.checkNotNullExpressionValue((Object)projectBuildModel, (String)"ProjectBuildModel.get(project)");
            ProjectBuildModel projectBuildModel2 = projectBuildModel;
            GradleBuildModel gradleBuildModel = projectBuildModel2.getModuleBuildModel(module);
            if (gradleBuildModel == null) {
                String string2 = "Build model for module " + module + " not found";
                throw new IllegalStateException(string2.toString());
            }
            Intrinsics.checkNotNullExpressionValue((Object)gradleBuildModel, (String)"projectBuildModel.getMod\u2026odule $module not found\")");
            GradleBuildModel moduleBuildModel = gradleBuildModel;
            GradlePropertyModel gradlePropertyModel = moduleBuildModel.android().kotlinOptions().freeCompilerArgs();
            Intrinsics.checkNotNullExpressionValue((Object)gradlePropertyModel, (String)"moduleBuildModel.android\u2026ions().freeCompilerArgs()");
            GradlePropertyModel freeCompilerArgs = gradlePropertyModel;
            switch (KotlinAndroidGradleModuleConfigurator$WhenMappings.$EnumSwitchMapping$1[state.ordinal()]) {
                case 1: {
                    void enabledString;
                    GradlePropertyModel gradlePropertyModel2;
                    GradlePropertyModel gradlePropertyModel3 = freeCompilerArgs.getListValue((Object)disabledString);
                    if (gradlePropertyModel3 != null) {
                        gradlePropertyModel3.delete();
                    }
                    if ((gradlePropertyModel2 = freeCompilerArgs.getListValue((Object)enabledString)) == null) {
                        freeCompilerArgs.addListValue().setValue((Object)enabledString);
                        gradlePropertyModel2 = Unit.INSTANCE;
                    }
                    break;
                }
                case 2: {
                    GradlePropertyModel gradlePropertyModel4;
                    void enabledString;
                    GradlePropertyModel gradlePropertyModel5 = freeCompilerArgs.getListValue((Object)enabledString);
                    if (gradlePropertyModel5 != null) {
                        gradlePropertyModel5.delete();
                    }
                    if ((gradlePropertyModel4 = freeCompilerArgs.getListValue((Object)disabledString)) == null) {
                        freeCompilerArgs.addListValue().setValue((Object)disabledString);
                        gradlePropertyModel4 = Unit.INSTANCE;
                    }
                    break;
                }
                default: {
                    throw (Throwable)new UnsupportedOperationException("Setting a Kotlin language feature to state " + state + " is unsupported in android-kotlin");
                }
            }
            projectBuildModel2.applyChanges();
            moduleBuildModel.reparse();
            GradlePropertyModel gradlePropertyModel6 = moduleBuildModel.android().kotlinOptions().freeCompilerArgs();
            Intrinsics.checkNotNullExpressionValue((Object)gradlePropertyModel6, (String)"moduleBuildModel.android\u2026ions().freeCompilerArgs()");
            PsiElement psiElement2 = gradlePropertyModel6.getPsiElement();
            if (psiElement2 == null) break block12;
            PsiElement it = psiElement = psiElement2;
            boolean bl = false;
            PsiElement psiElement3 = it;
            Intrinsics.checkNotNullExpressionValue((Object)psiElement3, (String)"it");
            PsiFile psiFile = psiElement3.getContainingFile();
            Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"it.containingFile");
            VirtualFile virtualFile = psiFile.getVirtualFile();
            TextRange textRange = it.getTextRange();
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"it.textRange");
            new OpenFileDescriptor(project2, virtualFile, textRange.getStartOffset()).navigate(true);
        }
    }

    public KotlinAndroidGradleModuleConfigurator() {
        this.name = NAME;
        this.presentableText = "Android with Gradle";
        this.kotlinPluginName = KOTLIN_ANDROID;
    }

    static {
        Companion = new Companion(null);
        nonAndroidxKtxLibraryMap = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"android.arch.navigation:navigation-ui", (Object)"android.arch.navigation:navigation-ui-ktx"), TuplesKt.to((Object)"android.arch.navigation:navigation-fragment", (Object)"android.arch.navigation:navigation-fragment-ktx")});
        androidxKtxLibraryMap = MapsKt.mapOf((Pair)TuplesKt.to((Object)"androidx.lifecycle:lifecycle-extensions", (Object)"androidx.lifecycle:lifecycle-viewmodel-ktx"));
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/android/configure/KotlinAndroidGradleModuleConfigurator$Companion;", "", "()V", "ANDROIDX_CORE_GROUP", "", "CORE_KTX", "KOTLIN_ANDROID", "NAME", "androidxKtxLibraryMap", "", "nonAndroidxKtxLibraryMap", "intellij.android.kotlin.idea"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

