/*
 * Decompiled with CFR 0.152.
 */
package training.featuresSuggester.ui;

import com.intellij.ide.BrowserUtil;
import com.intellij.ide.util.TipAndTrickBean;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.util.Alarm;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import training.featuresSuggester.DocumentationSuggestion;
import training.featuresSuggester.FeatureSuggesterBundle;
import training.featuresSuggester.PopupSuggestion;
import training.featuresSuggester.TipSuggestion;
import training.featuresSuggester.settings.FeatureSuggesterSettings;
import training.featuresSuggester.statistics.FeatureSuggesterStatistics;
import training.featuresSuggester.ui.SingleTipDialog;
import training.featuresSuggester.ui.SuggestionPresenter;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\fH\u0002J\"\u0010\r\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0010H\u0002J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J \u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Ltraining/featuresSuggester/ui/NotificationSuggestionPresenter;", "Ltraining/featuresSuggester/ui/SuggestionPresenter;", "()V", "notificationGroup", "Lcom/intellij/notification/NotificationGroup;", "createDontSuggestAction", "Lcom/intellij/openapi/actionSystem/AnAction;", "notification", "Lcom/intellij/notification/Notification;", "suggestion", "Ltraining/featuresSuggester/PopupSuggestion;", "createGoToDocumentationAction", "Ltraining/featuresSuggester/DocumentationSuggestion;", "createShowTipAction", "project", "Lcom/intellij/openapi/project/Project;", "Ltraining/featuresSuggester/TipSuggestion;", "getTipByFilename", "Lcom/intellij/ide/util/TipAndTrickBean;", "tipFilename", "", "showSuggestion", "", "disposable", "Lcom/intellij/openapi/Disposable;", "intellij.featuresTrainer"})
public final class NotificationSuggestionPresenter
implements SuggestionPresenter {
    private final NotificationGroup notificationGroup;

    @Override
    public void showSuggestion(@NotNull Project project, @NotNull PopupSuggestion suggestion, @NotNull Disposable disposable) {
        Notification notification2;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)suggestion, (String)"suggestion");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        Notification $this$apply = notification2 = this.notificationGroup.createNotification(FeatureSuggesterBundle.INSTANCE.message("notification.title", new Object[0]), suggestion.getMessage(), NotificationType.INFORMATION);
        boolean bl = false;
        PopupSuggestion popupSuggestion = suggestion;
        if (popupSuggestion instanceof TipSuggestion) {
            AnAction action2 = this.createShowTipAction(project, $this$apply, (TipSuggestion)suggestion);
            if (action2 != null) {
                $this$apply.addAction(action2);
            }
        } else if (popupSuggestion instanceof DocumentationSuggestion) {
            Intrinsics.checkNotNullExpressionValue((Object)$this$apply.addAction(this.createGoToDocumentationAction($this$apply, (DocumentationSuggestion)suggestion)), (String)"addAction(createGoToDocu\u2026Action(this, suggestion))");
        }
        $this$apply.addAction(this.createDontSuggestAction($this$apply, suggestion));
        Notification notification3 = notification2;
        notification3.notify(project);
        notification2 = (Function0)new Function0<Unit>(notification3){

            public final void invoke() {
                ((Notification)this.receiver).expire();
            }
        };
        new Alarm(disposable).addRequest(new Runnable((Function0)notification2){
            private final /* synthetic */ Function0 function;
            {
                this.function = function0;
            }

            public final /* synthetic */ void run() {
                Intrinsics.checkNotNullExpressionValue((Object)this.function.invoke(), (String)"invoke(...)");
            }
        }, 10000, ModalityState.any());
        FeatureSuggesterStatistics.Companion.logNotificationShowed(suggestion.getSuggesterId());
    }

    private final AnAction createDontSuggestAction(Notification notification2, PopupSuggestion suggestion) {
        return new AnAction(suggestion, notification2, FeatureSuggesterBundle.INSTANCE.message("notification.dont.suggest", new Object[0])){
            final /* synthetic */ PopupSuggestion $suggestion;
            final /* synthetic */ Notification $notification;

            public void actionPerformed(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                FeatureSuggesterSettings settings = FeatureSuggesterSettings.Companion.instance();
                settings.setEnabled(this.$suggestion.getSuggesterId(), false);
                this.$notification.hideBalloon();
                FeatureSuggesterStatistics.Companion.logNotificationDontSuggest(this.$suggestion.getSuggesterId());
            }
            {
                this.$suggestion = $captured_local_variable$0;
                this.$notification = $captured_local_variable$1;
                super($super_call_param$2);
            }
        };
    }

    private final AnAction createGoToDocumentationAction(Notification notification2, DocumentationSuggestion suggestion) {
        Object[] objectArray = new Object[1];
        ApplicationNamesInfo applicationNamesInfo = ApplicationNamesInfo.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)applicationNamesInfo, (String)"ApplicationNamesInfo.getInstance()");
        String string = applicationNamesInfo.getProductName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ApplicationNamesInfo.getInstance().productName");
        objectArray[0] = string;
        return new AnAction(suggestion, notification2, FeatureSuggesterBundle.INSTANCE.message("notification.open.help", objectArray)){
            final /* synthetic */ DocumentationSuggestion $suggestion;
            final /* synthetic */ Notification $notification;

            public void actionPerformed(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                BrowserUtil.open((String)this.$suggestion.getDocumentURL());
                this.$notification.hideBalloon();
                FeatureSuggesterStatistics.Companion.logNotificationLearnMore(this.$suggestion.getSuggesterId());
            }
            {
                this.$suggestion = $captured_local_variable$0;
                this.$notification = $captured_local_variable$1;
                super($super_call_param$2);
            }
        };
    }

    private final AnAction createShowTipAction(Project project, Notification notification2, TipSuggestion suggestion) {
        TipAndTrickBean tipAndTrickBean = this.getTipByFilename(suggestion.getSuggestingTipFilename());
        if (tipAndTrickBean == null) {
            return null;
        }
        TipAndTrickBean tip = tipAndTrickBean;
        return new AnAction(project, tip, notification2, suggestion, FeatureSuggesterBundle.INSTANCE.message("notification.learn.more", new Object[0])){
            final /* synthetic */ Project $project;
            final /* synthetic */ TipAndTrickBean $tip;
            final /* synthetic */ Notification $notification;
            final /* synthetic */ TipSuggestion $suggestion;

            public void actionPerformed(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                SingleTipDialog.Companion.showForProject(this.$project, this.$tip);
                this.$notification.hideBalloon();
                FeatureSuggesterStatistics.Companion.logNotificationLearnMore(this.$suggestion.getSuggesterId());
            }
            {
                this.$project = $captured_local_variable$0;
                this.$tip = $captured_local_variable$1;
                this.$notification = $captured_local_variable$2;
                this.$suggestion = $captured_local_variable$3;
                super($super_call_param$4);
            }
        };
    }

    private final TipAndTrickBean getTipByFilename(String tipFilename) {
        Object object;
        block1: {
            Object[] objectArray;
            Object[] objectArray2;
            ExtensionPointName extensionPointName = TipAndTrickBean.EP_NAME;
            Intrinsics.checkNotNullExpressionValue((Object)extensionPointName, (String)"TipAndTrickBean.EP_NAME");
            Object[] objectArray3 = extensionPointName.getExtensions();
            Intrinsics.checkNotNullExpressionValue((Object)objectArray3, (String)"TipAndTrickBean.EP_NAME.extensions");
            for (Object object2 : objectArray2 = (objectArray = objectArray3)) {
                TipAndTrickBean it = (TipAndTrickBean)object2;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.fileName, (Object)tipFilename)) continue;
                object = object2;
                break block1;
            }
            object = null;
        }
        return (TipAndTrickBean)object;
    }

    public NotificationSuggestionPresenter() {
        NotificationGroup notificationGroup = NotificationGroupManager.getInstance().getNotificationGroup("IDE Feature Suggester");
        Intrinsics.checkNotNullExpressionValue((Object)notificationGroup, (String)"NotificationGroupManager\u2026(\"IDE Feature Suggester\")");
        this.notificationGroup = notificationGroup;
    }
}

