/*
 * Decompiled with CFR 0.152.
 */
package training.learn;

import com.intellij.ide.scratch.RootType;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.ide.scratch.ScratchRootType;
import com.intellij.ide.startup.StartupManagerEx;
import com.intellij.lang.Language;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.TextEditorWithPreview;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ToolWindowType;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.util.Alarm;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.messages.MessageBusConnection;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import training.dsl.LessonUtil;
import training.dsl.impl.LessonContextImpl;
import training.dsl.impl.LessonExecutor;
import training.lang.LangManager;
import training.lang.LangSupport;
import training.learn.CourseManager;
import training.learn.LearnBundle;
import training.learn.NewLearnProjectUtil;
import training.learn.OpenLessonActivities;
import training.learn.OpenLessonActivities$openLessonWhenLearnPanelIsReady$;
import training.learn.OpenLessonActivities$openOnboardingFromWelcomeScreen$1$1$$special$;
import training.learn.OpenLessonActivities$prepareAndOpenLesson$;
import training.learn.OpenLessonParameters;
import training.learn.course.KLesson;
import training.learn.course.Lesson;
import training.learn.course.LessonType;
import training.learn.exceptons.LessonPreparationException;
import training.learn.lesson.LessonListener;
import training.learn.lesson.LessonManager;
import training.project.ProjectUtils;
import training.statistic.LessonStartingWay;
import training.statistic.StatisticBase;
import training.statistic.StatisticLessonListener;
import training.ui.LearnToolWindow;
import training.ui.LearningUiManager;
import training.util.UtilsKt;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J3\u0010\u0011\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\t2!\u0010\u0012\u001a\u001d\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\u0014\u0012\b\b\u0015\u0012\u0004\b\b(\r\u0012\u0004\u0012\u00020\u00070\u0013H\u0002J\u001a\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\tH\u0002J?\u0010\u001d\u001a\u00020\u00072\b\u0010\u001e\u001a\u0004\u0018\u00010\t2\b\u0010\u001f\u001a\u0004\u0018\u00010 2!\u0010\u0012\u001a\u001d\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\u0014\u0012\b\b\u0015\u0012\u0004\b\b(\r\u0012\u0004\u0012\u00020\u00070\u0013H\u0002J\u0010\u0010!\u001a\u00020\u00072\b\u0010\u001f\u001a\u0004\u0018\u00010 J\u0010\u0010\"\u001a\u00020\u00072\u0006\u0010#\u001a\u00020$H\u0007J\u0010\u0010%\u001a\u00020\u00072\u0006\u0010#\u001a\u00020$H\u0002J\u001a\u0010&\u001a\u00020\u00072\u0006\u0010#\u001a\u00020$2\b\u0010'\u001a\u0004\u0018\u00010\u0017H\u0002J\u0010\u0010(\u001a\u00020\u00072\u0006\u0010#\u001a\u00020$H\u0003J\u0018\u0010)\u001a\u00020\u00072\u0006\u0010*\u001a\u00020\u000b2\b\u0010\u001f\u001a\u0004\u0018\u00010 J\u0010\u0010+\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\tH\u0002J\u001a\u0010,\u001a\u00020\u00072\u0006\u0010#\u001a\u00020$2\b\b\u0002\u0010-\u001a\u00020.H\u0002J,\u0010/\u001a\u00020\u00072\u0006\u0010\n\u001a\u0002002\b\u00101\u001a\u0004\u0018\u0001022\u0006\u00103\u001a\u00020\t2\b\u0010'\u001a\u0004\u0018\u00010\u0017H\u0002J\u0018\u00104\u001a\u00020.2\u0006\u0010\u0019\u001a\u00020\t2\u0006\u00105\u001a\u000206H\u0002J\u001a\u00107\u001a\u00020\u00072\u0006\u0010#\u001a\u00020$2\b\u0010'\u001a\u0004\u0018\u00010\u0017H\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Ltraining/learn/OpenLessonActivities;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "addStatisticLessonListenerIfNeeded", "", "currentProject", "Lcom/intellij/openapi/project/Project;", "lesson", "Ltraining/learn/course/Lesson;", "askSwitchToLearnProjectBack", "learnProject", "findLearnProjectInOpenedProjects", "langSupport", "Ltraining/lang/LangSupport;", "finishProjectInitialization", "postInitCallback", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "getFileInLearnProject", "Lcom/intellij/openapi/vfs/VirtualFile;", "getScratchFile", "project", "filename", "", "hideOtherViews", "initLearnProject", "projectToClose", "selectedSdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "openLearnProjectFromWelcomeScreen", "openLesson", "params", "Ltraining/learn/OpenLessonParameters;", "openLessonForPreparedProject", "openLessonWhenLearnPanelIsReady", "vf", "openLessonWhenLearnProjectStart", "openOnboardingFromWelcomeScreen", "onboarding", "openReadme", "prepareAndOpenLesson", "withCleanup", "", "processDslLesson", "Ltraining/learn/course/KLesson;", "textEditor", "Lcom/intellij/openapi/fileEditor/TextEditor;", "projectWhereToStartLesson", "showLearnPanel", "preferredAnchor", "Lcom/intellij/openapi/wm/ToolWindowAnchor;", "waitLearningToolwindow", "intellij.featuresTrainer"})
public final class OpenLessonActivities {
    private static final Logger LOG;
    @NotNull
    public static final OpenLessonActivities INSTANCE;

    @RequiresEdt
    public final void openLesson(@NotNull OpenLessonParameters params) {
        LearnToolWindow activeToolWindow;
        Object object;
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Project projectWhereToStartLesson = params.getProjectWhereToStartLesson();
        LOG.debug(projectWhereToStartLesson.getName() + ": start openLesson method");
        LessonManager.Companion.getInstance().stopLesson();
        LearnToolWindow learnToolWindow = LearningUiManager.INSTANCE.getActiveToolWindow$intellij_featuresTrainer();
        if (learnToolWindow == null) {
            object = UtilsKt.getLearnToolWindowForProject(projectWhereToStartLesson);
            LearnToolWindow it = object;
            boolean bl = false;
            LearningUiManager.INSTANCE.setActiveToolWindow$intellij_featuresTrainer(it);
            learnToolWindow = activeToolWindow = object;
        }
        if (activeToolWindow != null && Intrinsics.areEqual((Object)activeToolWindow.getProject(), (Object)projectWhereToStartLesson) ^ true) {
            activeToolWindow.setModulesPanel$intellij_featuresTrainer();
        }
        if (!params.getForceStartLesson() && LessonManager.Companion.getInstance().lessonShouldBeOpenedCompleted(params.getLesson())) {
            LearnToolWindow learnToolWindow2 = LearningUiManager.INSTANCE.getActiveToolWindow$intellij_featuresTrainer();
            if (learnToolWindow2 == null) {
                object = "No active toolwindow in " + projectWhereToStartLesson;
                throw new IllegalStateException(object.toString());
            }
            learnToolWindow2.setLearnPanel$intellij_featuresTrainer();
            Lesson lesson = params.getLesson();
            if (lesson == null) {
                throw new NullPointerException("null cannot be cast to non-null type training.learn.course.KLesson");
            }
            LessonManager.Companion.getInstance().openLessonPassed$intellij_featuresTrainer((KLesson)lesson, projectWhereToStartLesson);
            return;
        }
        try {
            LangSupport langSupport2 = LangManager.Companion.getInstance().getLangSupport();
            if (langSupport2 == null) {
                throw (Throwable)new Exception("Language for learning plugin is not defined");
            }
            LangSupport langSupport3 = langSupport2;
            Project learnProject = LearningUiManager.INSTANCE.getLearnProject();
            if (learnProject != null && !UtilsKt.isLearningProject(learnProject, langSupport3)) {
                learnProject = null;
            }
            LOG.debug(projectWhereToStartLesson.getName() + ": trying to get cached LearnProject " + (learnProject != null));
            if (learnProject == null) {
                learnProject = this.findLearnProjectInOpenedProjects(langSupport3);
            }
            LOG.debug(projectWhereToStartLesson.getName() + ": trying to find LearnProject in opened projects " + (learnProject != null));
            if (learnProject != null) {
                LearningUiManager.INSTANCE.setLearnProject(learnProject);
            }
            LessonType lessonType = params.getLesson().getLessonType();
            if (lessonType == LessonType.SCRATCH) {
                LOG.debug(projectWhereToStartLesson.getName() + ": scratch based lesson");
            } else if (lessonType == LessonType.USER_PROJECT) {
                LOG.debug("The lesson opened in user project " + projectWhereToStartLesson.getName());
            } else if (learnProject == null || learnProject.isDisposed()) {
                if (!UtilsKt.isLearningProject(projectWhereToStartLesson, langSupport3)) {
                    LOG.debug(projectWhereToStartLesson.getName() + ": 1. learnProject is null or disposed");
                    this.initLearnProject(projectWhereToStartLesson, null, (Function1<? super Project, Unit>)((Function1)new Function1<Project, Unit>(projectWhereToStartLesson, params){
                        final /* synthetic */ Project $projectWhereToStartLesson;
                        final /* synthetic */ OpenLessonParameters $params;

                        public final void invoke(@NotNull Project it) {
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            OpenLessonActivities.access$getLOG$p(OpenLessonActivities.INSTANCE).debug(this.$projectWhereToStartLesson.getName() + ": 1. ... LearnProject has been started");
                            OpenLessonActivities.access$openLessonWhenLearnProjectStart(OpenLessonActivities.INSTANCE, new OpenLessonParameters(it, this.$params.getLesson(), this.$params.getForceStartLesson(), this.$params.getStartingWay()));
                            OpenLessonActivities.access$getLOG$p(OpenLessonActivities.INSTANCE).debug(this.$projectWhereToStartLesson.getName() + ": 1. ... open lesson when learn project has been started");
                        }
                        {
                            this.$projectWhereToStartLesson = project;
                            this.$params = openLessonParameters;
                            super(1);
                        }
                    }));
                    return;
                }
                LOG.debug(projectWhereToStartLesson.getName() + ": 0. learnProject is null but the current project (" + projectWhereToStartLesson.getName() + ")is LearnProject then just getFileInLearnProject");
                LearningUiManager.INSTANCE.setLearnProject(projectWhereToStartLesson);
                learnProject = projectWhereToStartLesson;
            } else {
                if (learnProject.isOpen() && Intrinsics.areEqual((Object)projectWhereToStartLesson, (Object)learnProject) ^ true) {
                    LOG.debug(projectWhereToStartLesson.getName() + ": 3. LearnProject is opened but not focused. Ask user to focus to LearnProject");
                    this.askSwitchToLearnProjectBack(learnProject, projectWhereToStartLesson);
                    return;
                }
                if (learnProject.isOpen() && Intrinsics.areEqual((Object)projectWhereToStartLesson, (Object)learnProject)) {
                    LOG.debug(projectWhereToStartLesson.getName() + ": 4. LearnProject is the current project");
                } else {
                    throw (Throwable)new Exception("Unable to start Learn project");
                }
            }
            if (lessonType.isProject$intellij_featuresTrainer()) {
                if (lessonType == LessonType.USER_PROJECT) {
                    this.prepareAndOpenLesson(params, false);
                } else {
                    if (Intrinsics.areEqual((Object)projectWhereToStartLesson, (Object)learnProject) ^ true) {
                        LOG.error((Throwable)new Exception("Invalid learning project initialization: projectWhereToStartLesson = " + projectWhereToStartLesson + ", learnProject = " + learnProject));
                        return;
                    }
                    OpenLessonActivities.prepareAndOpenLesson$default(this, params, false, 2, null);
                }
            } else {
                this.openLessonForPreparedProject(params);
            }
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void prepareAndOpenLesson(OpenLessonParameters params, boolean withCleanup) {
        void title$iv;
        String string = LearnBundle.INSTANCE.message("learn.project.initializing.process", new Object[0]);
        Project project$iv = params.getProjectWhereToStartLesson();
        boolean cancellable$iv = true;
        boolean $i$f$runBackgroundableTask = false;
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project$iv, (String)title$iv, cancellable$iv, project$iv, (String)title$iv, cancellable$iv, params, withCleanup){
            final /* synthetic */ Project $project;
            final /* synthetic */ String $title;
            final /* synthetic */ boolean $cancellable;
            final /* synthetic */ OpenLessonParameters $params$inlined;
            final /* synthetic */ boolean $withCleanup$inlined;
            {
                this.$project = $captured_local_variable$1;
                this.$title = $captured_local_variable$2;
                this.$cancellable = $captured_local_variable$3;
                this.$params$inlined = openLessonParameters;
                this.$withCleanup$inlined = bl;
                super($super_call_param$4, $super_call_param$5, $super_call_param$6);
            }

            public void run(@NotNull ProgressIndicator indicator) {
                block5: {
                    Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                    ProgressIndicator it = indicator;
                    boolean bl = false;
                    Project project = this.$params$inlined.getProjectWhereToStartLesson();
                    Lesson lessonToOpen = this.$params$inlined.getLesson();
                    try {
                        if (this.$withCleanup$inlined) {
                            LangSupport langSupport2 = LangManager.Companion.getInstance().getLangSupport();
                            if (langSupport2 != null) {
                                langSupport2.cleanupBeforeLessons(project);
                            }
                        }
                        lessonToOpen.prepare(project);
                    }
                    catch (LessonPreparationException e) {
                        OpenLessonActivities $this$thisLogger$iv = OpenLessonActivities.INSTANCE;
                        boolean $i$f$thisLogger = false;
                        Logger logger = Logger.getInstance(OpenLessonActivities.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
                        logger.warn("Error occurred when preparing the lesson " + lessonToOpen.getId(), (Throwable)e);
                        break block5;
                    }
                    catch (Throwable t) {
                        OpenLessonActivities $this$thisLogger$iv = OpenLessonActivities.INSTANCE;
                        boolean $i$f$thisLogger = false;
                        Logger logger = Logger.getInstance(OpenLessonActivities.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
                        logger.error("Error occurred when preparing the lesson " + lessonToOpen.getId(), t);
                        break block5;
                    }
                    ModalityState modalityState$iv = null;
                    boolean $i$f$invokeLater = false;
                    Application application = ApplicationManager.getApplication();
                    Runnable runnable = new Runnable(this){
                        final /* synthetic */ prepareAndOpenLesson$$inlined$runBackgroundableTask$1 this$0;
                        {
                            this.this$0 = var1_1;
                        }

                        public final void run() {
                            boolean bl = false;
                            OpenLessonActivities.access$openLessonForPreparedProject(OpenLessonActivities.INSTANCE, this.this$0.$params$inlined);
                        }
                    };
                    ModalityState modalityState = ModalityState.defaultModalityState();
                    Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"ModalityState.defaultModalityState()");
                    application.invokeLater(runnable, modalityState);
                }
            }
        });
    }

    static /* synthetic */ void prepareAndOpenLesson$default(OpenLessonActivities openLessonActivities, OpenLessonParameters openLessonParameters, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        openLessonActivities.prepareAndOpenLesson(openLessonParameters, bl);
    }

    private final void openLessonForPreparedProject(OpenLessonParameters params) {
        VirtualFile vf;
        VirtualFile virtualFile;
        LangSupport langSupport2 = LangManager.Companion.getInstance().getLangSupport();
        if (langSupport2 == null) {
            throw (Throwable)new Exception("Language should be defined by now");
        }
        LangSupport langSupport3 = langSupport2;
        Project project = params.getProjectWhereToStartLesson();
        Lesson lesson = params.getLesson();
        if (lesson.getLessonType() == LessonType.SCRATCH) {
            LOG.debug(project.getName() + ": scratch based lesson");
            String string = lesson.getSampleFilePath();
            if (string == null) {
                string = langSupport3.getScratchFileName();
            }
            virtualFile = this.getScratchFile(project, lesson, string);
        } else {
            LOG.debug(project.getName() + ": 4. LearnProject is the current project");
            virtualFile = vf = this.getFileInLearnProject(langSupport3, lesson);
        }
        if (lesson.getLessonType() != LessonType.SCRATCH) {
            ProjectUtils.INSTANCE.closeAllEditorsInProject(project);
        }
        if (lesson.getLessonType() != LessonType.SCRATCH || Intrinsics.areEqual((Object)LearningUiManager.INSTANCE.getLearnProject(), (Object)project)) {
            this.hideOtherViews(project);
        }
        if (this.showLearnPanel(project, lesson.preferredLearnWindowAnchor(project))) {
            this.openLessonWhenLearnPanelIsReady(params, vf);
        } else {
            this.waitLearningToolwindow(params, vf);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void openLessonWhenLearnPanelIsReady(OpenLessonParameters params, VirtualFile vf) {
        FileEditor[] editors;
        LearnToolWindow learnToolWindow;
        Object object;
        Project project = params.getProjectWhereToStartLesson();
        LOG.debug(project.getName() + ": Add listeners to lesson");
        this.addStatisticLessonListenerIfNeeded(project, params.getLesson());
        LOG.debug(project.getName() + ": Set lesson view");
        LearningUiManager learningUiManager = LearningUiManager.INSTANCE;
        LearnToolWindow learnToolWindow2 = UtilsKt.getLearnToolWindowForProject(project);
        if (learnToolWindow2 != null) {
            void it;
            LearnToolWindow learnToolWindow3 = learnToolWindow2;
            object = learnToolWindow3;
            LearningUiManager learningUiManager2 = learningUiManager;
            boolean bl = false;
            it.setLearnPanel$intellij_featuresTrainer();
            Unit unit = Unit.INSTANCE;
            learningUiManager = learningUiManager2;
            learnToolWindow = learnToolWindow3;
        } else {
            learnToolWindow = null;
        }
        learningUiManager.setActiveToolWindow$intellij_featuresTrainer(learnToolWindow);
        LOG.debug(project.getName() + ": XmlLesson onStart()");
        params.getLesson().onStart$intellij_featuresTrainer(params.getStartingWay());
        LOG.debug(project.getName() + ": PREPARING TO START LESSON:");
        LOG.debug(project.getName() + ": 1. Open or find editor");
        TextEditor textEditor = null;
        if (vf != null && FileEditorManager.getInstance((Project)project).isFileOpen(vf)) {
            for (FileEditor fileEditor : editors = FileEditorManager.getInstance((Project)project).getEditors(vf)) {
                if (!(fileEditor instanceof TextEditor)) continue;
                textEditor = (TextEditor)fileEditor;
            }
        }
        if (vf != null && textEditor == null) {
            for (FileEditor fileEditor : editors = FileEditorManager.getInstance((Project)project).openFile(vf, true, true)) {
                if (!(fileEditor instanceof TextEditor)) continue;
                textEditor = (TextEditor)fileEditor;
            }
            if (textEditor == null) {
                LOG.error("Cannot open editor for " + vf);
                if (params.getLesson().getLessonType() == LessonType.SCRATCH) {
                    ModalityState modalityState$iv = null;
                    boolean $i$f$invokeLater = false;
                    Application application = ApplicationManager.getApplication();
                    Runnable runnable = new Runnable(vf){
                        final /* synthetic */ VirtualFile $vf$inlined;
                        {
                            this.$vf$inlined = virtualFile;
                        }

                        public final void run() {
                            boolean bl = false;
                            boolean $i$f$runWriteAction = false;
                            ApplicationManager.getApplication().runWriteAction(new Computable(this){
                                final /* synthetic */ openLessonWhenLearnPanelIsReady$$inlined$invokeLater$1 this$0;
                                {
                                    this.this$0 = var1_1;
                                }

                                public final T compute() {
                                    boolean bl = false;
                                    this.this$0.$vf$inlined.delete((Object)OpenLessonActivities.INSTANCE);
                                    return (T)Unit.INSTANCE;
                                }
                            });
                        }
                    };
                    ModalityState modalityState = ModalityState.defaultModalityState();
                    Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"ModalityState.defaultModalityState()");
                    application.invokeLater(runnable, modalityState);
                }
            }
        }
        LOG.debug(project.getName() + ": 2. Set the focus on this editor");
        if (vf != null) {
            FileEditorManager.getInstance((Project)project).openEditor(new OpenFileDescriptor(project, vf), true);
        }
        LOG.debug(project.getName() + ": 4. Process lesson");
        if (!(params.getLesson() instanceof KLesson)) {
            object = "Unknown lesson format";
            throw new IllegalStateException(object.toString());
        }
        this.processDslLesson((KLesson)params.getLesson(), textEditor, project, vf);
    }

    private final void waitLearningToolwindow(OpenLessonParameters params, VirtualFile vf) {
        Project project = params.getProjectWhereToStartLesson();
        MessageBusConnection messageBusConnection = project.getMessageBus().connect();
        Intrinsics.checkNotNullExpressionValue((Object)messageBusConnection, (String)"project.messageBus.connect()");
        MessageBusConnection connect = messageBusConnection;
        connect.subscribe(ToolWindowManagerListener.TOPIC, (Object)new ToolWindowManagerListener(connect, project, params, vf){
            final /* synthetic */ MessageBusConnection $connect;
            final /* synthetic */ Project $project;
            final /* synthetic */ OpenLessonParameters $params;
            final /* synthetic */ VirtualFile $vf;

            public void toolWindowsRegistered(@NotNull List<String> ids, @NotNull ToolWindowManager toolWindowManager) {
                ToolWindow toolWindow;
                Intrinsics.checkNotNullParameter(ids, (String)"ids");
                Intrinsics.checkNotNullParameter((Object)toolWindowManager, (String)"toolWindowManager");
                if (ids.contains("Learn") && (toolWindow = toolWindowManager.getToolWindow("Learn")) != null) {
                    this.$connect.disconnect();
                    ModalityState modalityState$iv = null;
                    boolean $i$f$invokeLater = false;
                    Application application = ApplicationManager.getApplication();
                    Runnable runnable = new Runnable(this){
                        final /* synthetic */ waitLearningToolwindow.1 this$0;
                        {
                            this.this$0 = var1_1;
                        }

                        public final void run() {
                            boolean bl = false;
                            OpenLessonActivities.access$showLearnPanel(OpenLessonActivities.INSTANCE, this.this$0.$project, this.this$0.$params.getLesson().preferredLearnWindowAnchor(this.this$0.$project));
                            OpenLessonActivities.access$openLessonWhenLearnPanelIsReady(OpenLessonActivities.INSTANCE, this.this$0.$params, this.this$0.$vf);
                        }
                    };
                    ModalityState modalityState = ModalityState.defaultModalityState();
                    Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"ModalityState.defaultModalityState()");
                    application.invokeLater(runnable, modalityState);
                }
            }
            {
                this.$connect = $captured_local_variable$0;
                this.$project = $captured_local_variable$1;
                this.$params = $captured_local_variable$2;
                this.$vf = $captured_local_variable$3;
            }
        });
    }

    private final void processDslLesson(KLesson lesson, TextEditor textEditor, Project projectWhereToStartLesson, VirtualFile vf) {
        TextEditor textEditor2 = textEditor;
        LessonExecutor executor2 = new LessonExecutor(lesson, projectWhereToStartLesson, (Editor)(textEditor2 != null ? textEditor2.getEditor() : null), vf);
        LessonContextImpl lessonContext = new LessonContextImpl(executor2);
        TextEditor textEditor3 = textEditor;
        LessonManager.Companion.getInstance().initDslLesson$intellij_featuresTrainer((Editor)(textEditor3 != null ? textEditor3.getEditor() : null), lesson, executor2);
        lesson.getLessonContent().invoke((Object)lessonContext);
        executor2.startLesson();
    }

    private final void hideOtherViews(Project project) {
        ApplicationManager.getApplication().invokeLater(new Runnable(project){
            final /* synthetic */ Project $project;

            public final void run() {
                LessonUtil.INSTANCE.hideStandardToolwindows(this.$project);
            }
            {
                this.$project = project;
            }
        });
    }

    private final void addStatisticLessonListenerIfNeeded(Project currentProject, Lesson lesson) {
        boolean bl;
        StatisticLessonListener statLessonListener;
        block4: {
            statLessonListener = new StatisticLessonListener(currentProject);
            Iterable $this$any$iv = lesson.getLessonListeners$intellij_featuresTrainer();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    LessonListener it = (LessonListener)element$iv;
                    boolean bl2 = false;
                    if (!(it instanceof StatisticLessonListener)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        if (!bl) {
            lesson.addLessonListener(statLessonListener);
        }
    }

    private final void openReadme(Project project) {
        VirtualFile root = ProjectUtils.INSTANCE.getCurrentLearningProjectRoot();
        VirtualFile virtualFile = root.findFileByRelativePath("README.md");
        if (virtualFile == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"root.findFileByRelativePath(\"README.md\") ?: return");
        VirtualFile readme = virtualFile;
        TextEditorWithPreview.openPreviewForFile((Project)project, (VirtualFile)readme);
    }

    public final void openOnboardingFromWelcomeScreen(@NotNull Lesson onboarding, @Nullable Sdk selectedSdk) {
        Intrinsics.checkNotNullParameter((Object)onboarding, (String)"onboarding");
        StatisticBase.Companion.logLearnProjectOpenedForTheFirstTime(StatisticBase.LearnProjectOpeningWay.ONBOARDING_PROMOTER);
        this.initLearnProject(null, selectedSdk, (Function1<? super Project, Unit>)((Function1)new Function1<Project, Unit>(onboarding){
            final /* synthetic */ Lesson $onboarding;

            public final void invoke(@NotNull Project project) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                StartupManager.getInstance((Project)project).runAfterOpened(new Runnable(this, project){
                    final /* synthetic */ openOnboardingFromWelcomeScreen.1 this$0;
                    final /* synthetic */ Project $project;

                    public final void run() {
                        ModalityState modalityState$iv = null;
                        boolean $i$f$invokeLater = false;
                        Application application = ApplicationManager.getApplication();
                        Runnable runnable = new Runnable(this){
                            final /* synthetic */ openOnboardingFromWelcomeScreen.1 this$0;
                            {
                                this.this$0 = var1_1;
                            }

                            public final void run() {
                                boolean bl = false;
                                if (this.this$0.this$0.$onboarding.getProperties().getCanStartInDumbMode()) {
                                    CourseManager.Companion.getInstance().openLesson(this.this$0.$project, this.this$0.this$0.$onboarding, LessonStartingWay.ONBOARDING_PROMOTER, true);
                                } else {
                                    DumbService.getInstance((Project)this.this$0.$project).runWhenSmart(new Runnable(this){
                                        final /* synthetic */ openOnboardingFromWelcomeScreen$1$1$$special$$inlined$invokeLater$1 this$0;
                                        {
                                            this.this$0 = var1_1;
                                        }

                                        public final void run() {
                                            CourseManager.Companion.getInstance().openLesson(this.this$0.this$0.$project, this.this$0.this$0.this$0.$onboarding, LessonStartingWay.ONBOARDING_PROMOTER, true);
                                        }
                                    });
                                }
                            }
                        };
                        ModalityState modalityState = ModalityState.defaultModalityState();
                        Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"ModalityState.defaultModalityState()");
                        application.invokeLater(runnable, modalityState);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$project = project;
                    }
                });
            }
            {
                this.$onboarding = lesson;
                super(1);
            }
        }));
    }

    public final void openLearnProjectFromWelcomeScreen(@Nullable Sdk selectedSdk) {
        StatisticBase.Companion.logLearnProjectOpenedForTheFirstTime(StatisticBase.LearnProjectOpeningWay.LEARN_IDE);
        this.initLearnProject(null, selectedSdk, (Function1<? super Project, Unit>)((Function1)openLearnProjectFromWelcomeScreen.1.INSTANCE));
    }

    private final boolean showLearnPanel(Project project, ToolWindowAnchor preferredAnchor) {
        ToolWindow toolWindow = UtilsKt.learningToolWindow(project);
        if (toolWindow == null) {
            return false;
        }
        ToolWindow learn = toolWindow;
        if (Intrinsics.areEqual((Object)learn.getAnchor(), (Object)preferredAnchor) ^ true && learn.getType() == ToolWindowType.DOCKED) {
            learn.setAnchor(preferredAnchor, null);
        }
        learn.show();
        return true;
    }

    @RequiresEdt
    private final void openLessonWhenLearnProjectStart(OpenLessonParameters params) {
        if (params.getLesson().getProperties().getCanStartInDumbMode()) {
            this.prepareAndOpenLesson(params, false);
            return;
        }
        Project myLearnProject = params.getProjectWhereToStartLesson();
        var $fun$openLesson$1 = new Function0<Unit>(myLearnProject, params){
            final /* synthetic */ Project $myLearnProject;
            final /* synthetic */ OpenLessonParameters $params;

            public final void invoke() {
                ToolWindowManager toolWindowManager = ToolWindowManager.Companion.getInstance(this.$myLearnProject);
                ToolWindow learnToolWindow = toolWindowManager.getToolWindow("Learn");
                if (learnToolWindow != null) {
                    DumbService.getInstance((Project)this.$myLearnProject).runWhenSmart(new Runnable(this){
                        final /* synthetic */ openLessonWhenLearnProjectStart.1 this$0;

                        public final void run() {
                            Function0 openWhenSmart2;
                            Function0 function0 = openWhenSmart2 = (Function0)new Function0<Unit>(this){
                                final /* synthetic */ openLessonWhenLearnProjectStart.1 this$0;

                                public final void invoke() {
                                    DumbService.getInstance((Project)this.this$0.this$0.$myLearnProject).runWhenSmart(new Runnable(this){
                                        final /* synthetic */ openLessonWhenLearnProjectStart.openWhenSmart.1 this$0;

                                        public final void run() {
                                            OpenLessonActivities.access$prepareAndOpenLesson(OpenLessonActivities.INSTANCE, this.this$0.this$0.this$0.$params, false);
                                        }
                                        {
                                            this.this$0 = var1_1;
                                        }
                                    });
                                }
                                {
                                    this.this$0 = var1_1;
                                    super(0);
                                }
                            };
                            new Alarm().addRequest(new Runnable(function0){
                                private final /* synthetic */ Function0 function;
                                {
                                    this.function = function0;
                                }

                                public final /* synthetic */ void run() {
                                    Intrinsics.checkNotNullExpressionValue((Object)this.function.invoke(), (String)"invoke(...)");
                                }
                            }, 500);
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    });
                }
            }
            {
                this.$myLearnProject = project;
                this.$params = openLessonParameters;
                super(0);
            }
        };
        StartupManager startupManager = StartupManager.getInstance((Project)myLearnProject);
        if (startupManager instanceof StartupManagerEx && startupManager.postStartupActivityPassed()) {
            $fun$openLesson$1.invoke();
        } else {
            startupManager.registerPostStartupActivity(new Runnable($fun$openLesson$1){
                final /* synthetic */ openLessonWhenLearnProjectStart.1 $openLesson$1;

                public final void run() {
                    this.$openLesson$1.invoke();
                }
                {
                    this.$openLesson$1 = var1_1;
                }
            });
        }
    }

    private final VirtualFile getScratchFile(Project project, Lesson lesson, String filename) {
        String string = lesson.getLanguageId();
        if (string == null) {
            String string2 = "Scratch lesson " + lesson.getId() + " should define language";
            throw new IllegalStateException(string2.toString());
        }
        String languageId = string;
        Language languageByID = UtilsKt.findLanguageByID(languageId);
        VirtualFile virtualFile = ScratchFileService.getInstance().findFile((RootType)ScratchRootType.getInstance(), filename, ScratchFileService.Option.create_if_missing);
        if (virtualFile == null) {
            String string3 = "Cannot create scratch file " + filename + " for " + languageByID + " language ID in " + project.getName();
            throw new IllegalStateException(string3.toString());
        }
        VirtualFile vf = virtualFile;
        ScratchFileService scratchFileService = ScratchFileService.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)scratchFileService, (String)"ScratchFileService.getInstance()");
        scratchFileService.getScratchesMapping().setMapping(vf, (Object)languageByID);
        FileEditorManager.getInstance((Project)project).closeFile(vf);
        return vf;
    }

    private final void askSwitchToLearnProjectBack(Project learnProject, Project currentProject) {
        Object[] objectArray = new Object[1];
        String string = learnProject.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"learnProject.name");
        objectArray[0] = string;
        Messages.showInfoMessage((Project)currentProject, (String)LearnBundle.INSTANCE.message("dialog.askToSwitchToLearnProject.message", objectArray), (String)LearnBundle.INSTANCE.message("dialog.askToSwitchToLearnProject.title", new Object[0]));
    }

    private final VirtualFile getFileInLearnProject(LangSupport langSupport2, Lesson lesson) {
        if (!lesson.getProperties().getOpenFileAtStart()) {
            LOG.debug(lesson.getName() + " does not open any file at the start");
            return null;
        }
        Computable<VirtualFile> function2 = new Computable<VirtualFile>(lesson, langSupport2){
            final /* synthetic */ Lesson $lesson;
            final /* synthetic */ LangSupport $langSupport;

            @NotNull
            public VirtualFile compute() {
                String string;
                VirtualFile dir;
                VirtualFile virtualFile;
                String string2;
                String string3 = this.$lesson.getSampleFilePath();
                if (string3 == null) {
                    string3 = string2 = this.$lesson.getModule().getSampleFilePath();
                }
                if (string3 == null) {
                    LangSupport langSupport2 = this.$lesson.getModule().getPrimaryLanguage();
                    string2 = langSupport2 != null ? langSupport2.getSampleFilePath() : null;
                }
                if (string2 == null) {
                    String string4 = "No file provided to start lesson " + this.$lesson.getName() + " (" + this.$lesson.getId() + ") for " + this.$langSupport.getPrimaryLanguage() + " course";
                    throw new IllegalStateException(string4.toString());
                }
                String relativeFilePath = string2;
                VirtualFile root = ProjectUtils.INSTANCE.getProjectRoot(this.$langSupport);
                VirtualFile virtualFile2 = root.findFileByRelativePath(relativeFilePath);
                if (virtualFile2 != null) {
                    VirtualFile virtualFile3;
                    VirtualFile it = virtualFile3 = virtualFile2;
                    boolean bl = false;
                    VirtualFile virtualFile4 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFile4, (String)"it");
                    return virtualFile4;
                }
                int lastSeparator = StringsKt.lastIndexOf$default((CharSequence)relativeFilePath, (String)"/", (int)0, (boolean)false, (int)6, null);
                if (lastSeparator != -1) {
                    String bl = relativeFilePath;
                    int n = 0;
                    String string5 = bl.substring(n, lastSeparator);
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    virtualFile = VfsUtil.createDirectoryIfMissing((VirtualFile)root, (String)string5);
                } else {
                    virtualFile = dir = root;
                }
                if (lastSeparator == -1) {
                    string = relativeFilePath;
                } else {
                    String string6 = relativeFilePath;
                    int n = lastSeparator + 1;
                    String string7 = string6.substring(n);
                    Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"this as java.lang.String).substring(startIndex)");
                    string = string7;
                }
                String fileName = string;
                VirtualFile virtualFile5 = dir.createChildData((Object)this, fileName);
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile5, (String)"dir.createChildData(this, fileName)");
                return virtualFile5;
            }
            {
                this.$lesson = $captured_local_variable$0;
                this.$langSupport = $captured_local_variable$1;
            }
        };
        VirtualFile vf = (VirtualFile)ApplicationManager.getApplication().runWriteAction((Computable)function2);
        boolean bl = vf instanceof VirtualFile;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        return vf;
    }

    private final void initLearnProject(Project projectToClose, Sdk selectedSdk, Function1<? super Project, Unit> postInitCallback) {
        LangSupport langSupport2 = LangManager.Companion.getInstance().getLangSupport();
        if (langSupport2 == null) {
            throw (Throwable)new Exception("Language for learning plugin is not defined");
        }
        LangSupport langSupport3 = langSupport2;
        Project project = this.findLearnProjectInOpenedProjects(langSupport3);
        if (project != null) {
            Project project2;
            Project it = project2 = project;
            boolean bl = false;
            postInitCallback.invoke((Object)it);
            return;
        }
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        if (!application.isUnitTestMode() && projectToClose != null && !NewLearnProjectUtil.INSTANCE.showDialogOpenLearnProject(projectToClose)) {
            return;
        }
        try {
            NewLearnProjectUtil.INSTANCE.createLearnProject(projectToClose, langSupport3, selectedSdk, (Function1<? super Project, Unit>)((Function1)new Function1<Project, Unit>(langSupport3, postInitCallback){
                final /* synthetic */ LangSupport $langSupport;
                final /* synthetic */ Function1 $postInitCallback;

                public final void invoke(@NotNull Project learnProject) {
                    Intrinsics.checkNotNullParameter((Object)learnProject, (String)"learnProject");
                    try {
                        this.$langSupport.applyToProjectAfterConfigure().invoke((Object)learnProject);
                    }
                    catch (Throwable e) {
                        OpenLessonActivities.access$getLOG$p(OpenLessonActivities.INSTANCE).error(e);
                        OpenLessonActivities.access$getLOG$p(OpenLessonActivities.INSTANCE).error("The configuration will be retried after 2 seconds");
                        new Alarm().addRequest(new Runnable(this, learnProject){
                            final /* synthetic */ initLearnProject.2 this$0;
                            final /* synthetic */ Project $learnProject;

                            public final void run() {
                                this.this$0.$langSupport.applyToProjectAfterConfigure().invoke((Object)this.$learnProject);
                                OpenLessonActivities.access$finishProjectInitialization(OpenLessonActivities.INSTANCE, this.$learnProject, this.this$0.$postInitCallback);
                            }
                            {
                                this.this$0 = var1_1;
                                this.$learnProject = project;
                            }
                        }, 2000);
                        return;
                    }
                    OpenLessonActivities.access$finishProjectInitialization(OpenLessonActivities.INSTANCE, learnProject, this.$postInitCallback);
                }
                {
                    this.$langSupport = langSupport2;
                    this.$postInitCallback = function1;
                    super(1);
                }
            }));
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    private final void finishProjectInitialization(Project learnProject, Function1<? super Project, Unit> postInitCallback) {
        Application app$iv;
        LearningUiManager.INSTANCE.setLearnProject(learnProject);
        ModalityState modalityState$iv = null;
        boolean $i$f$runInEdt = false;
        Application application = app$iv = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"app");
        if (application.isDispatchThread()) {
            boolean bl = false;
            postInitCallback.invoke((Object)learnProject);
        } else {
            boolean $i$f$invokeLater = false;
            Application application2 = ApplicationManager.getApplication();
            Runnable runnable = new Runnable(postInitCallback, learnProject){
                final /* synthetic */ Function1 $postInitCallback$inlined;
                final /* synthetic */ Project $learnProject$inlined;
                {
                    this.$postInitCallback$inlined = function1;
                    this.$learnProject$inlined = project;
                }

                public final void run() {
                    boolean bl = false;
                    this.$postInitCallback$inlined.invoke((Object)this.$learnProject$inlined);
                }
            };
            ModalityState modalityState = ModalityState.defaultModalityState();
            Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"ModalityState.defaultModalityState()");
            application2.invokeLater(runnable, modalityState);
        }
    }

    private final Project findLearnProjectInOpenedProjects(LangSupport langSupport2) {
        Project project;
        block1: {
            Project[] openProjects;
            ProjectManager projectManager = ProjectManager.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)projectManager, (String)"ProjectManager.getInstance()");
            Project[] projectArray = projectManager.getOpenProjects();
            Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"ProjectManager.getInstance().openProjects");
            Project[] $this$firstOrNull$iv = openProjects = projectArray;
            boolean $i$f$firstOrNull = false;
            for (Project element$iv : $this$firstOrNull$iv) {
                Project it = element$iv;
                boolean bl = false;
                Project project2 = it;
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"it");
                if (!UtilsKt.isLearningProject(project2, langSupport2)) continue;
                project = element$iv;
                break block1;
            }
            project = null;
        }
        return project;
    }

    private OpenLessonActivities() {
    }

    static {
        OpenLessonActivities openLessonActivities;
        INSTANCE = openLessonActivities = new OpenLessonActivities();
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(OpenLessonActivities.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }

    public static final /* synthetic */ Logger access$getLOG$p(OpenLessonActivities $this) {
        OpenLessonActivities openLessonActivities = $this;
        return LOG;
    }

    public static final /* synthetic */ void access$openLessonWhenLearnProjectStart(OpenLessonActivities $this, OpenLessonParameters params) {
        $this.openLessonWhenLearnProjectStart(params);
    }

    public static final /* synthetic */ void access$openLessonForPreparedProject(OpenLessonActivities $this, OpenLessonParameters params) {
        $this.openLessonForPreparedProject(params);
    }

    public static final /* synthetic */ boolean access$showLearnPanel(OpenLessonActivities $this, Project project, ToolWindowAnchor preferredAnchor) {
        return $this.showLearnPanel(project, preferredAnchor);
    }

    public static final /* synthetic */ void access$openLessonWhenLearnPanelIsReady(OpenLessonActivities $this, OpenLessonParameters params, VirtualFile vf) {
        $this.openLessonWhenLearnPanelIsReady(params, vf);
    }

    public static final /* synthetic */ void access$openReadme(OpenLessonActivities $this, Project project) {
        $this.openReadme(project);
    }

    public static final /* synthetic */ void access$hideOtherViews(OpenLessonActivities $this, Project project) {
        $this.hideOtherViews(project);
    }

    public static final /* synthetic */ void access$prepareAndOpenLesson(OpenLessonActivities $this, OpenLessonParameters params, boolean withCleanup) {
        $this.prepareAndOpenLesson(params, withCleanup);
    }

    public static final /* synthetic */ void access$finishProjectInitialization(OpenLessonActivities $this, Project learnProject, Function1 postInitCallback) {
        $this.finishProjectInitialization(learnProject, (Function1<? super Project, Unit>)postInitCallback);
    }
}

