/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.validation.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.Language;
import com.intellij.psi.PsiElement;
import org.intellij.lang.xpath.XPathFileType;
import org.intellij.lang.xpath.XPathTokenTypes;
import org.intellij.lang.xpath.psi.XPathBinaryExpression;
import org.intellij.lang.xpath.psi.XPathExpression;
import org.intellij.lang.xpath.psi.XPathFunctionCall;
import org.intellij.lang.xpath.psi.XPathString;
import org.intellij.lang.xpath.validation.inspections.XPathInspection;
import org.intellij.plugins.xpathView.XPathBundle;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class HardwiredNamespacePrefix
extends XPathInspection {
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    protected XPathInspection.Visitor createVisitor(final InspectionManager manager, final boolean isOnTheFly) {
        return new XPathInspection.Visitor(manager, isOnTheFly){

            @Override
            protected void checkExpression(XPathExpression expression) {
                if (!(expression instanceof XPathBinaryExpression)) {
                    return;
                }
                XPathBinaryExpression expr = (XPathBinaryExpression)expression;
                if (expr.getOperator() == XPathTokenTypes.EQ) {
                    XPathExpression rop;
                    XPathExpression lop = expr.getLOperand();
                    if (HardwiredNamespacePrefix.isNameComparison(lop, rop = expr.getROperand())) {
                        assert (rop != null);
                        ProblemDescriptor p = manager.createProblemDescriptor((PsiElement)rop, XPathBundle.message("inspection.message.hardwired.namespace.prefix", new Object[0]), isOnTheFly, LocalQuickFix.EMPTY_ARRAY, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
                        this.addProblem(p);
                    } else if (HardwiredNamespacePrefix.isNameComparison(rop, lop)) {
                        assert (lop != null);
                        ProblemDescriptor p = manager.createProblemDescriptor((PsiElement)lop, XPathBundle.message("inspection.message.hardwired.namespace.prefix", new Object[0]), isOnTheFly, LocalQuickFix.EMPTY_ARRAY, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
                        this.addProblem(p);
                    } else if (HardwiredNamespacePrefix.isNameFunctionCall(lop) || HardwiredNamespacePrefix.isNameFunctionCall(rop)) {
                        // empty if block
                    }
                }
            }
        };
    }

    private static boolean isNameComparison(XPathExpression op1, XPathExpression op2) {
        if (!HardwiredNamespacePrefix.isNameFunctionCall(op1)) {
            return false;
        }
        if (!(op2 instanceof XPathString)) {
            return false;
        }
        String value = ((XPathString)op2).getValue();
        return value != null && value.contains(":");
    }

    private static boolean isNameFunctionCall(XPathExpression op1) {
        if (!(op1 instanceof XPathFunctionCall)) {
            return false;
        }
        XPathFunctionCall fc = (XPathFunctionCall)op1;
        return "name".equals(fc.getFunctionName());
    }

    @NonNls
    @NotNull
    public String getShortName() {
        return "HardwiredNamespacePrefix";
    }

    @Override
    protected boolean acceptsLanguage(Language language) {
        return language == XPathFileType.XPATH.getLanguage() || language == XPathFileType.XPATH2.getLanguage();
    }
}

