/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.associations.impl;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.ide.util.treeView.TreeState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import javax.swing.JComponent;
import org.intellij.lang.xpath.xslt.associations.impl.AssociationsEditor;
import org.intellij.plugins.xpathView.XPathBundle;
import org.jetbrains.annotations.NotNull;

public final class FileAssociationsConfigurable
implements SearchableConfigurable,
Configurable.NoScroll {
    private final Project myProject;
    private final UIState myState;
    private AssociationsEditor myEditor;

    public FileAssociationsConfigurable(Project project) {
        this.myProject = project;
        this.myState = (UIState)project.getService(UIState.class);
    }

    public String getDisplayName() {
        return XPathBundle.message("configurable.FileAssociationsConfigurable.display.name", new Object[0]);
    }

    @NotNull
    public String getHelpTopic() {
        return "xslt.associations";
    }

    public JComponent createComponent() {
        this.myEditor = (AssociationsEditor)ReadAction.compute(() -> new AssociationsEditor(this.myProject, this.myState.state));
        return this.myEditor.getComponent();
    }

    public boolean isModified() {
        return this.myEditor != null && this.myEditor.isModified();
    }

    public void apply() {
        this.myEditor.apply();
        DaemonCodeAnalyzer.getInstance((Project)this.myProject).restart();
    }

    public void reset() {
        this.myEditor.reset();
    }

    public void disposeUIResources() {
        if (this.myEditor != null) {
            this.myState.state = this.myEditor.getState();
            this.myEditor.dispose();
            this.myEditor = null;
        }
    }

    public AssociationsEditor getEditor() {
        return this.myEditor;
    }

    public static void editAssociations(Project project, PsiFile file) {
        FileAssociationsConfigurable instance = new FileAssociationsConfigurable(project);
        ShowSettingsUtil.getInstance().editConfigurable(project, (Configurable)instance, () -> {
            AssociationsEditor editor = instance.getEditor();
            if (file != null) {
                editor.select(file);
            }
        });
    }

    @NotNull
    public String getId() {
        String string = this.getHelpTopic();
        if (string == null) {
            FileAssociationsConfigurable.$$$reportNull$$$0(0);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/associations/impl/FileAssociationsConfigurable", "getId"));
    }

    @State(name="XSLT-Support.FileAssociations.UIState", storages={@Storage(value="$WORKSPACE_FILE$")})
    public static class UIState
    implements PersistentStateComponent<TreeState> {
        private TreeState state;

        public TreeState getState() {
            return this.state != null ? this.state : TreeState.createFrom(null);
        }

        public void loadState(@NotNull TreeState state) {
            if (state == null) {
                UIState.$$$reportNull$$$0(0);
            }
            this.state = state;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/intellij/lang/xpath/xslt/associations/impl/FileAssociationsConfigurable$UIState", "loadState"));
        }
    }
}

