/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.HashOrderMixing;
import com.carrotsearch.hppc.IntIntHashMap;

public class IntIntScatterMap
extends IntIntHashMap {
    public IntIntScatterMap() {
        this(4);
    }

    public IntIntScatterMap(int expectedElements) {
        this(expectedElements, 0.75);
    }

    public IntIntScatterMap(int expectedElements, double loadFactor) {
        super(expectedElements, loadFactor, HashOrderMixing.none());
    }

    @Override
    protected int hashKey(int key) {
        return BitMixer.mixPhi(key);
    }

    public static IntIntScatterMap from(int[] keys, int[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        IntIntScatterMap map2 = new IntIntScatterMap(keys.length);
        for (int i2 = 0; i2 < keys.length; ++i2) {
            map2.put(keys[i2], values[i2]);
        }
        return map2;
    }
}

