/*
 * Decompiled with CFR 0.152.
 */
package tech.units.indriya.internal.format;

import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import javax.measure.Unit;
import tech.units.indriya.AbstractUnit;
import tech.units.indriya.format.SymbolMap;
import tech.units.indriya.function.LogConverter;
import tech.units.indriya.function.MultiplyConverter;
import tech.units.indriya.internal.format.DefaultCharStream;
import tech.units.indriya.internal.format.Token;
import tech.units.indriya.internal.format.TokenException;
import tech.units.indriya.internal.format.UnitTokenConstants;
import tech.units.indriya.internal.format.UnitTokenManager;
import tech.units.indriya.unit.Prefix;

public final class LocalUnitFormatParser {
    private SymbolMap symbols;
    public UnitTokenManager tokenSource;
    private DefaultCharStream inputStream;
    public Token token;
    public Token nextToken;
    private int nextTokenIndex;
    private Token scanpos;
    private Token lastpos;
    private int laInt;
    private int genInt;
    private final int[] laA = new int[19];
    private static int[] laB;
    private final JJCalls[] rtns = new JJCalls[2];
    private boolean rescan = false;
    private int gcInt = 0;
    private final List<int[]> expentries = new ArrayList<int[]>();
    private int[] expentry;
    private int kind = -1;
    private final int[] lastTokens = new int[100];
    private int endpos;

    public LocalUnitFormatParser(SymbolMap symbols, Reader in) {
        this(in);
        this.symbols = symbols;
    }

    public final Unit parseUnit() throws TokenException {
        Unit result = this.compoundExpr();
        this.consumeToken(0);
        return result;
    }

    public final Unit compoundExpr() throws TokenException {
        throw new UnsupportedOperationException("Compound units not supported");
    }

    public final Unit addExpr() throws TokenException {
        Unit result = AbstractUnit.ONE;
        Number n1 = null;
        Token sign1 = null;
        Number n2 = null;
        Token sign2 = null;
        if (this.jj_2_1(Integer.MAX_VALUE)) {
            n1 = this.numberExpr();
            sign1 = this.sign();
        }
        result = this.mulExpr();
        switch (this.nextTokenIndex == -1 ? this.jj_ntk() : this.nextTokenIndex) {
            case 5: 
            case 6: {
                sign2 = this.sign();
                n2 = this.numberExpr();
                break;
            }
            default: {
                this.laA[1] = this.genInt;
            }
        }
        if (n1 != null) {
            if (sign1.image.equals("-")) {
                result = result.multiply(-1.0);
            }
            result = result.shift(n1.doubleValue());
        }
        if (n2 != null) {
            double offset = n2.doubleValue();
            if (sign2.image.equals("-")) {
                offset = -offset;
            }
            result = result.shift(offset);
        }
        return result;
    }

    public final Unit mulExpr() throws TokenException {
        Unit<?> result;
        block12: {
            result = AbstractUnit.ONE;
            Unit temp = AbstractUnit.ONE;
            result = this.exponentExpr();
            block11: while (true) {
                switch (this.nextTokenIndex == -1 ? this.jj_ntk() : this.nextTokenIndex) {
                    case 7: 
                    case 8: 
                    case 9: {
                        break;
                    }
                    default: {
                        this.laA[2] = this.genInt;
                        break block12;
                    }
                }
                switch (this.nextTokenIndex == -1 ? this.jj_ntk() : this.nextTokenIndex) {
                    case 7: 
                    case 8: {
                        switch (this.nextTokenIndex == -1 ? this.jj_ntk() : this.nextTokenIndex) {
                            case 7: {
                                this.consumeToken(7);
                                break;
                            }
                            case 8: {
                                this.consumeToken(8);
                                break;
                            }
                            default: {
                                this.laA[3] = this.genInt;
                                this.consumeToken(-1);
                                throw new TokenException();
                            }
                        }
                        temp = this.exponentExpr();
                        result = result.multiply(temp);
                        continue block11;
                    }
                    case 9: {
                        this.consumeToken(9);
                        temp = this.exponentExpr();
                        result = result.divide(temp);
                        continue block11;
                    }
                }
                break;
            }
            this.laA[4] = this.genInt;
            this.consumeToken(-1);
            throw new TokenException();
        }
        return result;
    }

    public final Unit exponentExpr() throws TokenException {
        Unit<?> result = AbstractUnit.ONE;
        Exponent exponent = null;
        Token token = null;
        if (this.jj_2_2(Integer.MAX_VALUE)) {
            switch (this.nextTokenIndex == -1 ? this.jj_ntk() : this.nextTokenIndex) {
                case 14: {
                    token = this.consumeToken(14);
                    break;
                }
                case 19: {
                    token = this.consumeToken(19);
                    break;
                }
                default: {
                    this.laA[5] = this.genInt;
                    this.consumeToken(-1);
                    throw new TokenException();
                }
            }
            this.consumeToken(10);
            result = this.atomicExpr();
            double base2 = token.kind == 14 ? (double)Integer.parseInt(token.image) : Math.E;
            return result.transform(new LogConverter(base2).inverse());
        }
        switch (this.nextTokenIndex == -1 ? this.jj_ntk() : this.nextTokenIndex) {
            case 12: 
            case 14: 
            case 16: 
            case 20: {
                result = this.atomicExpr();
                switch (this.nextTokenIndex == -1 ? this.jj_ntk() : this.nextTokenIndex) {
                    case 10: 
                    case 15: {
                        exponent = this.exp();
                        break;
                    }
                    default: {
                        this.laA[6] = this.genInt;
                    }
                }
                if (exponent != null) {
                    if (exponent.pow != 1) {
                        result = result.pow(exponent.pow);
                    }
                    if (exponent.root != 1) {
                        result = result.root(exponent.root);
                    }
                }
                return result;
            }
            case 17: 
            case 18: {
                block11 : switch (this.nextTokenIndex == -1 ? this.jj_ntk() : this.nextTokenIndex) {
                    case 17: {
                        this.consumeToken(17);
                        switch (this.nextTokenIndex == -1 ? this.jj_ntk() : this.nextTokenIndex) {
                            case 14: {
                                token = this.consumeToken(14);
                                break block11;
                            }
                        }
                        this.laA[7] = this.genInt;
                        break;
                    }
                    case 18: {
                        token = this.consumeToken(18);
                        break;
                    }
                    default: {
                        this.laA[8] = this.genInt;
                        this.consumeToken(-1);
                        throw new TokenException();
                    }
                }
                this.consumeToken(12);
                result = this.addExpr();
                this.consumeToken(13);
                double base3 = 10.0;
                if (token != null) {
                    if (token.kind == 14) {
                        base3 = Integer.parseInt(token.image);
                    } else if (token.kind == 18) {
                        base3 = Math.E;
                    }
                }
                return result.transform(new LogConverter(base3));
            }
        }
        this.laA[9] = this.genInt;
        this.consumeToken(-1);
        throw new TokenException();
    }

    public final Unit atomicExpr() throws TokenException {
        Unit result = AbstractUnit.ONE;
        Number n = null;
        Token token = null;
        switch (this.nextTokenIndex == -1 ? this.jj_ntk() : this.nextTokenIndex) {
            case 14: 
            case 16: {
                n = this.numberExpr();
                if (n instanceof Integer) {
                    return result.multiply(n.intValue());
                }
                return result.multiply(n.doubleValue());
            }
            case 20: {
                token = this.consumeToken(20);
                Unit<?> unit = this.symbols.getUnit(token.image);
                if (unit == null) {
                    String prefixSymbol;
                    Prefix prefix = this.symbols.getPrefix(token.image);
                    if (prefix != null && (unit = this.symbols.getUnit(token.image.substring((prefixSymbol = this.symbols.getSymbol(prefix)).length()))) != null) {
                        return unit.transform(MultiplyConverter.of(prefix));
                    }
                    throw new TokenException();
                }
                return unit;
            }
            case 12: {
                this.consumeToken(12);
                result = this.addExpr();
                this.consumeToken(13);
                return result;
            }
        }
        this.laA[10] = this.genInt;
        this.consumeToken(-1);
        throw new TokenException();
    }

    public final Token sign() throws TokenException {
        Token result = null;
        switch (this.nextTokenIndex == -1 ? this.jj_ntk() : this.nextTokenIndex) {
            case 5: {
                result = this.consumeToken(5);
                break;
            }
            case 6: {
                result = this.consumeToken(6);
                break;
            }
            default: {
                this.laA[11] = this.genInt;
                this.consumeToken(-1);
                throw new TokenException();
            }
        }
        return result;
    }

    public final Number numberExpr() throws TokenException {
        Token token = null;
        switch (this.nextTokenIndex == -1 ? this.jj_ntk() : this.nextTokenIndex) {
            case 14: {
                token = this.consumeToken(14);
                return Long.valueOf(token.image);
            }
            case 16: {
                token = this.consumeToken(16);
                return Double.valueOf(token.image);
            }
        }
        this.laA[12] = this.genInt;
        this.consumeToken(-1);
        throw new TokenException();
    }

    public final Exponent exp() throws TokenException {
        Token powSign = null;
        Token powToken = null;
        Token rootSign = null;
        Token rootToken = null;
        switch (this.nextTokenIndex == -1 ? this.jj_ntk() : this.nextTokenIndex) {
            case 10: {
                this.consumeToken(10);
                switch (this.nextTokenIndex == -1 ? this.jj_ntk() : this.nextTokenIndex) {
                    case 5: 
                    case 6: 
                    case 14: {
                        switch (this.nextTokenIndex == -1 ? this.jj_ntk() : this.nextTokenIndex) {
                            case 5: 
                            case 6: {
                                powSign = this.sign();
                                break;
                            }
                            default: {
                                this.laA[13] = this.genInt;
                            }
                        }
                        powToken = this.consumeToken(14);
                        int pow = Integer.parseInt(powToken.image);
                        if (powSign != null && powSign.image.equals("-")) {
                            pow = -pow;
                        }
                        return new Exponent(pow, 1);
                    }
                    case 12: {
                        this.consumeToken(12);
                        switch (this.nextTokenIndex == -1 ? this.jj_ntk() : this.nextTokenIndex) {
                            case 5: 
                            case 6: {
                                powSign = this.sign();
                                break;
                            }
                            default: {
                                this.laA[14] = this.genInt;
                            }
                        }
                        powToken = this.consumeToken(14);
                        switch (this.nextTokenIndex == -1 ? this.jj_ntk() : this.nextTokenIndex) {
                            case 9: {
                                this.consumeToken(9);
                                switch (this.nextTokenIndex == -1 ? this.jj_ntk() : this.nextTokenIndex) {
                                    case 5: 
                                    case 6: {
                                        rootSign = this.sign();
                                        break;
                                    }
                                    default: {
                                        this.laA[15] = this.genInt;
                                    }
                                }
                                rootToken = this.consumeToken(14);
                                break;
                            }
                            default: {
                                this.laA[16] = this.genInt;
                            }
                        }
                        this.consumeToken(13);
                        int pow = Integer.parseInt(powToken.image);
                        if (powSign != null && powSign.image.equals("-")) {
                            pow = -pow;
                        }
                        int root = 1;
                        if (rootToken != null) {
                            root = Integer.parseInt(rootToken.image);
                            if (rootSign != null && rootSign.image.equals("-")) {
                                root = -root;
                            }
                        }
                        return new Exponent(pow, root);
                    }
                }
                this.laA[17] = this.genInt;
                this.consumeToken(-1);
                throw new TokenException();
            }
            case 15: {
                powToken = this.consumeToken(15);
                int pow = 0;
                block31: for (int i2 = 0; i2 < powToken.image.length(); ++i2) {
                    pow *= 10;
                    switch (powToken.image.charAt(i2)) {
                        case '\u00b9': {
                            ++pow;
                            continue block31;
                        }
                        case '\u00b2': {
                            pow += 2;
                            continue block31;
                        }
                        case '\u00b3': {
                            pow += 3;
                            continue block31;
                        }
                        case '\u2074': {
                            pow += 4;
                            continue block31;
                        }
                        case '\u2075': {
                            pow += 5;
                            continue block31;
                        }
                        case '\u2076': {
                            pow += 6;
                            continue block31;
                        }
                        case '\u2077': {
                            pow += 7;
                            continue block31;
                        }
                        case '\u2078': {
                            pow += 8;
                            continue block31;
                        }
                        case '\u2079': {
                            pow += 9;
                        }
                    }
                }
                return new Exponent(pow, 1);
            }
        }
        this.laA[18] = this.genInt;
        this.consumeToken(-1);
        throw new TokenException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_1(int xla) {
        this.laInt = xla;
        this.lastpos = this.scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_2(int xla) {
        this.laInt = xla;
        this.lastpos = this.scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, xla);
        }
    }

    private boolean jj_3R_3() {
        Token xsp = this.scanpos;
        if (this.jj_3R_5()) {
            this.scanpos = xsp;
            if (this.jj_3R_6()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_6() {
        return this.scanToken(16);
    }

    private boolean jj_3_2() {
        Token xsp = this.scanpos;
        if (this.scanToken(14)) {
            this.scanpos = xsp;
            if (this.scanToken(19)) {
                return true;
            }
        }
        return this.scanToken(10);
    }

    private boolean jj_3_1() {
        return this.jj_3R_3() || this.jj_3R_4();
    }

    private boolean jj_3R_4() {
        Token xsp = this.scanpos;
        if (this.scanToken(5)) {
            this.scanpos = xsp;
            if (this.scanToken(6)) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_5() {
        return this.scanToken(14);
    }

    private static void init() {
        laB = new int[]{2048, 96, 896, 384, 896, 540672, 33792, 16384, 393216, 1527808, 0x115000, 96, 81920, 96, 96, 96, 512, 20576, 33792};
    }

    public LocalUnitFormatParser(InputStream stream) {
        this(stream, null);
    }

    public LocalUnitFormatParser(InputStream stream, String encoding) {
        int i2;
        try {
            this.inputStream = new DefaultCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.tokenSource = new UnitTokenManager(this.inputStream);
        this.token = new Token();
        this.nextTokenIndex = -1;
        this.genInt = 0;
        for (i2 = 0; i2 < 19; ++i2) {
            this.laA[i2] = -1;
        }
        for (i2 = 0; i2 < this.rtns.length; ++i2) {
            this.rtns[i2] = new JJCalls();
        }
    }

    public void reInit(InputStream stream) {
        this.reInit(stream, null);
    }

    public void reInit(InputStream stream, String encoding) {
        int i2;
        try {
            this.inputStream.reInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.tokenSource.reInit(this.inputStream);
        this.token = new Token();
        this.nextTokenIndex = -1;
        this.genInt = 0;
        for (i2 = 0; i2 < 19; ++i2) {
            this.laA[i2] = -1;
        }
        for (i2 = 0; i2 < this.rtns.length; ++i2) {
            this.rtns[i2] = new JJCalls();
        }
    }

    public LocalUnitFormatParser(Reader stream) {
        int i2;
        this.inputStream = new DefaultCharStream(stream, 1, 1);
        this.tokenSource = new UnitTokenManager(this.inputStream);
        this.token = new Token();
        this.nextTokenIndex = -1;
        this.genInt = 0;
        for (i2 = 0; i2 < 19; ++i2) {
            this.laA[i2] = -1;
        }
        for (i2 = 0; i2 < this.rtns.length; ++i2) {
            this.rtns[i2] = new JJCalls();
        }
    }

    public void reInit(Reader stream) {
        int i2;
        this.inputStream.reInit(stream, 1, 1);
        this.tokenSource.reInit(this.inputStream);
        this.token = new Token();
        this.nextTokenIndex = -1;
        this.genInt = 0;
        for (i2 = 0; i2 < 19; ++i2) {
            this.laA[i2] = -1;
        }
        for (i2 = 0; i2 < this.rtns.length; ++i2) {
            this.rtns[i2] = new JJCalls();
        }
    }

    public LocalUnitFormatParser(UnitTokenManager tm) {
        int i2;
        this.tokenSource = tm;
        this.token = new Token();
        this.nextTokenIndex = -1;
        this.genInt = 0;
        for (i2 = 0; i2 < 19; ++i2) {
            this.laA[i2] = -1;
        }
        for (i2 = 0; i2 < this.rtns.length; ++i2) {
            this.rtns[i2] = new JJCalls();
        }
    }

    public void reInit(UnitTokenManager tm) {
        int i2;
        this.tokenSource = tm;
        this.token = new Token();
        this.nextTokenIndex = -1;
        this.genInt = 0;
        for (i2 = 0; i2 < 19; ++i2) {
            this.laA[i2] = -1;
        }
        for (i2 = 0; i2 < this.rtns.length; ++i2) {
            this.rtns[i2] = new JJCalls();
        }
    }

    private Token consumeToken(int kind) throws TokenException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.tokenSource.getNextToken());
        this.nextTokenIndex = -1;
        if (this.token.kind == kind) {
            ++this.genInt;
            if (++this.gcInt > 100) {
                this.gcInt = 0;
                JJCalls[] jJCallsArray = this.rtns;
                int n = jJCallsArray.length;
                for (int j = 0; j < n; ++j) {
                    JJCalls jj_2_rtn;
                    JJCalls c = jj_2_rtn = jJCallsArray[j];
                    while (c != null) {
                        if (c.gen < this.genInt) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.kind = kind;
        throw this.raiseTokenException();
    }

    private boolean scanToken(int kind) {
        if (this.scanpos == this.lastpos) {
            --this.laInt;
            if (this.scanpos.next == null) {
                this.scanpos = this.scanpos.next = this.tokenSource.getNextToken();
                this.lastpos = this.scanpos.next;
            } else {
                this.lastpos = this.scanpos = this.scanpos.next;
            }
        } else {
            this.scanpos = this.scanpos.next;
        }
        if (this.rescan) {
            int i2 = 0;
            Token tok = this.token;
            while (tok != null && tok != this.scanpos) {
                ++i2;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i2);
            }
        }
        if (this.scanpos.kind != kind) {
            return true;
        }
        if (this.laInt == 0 && this.scanpos == this.lastpos) {
            throw new LookaheadSuccess();
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.tokenSource.getNextToken());
        this.nextTokenIndex = -1;
        ++this.genInt;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i2 = 0; i2 < index; ++i2) {
            t = t.next != null ? t.next : (t.next = this.tokenSource.getNextToken());
        }
        return t;
    }

    private int jj_ntk() {
        this.nextToken = this.token.next;
        if (this.nextToken == null) {
            this.token.next = this.tokenSource.getNextToken();
            this.nextTokenIndex = this.token.next.kind;
            return this.nextTokenIndex;
        }
        this.nextTokenIndex = this.nextToken.kind;
        return this.nextTokenIndex;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.endpos + 1) {
            this.lastTokens[this.endpos++] = kind;
        } else if (this.endpos != 0) {
            this.expentry = new int[this.endpos];
            System.arraycopy(this.lastTokens, 0, this.expentry, 0, this.endpos);
            block0: for (int[] jj_expentry1 : this.expentries) {
                if (jj_expentry1.length != this.expentry.length) continue;
                for (int i2 = 0; i2 < this.expentry.length; ++i2) {
                    if (jj_expentry1[i2] != this.expentry[i2]) continue block0;
                }
                this.expentries.add(this.expentry);
                break;
            }
            if (pos != 0) {
                this.endpos = pos;
                this.lastTokens[this.endpos - 1] = kind;
            }
        }
    }

    TokenException raiseTokenException() {
        int i2;
        this.expentries.clear();
        boolean[] la1tokens = new boolean[21];
        if (this.kind >= 0) {
            la1tokens[this.kind] = true;
            this.kind = -1;
        }
        for (i2 = 0; i2 < 19; ++i2) {
            if (this.laA[i2] != this.genInt) continue;
            for (int j = 0; j < 32; ++j) {
                if ((laB[i2] & 1 << j) == 0) continue;
                la1tokens[j] = true;
            }
        }
        for (i2 = 0; i2 < 21; ++i2) {
            if (!la1tokens[i2]) continue;
            this.expentry = new int[1];
            this.expentry[0] = i2;
            this.expentries.add(this.expentry);
        }
        this.endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.expentries.size()][];
        for (int i3 = 0; i3 < this.expentries.size(); ++i3) {
            exptokseq[i3] = this.expentries.get(i3);
        }
        return new TokenException(this.token, exptokseq, UnitTokenConstants.tokenImage);
    }

    public final void enableTracing() {
    }

    public final void disableTracing() {
    }

    private void jj_rescan_token() {
        this.rescan = true;
        for (int i2 = 0; i2 < 2; ++i2) {
            try {
                JJCalls p2 = this.rtns[i2];
                do {
                    if (p2.gen <= this.genInt) continue;
                    this.laInt = p2.arg;
                    this.lastpos = this.scanpos = p2.first;
                    switch (i2) {
                        case 0: {
                            this.jj_3_1();
                            break;
                        }
                        case 1: {
                            this.jj_3_2();
                        }
                    }
                } while ((p2 = p2.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.rescan = false;
    }

    private void jj_save(int index, int xla) {
        JJCalls p2 = this.rtns[index];
        while (p2.gen > this.genInt) {
            if (p2.next == null) {
                p2 = p2.next = new JJCalls();
                break;
            }
            p2 = p2.next;
        }
        p2.gen = this.genInt + xla - this.laInt;
        p2.first = this.token;
        p2.arg = xla;
    }

    static {
        LocalUnitFormatParser.init();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends RuntimeException {
        private static final long serialVersionUID = 2205332054119123041L;

        private LookaheadSuccess() {
        }
    }

    private static class Exponent {
        public final int pow;
        public final int root;

        public Exponent(int pow, int root) {
            this.pow = pow;
            this.root = root;
        }
    }
}

