/*
 * Decompiled with CFR 0.152.
 */
package tech.units.indriya.internal.simplify;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.BinaryOperator;
import tech.units.indriya.AbstractConverter;
import tech.units.indriya.function.AddConverter;
import tech.units.indriya.function.ExpConverter;
import tech.units.indriya.function.LogConverter;
import tech.units.indriya.function.MultiplyConverter;
import tech.units.indriya.function.PowersOfIntConverter;
import tech.units.indriya.function.PowersOfPiConverter;
import tech.units.indriya.function.RationalConverter;
import tech.units.indriya.internal.simplify.SimplificationWorker;

public final class Simplifier {
    static final Map<Class<?>, Integer> normalFormOrder = new HashMap(6);

    public static AbstractConverter compose(AbstractConverter a2, AbstractConverter b2, BiPredicate<AbstractConverter, AbstractConverter> simpleComposeTest, BinaryOperator<AbstractConverter> simpleComposeAction) {
        if (a2.isIdentity()) {
            if (b2.isIdentity()) {
                return Simplifier.isNormalFormOrderWhenIdentity(a2, b2) ? a2 : b2;
            }
            return b2;
        }
        if (b2.isIdentity()) {
            return a2;
        }
        if (simpleComposeTest.test(a2, b2)) {
            return (AbstractConverter)simpleComposeAction.apply(a2, b2);
        }
        boolean commutative = a2.isLinear() && b2.isLinear();
        boolean swap = commutative && !Simplifier.isNormalFormOrderWhenCommutative(a2, b2);
        AbstractConverter.Pair nonSimplifiedForm = swap ? new AbstractConverter.Pair(b2, a2) : new AbstractConverter.Pair(a2, b2);
        return new SimplificationWorker(simpleComposeTest, simpleComposeAction).simplify(nonSimplifiedForm.getConversionSteps());
    }

    static boolean isNormalFormOrderWhenIdentity(AbstractConverter a2, AbstractConverter b2) {
        if (a2.getClass().equals(b2.getClass())) {
            return true;
        }
        return normalFormOrder.get(a2.getClass()) <= normalFormOrder.get(b2.getClass());
    }

    static boolean isNormalFormOrderWhenCommutative(AbstractConverter a2, AbstractConverter b2) {
        if (a2.getClass().equals(b2.getClass())) {
            if (a2 instanceof PowersOfIntConverter) {
                return ((PowersOfIntConverter)a2).getBase() <= ((PowersOfIntConverter)b2).getBase();
            }
            return true;
        }
        Integer orderA = Objects.requireNonNull(normalFormOrder.get(a2.getClass()), () -> String.format("no normal-form order defined for class '%s'", a2.getClass().getName()));
        Integer orderB = Objects.requireNonNull(normalFormOrder.get(b2.getClass()), () -> String.format("no normal-form order defined for class '%s'", b2.getClass().getName()));
        return orderA <= orderB;
    }

    static {
        normalFormOrder.put(AbstractConverter.IDENTITY.getClass(), 0);
        normalFormOrder.put(PowersOfIntConverter.class, 1);
        normalFormOrder.put(RationalConverter.class, 2);
        normalFormOrder.put(PowersOfPiConverter.class, 3);
        normalFormOrder.put(MultiplyConverter.class, 4);
        normalFormOrder.put(AddConverter.class, 5);
        normalFormOrder.put(LogConverter.class, 6);
        normalFormOrder.put(ExpConverter.class, 7);
        normalFormOrder.put(AbstractConverter.Pair.class, 99);
    }
}

