/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution.test.runner;

import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.actions.RunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.TestData;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.plugins.gradle.execution.GradleRunnerUtil;
import org.jetbrains.plugins.gradle.execution.build.CachedModuleDataFinder;
import org.jetbrains.plugins.gradle.execution.test.runner.GradleTestTasksProvider;
import org.jetbrains.plugins.gradle.execution.test.runner.TestTasksChooser;
import org.jetbrains.plugins.gradle.service.execution.GradleExternalTaskConfigurationType;
import org.jetbrains.plugins.gradle.service.execution.GradleRunConfiguration;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.TestRunner;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.gradle.util.GradleModuleData;
import org.jetbrains.plugins.gradle.util.TasksToRun;

public abstract class GradleTestRunConfigurationProducer
extends RunConfigurationProducer<GradleRunConfiguration> {
    protected static final Logger LOG = Logger.getInstance(GradleTestRunConfigurationProducer.class);
    private TestTasksChooser testTasksChooser = new TestTasksChooser();

    protected GradleTestRunConfigurationProducer() {
        super(true);
    }

    @NotNull
    public ConfigurationFactory getConfigurationFactory() {
        ConfigurationFactory configurationFactory = GradleExternalTaskConfigurationType.getInstance().getFactory();
        if (configurationFactory == null) {
            GradleTestRunConfigurationProducer.$$$reportNull$$$0(0);
        }
        return configurationFactory;
    }

    public boolean isPreferredConfiguration(@NotNull ConfigurationFromContext self, @NotNull ConfigurationFromContext other) {
        if (self == null) {
            GradleTestRunConfigurationProducer.$$$reportNull$$$0(1);
        }
        if (other == null) {
            GradleTestRunConfigurationProducer.$$$reportNull$$$0(2);
        }
        return GradleTestRunConfigurationProducer.isUsedTestRunners(self.getConfiguration(), TestRunner.CHOOSE_PER_TEST, TestRunner.GRADLE);
    }

    public boolean shouldReplace(@NotNull ConfigurationFromContext self, @NotNull ConfigurationFromContext other) {
        if (self == null) {
            GradleTestRunConfigurationProducer.$$$reportNull$$$0(3);
        }
        if (other == null) {
            GradleTestRunConfigurationProducer.$$$reportNull$$$0(4);
        }
        return GradleTestRunConfigurationProducer.isUsedTestRunners(self.getConfiguration(), TestRunner.GRADLE);
    }

    public boolean setupConfigurationFromContext(@NotNull GradleRunConfiguration configuration, @NotNull ConfigurationContext context, @NotNull Ref<PsiElement> sourceElement) {
        if (configuration == null) {
            GradleTestRunConfigurationProducer.$$$reportNull$$$0(5);
        }
        if (context == null) {
            GradleTestRunConfigurationProducer.$$$reportNull$$$0(6);
        }
        if (sourceElement == null) {
            GradleTestRunConfigurationProducer.$$$reportNull$$$0(7);
        }
        if (!GradleConstants.SYSTEM_ID.equals((Object)configuration.getSettings().getExternalSystemId())) {
            return false;
        }
        if (sourceElement.isNull()) {
            return false;
        }
        if (GradleTestRunConfigurationProducer.isUsedTestRunners(context, TestRunner.PLATFORM)) {
            return false;
        }
        configuration.setScriptDebugEnabled(false);
        boolean result = this.doSetupConfigurationFromContext(configuration, context, sourceElement);
        this.restoreDefaultScriptParametersIfNeeded((RunConfiguration)configuration, context);
        return result;
    }

    protected abstract boolean doSetupConfigurationFromContext(@NotNull GradleRunConfiguration var1, @NotNull ConfigurationContext var2, @NotNull Ref<PsiElement> var3);

    public boolean isConfigurationFromContext(@NotNull GradleRunConfiguration configuration, @NotNull ConfigurationContext context) {
        ProjectSystemId externalSystemId;
        if (configuration == null) {
            GradleTestRunConfigurationProducer.$$$reportNull$$$0(8);
        }
        if (context == null) {
            GradleTestRunConfigurationProducer.$$$reportNull$$$0(9);
        }
        return GradleConstants.SYSTEM_ID.equals((Object)(externalSystemId = configuration.getSettings().getExternalSystemId())) && GradleTestRunConfigurationProducer.isUsedTestRunners(configuration, TestRunner.CHOOSE_PER_TEST, TestRunner.GRADLE) && this.doIsConfigurationFromContext(configuration, context);
    }

    protected abstract boolean doIsConfigurationFromContext(@NotNull GradleRunConfiguration var1, @NotNull ConfigurationContext var2);

    public void onFirstRun(@NotNull ConfigurationFromContext configuration, @NotNull ConfigurationContext context, @NotNull Runnable startRunnable) {
        if (configuration == null) {
            GradleTestRunConfigurationProducer.$$$reportNull$$$0(10);
        }
        if (context == null) {
            GradleTestRunConfigurationProducer.$$$reportNull$$$0(11);
        }
        if (startRunnable == null) {
            GradleTestRunConfigurationProducer.$$$reportNull$$$0(12);
        }
        this.restoreDefaultScriptParametersIfNeeded(configuration.getConfiguration(), context);
        startRunnable.run();
    }

    protected void restoreDefaultScriptParametersIfNeeded(@NotNull RunConfiguration configuration, @NotNull ConfigurationContext context) {
        RunnerAndConfigurationSettings template;
        RunConfiguration original;
        if (configuration == null) {
            GradleTestRunConfigurationProducer.$$$reportNull$$$0(13);
        }
        if (context == null) {
            GradleTestRunConfigurationProducer.$$$reportNull$$$0(14);
        }
        if ((original = (template = context.getRunManager().getConfigurationTemplate(this.getConfigurationFactory())).getConfiguration()) instanceof ExternalSystemRunConfiguration && configuration instanceof ExternalSystemRunConfiguration) {
            ExternalSystemRunConfiguration originalRC = (ExternalSystemRunConfiguration)original;
            ExternalSystemRunConfiguration configurationRC = (ExternalSystemRunConfiguration)configuration;
            String currentParams = configurationRC.getSettings().getScriptParameters();
            String defaultParams = originalRC.getSettings().getScriptParameters();
            if (!StringUtil.isEmptyOrSpaces((String)defaultParams)) {
                if (!StringUtil.isEmptyOrSpaces((String)currentParams)) {
                    configurationRC.getSettings().setScriptParameters(currentParams + " " + defaultParams);
                } else {
                    configurationRC.getSettings().setScriptParameters(defaultParams);
                }
            }
        }
    }

    @Nullable
    protected static String resolveProjectPath(@NotNull Module module) {
        GradleModuleData gradleModuleData;
        if (module == null) {
            GradleTestRunConfigurationProducer.$$$reportNull$$$0(15);
        }
        if ((gradleModuleData = CachedModuleDataFinder.getGradleModuleData((Module)module)) == null) {
            return null;
        }
        boolean isGradleProjectDirUsedToRunTasks = gradleModuleData.getDirectoryToRunTask().equals(gradleModuleData.getGradleProjectDir());
        if (!isGradleProjectDirUsedToRunTasks) {
            return gradleModuleData.getDirectoryToRunTask();
        }
        return GradleRunnerUtil.resolveProjectPath(module);
    }

    protected TestTasksChooser getTestTasksChooser() {
        return this.testTasksChooser;
    }

    @TestOnly
    public void setTestTasksChooser(TestTasksChooser testTasksChooser) {
        this.testTasksChooser = testTasksChooser;
    }

    @NotNull
    public static TasksToRun findTestsTaskToRun(@NotNull VirtualFile source, @NotNull Project project) {
        List<TasksToRun> tasksToRun;
        if (source == null) {
            GradleTestRunConfigurationProducer.$$$reportNull$$$0(16);
        }
        if (project == null) {
            GradleTestRunConfigurationProducer.$$$reportNull$$$0(17);
        }
        if ((tasksToRun = GradleTestRunConfigurationProducer.findAllTestsTaskToRun(source, project)).isEmpty()) {
            TasksToRun.Empty empty = TasksToRun.EMPTY;
            if (empty == null) {
                GradleTestRunConfigurationProducer.$$$reportNull$$$0(18);
            }
            return empty;
        }
        TasksToRun tasksToRun2 = tasksToRun.get(0);
        if (tasksToRun2 == null) {
            GradleTestRunConfigurationProducer.$$$reportNull$$$0(19);
        }
        return tasksToRun2;
    }

    @NotNull
    public static List<TasksToRun> findAllTestsTaskToRun(@NotNull VirtualFile source, @NotNull Project project) {
        if (source == null) {
            GradleTestRunConfigurationProducer.$$$reportNull$$$0(20);
        }
        if (project == null) {
            GradleTestRunConfigurationProducer.$$$reportNull$$$0(21);
        }
        String sourcePath = source.getPath();
        ProjectFileIndex projectFileIndex = ProjectFileIndex.SERVICE.getInstance((Project)project);
        Module module = projectFileIndex.getModuleForFile(source);
        if (module == null) {
            List<TasksToRun> list = Collections.emptyList();
            if (list == null) {
                GradleTestRunConfigurationProducer.$$$reportNull$$$0(22);
            }
            return list;
        }
        ArrayList<TasksToRun> testTasks = new ArrayList<TasksToRun>();
        for (GradleTestTasksProvider provider : (GradleTestTasksProvider[])GradleTestTasksProvider.EP_NAME.getExtensions()) {
            List<String> tasks = provider.getTasks(module, source);
            if (ContainerUtil.isEmpty(tasks)) continue;
            String testName = StringUtil.join(tasks, (String)" ");
            testTasks.add(new TasksToRun.Impl(testName, tasks));
        }
        GradleModuleData gradleModuleData = CachedModuleDataFinder.getGradleModuleData((Module)module);
        if (gradleModuleData == null) {
            ArrayList<TasksToRun> arrayList = testTasks;
            if (arrayList == null) {
                GradleTestRunConfigurationProducer.$$$reportNull$$$0(23);
            }
            return arrayList;
        }
        for (TestData testData : gradleModuleData.findAll(ProjectKeys.TEST)) {
            Set sourceFolders = testData.getSourceFolders();
            for (String sourceFolder : sourceFolders) {
                if (!FileUtil.isAncestor((String)sourceFolder, (String)sourcePath, (boolean)false)) continue;
                String testTaskSimpleName = testData.getTestName();
                SmartList tasks = new SmartList((Object)gradleModuleData.getTaskPath(testTaskSimpleName, true));
                testTasks.add(new TasksToRun.Impl(testTaskSimpleName, (List<String>)tasks));
            }
        }
        ArrayList<TasksToRun> arrayList = testTasks;
        if (arrayList == null) {
            GradleTestRunConfigurationProducer.$$$reportNull$$$0(24);
        }
        return arrayList;
    }

    private static boolean isUsedTestRunners(@NotNull RunConfiguration configuration, TestRunner ... runners) {
        if (configuration == null) {
            GradleTestRunConfigurationProducer.$$$reportNull$$$0(25);
        }
        if (runners == null) {
            GradleTestRunConfigurationProducer.$$$reportNull$$$0(26);
        }
        return configuration instanceof GradleRunConfiguration && GradleTestRunConfigurationProducer.isUsedTestRunners((GradleRunConfiguration)configuration, runners);
    }

    private static boolean isUsedTestRunners(@NotNull GradleRunConfiguration configuration, TestRunner ... runners) {
        if (configuration == null) {
            GradleTestRunConfigurationProducer.$$$reportNull$$$0(27);
        }
        if (runners == null) {
            GradleTestRunConfigurationProducer.$$$reportNull$$$0(28);
        }
        Project project = configuration.getProject();
        String externalProjectPath = configuration.getSettings().getExternalProjectPath();
        return GradleTestRunConfigurationProducer.isUsedTestRunners(project, externalProjectPath, runners);
    }

    private static boolean isUsedTestRunners(@NotNull ConfigurationContext context, TestRunner ... runners) {
        if (context == null) {
            GradleTestRunConfigurationProducer.$$$reportNull$$$0(29);
        }
        if (runners == null) {
            GradleTestRunConfigurationProducer.$$$reportNull$$$0(30);
        }
        Project project = context.getProject();
        Module module = context.getModule();
        return project != null && module != null && GradleTestRunConfigurationProducer.isUsedTestRunners(project, GradleTestRunConfigurationProducer.resolveProjectPath(module), runners);
    }

    private static boolean isUsedTestRunners(@NotNull Project project, @Nullable String externalProjectPath, TestRunner ... runners) {
        if (project == null) {
            GradleTestRunConfigurationProducer.$$$reportNull$$$0(31);
        }
        if (runners == null) {
            GradleTestRunConfigurationProducer.$$$reportNull$$$0(32);
        }
        TestRunner testRunner = GradleProjectSettings.getTestRunner((Project)project, (String)externalProjectPath);
        return ContainerUtil.exists((Object[])runners, it -> it.equals((Object)testRunner));
    }

    protected static void setUniqueNameIfNeeded(@NotNull Project project, @NotNull GradleRunConfiguration configuration) {
        if (project == null) {
            GradleTestRunConfigurationProducer.$$$reportNull$$$0(33);
        }
        if (configuration == null) {
            GradleTestRunConfigurationProducer.$$$reportNull$$$0(34);
        }
        RunManager runManager = RunManager.getInstance((Project)project);
        runManager.setUniqueNameIfNeeded((RunConfiguration)configuration);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 21: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 21: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/execution/test/runner/GradleTestRunConfigurationProducer";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "self";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 5: 
            case 8: 
            case 10: 
            case 13: 
            case 25: 
            case 27: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 6: 
            case 9: 
            case 11: 
            case 14: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceElement";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startRunnable";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 17: 
            case 21: 
            case 31: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 26: 
            case 28: 
            case 30: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runners";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationFactory";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 21: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/execution/test/runner/GradleTestRunConfigurationProducer";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "findTestsTaskToRun";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "findAllTestsTaskToRun";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isPreferredConfiguration";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "shouldReplace";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setupConfigurationFromContext";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isConfigurationFromContext";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "onFirstRun";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "restoreDefaultScriptParametersIfNeeded";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "resolveProjectPath";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "findTestsTaskToRun";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "findAllTestsTaskToRun";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "isUsedTestRunners";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "setUniqueNameIfNeeded";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 21: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

