#!/bin/bash -xe
# script to trigger rhpkg - after updating vendor folder: TODO switch to cachito
#
verbose=1
scratchFlag=""
doRhpkgContainerBuild=1
forceBuild=0
PULL_ASSETS=0

idePackagingUrl=https://download-cdn.jetbrains.com/idea/ideaIC-2022.1.tar.gz

while [[ "$#" -gt 0 ]]; do
	case $1 in
		'-p'|'--pull-assets') PULL_ASSETS=1; shift 0;;
		'-a'|'--publish-assets') exit 0; shift 0;;
		'-d'|'--delete-assets') exit 0; shift 0;;
		'-n'|'--nobuild') doRhpkgContainerBuild=0; shift 0;;
		'-f'|'--force-build') forceBuild=1; shift 0;;
		'-s'|'--scratch') scratchFlag="--scratch"; shift 0;;
		'-v') CSV_VERSION="$2"; shift 1;;
	esac
	shift 1
done

function log()
{
	if [[ ${verbose} -gt 0 ]]; then
	echo "$1"
	fi
}

if [[ ${PULL_ASSETS} -eq 1 ]]; then
  JDK_VER="11"
  sudo yum -y install java-${JDK_VER}-openjdk java-${JDK_VER}-openjdk-devel
  export PATH="/usr/lib/jvm/java-${JDK_VER}-openjdk:/usr/bin:${PATH}"
  export JAVA_HOME="/usr/lib/jvm/java-${JDK_VER}-openjdk"

  log "[INFO] java version:"
  java -version

  ./projector.sh build --prepare --url $idePackagingUrl --tag idea-rhel8

  if [[ ! -f "asset-ide-packaging.tar.gz" ]]; then
    log "[ERROR] 'asset-ide-packaging.tar.gz' not found, so nothing to build."
    exit 1;
  fi

  if [[ ! -f "asset-projector-server-assembly.zip" ]]; then
    log "[ERROR] 'asset-projector-server-assembly.zip' not found, so nothing to build."
    exit 1;
  fi

  if [[ ! -f "asset-static-assembly.tar.gz" ]]; then
    log "[ERROR] 'asset-static-assembly.tar.gz' not found, so nothing to build."
    exit 1;
  fi

  if [[ ! -f "asset-che-plugin-assembly.zip" ]]; then
    log "[ERROR] 'asset-che-plugin-assembly.zip' not found, so nothing to build."
    exit 1;
  fi

  if [[ ! -f "asset-machine-exec" ]]; then
    log "[ERROR] 'asset-machine-exec' not found, so nothing to build."
    exit 1;
  fi

  outputFiles="asset-ide-packaging.tar.gz asset-projector-server-assembly.zip asset-static-assembly.tar.gz asset-che-plugin-assembly.zip asset-machine-exec"
fi

if [[ $(git diff-index HEAD --) ]] || [[ ${PULL_ASSETS} -eq 1 ]]; then
	git add sources Dockerfile .gitignore || true
	log "[INFO] Upload new sources: ${outputFiles}"
	# shellcheck disable=SC2086
	rhpkg new-sources ${outputFiles}
	log "[INFO] Commit new sources from: ${outputFiles}"
	COMMIT_MSG="ci: ${outputFiles}"
	if [[ $(git commit -s -m "${COMMIT_MSG}" sources Dockerfile .gitignore) == *"nothing to commit, working tree clean"* ]]; then
		log "[INFO] No new sources, so nothing to build."
	elif [[ ${doRhpkgContainerBuild} -eq 1 ]]; then
		log "[INFO] Push change:"
		git pull; git push; git status -s || true
	fi
	if [[ ${doRhpkgContainerBuild} -eq 1 ]]; then
		echo "[INFO] #1 Trigger container-build in current branch: rhpkg container-build ${scratchFlag}"
		git status || true
		gitbranch="$(git rev-parse --abbrev-ref HEAD)"
		target=${gitbranch}-containers-candidate
		if [[ $scratchFlag == "--scratch" ]]; then target=devspaces-3-rhel-8-containers-candidate; fi
		repo="$(git remote -v | grep origin | head -1 | sed -r -e "s#.+/containers/(.+) \(fetch.+#\1#")"
		sha="$(git rev-parse HEAD)"
		tmpfile=$(mktemp) && brew container-build ${target} git+https://pkgs.devel.redhat.com/git/containers/${repo}#${sha} --git-branch ${gitbranch} ${scratchFlag} --nowait 2>/dev/null | tee 2>&1 "${tmpfile}"
		# shellcheck disable=SC2002
		taskID=$(cat "$tmpfile" | grep "Created task:" | sed -e "s#Created task:##") && brew watch-logs "$taskID" | tee 2>&1 "$tmpfile"
		ERRORS="$(grep "image build failed" "$tmpfile")" && rm -f "$tmpfile"
		if [[ "$ERRORS" != "" ]]; then echo "Brew build has failed:

$ERRORS

"; exit 1; fi
	fi
else
	if [[ ${forceBuild} -eq 1 ]]; then
		echo "[INFO] #2 Trigger container-build in current branch: rhpkg container-build ${scratchFlag}"
		git status || true
		gitbranch="$(git rev-parse --abbrev-ref HEAD)"
		target=${gitbranch}-containers-candidate
		if [[ $scratchFlag == "--scratch" ]]; then target=devspaces-3-rhel-8-containers-candidate; fi
		repo="$(git remote -v | grep origin | head -1 | sed -r -e "s#.+/containers/(.+) \(fetch.+#\1#")"
		sha="$(git rev-parse HEAD)"
		tmpfile=$(mktemp) && brew container-build ${target} git+https://pkgs.devel.redhat.com/git/containers/${repo}#${sha} --git-branch ${gitbranch} ${scratchFlag} --nowait 2>/dev/null | tee 2>&1 "${tmpfile}"
		# shellcheck disable=SC2002
		taskID=$(cat "$tmpfile" | grep "Created task:" | sed -e "s#Created task:##") && brew watch-logs "$taskID" | tee 2>&1 "$tmpfile"
		ERRORS="$(grep "image build failed" "$tmpfile")" && rm -f "$tmpfile"
		if [[ "$ERRORS" != "" ]]; then echo "Brew build has failed:

$ERRORS

"; exit 1; fi
	else
		log "[INFO] No new sources, so nothing to build."
	fi
fi
