/*
 * MIT License
 *
 * Copyright (c) 2019-2022 JetBrains s.r.o.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
package org.jetbrains.projector.common.protocol.data

/* Virtual keys enum (matching AWT). */
enum class VK(vararg typedSymbols: Char = charArrayOf()) {

  ENTER('\n'),
  BACK_SPACE('\b'),
  TAB('\t'),
  CANCEL,
  CLEAR,
  SHIFT,
  CONTROL,
  ALT,
  PAUSE,
  CAPS_LOCK,
  ESCAPE('\u001b'),
  SPACE(' '),
  PAGE_UP,
  PAGE_DOWN,
  END,
  HOME,
  LEFT,
  UP,
  RIGHT,
  DOWN,
  COMMA(','),
  MINUS('-'),
  PERIOD('.'),
  SLASH('/'),
  D0('0'),
  D1('1'),
  D2('2'),
  D3('3'),
  D4('4'),
  D5('5'),
  D6('6'),
  D7('7'),
  D8('8'),
  D9('9'),
  SEMICOLON(';'),
  EQUALS('='),
  A('a', 'A'),
  B('b', 'B'),
  C('c', 'C'),
  D('d', 'D'),
  E('e', 'E'),
  F('f', 'F'),
  G('g', 'G'),
  H('h', 'H'),
  I('i', 'I'),
  J('j', 'J'),
  K('k', 'K'),
  L('l', 'L'),
  M('m', 'M'),
  N('n', 'N'),
  O('o', 'O'),
  P('p', 'P'),
  Q('q', 'Q'),
  R('r', 'R'),
  S('s', 'S'),
  T('t', 'T'),
  U('u', 'U'),
  V('v', 'V'),
  W('w', 'W'),
  X('x', 'X'),
  Y('y', 'Y'),
  Z('z', 'Z'),
  OPEN_BRACKET('['),
  BACK_SLASH('\\'),
  CLOSE_BRACKET(']'),
  NUMPAD0,
  NUMPAD1,
  NUMPAD2,
  NUMPAD3,
  NUMPAD4,
  NUMPAD5,
  NUMPAD6,
  NUMPAD7,
  NUMPAD8,
  NUMPAD9,
  MULTIPLY,
  ADD,
  SEPARATOR,
  SUBTRACT,
  DECIMAL,
  DIVIDE,
  DELETE('\u007f'),
  NUM_LOCK,
  SCROLL_LOCK,
  F1,
  F2,
  F3,
  F4,
  F5,
  F6,
  F7,
  F8,
  F9,
  F10,
  F11,
  F12,
  F13,
  F14,
  F15,
  F16,
  F17,
  F18,
  F19,
  F20,
  F21,
  F22,
  F23,
  F24,
  PRINTSCREEN,
  INSERT,
  HELP,
  META,
  BACK_QUOTE('`'),
  QUOTE('\''),
  KP_UP,
  KP_DOWN,
  KP_LEFT,
  KP_RIGHT,
  DEAD_GRAVE,
  DEAD_ACUTE,
  DEAD_CIRCUMFLEX,
  DEAD_TILDE,
  DEAD_MACRON,
  DEAD_BREVE,
  DEAD_ABOVEDOT,
  DEAD_DIAERESIS,
  DEAD_ABOVERING,
  DEAD_DOUBLEACUTE,
  DEAD_CARON,
  DEAD_CEDILLA,
  DEAD_OGONEK,
  DEAD_IOTA,
  DEAD_VOICED_SOUND,
  DEAD_SEMIVOICED_SOUND,
  AMPERSAND('&'),
  ASTERISK('*'),
  QUOTEDBL('"'),
  LESS('<'),
  GREATER('>'),
  BRACELEFT,
  BRACERIGHT,
  AT('@'),
  COLON(':'),
  CIRCUMFLEX,
  DOLLAR('$'),
  EURO_SIGN('€'),
  EXCLAMATION_MARK('!'),
  INVERTED_EXCLAMATION_MARK('¡'),
  LEFT_PARENTHESIS('('),
  NUMBER_SIGN('#'),
  PLUS('+'),
  RIGHT_PARENTHESIS(')'),
  UNDERSCORE('_'),
  WINDOWS,
  CONTEXT_MENU,
  FINAL,
  CONVERT,
  NONCONVERT,
  ACCEPT,
  MODECHANGE,
  KANA,
  KANJI,
  ALPHANUMERIC,
  KATAKANA,
  HIRAGANA,
  FULL_WIDTH,
  HALF_WIDTH,
  ROMAN_CHARACTERS,
  ALL_CANDIDATES,
  PREVIOUS_CANDIDATE,
  CODE_INPUT,
  JAPANESE_KATAKANA,
  JAPANESE_HIRAGANA,
  JAPANESE_ROMAN,
  KANA_LOCK,
  INPUT_METHOD_ON_OFF,
  CUT,
  COPY,
  PASTE,
  UNDO,
  AGAIN,
  FIND,
  PROPS,
  STOP,
  COMPOSE,
  ALT_GRAPH,
  BEGIN,
  UNDEFINED;

  val typedSymbols = typedSymbols.asList()

  companion object {

    val codeMap by lazy { values().flatMap { key -> key.typedSymbols.map { it to key } }.toMap() }
  }
}
