/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.editor.tables.actions.row;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.lang.ref.WeakReference;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.plugins.markdown.editor.tables.TableUtils;
import org.intellij.plugins.markdown.editor.tables.actions.TableActionKeys;
import org.intellij.plugins.markdown.editor.tables.actions.row.RowBasedTableAction;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTable;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTableRow;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTableSeparatorRow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b \u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u001a\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014J.\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\n\u0018\u00010\u00112\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J \u0010\u0013\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\nH$J\u0010\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J$\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00122\b\u0010\u0015\u001a\u0004\u0018\u00010\nH\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/intellij/plugins/markdown/editor/tables/actions/row/RowBasedTableAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "considerSeparatorRow", "", "(Z)V", "actionPerformed", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "findRow", "Lcom/intellij/psi/PsiElement;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "findRowOrSeparator", "findTableAndRow", "Lkotlin/Pair;", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownTable;", "performAction", "table", "rowElement", "update", "Companion", "intellij.markdown.core"})
public abstract class RowBasedTableAction
extends AnAction {
    private final boolean considerSeparatorRow;
    @NotNull
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - void declaration
     */
    public void actionPerformed(@NotNull AnActionEvent event) {
        void table;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Object object = event.getRequiredData(CommonDataKeys.EDITOR);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"event.getRequiredData(CommonDataKeys.EDITOR)");
        Editor editor2 = (Editor)object;
        Object object2 = event.getRequiredData(CommonDataKeys.PSI_FILE);
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"event.getRequiredData(CommonDataKeys.PSI_FILE)");
        PsiFile file = (PsiFile)object2;
        Pair<MarkdownTable, PsiElement> tableAndRow = this.findTableAndRow(event, file, editor2);
        if (tableAndRow == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        Pair<MarkdownTable, PsiElement> pair = tableAndRow;
        MarkdownTable markdownTable = (MarkdownTable)pair.component1();
        PsiElement row = (PsiElement)pair.component2();
        this.performAction(editor2, (MarkdownTable)table, row);
    }

    /*
     * WARNING - void declaration
     */
    public void update(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Project project = (Project)event.getData(CommonDataKeys.PROJECT);
        Editor editor2 = (Editor)event.getData(CommonDataKeys.EDITOR);
        PsiFile file = (PsiFile)event.getData(CommonDataKeys.PSI_FILE);
        if (project == null || editor2 == null || file == null) {
            Presentation presentation = event.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"event.presentation");
            presentation.setEnabledAndVisible(false);
            return;
        }
        Pair<MarkdownTable, PsiElement> tableAndRow = this.findTableAndRow(event, file, editor2);
        Presentation presentation = event.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"event.presentation");
        presentation.setEnabledAndVisible(tableAndRow != null);
        if (tableAndRow != null) {
            void table;
            Pair<MarkdownTable, PsiElement> pair = tableAndRow;
            MarkdownTable markdownTable = (MarkdownTable)pair.component1();
            PsiElement row = (PsiElement)pair.component2();
            this.update(event, (MarkdownTable)table, row);
        } else {
            this.update(event, null, null);
        }
    }

    protected abstract void performAction(@NotNull Editor var1, @NotNull MarkdownTable var2, @NotNull PsiElement var3);

    protected void update(@NotNull AnActionEvent event, @Nullable MarkdownTable table, @Nullable PsiElement rowElement) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
    }

    private final Pair<MarkdownTable, PsiElement> findTableAndRow(AnActionEvent event, PsiFile file, Editor editor2) {
        return this.considerSeparatorRow ? Companion.findTableAndRow(event, file, editor2, (Function2<? super PsiFile, ? super Editor, ? extends PsiElement>)((Function2)new Function2<PsiFile, Editor, PsiElement>(this){

            @Nullable
            public final PsiElement invoke(@NotNull PsiFile p1, @NotNull Editor p2) {
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
                return ((RowBasedTableAction)((Object)this.receiver)).findRowOrSeparator(p1, p2);
            }
        })) : Companion.findTableAndRow(event, file, editor2, (Function2<? super PsiFile, ? super Editor, ? extends PsiElement>)((Function2)new Function2<PsiFile, Editor, PsiElement>(this){

            @Nullable
            public final PsiElement invoke(@NotNull PsiFile p1, @NotNull Editor p2) {
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
                return ((RowBasedTableAction)((Object)this.receiver)).findRow(p1, p2);
            }
        }));
    }

    @Nullable
    protected PsiElement findRowOrSeparator(@NotNull PsiFile file, @NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        CaretModel caretModel = editor2.getCaretModel();
        Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"editor.caretModel");
        Caret caret = caretModel.getCurrentCaret();
        Intrinsics.checkNotNullExpressionValue((Object)caret, (String)"editor.caretModel.currentCaret");
        return TableUtils.findRowOrSeparator(file, caret.getOffset());
    }

    @Nullable
    protected PsiElement findRow(@NotNull PsiFile file, @NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        CaretModel caretModel = editor2.getCaretModel();
        Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"editor.caretModel");
        Caret caret = caretModel.getCurrentCaret();
        Intrinsics.checkNotNullExpressionValue((Object)caret, (String)"editor.caretModel.currentCaret");
        return (PsiElement)TableUtils.findRow(file, caret.getOffset());
    }

    public RowBasedTableAction(boolean considerSeparatorRow) {
        this.considerSeparatorRow = considerSeparatorRow;
    }

    public /* synthetic */ RowBasedTableAction(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        this(bl);
    }

    public RowBasedTableAction() {
        this(false, 1, null);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJH\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u001a\u0010\r\u001a\u0016\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u000eJ\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0010\u001a\u00020\u0006H\u0002\u00a8\u0006\u0011"}, d2={"Lorg/intellij/plugins/markdown/editor/tables/actions/row/RowBasedTableAction$Companion;", "", "()V", "findTableAndRow", "Lkotlin/Pair;", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownTable;", "Lcom/intellij/psi/PsiElement;", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "rowGetter", "Lkotlin/Function2;", "obtainParentTable", "element", "intellij.markdown.core"})
    public static final class Companion {
        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Nullable
        public final Pair<MarkdownTable, PsiElement> findTableAndRow(@NotNull AnActionEvent event, @NotNull PsiFile file, @NotNull Editor editor2, @NotNull Function2<? super PsiFile, ? super Editor, ? extends PsiElement> rowGetter) {
            PsiElement psiElement;
            PsiElement row;
            PsiElement psiElement2;
            MarkdownTable table;
            PsiElement elementFromEvent;
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            Intrinsics.checkNotNullParameter(rowGetter, (String)"rowGetter");
            WeakReference weakReference = (WeakReference)event.getData(TableActionKeys.INSTANCE.getELEMENT());
            Object object = elementFromEvent = weakReference != null ? (PsiElement)weakReference.get() : null;
            if (elementFromEvent != null && (table = this.obtainParentTable(elementFromEvent)) != null) {
                return TuplesKt.to((Object)table, (Object)elementFromEvent);
            }
            PsiElement psiElement3 = (PsiElement)rowGetter.invoke((Object)file, (Object)editor2);
            if (psiElement3 == null) return null;
            PsiElement it = psiElement2 = psiElement3;
            boolean bl = false;
            if (!it.isValid()) return null;
            PsiElement psiElement5 = psiElement2;
            psiElement5 = row = psiElement5;
            Object object2 = psiElement5;
            if (psiElement5 == null) return null;
            PsiElement p1 = psiElement = object2;
            boolean bl2 = false;
            MarkdownTable markdownTable = this.obtainParentTable(p1);
            object2 = markdownTable;
            if (markdownTable == null) return null;
            PsiElement it2 = psiElement = object2;
            boolean bl3 = false;
            if (!it2.isValid()) return null;
            PsiElement psiElement6 = psiElement;
            PsiElement table2 = psiElement6;
            if (table2 == null) return null;
            Pair pair = TuplesKt.to(table2, (Object)row);
            return pair;
        }

        private final MarkdownTable obtainParentTable(PsiElement element2) {
            PsiElement psiElement = element2;
            return psiElement instanceof MarkdownTableRow ? ((MarkdownTableRow)element2).getParentTable() : (psiElement instanceof MarkdownTableSeparatorRow ? ((MarkdownTableSeparatorRow)element2).getParentTable() : null);
        }

        @Nullable
        public final Pair<MarkdownTable, PsiElement> findTableAndRow(@NotNull AnActionEvent event, @NotNull PsiFile file, @NotNull Editor editor2) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            return this.findTableAndRow(event, file, editor2, (Function2<? super PsiFile, ? super Editor, ? extends PsiElement>)((Function2)findTableAndRow.1.INSTANCE));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

