/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.extensions.common.highlighter;

import com.intellij.lang.Language;
import com.intellij.markdown.utils.lang.HtmlSyntaxHighlighter;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColorUtil;
import java.awt.Color;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.html.HtmlGenerator;
import org.intellij.plugins.markdown.extensions.CodeFenceGeneratingProvider;
import org.intellij.plugins.markdown.extensions.jcef.commandRunner.CommandRunnerExtension;
import org.intellij.plugins.markdown.injection.aliases.CodeFenceLanguageGuesser;
import org.intellij.plugins.markdown.ui.preview.html.DefaultCodeFenceGeneratingProvider;
import org.intellij.plugins.markdown.ui.preview.html.MarkdownUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u0000\u0018\u0000 )2\u00020\u0001:\u0002()B\u0005\u00a2\u0006\u0002\u0010\u0002J6\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\b2\u0018\u0010\r\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\b0\u000f0\u000e2\n\u0010\u0011\u001a\u00060\u0012j\u0002`\u0013H\u0002J\b\u0010\u0014\u001a\u00020\u000bH\u0002J \u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J&\u0010\u001a\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u0005J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0016\u001a\u00020\bH\u0016J\b\u0010\u001e\u001a\u00020\u000bH\u0016J\u0010\u0010\u001f\u001a\u00020\b2\u0006\u0010 \u001a\u00020\bH\u0002J \u0010!\u001a\u00020\b2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0014\u0010%\u001a\u00020\u0010*\u00020\u00102\u0006\u0010&\u001a\u00020'H\u0002R\u0016\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lorg/intellij/plugins/markdown/extensions/common/highlighter/MarkdownCodeFencePreviewHighlighter;", "Lorg/intellij/plugins/markdown/extensions/CodeFenceGeneratingProvider;", "()V", "currentFile", "Ljava/lang/ThreadLocal;", "Lcom/intellij/openapi/vfs/VirtualFile;", "values", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lorg/intellij/plugins/markdown/extensions/common/highlighter/MarkdownCodeFencePreviewHighlighter$CachedHTMLResult;", "appendWithReplacements", "", "line", "targets", "", "Lkotlin/Pair;", "Lkotlin/ranges/IntRange;", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "cleanup", "generateHtml", "language", "raw", "node", "Lorg/intellij/markdown/ast/ASTNode;", "generateHtmlForFile", "file", "isApplicable", "", "onLaFChanged", "processCodeLine", "rawCodeLine", "render", "lang", "Lcom/intellij/lang/Language;", "text", "shift", "value", "", "CachedHTMLResult", "Companion", "intellij.markdown.core"})
public final class MarkdownCodeFencePreviewHighlighter
implements CodeFenceGeneratingProvider {
    private final ConcurrentHashMap<String, CachedHTMLResult> values = new ConcurrentHashMap();
    private final ThreadLocal<VirtualFile> currentFile = new ThreadLocal();
    private static final int expiration = 300000;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    public boolean isApplicable(@NotNull String language) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        return CodeFenceLanguageGuesser.guessLanguageForInjection(language) != null;
    }

    @NotNull
    public final String generateHtmlForFile(@NotNull String language, @NotNull String raw, @NotNull ASTNode node, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.currentFile.set(file);
        String result = this.generateHtml(language, raw, node);
        this.currentFile.set(null);
        return result;
    }

    @Override
    @NotNull
    public String generateHtml(@NotNull String language, @NotNull String raw, @NotNull ASTNode node) {
        CachedHTMLResult.HTMLResult resolved;
        CachedHTMLResult cached;
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Language language2 = CodeFenceLanguageGuesser.guessLanguageForInjection(language);
        if (language2 == null) {
            return DefaultCodeFenceGeneratingProvider.Companion.escape$intellij_markdown_core(raw);
        }
        Language lang = language2;
        String md5 = MarkdownUtil.INSTANCE.md5(raw, language);
        CachedHTMLResult cachedHTMLResult = cached = this.values.get(md5);
        CachedHTMLResult.HTMLResult hTMLResult = resolved = cachedHTMLResult != null ? cachedHTMLResult.resolve() : null;
        if (resolved != null) {
            CachedHTMLResult cachedHTMLResult2 = cached;
            cachedHTMLResult2.setExpires(cachedHTMLResult2.getExpires() + (long)300000);
            return resolved.getHtml();
        }
        this.cleanup();
        String text = this.render(lang, raw, node);
        CachedHTMLResult html2 = new CachedHTMLResult(new SoftReference<String>(text), System.currentTimeMillis() + (long)300000);
        ((Map)this.values).put(md5, html2);
        return text;
    }

    @Override
    public void onLaFChanged() {
        this.values.clear();
    }

    /*
     * WARNING - void declaration
     */
    private final void cleanup() {
        void $this$filterTo$iv$iv;
        long time = System.currentTimeMillis();
        Map $this$filter$iv = this.values;
        boolean $i$f$filter = false;
        Map map = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator.next();
            boolean bl = false;
            if (!(((CachedHTMLResult)it.getValue()).getExpires() < time)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Set toRemove = destination$iv$iv.keySet();
        Iterable $this$forEach$iv = toRemove;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            this.values.remove(it);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final String render(Language lang, String text, ASTNode node) {
        Object object;
        CharSequence charSequence;
        CharSequence charSequence2;
        ArrayList<Object> arrayList;
        block10: {
            block9: {
                void it;
                String string;
                Object object2;
                CharSequence charSequence3;
                Iterable iterable;
                CharSequence charSequence4;
                ArrayList<Object> arrayList2;
                block8: {
                    Object targets;
                    Map highlightTokens = new LinkedHashMap();
                    HtmlSyntaxHighlighter.Companion.parseContent(null, lang, text, (Function3)new Function3<String, IntRange, Color, Unit>(highlightTokens){
                        final /* synthetic */ Map $highlightTokens;

                        public final void invoke(@NotNull String content2, @NotNull IntRange intRange, @Nullable Color color) {
                            Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
                            Intrinsics.checkNotNullParameter((Object)intRange, (String)"intRange");
                            if (color != null) {
                                this.$highlightTokens.put(intRange, "<span style=\"color:" + ColorUtil.toHtmlColor((Color)color) + "\">" + DefaultCodeFenceGeneratingProvider.Companion.escape$intellij_markdown_core(content2) + "</span>");
                            }
                        }
                        {
                            this.$highlightTokens = map;
                            super(3);
                        }
                    });
                    int baseOffset = DefaultCodeFenceGeneratingProvider.Companion.calcCodeFenceContentBaseOffset$intellij_markdown_core(node);
                    ArrayList<Object> lines2 = new ArrayList<Object>();
                    int left = 0;
                    for (String line : StringsKt.lines((CharSequence)text)) {
                        void $this$buildString;
                        StringBuilder $this$mapTo$iv$iv;
                        void $this$map$iv;
                        IntRange range;
                        Map.Entry entry;
                        Map.Entry $dstr$range$_u24__u24;
                        void $this$filterTo$iv$iv;
                        Iterable $this$filter$iv = highlightTokens.entrySet();
                        boolean $i$f$filter = false;
                        Iterable iterable2 = $this$filter$iv;
                        Collection destination$iv$iv = new ArrayList();
                        boolean $i$f$filterTo = false;
                        for (Object element$iv$iv : $this$filterTo$iv$iv) {
                            $dstr$range$_u24__u24 = (Map.Entry)element$iv$iv;
                            boolean bl = false;
                            entry = $dstr$range$_u24__u24;
                            range = (IntRange)entry.getKey();
                            if (!(range.getFirst() >= left && range.getLast() <= left + line.length())) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        $this$filter$iv = (List)destination$iv$iv;
                        boolean $i$f$map = false;
                        $this$filterTo$iv$iv = $this$map$iv;
                        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        Object object3 = $this$mapTo$iv$iv.iterator();
                        while (object3.hasNext()) {
                            void $dstr$range$replacement;
                            Object item$iv$iv = object3.next();
                            $dstr$range$_u24__u24 = (Map.Entry)item$iv$iv;
                            arrayList2 = destination$iv$iv;
                            boolean bl = false;
                            entry = $dstr$range$replacement;
                            range = (IntRange)entry.getKey();
                            entry = $dstr$range$replacement;
                            String replacement = (String)entry.getValue();
                            charSequence4 = TuplesKt.to((Object)this.shift(range, -left), (Object)replacement);
                            arrayList2.add(charSequence4);
                        }
                        targets = (List)destination$iv$iv;
                        int right = left + line.length() + 1;
                        $this$mapTo$iv$iv = $i$f$map = new StringBuilder();
                        arrayList2 = lines2;
                        boolean bl = false;
                        $this$buildString.append("<span " + HtmlGenerator.Companion.getSRC_ATTRIBUTE_NAME() + "='" + (left + baseOffset) + ".." + (right + baseOffset) + "'>");
                        Collection collection = lines2;
                        if (!collection.isEmpty()) {
                            $this$buildString.append(this.processCodeLine(line));
                        }
                        this.appendWithReplacements(line, (List<Pair<IntRange, String>>)targets, (StringBuilder)$this$buildString);
                        $this$buildString.append("</span>");
                        charSequence4 = Unit.INSTANCE;
                        object3 = $i$f$map.toString();
                        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"StringBuilder().apply(builderAction).toString()");
                        arrayList2.add(object3);
                        left = right;
                    }
                    iterable = node.getChildren();
                    charSequence3 = "<span " + HtmlGenerator.Companion.getSRC_ATTRIBUTE_NAME() + "='" + node.getStartOffset() + ".." + baseOffset + "'/>";
                    charSequence4 = "\n";
                    arrayList2 = lines2;
                    object2 = iterable;
                    targets = object2.iterator();
                    while (targets.hasNext()) {
                        Object t = targets.next();
                        ASTNode it2 = (ASTNode)t;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it2.getType(), (Object)MarkdownTokenTypes.CODE_FENCE_END)) continue;
                        string = (String)t;
                        break block8;
                    }
                    string = null;
                }
                String string2 = string;
                arrayList = arrayList2;
                charSequence2 = charSequence4;
                charSequence = charSequence3;
                object = (ASTNode)string2;
                if (object == null) break block9;
                iterable = object;
                object2 = iterable;
                charSequence3 = charSequence;
                charSequence4 = charSequence2;
                arrayList2 = arrayList;
                boolean bl = false;
                string2 = "<span " + HtmlGenerator.Companion.getSRC_ATTRIBUTE_NAME() + "='" + it.getStartOffset() + ".." + it.getEndOffset() + "'/>";
                arrayList = arrayList2;
                charSequence2 = charSequence4;
                charSequence = charSequence3;
                object = string2;
                if (object != null) break block10;
            }
            object = "";
        }
        return CollectionsKt.joinToString$default((Iterable)arrayList, (CharSequence)charSequence2, (CharSequence)charSequence, (CharSequence)((CharSequence)object), (int)0, null, null, (int)56, null);
    }

    private final IntRange shift(IntRange $this$shift, int value) {
        int n = $this$shift.getFirst() + value;
        return new IntRange(n, $this$shift.getLast() + value);
    }

    /*
     * WARNING - void declaration
     */
    private final void appendWithReplacements(String line, List<Pair<IntRange, String>> targets, StringBuilder builder) {
        String actualLine = line;
        int left = 0;
        Iterable $this$sortedBy$iv = targets;
        boolean $i$f$sortedBy = false;
        for (Pair pair : CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Pair it = (Pair)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(((IntRange)it.getFirst()).getFirst());
                it = (Pair)b;
                Comparable comparable2 = comparable;
                bl = false;
                Integer n = ((IntRange)it.getFirst()).getFirst();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
            }
        })) {
            void range;
            $this$sortedBy$iv = (IntRange)pair.component1();
            String replacement = (String)pair.component2();
            String string = actualLine;
            int n = 0;
            int n2 = range.getFirst() - left;
            String string2 = string.substring(n, n2);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            builder.append(DefaultCodeFenceGeneratingProvider.Companion.escape$intellij_markdown_core(string2));
            builder.append(replacement);
            string = actualLine;
            n = range.getLast() - left;
            String string3 = string.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).substring(startIndex)");
            actualLine = string3;
            left = range.getLast();
        }
        builder.append(DefaultCodeFenceGeneratingProvider.Companion.escape$intellij_markdown_core(actualLine));
    }

    private final String processCodeLine(String rawCodeLine) {
        Object object;
        block3: {
            block2: {
                VirtualFile virtualFile;
                object = this.currentFile.get();
                if (object == null) break block2;
                VirtualFile file = virtualFile = object;
                boolean bl = false;
                CommandRunnerExtension commandRunnerExtension = CommandRunnerExtension.Companion.getRunnerByFile(file);
                object = commandRunnerExtension != null ? commandRunnerExtension.processCodeLine(rawCodeLine, true) : null;
                if (object != null) break block3;
            }
            object = "";
        }
        return object;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\b\u0018\u00002\u00020\u0001:\u0001\u0019B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0006H\u00c6\u0003J#\u0010\u0010\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017J\t\u0010\u0018\u001a\u00020\u0004H\u00d6\u0001R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001a"}, d2={"Lorg/intellij/plugins/markdown/extensions/common/highlighter/MarkdownCodeFencePreviewHighlighter$CachedHTMLResult;", "", "html", "Ljava/lang/ref/SoftReference;", "", "expires", "", "(Ljava/lang/ref/SoftReference;J)V", "getExpires", "()J", "setExpires", "(J)V", "getHtml", "()Ljava/lang/ref/SoftReference;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "resolve", "Lorg/intellij/plugins/markdown/extensions/common/highlighter/MarkdownCodeFencePreviewHighlighter$CachedHTMLResult$HTMLResult;", "toString", "HTMLResult", "intellij.markdown.core"})
    private static final class CachedHTMLResult {
        @NotNull
        private final SoftReference<String> html;
        private long expires;

        @Nullable
        public final HTMLResult resolve() {
            HTMLResult hTMLResult;
            String string = this.html.get();
            if (string != null) {
                String string2;
                String it = string2 = string;
                boolean bl = false;
                String string3 = it;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"it");
                hTMLResult = new HTMLResult(string3, this.expires);
            } else {
                hTMLResult = null;
            }
            return hTMLResult;
        }

        @NotNull
        public final SoftReference<String> getHtml() {
            return this.html;
        }

        public final long getExpires() {
            return this.expires;
        }

        public final void setExpires(long l) {
            this.expires = l;
        }

        public CachedHTMLResult(@NotNull SoftReference<String> html2, long expires) {
            Intrinsics.checkNotNullParameter(html2, (String)"html");
            this.html = html2;
            this.expires = expires;
        }

        @NotNull
        public final SoftReference<String> component1() {
            return this.html;
        }

        public final long component2() {
            return this.expires;
        }

        @NotNull
        public final CachedHTMLResult copy(@NotNull SoftReference<String> html2, long expires) {
            Intrinsics.checkNotNullParameter(html2, (String)"html");
            return new CachedHTMLResult(html2, expires);
        }

        public static /* synthetic */ CachedHTMLResult copy$default(CachedHTMLResult cachedHTMLResult, SoftReference softReference, long l, int n, Object object) {
            if ((n & 1) != 0) {
                softReference = cachedHTMLResult.html;
            }
            if ((n & 2) != 0) {
                l = cachedHTMLResult.expires;
            }
            return cachedHTMLResult.copy(softReference, l);
        }

        @NotNull
        public String toString() {
            return "CachedHTMLResult(html=" + this.html + ", expires=" + this.expires + ")";
        }

        public int hashCode() {
            SoftReference<String> softReference = this.html;
            return (softReference != null ? softReference.hashCode() : 0) * 31 + Long.hashCode(this.expires);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof CachedHTMLResult)) break block3;
                    CachedHTMLResult cachedHTMLResult = (CachedHTMLResult)object;
                    if (!Intrinsics.areEqual(this.html, cachedHTMLResult.html) || this.expires != cachedHTMLResult.expires) break block3;
                }
                return true;
            }
            return false;
        }

        @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lorg/intellij/plugins/markdown/extensions/common/highlighter/MarkdownCodeFencePreviewHighlighter$CachedHTMLResult$HTMLResult;", "", "html", "", "expires", "", "(Ljava/lang/String;J)V", "getExpires", "()J", "getHtml", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.markdown.core"})
        public static final class HTMLResult {
            @NotNull
            private final String html;
            private final long expires;

            @NotNull
            public final String getHtml() {
                return this.html;
            }

            public final long getExpires() {
                return this.expires;
            }

            public HTMLResult(@NotNull String html2, long expires) {
                Intrinsics.checkNotNullParameter((Object)html2, (String)"html");
                this.html = html2;
                this.expires = expires;
            }

            @NotNull
            public final String component1() {
                return this.html;
            }

            public final long component2() {
                return this.expires;
            }

            @NotNull
            public final HTMLResult copy(@NotNull String html2, long expires) {
                Intrinsics.checkNotNullParameter((Object)html2, (String)"html");
                return new HTMLResult(html2, expires);
            }

            public static /* synthetic */ HTMLResult copy$default(HTMLResult hTMLResult, String string, long l, int n, Object object) {
                if ((n & 1) != 0) {
                    string = hTMLResult.html;
                }
                if ((n & 2) != 0) {
                    l = hTMLResult.expires;
                }
                return hTMLResult.copy(string, l);
            }

            @NotNull
            public String toString() {
                return "HTMLResult(html=" + this.html + ", expires=" + this.expires + ")";
            }

            public int hashCode() {
                String string = this.html;
                return (string != null ? string.hashCode() : 0) * 31 + Long.hashCode(this.expires);
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof HTMLResult)) break block3;
                        HTMLResult hTMLResult = (HTMLResult)object;
                        if (!Intrinsics.areEqual((Object)this.html, (Object)hTMLResult.html) || this.expires != hTMLResult.expires) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/intellij/plugins/markdown/extensions/common/highlighter/MarkdownCodeFencePreviewHighlighter$Companion;", "", "()V", "expiration", "", "intellij.markdown.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

