/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.google.accounts;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.intellij.collaboration.async.CompletableFutureUtil;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.plugins.markdown.google.GoogleAuthorizedUserException;
import org.intellij.plugins.markdown.google.accounts.data.GoogleUserInfo;
import org.intellij.plugins.markdown.google.utils.GoogleAccountsUtils;
import org.jetbrains.annotations.NotNull;

@Service
@Metadata(mv={1, 5, 1}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0001\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u001e\u0010\n\u001a\n \u000b*\u0004\u0018\u00010\u00050\u00052\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\rH\u0003J\u0015\u0010\u000e\u001a\u00070\u000f\u00a2\u0006\u0002\b\u00102\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\r2\u0006\u0010\u0006\u001a\u00020\u0007H\u0003\u00a8\u0006\u0013"}, d2={"Lorg/intellij/plugins/markdown/google/accounts/GoogleUserInfoService;", "", "()V", "acquireUserInfo", "Ljava/util/concurrent/CompletableFuture;", "Lorg/intellij/plugins/markdown/google/accounts/data/GoogleUserInfo;", "accessToken", "", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "deserializeResponse", "kotlin.jvm.PlatformType", "response", "Ljava/net/http/HttpResponse;", "getUserInfoUrl", "Lcom/intellij/util/Url;", "Lorg/jetbrains/annotations/NotNull;", "requestUserInfo", "Companion", "intellij.markdown.core"})
public final class GoogleUserInfoService {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @RequiresEdt
    @NotNull
    public final CompletableFuture<GoogleUserInfo> acquireUserInfo(@NotNull String accessToken, @NotNull ProgressIndicator progressIndicator) {
        Intrinsics.checkNotNullParameter((Object)accessToken, (String)"accessToken");
        Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
        ProgressManager progressManager = ProgressManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)progressManager, (String)"ProgressManager.getInstance()");
        return CompletableFutureUtil.INSTANCE.submitIOTask(progressManager, progressIndicator, (Function1)new Function1<ProgressIndicator, GoogleUserInfo>(this, accessToken){
            final /* synthetic */ GoogleUserInfoService this$0;
            final /* synthetic */ String $accessToken;

            @NotNull
            public final GoogleUserInfo invoke(@NotNull ProgressIndicator it) {
                JsonNode responseTree;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                HttpResponse response = GoogleUserInfoService.access$requestUserInfo(this.this$0, this.$accessToken);
                if (response.statusCode() == 200) {
                    GoogleUserInfo googleUserInfo = GoogleUserInfoService.access$deserializeResponse(this.this$0, response);
                    Intrinsics.checkNotNullExpressionValue((Object)googleUserInfo, (String)"deserializeResponse(response)");
                    return googleUserInfo;
                }
                JsonNode jsonNode = responseTree = GoogleAccountsUtils.INSTANCE.getJacksonMapper().readTree((String)response.body());
                Intrinsics.checkNotNullExpressionValue((Object)jsonNode, (String)"responseTree");
                if (jsonNode.isEmpty()) {
                    throw (Throwable)new RuntimeException("Couldn't get user data");
                }
                switch (responseTree.get("error").get("code").asInt()) {
                    case 401: {
                        throw (Throwable)new GoogleAuthorizedUserException();
                    }
                }
                throw (Throwable)new RuntimeException(responseTree.get("error").get("status").asText());
            }
            {
                this.this$0 = googleUserInfoService;
                this.$accessToken = string;
                super(1);
            }
        });
    }

    @RequiresBackgroundThread
    private final HttpResponse<String> requestUserInfo(String accessToken) {
        String string = this.getUserInfoUrl(accessToken).toExternalForm();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUserInfoUrl(accessToken).toExternalForm()");
        String userInfoUrl = string;
        HttpClient client = HttpClient.newHttpClient();
        HttpRequest httpRequest = HttpRequest.newBuilder().uri(URI.create(userInfoUrl)).header("Content-Type", "application/json").GET().build();
        Intrinsics.checkNotNullExpressionValue((Object)httpRequest, (String)"HttpRequest.newBuilder()\u2026    .GET()\n      .build()");
        HttpRequest httpRequest2 = httpRequest;
        HttpResponse<String> httpResponse = client.send(httpRequest2, HttpResponse.BodyHandlers.ofString());
        Intrinsics.checkNotNullExpressionValue(httpResponse, (String)"client.send(httpRequest,\u2026.BodyHandlers.ofString())");
        return httpResponse;
    }

    @RequiresBackgroundThread
    private final GoogleUserInfo deserializeResponse(HttpResponse<String> response) {
        ObjectMapper objectMapper;
        ObjectMapper $this$with = objectMapper = GoogleAccountsUtils.INSTANCE.getJacksonMapper();
        boolean bl = false;
        $this$with.setPropertyNamingStrategy((PropertyNamingStrategy)new PropertyNamingStrategies.SnakeCaseStrategy());
        return (GoogleUserInfo)$this$with.readValue(response.body(), GoogleUserInfo.class);
    }

    private final Url getUserInfoUrl(String accessToken) {
        Url url = GoogleUserInfoService.Companion.getUSER_INFO_URL().addParameters(MapsKt.mapOf((Pair)TuplesKt.to((Object)"access_token", (Object)accessToken)));
        Intrinsics.checkNotNullExpressionValue((Object)url, (String)"USER_INFO_URL.addParamet\u2026oken\" to accessToken\n  ))");
        return url;
    }

    public static final /* synthetic */ HttpResponse access$requestUserInfo(GoogleUserInfoService $this, String accessToken) {
        return $this.requestUserInfo(accessToken);
    }

    public static final /* synthetic */ GoogleUserInfo access$deserializeResponse(GoogleUserInfoService $this, HttpResponse response) {
        return $this.deserializeResponse(response);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/intellij/plugins/markdown/google/accounts/GoogleUserInfoService$Companion;", "", "()V", "USER_INFO_URL", "Lcom/intellij/util/Url;", "getUSER_INFO_URL", "()Lcom/intellij/util/Url;", "intellij.markdown.core"})
    public static final class Companion {
        private final Url getUSER_INFO_URL() {
            return Urls.newFromEncoded((String)"https://www.googleapis.com/oauth2/v2/userinfo");
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

