/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.lang.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.flavours.commonmark.CommonMarkMarkerProcessor;
import org.intellij.markdown.flavours.gfm.GFMConstraints;
import org.intellij.markdown.flavours.gfm.GFMTokenTypes;
import org.intellij.markdown.flavours.gfm.table.GitHubTableMarkerProvider;
import org.intellij.markdown.parser.LookaheadText;
import org.intellij.markdown.parser.MarkerProcessor;
import org.intellij.markdown.parser.MarkerProcessorFactory;
import org.intellij.markdown.parser.ProductionHolder;
import org.intellij.markdown.parser.constraints.MarkdownConstraints;
import org.intellij.markdown.parser.constraints.MarkdownConstraintsKt;
import org.intellij.markdown.parser.markerblocks.MarkerBlockProvider;
import org.intellij.markdown.parser.markerblocks.providers.AtxHeaderProvider;
import org.intellij.markdown.parser.markerblocks.providers.LinkReferenceDefinitionProvider;
import org.intellij.markdown.parser.sequentialparsers.SequentialParser;
import org.intellij.plugins.markdown.lang.parser.CommentAwareLinkReferenceDefinitionProvider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0012B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0014\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\bH\u0014J$\u0010\f\u001a\u00020\r2\n\u0010\u000e\u001a\u00060\u000fR\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u0003H\u0014R\u001a\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/intellij/plugins/markdown/lang/parser/GFMCommentAwareMarkerProcessor;", "Lorg/intellij/markdown/flavours/commonmark/CommonMarkMarkerProcessor;", "productionHolder", "Lorg/intellij/markdown/parser/ProductionHolder;", "constraintsBase", "Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;", "(Lorg/intellij/markdown/parser/ProductionHolder;Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;)V", "markerBlockProviders", "", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlockProvider;", "Lorg/intellij/markdown/parser/MarkerProcessor$StateInfo;", "getMarkerBlockProviders", "populateConstraintsTokens", "", "pos", "Lorg/intellij/markdown/parser/LookaheadText$Position;", "Lorg/intellij/markdown/parser/LookaheadText;", "constraints", "Factory", "intellij.markdown.core"})
public final class GFMCommentAwareMarkerProcessor
extends CommonMarkMarkerProcessor {
    private final List<MarkerBlockProvider<MarkerProcessor.StateInfo>> markerBlockProviders;

    protected void populateConstraintsTokens(@NotNull LookaheadText.Position pos, @NotNull MarkdownConstraints constraints, @NotNull ProductionHolder productionHolder) {
        IElementType iElementType;
        boolean bl;
        int offset;
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)constraints, (String)"constraints");
        Intrinsics.checkNotNullParameter((Object)productionHolder, (String)"productionHolder");
        if (!(constraints instanceof GFMConstraints) || !((GFMConstraints)constraints).hasCheckbox()) {
            super.populateConstraintsTokens(pos, constraints, productionHolder);
            return;
        }
        String line = pos.getCurrentLine();
        for (offset = pos.getOffsetInCurrentLine(); offset < line.length() && line.charAt(offset) != '['; ++offset) {
        }
        if (offset == line.length()) {
            super.populateConstraintsTokens(pos, constraints, productionHolder);
            return;
        }
        char[] cArray = constraints.getTypes();
        boolean bl2 = bl = !(cArray.length == 0);
        if (!bl) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        switch (ArraysKt.last((char[])constraints.getTypes())) {
            case '>': {
                iElementType = MarkdownTokenTypes.BLOCK_QUOTE;
                break;
            }
            case ')': 
            case '.': {
                iElementType = MarkdownTokenTypes.LIST_NUMBER;
                break;
            }
            default: {
                iElementType = MarkdownTokenTypes.LIST_BULLET;
            }
        }
        IElementType type = iElementType;
        int middleOffset = pos.getOffset() - pos.getOffsetInCurrentLine() + offset;
        int n = pos.getOffset() - pos.getOffsetInCurrentLine() + MarkdownConstraintsKt.getCharsEaten((MarkdownConstraints)constraints, (CharSequence)pos.getCurrentLine());
        int n2 = pos.getNextLineOrEofOffset();
        int endOffset = Math.min(n, n2);
        Object[] objectArray = new SequentialParser.Node[2];
        n = pos.getOffset();
        objectArray[0] = new SequentialParser.Node(new IntRange(n, middleOffset), type);
        n = middleOffset;
        objectArray[1] = new SequentialParser.Node(new IntRange(n, endOffset), GFMTokenTypes.CHECK_BOX);
        productionHolder.addProduction((Collection)CollectionsKt.listOf((Object[])objectArray));
    }

    @NotNull
    protected List<MarkerBlockProvider<MarkerProcessor.StateInfo>> getMarkerBlockProviders() {
        return this.markerBlockProviders;
    }

    public GFMCommentAwareMarkerProcessor(@NotNull ProductionHolder productionHolder, @NotNull MarkdownConstraints constraintsBase) {
        MarkerBlockProvider it;
        Iterable $this$filterNotTo$iv$iv;
        Iterable $this$filterNot$iv;
        Intrinsics.checkNotNullParameter((Object)productionHolder, (String)"productionHolder");
        Intrinsics.checkNotNullParameter((Object)constraintsBase, (String)"constraintsBase");
        super(productionHolder, constraintsBase);
        Iterable iterable = super.getMarkerBlockProviders();
        GFMCommentAwareMarkerProcessor gFMCommentAwareMarkerProcessor = this;
        boolean $i$f$filterNot = false;
        void var5_6 = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (MarkerBlockProvider)element$iv$iv;
            boolean bl = false;
            if (it instanceof AtxHeaderProvider) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list2 = (List)destination$iv$iv;
        $this$filterNot$iv = list2;
        $i$f$filterNot = false;
        $this$filterNotTo$iv$iv = $this$filterNot$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (MarkerBlockProvider)element$iv$iv;
            boolean bl = false;
            if (it instanceof LinkReferenceDefinitionProvider) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        list2 = (List)destination$iv$iv;
        gFMCommentAwareMarkerProcessor.markerBlockProviders = CollectionsKt.plus((Collection)list2, (Iterable)CollectionsKt.listOf((Object[])new MarkerBlockProvider[]{(MarkerBlockProvider)new GitHubTableMarkerProvider(), (MarkerBlockProvider)new AtxHeaderProvider(), new CommentAwareLinkReferenceDefinitionProvider()}));
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/intellij/plugins/markdown/lang/parser/GFMCommentAwareMarkerProcessor$Factory;", "Lorg/intellij/markdown/parser/MarkerProcessorFactory;", "()V", "createMarkerProcessor", "Lorg/intellij/markdown/parser/MarkerProcessor;", "productionHolder", "Lorg/intellij/markdown/parser/ProductionHolder;", "intellij.markdown.core"})
    public static final class Factory
    implements MarkerProcessorFactory {
        @NotNull
        public static final Factory INSTANCE;

        @NotNull
        public MarkerProcessor<?> createMarkerProcessor(@NotNull ProductionHolder productionHolder) {
            Intrinsics.checkNotNullParameter((Object)productionHolder, (String)"productionHolder");
            return (MarkerProcessor)new GFMCommentAwareMarkerProcessor(productionHolder, (MarkdownConstraints)GFMConstraints.Companion.getBASE());
        }

        private Factory() {
        }

        static {
            Factory factory;
            INSTANCE = factory = new Factory();
        }
    }
}

