/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.navigation.ColoredItemPresentation;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtilKt;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.plugins.markdown.lang.MarkdownTokenTypeSets;
import org.intellij.plugins.markdown.lang.psi.MarkdownElementVisitor;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownHeaderImpl;
import org.intellij.plugins.markdown.lang.stubs.impl.MarkdownHeaderStubElement;
import org.intellij.plugins.markdown.lang.stubs.impl.MarkdownHeaderStubElementType;
import org.intellij.plugins.markdown.structureView.MarkdownStructureColors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\n\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002J\n\u0010\u0014\u001a\u0004\u0018\u00010\u0013H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0017"}, d2={"Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownHeader;", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownHeaderImpl;", "node", "Lcom/intellij/lang/ASTNode;", "(Lcom/intellij/lang/ASTNode;)V", "stub", "Lorg/intellij/plugins/markdown/lang/stubs/impl/MarkdownHeaderStubElement;", "type", "Lorg/intellij/plugins/markdown/lang/stubs/impl/MarkdownHeaderStubElementType;", "(Lorg/intellij/plugins/markdown/lang/stubs/impl/MarkdownHeaderStubElement;Lorg/intellij/plugins/markdown/lang/stubs/impl/MarkdownHeaderStubElementType;)V", "level", "", "getLevel", "()I", "accept", "", "visitor", "Lcom/intellij/psi/PsiElementVisitor;", "getHeaderText", "", "getName", "getPresentation", "Lcom/intellij/navigation/ItemPresentation;", "intellij.markdown.core"})
public final class MarkdownHeader
extends MarkdownHeaderImpl {
    public final int getLevel() {
        return this.calculateHeaderLevel();
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        Intrinsics.checkNotNullParameter((Object)visitor, (String)"visitor");
        PsiElementVisitor psiElementVisitor = visitor;
        if (psiElementVisitor instanceof MarkdownElementVisitor) {
            ((MarkdownElementVisitor)visitor).visitHeader(this);
        } else {
            super.accept(visitor);
        }
    }

    @NotNull
    public ItemPresentation getPresentation() {
        String headerText = this.getHeaderText();
        Object object = headerText;
        if (object == null) {
            object = "Invalid header: " + this.getText();
        }
        String text = object;
        return (ItemPresentation)new ColoredItemPresentation(this, text){
            final /* synthetic */ MarkdownHeader this$0;
            final /* synthetic */ String $text;

            @NotNull
            public String getPresentableText() {
                PsiElement prevSibling = this.this$0.getPrevSibling();
                if (Registry.is((String)"markdown.structure.view.list.visibility") && MarkdownTokenTypeSets.LIST_MARKERS.contains(PsiTreeUtilKt.getElementType((PsiElement)prevSibling))) {
                    PsiElement psiElement = prevSibling;
                    Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"prevSibling");
                    return psiElement.getText() + this.$text;
                }
                return this.$text;
            }

            @Nullable
            public Icon getIcon(boolean open) {
                return null;
            }

            @Nullable
            public TextAttributesKey getTextAttributesKey() {
                TextAttributesKey textAttributesKey;
                switch (this.this$0.getLevel()) {
                    case 1: {
                        textAttributesKey = MarkdownStructureColors.MARKDOWN_HEADER_BOLD;
                        break;
                    }
                    default: {
                        textAttributesKey = MarkdownStructureColors.MARKDOWN_HEADER;
                    }
                }
                return textAttributesKey;
            }
            {
                this.this$0 = this$0;
                this.$text = $captured_local_variable$1;
            }
        };
    }

    @Nullable
    public String getName() {
        return this.getHeaderText();
    }

    private final String getHeaderText() {
        if (!this.isValid()) {
            return null;
        }
        PsiElement psiElement = this.findChildByType(MarkdownTokenTypeSets.INLINE_HOLDING_ELEMENT_TYPES);
        if (psiElement == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"findChildByType<PsiEleme\u2026ENT_TYPES) ?: return null");
        PsiElement contentHolder = psiElement;
        return StringUtil.trim((String)contentHolder.getText());
    }

    public MarkdownHeader(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        super(node);
    }

    public MarkdownHeader(@NotNull MarkdownHeaderStubElement stub, @NotNull MarkdownHeaderStubElementType type) {
        Intrinsics.checkNotNullParameter((Object)stub, (String)"stub");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        super(stub, type);
    }
}

