/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.ui.actions.styling;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ReadOnlyFragmentModificationException;
import com.intellij.openapi.editor.ReadOnlyModificationException;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.RefactoringBundle;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.intellij.plugins.markdown.editor.images.ConfigureImageDialog;
import org.intellij.plugins.markdown.editor.images.ImageUtils;
import org.intellij.plugins.markdown.editor.images.MarkdownImageData;
import org.intellij.plugins.markdown.ui.actions.MarkdownActionPlaces;
import org.intellij.plugins.markdown.ui.actions.MarkdownActionUtil;
import org.intellij.plugins.markdown.ui.actions.styling.InsertImageAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\r"}, d2={"Lorg/intellij/plugins/markdown/ui/actions/styling/InsertImageAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "actionPerformed", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "buildImageText", "", "imageData", "Lorg/intellij/plugins/markdown/editor/images/MarkdownImageData;", "update", "intellij.markdown.core"})
public final class InsertImageAction
extends AnAction
implements DumbAware {
    public void update(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Presentation presentation = event.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"event.presentation");
        Editor editor2 = MarkdownActionUtil.findMarkdownTextEditor(event);
        presentation.setEnabled(editor2 != null && (editor2 = editor2.getDocument()) != null && editor2.isWritable());
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Editor editor2 = MarkdownActionUtil.findMarkdownTextEditor(event);
        if (editor2 == null) {
            return;
        }
        Editor editor3 = editor2;
        Project project = editor3.getProject();
        String string = MarkdownBundle.message("markdown.insert.image.dialog.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"MarkdownBundle.message(\"\u2026sert.image.dialog.title\")");
        new ConfigureImageDialog(project, string, null, null, null, null, null, false, 252, null).show((Function1<? super MarkdownImageData, Unit>)((Function1)new Function1<MarkdownImageData, Unit>(this, editor3, project){
            final /* synthetic */ InsertImageAction this$0;
            final /* synthetic */ Editor $editor;
            final /* synthetic */ Project $project;

            public final void invoke(@NotNull MarkdownImageData imageData) {
                Intrinsics.checkNotNullParameter((Object)imageData, (String)"imageData");
                Document document = this.$editor.getDocument();
                Intrinsics.checkNotNullExpressionValue((Object)document, (String)"editor.document");
                Document document2 = document;
                String imageText = InsertImageAction.access$buildImageText(this.this$0, imageData);
                try {
                    WriteCommandAction.runWriteCommandAction((Project)this.$project, (String)this.this$0.getTemplateText(), null, (Runnable)new Runnable(this, document2, imageText){
                        final /* synthetic */ actionPerformed.1 this$0;
                        final /* synthetic */ Document $document;
                        final /* synthetic */ String $imageText;

                        public final void run() {
                            this.this$0.$editor.getCaretModel().runForEachCaret(new CaretAction(this){
                                final /* synthetic */ actionPerformed.1 this$0;

                                public final void perform(@NotNull Caret caret) {
                                    Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
                                    int offset = caret.getOffset();
                                    this.this$0.$document.insertString(offset, (CharSequence)this.this$0.$imageText);
                                    caret.moveToOffset(offset + this.this$0.$imageText.length());
                                }
                                {
                                    this.this$0 = var1_1;
                                }
                            });
                        }
                        {
                            this.this$0 = var1_1;
                            this.$document = document;
                            this.$imageText = string;
                        }
                    }, (PsiFile[])new PsiFile[0]);
                }
                catch (ReadOnlyModificationException exception) {
                    Messages.showErrorDialog((Project)this.$project, (String)exception.getLocalizedMessage(), (String)RefactoringBundle.message((String)"error.title"));
                }
                catch (ReadOnlyFragmentModificationException exception) {
                    EditorActionManager.getInstance().getReadonlyFragmentModificationHandler(document2).handle(exception);
                }
            }
            {
                this.this$0 = insertImageAction;
                this.$editor = editor2;
                this.$project = project;
                super(1);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    private final String buildImageText(MarkdownImageData imageData) {
        String string;
        if (imageData.getShouldConvertToHtml()) {
            string = ImageUtils.createHtmlImageText(imageData);
        } else {
            void title;
            void path;
            MarkdownImageData markdownImageData = imageData;
            String string2 = markdownImageData.component1();
            String string3 = markdownImageData.component4();
            String description = markdownImageData.component5();
            string = ImageUtils.createMarkdownImageText(description, (String)path, (String)title);
        }
        return string;
    }

    public InsertImageAction() {
        this.addTextOverride(MarkdownActionPlaces.getINSERT_POPUP(), 1.INSTANCE);
    }

    public static final /* synthetic */ String access$buildImageText(InsertImageAction $this, MarkdownImageData imageData) {
        return $this.buildImageText(imageData);
    }
}

