/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.ui.actions.styling;

import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ex.ClipboardUtil;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.refactoring.suggested.UtilsKt;
import com.intellij.util.LocalFileUrl;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.io.PathKt;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.intellij.plugins.markdown.lang.MarkdownElementTypes;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownFile;
import org.intellij.plugins.markdown.ui.actions.MarkdownActionPlaces;
import org.intellij.plugins.markdown.ui.actions.MarkdownActionUtil;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\n\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0015\u0010\u0011\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00122\u0006\u0010\u0013\u001a\u00020\u0005H\u0002J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u000eH\u0016J(\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J \u0010\u001f\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0016\u0010 \u001a\u0004\u0018\u00010\u0019*\u00020\u001b2\u0006\u0010!\u001a\u00020\"H\u0002R\u0014\u0010\u0004\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007\u00a8\u0006#"}, d2={"Lorg/intellij/plugins/markdown/ui/actions/styling/MarkdownCreateLinkAction;", "Lcom/intellij/openapi/actionSystem/ToggleAction;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "unwrapActionName", "", "getUnwrapActionName", "()Ljava/lang/String;", "wrapActionBaseName", "getWrapActionBaseName", "getLinkDestinationInClipboard", "editor", "Lcom/intellij/openapi/editor/Editor;", "isSelected", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "obtainWrapActionName", "Lorg/jetbrains/annotations/Nls;", "place", "setSelected", "", "state", "unwrapLink", "linkElement", "Lcom/intellij/psi/PsiElement;", "caret", "Lcom/intellij/openapi/editor/Caret;", "project", "Lcom/intellij/openapi/project/Project;", "update", "wrapSelectionWithLink", "getSelectedLinkElement", "file", "Lcom/intellij/psi/PsiFile;", "intellij.markdown.core"})
public final class MarkdownCreateLinkAction
extends ToggleAction
implements DumbAware {
    private final String getWrapActionBaseName() {
        String string = MarkdownBundle.message("action.Markdown.Styling.CreateLink.text", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"MarkdownBundle.message(\"\u2026Styling.CreateLink.text\")");
        return string;
    }

    private final String getUnwrapActionName() {
        String string = MarkdownBundle.message("action.Markdown.Styling.CreateLink.unwrap.text", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"MarkdownBundle.message(\"\u2026.CreateLink.unwrap.text\")");
        return string;
    }

    private final String obtainWrapActionName(String place) {
        String string;
        String string2 = place;
        if (Intrinsics.areEqual((Object)string2, (Object)MarkdownActionPlaces.getINSERT_POPUP())) {
            String string3 = MarkdownBundle.message("action.Markdown.Styling.CreateLink.insert.popup.text", new Object[0]);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"MarkdownBundle.message(\"\u2026eLink.insert.popup.text\")");
        } else {
            string = this.getWrapActionBaseName();
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public boolean isSelected(@NotNull AnActionEvent e) {
        boolean bl;
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Editor editor2 = MarkdownActionUtil.findMarkdownTextEditor(e);
        PsiFile file = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        if (editor2 == null || !(file instanceof MarkdownFile)) {
            Presentation presentation = e.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"e.presentation");
            presentation.setEnabledAndVisible(false);
            return false;
        }
        Presentation presentation = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"e.presentation");
        presentation.setEnabledAndVisible(true);
        CaretModel caretModel = editor2.getCaretModel();
        Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"editor.caretModel");
        List list2 = caretModel.getAllCarets();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"editor.caretModel.allCarets");
        Iterable iterable = list2;
        boolean $i$f$filter = false;
        void var7_8 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Caret it = (Caret)element$iv$iv;
            boolean bl2 = false;
            Caret caret = it;
            Intrinsics.checkNotNullExpressionValue((Object)caret, (String)"it");
            if (!(this.getSelectedLinkElement(caret, file) != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List caretsWithLinks = (List)destination$iv$iv;
        Collection collection = caretsWithLinks;
        int caretsWithLinksCount = collection.size();
        if (caretsWithLinksCount == 0 || Intrinsics.areEqual((Object)e.getPlace(), (Object)"EditorPopup")) {
            Presentation presentation2 = e.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation2, (String)"e.presentation");
            presentation2.setEnabled(!editor2.isViewer());
            Presentation presentation3 = e.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation3, (String)"e.presentation");
            String string = e.getPlace();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"e.place");
            presentation3.setText(this.obtainWrapActionName(string));
            Presentation presentation4 = e.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation4, (String)"e.presentation");
            presentation4.setDescription(MarkdownBundle.message("action.Markdown.Styling.CreateLink.description", new Object[0]));
            bl = false;
        } else {
            CaretModel caretModel2 = editor2.getCaretModel();
            Intrinsics.checkNotNullExpressionValue((Object)caretModel2, (String)"editor.caretModel");
            if (caretsWithLinksCount == caretModel2.getCaretCount()) {
                Presentation presentation5 = e.getPresentation();
                Intrinsics.checkNotNullExpressionValue((Object)presentation5, (String)"e.presentation");
                presentation5.setEnabled(!editor2.isViewer());
                Presentation presentation6 = e.getPresentation();
                Intrinsics.checkNotNullExpressionValue((Object)presentation6, (String)"e.presentation");
                presentation6.setText(this.getUnwrapActionName());
                Presentation presentation7 = e.getPresentation();
                Intrinsics.checkNotNullExpressionValue((Object)presentation7, (String)"e.presentation");
                presentation7.setDescription(MarkdownBundle.message("action.Markdown.Styling.CreateLink.unwrap.description", new Object[0]));
                bl = true;
            } else {
                Presentation presentation8 = e.getPresentation();
                Intrinsics.checkNotNullExpressionValue((Object)presentation8, (String)"e.presentation");
                presentation8.setEnabled(false);
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public void setSelected(@NotNull AnActionEvent e, boolean state) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Editor editor2 = MarkdownActionUtil.findMarkdownTextEditor(e);
        if (editor2 == null) {
            String string = "Could not find Markdown editor";
            throw new IllegalStateException(string.toString());
        }
        Editor editor3 = editor2;
        Object object = e.getRequiredData(CommonDataKeys.PSI_FILE);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"e.getRequiredData(CommonDataKeys.PSI_FILE)");
        PsiFile file = (PsiFile)object;
        if (state) {
            CaretModel caretModel = editor3.getCaretModel();
            Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"editor.caretModel");
            Iterator iterator = caretModel.getAllCarets().iterator();
            while (iterator.hasNext()) {
                Caret caret;
                Caret caret2 = caret = (Caret)iterator.next();
                Intrinsics.checkNotNullExpressionValue((Object)caret2, (String)"caret");
                Project project = file.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"file.project");
                this.wrapSelectionWithLink(caret2, editor3, project);
            }
        } else {
            void $this$forEach$iv;
            PsiElement key$iv;
            Iterable $this$distinctBy$iv;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Iterable $this$sortedBy$iv;
            CaretModel caretModel = editor3.getCaretModel();
            Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"editor.caretModel");
            List list2 = caretModel.getAllCarets();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"editor.caretModel.allCarets");
            Iterable caret = list2;
            boolean $i$f$sortedBy = false;
            $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    Caret it = (Caret)a;
                    boolean bl = false;
                    Caret caret = it;
                    Intrinsics.checkNotNullExpressionValue((Object)caret, (String)"it");
                    it = (Caret)b;
                    Comparable comparable = Integer.valueOf(-caret.getOffset());
                    bl = false;
                    Caret caret2 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)caret2, (String)"it");
                    Integer n = -caret2.getOffset();
                    return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)n);
                }
            });
            boolean $i$f$map = false;
            Iterator iterator = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void caret3;
                Caret caret4 = (Caret)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                void v7 = caret3;
                Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"caret");
                Pair pair = TuplesKt.to((Object)caret3, (Object)this.getSelectedLinkElement((Caret)v7, file));
                collection.add(pair);
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$distinctBy = false;
            HashSet<PsiElement> set$iv = new HashSet<PsiElement>();
            ArrayList list$iv = new ArrayList();
            for (Object e$iv : $this$distinctBy$iv) {
                Pair $dstr$_u24__u24$element = (Pair)e$iv;
                boolean bl = false;
                PsiElement element2 = (PsiElement)$dstr$_u24__u24$element.component2();
                key$iv = element2;
                if (!set$iv.add(key$iv)) continue;
                list$iv.add(e$iv);
            }
            $this$distinctBy$iv = list$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                void caret5;
                boolean bl;
                Pair $dstr$caret$element = (Pair)element$iv;
                boolean bl2 = false;
                key$iv = (Caret)$dstr$caret$element.component1();
                PsiElement element3 = (PsiElement)$dstr$caret$element.component2();
                boolean bl3 = bl = element3 != null;
                if (_Assertions.ENABLED && !bl) {
                    String string = "Assertion failed";
                    throw new AssertionError((Object)string);
                }
                if (element3 == null) continue;
                void v9 = caret5;
                Intrinsics.checkNotNullExpressionValue((Object)v9, (String)"caret");
                Project project = file.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"file.project");
                this.unwrapLink(element3, (Caret)v9, editor3, project);
            }
        }
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Presentation presentation = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"e.presentation");
        Icon originalIcon = presentation.getIcon();
        super.update(e);
        if (ActionPlaces.isPopupPlace((String)e.getPlace())) {
            Presentation presentation2 = e.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation2, (String)"e.presentation");
            presentation2.setIcon(originalIcon);
        }
    }

    private final void wrapSelectionWithLink(Caret caret, Editor editor2, Project project) {
        PsiFile[] psiFileArray;
        PsiFile file;
        String string = caret.getSelectedText();
        if (string == null) {
            string = "";
        }
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"caret.selectedText ?: \"\"");
        String selected = string;
        int selectionStart = caret.getSelectionStart();
        int selectionEnd = caret.getSelectionEnd();
        PsiFile psiFile = file = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor2.getDocument());
        if (psiFile != null) {
            PsiFile psiFile2;
            PsiFile it = psiFile2 = psiFile;
            boolean bl = false;
            PsiFile[] psiFileArray2 = new PsiFile[1];
            psiFileArray = psiFileArray2;
            psiFileArray2[0] = it;
        } else {
            psiFileArray = new PsiFile[]{};
        }
        PsiFile[] fileArray = psiFileArray;
        WriteCommandAction.writeCommandAction((Project)project, (PsiFile[])Arrays.copyOf(fileArray, fileArray.length)).withName(this.getWrapActionBaseName()).run(new ThrowableRunnable(this, caret, editor2, selectionStart, selectionEnd, selected){
            final /* synthetic */ MarkdownCreateLinkAction this$0;
            final /* synthetic */ Caret $caret;
            final /* synthetic */ Editor $editor;
            final /* synthetic */ int $selectionStart;
            final /* synthetic */ int $selectionEnd;
            final /* synthetic */ String $selected;

            public final void run() {
                block0: {
                    String string;
                    this.$caret.removeSelection();
                    this.$editor.getDocument().replaceString(this.$selectionStart, this.$selectionEnd, (CharSequence)("[" + this.$selected + "]()"));
                    this.$caret.moveToOffset(this.$selectionEnd + 3);
                    String string2 = MarkdownCreateLinkAction.access$getLinkDestinationInClipboard(this.this$0, this.$editor);
                    if (string2 == null) break block0;
                    String linkDestination = string = string2;
                    boolean bl = false;
                    int linkStartOffset = this.$caret.getOffset();
                    this.$editor.getDocument().insertString(linkStartOffset, (CharSequence)linkDestination);
                    this.$caret.setSelection(linkStartOffset, linkStartOffset + linkDestination.length());
                }
            }
            {
                this.this$0 = markdownCreateLinkAction;
                this.$caret = caret;
                this.$editor = editor2;
                this.$selectionStart = n;
                this.$selectionEnd = n2;
                this.$selected = string;
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final String getLinkDestinationInClipboard(Editor editor2) {
        boolean bl;
        String string;
        String string2 = ClipboardUtil.getTextInClipboard();
        if (string2 == null) return null;
        String path = string = string2;
        boolean bl2 = false;
        String string3 = path;
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"path");
        Url url = Urls.parse((String)string3, (boolean)true);
        if (url == null) {
            return null;
        }
        if (url instanceof LocalFileUrl) {
            Path absolutePath;
            VirtualFile virtualFile;
            VirtualFile virtualFile2;
            Path path2;
            try {
                path2 = Path.of(path, new String[0]);
            }
            catch (InvalidPathException e) {
                return null;
            }
            Path relativePath = path2;
            VirtualFile virtualFile3 = FileDocumentManager.getInstance().getFile(editor2.getDocument());
            if (virtualFile3 == null) return null;
            VirtualFile virtualFile4 = virtualFile3.getParent();
            VirtualFile virtualFile5 = virtualFile2 = virtualFile4;
            Object object = virtualFile5;
            if (virtualFile5 == null) return null;
            VirtualFile it = virtualFile = object;
            boolean bl3 = false;
            Path path3 = Path.of(it.getPath(), new String[0]);
            object = path3;
            if (path3 == null) return null;
            Path path4 = object.resolve(relativePath);
            Path path5 = absolutePath = path4;
            if (path5 == null) return null;
            bl = PathKt.exists(path5);
        } else {
            bl = true;
        }
        if (!bl) return null;
        String string4 = string;
        return string4;
    }

    private final void unwrapLink(PsiElement linkElement, Caret caret, Editor editor2, Project project) {
        PsiFile[] psiFileArray;
        PsiFile file;
        String string;
        String string2;
        block4: {
            PsiElement[] psiElementArray;
            PsiElement[] psiElementArray2;
            PsiElement[] psiElementArray3 = linkElement.getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)psiElementArray3, (String)"linkElement.children");
            for (PsiElement psiElement : psiElementArray2 = (psiElementArray = psiElementArray3)) {
                PsiElement it = psiElement;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)it), (Object)MarkdownElementTypes.LINK_TEXT)) continue;
                string2 = psiElement;
                break block4;
            }
            string2 = string = null;
        }
        if (string2 == null || (string = string.getText()) == null || (string = StringsKt.drop((String)string, (int)1)) == null || (string = StringsKt.dropLast((String)string, (int)1)) == null) {
            string = "";
        }
        String linkText = string;
        int start = UtilsKt.getStartOffset((PsiElement)linkElement);
        int newEnd = start + linkText.length();
        int n = caret.getSelectionStart() - 1;
        n = Math.min(newEnd, n);
        int selectionStart = Math.max(start, n);
        int n2 = caret.getSelectionEnd() - 1;
        n2 = Math.min(newEnd, n2);
        int selectionEnd = Math.max(start, n2);
        PsiFile psiFile = file = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor2.getDocument());
        if (psiFile != null) {
            PsiFile psiFile2;
            PsiFile it = psiFile2 = psiFile;
            boolean bl = false;
            PsiFile[] psiFileArray2 = new PsiFile[1];
            psiFileArray = psiFileArray2;
            psiFileArray2[0] = it;
        } else {
            psiFileArray = new PsiFile[]{};
        }
        PsiFile[] fileArray = psiFileArray;
        WriteCommandAction.writeCommandAction((Project)project, (PsiFile[])Arrays.copyOf(fileArray, fileArray.length)).withName(this.getUnwrapActionName()).run(new ThrowableRunnable(selectionStart, selectionEnd, caret, editor2, start, linkElement, linkText){
            final /* synthetic */ int $selectionStart;
            final /* synthetic */ int $selectionEnd;
            final /* synthetic */ Caret $caret;
            final /* synthetic */ Editor $editor;
            final /* synthetic */ int $start;
            final /* synthetic */ PsiElement $linkElement;
            final /* synthetic */ String $linkText;

            public final void run() {
                if (this.$selectionStart == this.$selectionEnd) {
                    this.$caret.removeSelection();
                    this.$caret.moveCaretRelatively(-1, 0, false, false);
                }
                this.$editor.getDocument().replaceString(this.$start, UtilsKt.getEndOffset((PsiElement)this.$linkElement), (CharSequence)this.$linkText);
                if (this.$selectionStart != this.$selectionEnd) {
                    this.$caret.setSelection(this.$selectionStart, this.$selectionEnd);
                }
            }
            {
                this.$selectionStart = n;
                this.$selectionEnd = n2;
                this.$caret = caret;
                this.$editor = editor2;
                this.$start = n3;
                this.$linkElement = psiElement;
                this.$linkText = string;
            }
        });
    }

    private final PsiElement getSelectedLinkElement(Caret $this$getSelectedLinkElement, PsiFile file) {
        Object object;
        PsiElement linkElement;
        Object v0;
        Sequence sequence;
        block3: {
            Sequence sequence2 = sequence = SequencesKt.asSequence((Iterator)PsiTreeUtilKt.elementsAtOffsetUp((PsiFile)file, (int)$this$getSelectedLinkElement.getSelectionStart()));
            for (Object e : sequence2) {
                Pair $dstr$element$_u24__u24 = (Pair)e;
                boolean bl = false;
                PsiElement element2 = (PsiElement)$dstr$element$_u24__u24.component1();
                if (!Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)element2), (Object)MarkdownElementTypes.INLINE_LINK)) continue;
                v0 = e;
                break block3;
            }
            v0 = null;
        }
        Pair pair = v0;
        PsiElement psiElement = linkElement = pair != null ? (PsiElement)pair.getFirst() : null;
        if (psiElement != null) {
            Sequence element3 = sequence = psiElement;
            boolean bl = false;
            object = ($this$getSelectedLinkElement.hasSelection() ? $this$getSelectedLinkElement.getSelectionEnd() <= UtilsKt.getEndOffset((PsiElement)element3) : $this$getSelectedLinkElement.getOffset() > UtilsKt.getStartOffset((PsiElement)element3)) ? sequence : null;
        } else {
            object = null;
        }
        return object;
    }

    public static final /* synthetic */ String access$getLinkDestinationInClipboard(MarkdownCreateLinkAction $this, Editor editor2) {
        return $this.getLinkDestinationInClipboard(editor2);
    }
}

