/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.ui.preview;

import com.intellij.CommonBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.TextEditorWithPreview;
import com.intellij.openapi.fileEditor.impl.EditorHistoryManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.util.Alarm;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseWheelEvent;
import java.beans.PropertyChangeListener;
import java.util.Objects;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.intellij.plugins.markdown.settings.MarkdownExtensionsSettings;
import org.intellij.plugins.markdown.settings.MarkdownSettings;
import org.intellij.plugins.markdown.ui.preview.MarkdownHtmlPanel;
import org.intellij.plugins.markdown.ui.preview.MarkdownHtmlPanelEx;
import org.intellij.plugins.markdown.ui.preview.MarkdownHtmlPanelProvider;
import org.intellij.plugins.markdown.ui.preview.MarkdownSplitEditorProvider;
import org.intellij.plugins.markdown.ui.preview.html.MarkdownUtil;
import org.intellij.plugins.markdown.ui.split.SplitFileEditor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MarkdownPreviewFileEditor
extends UserDataHolderBase
implements FileEditor {
    private static final long PARSING_CALL_TIMEOUT_MS = 50L;
    private static final long RENDERING_DELAY_MS = 20L;
    public static final Key<MarkdownHtmlPanel> PREVIEW_BROWSER = Key.create((String)"PREVIEW_BROWSER");
    private final Project myProject;
    private final VirtualFile myFile;
    @Nullable
    private final Document myDocument;
    private final JPanel myHtmlPanelWrapper;
    @Nullable
    private MarkdownHtmlPanel myPanel;
    @Nullable
    private MarkdownHtmlPanelProvider.ProviderInfo myLastPanelProviderInfo;
    private final Alarm myPooledAlarm;
    private final Alarm mySwingAlarm;
    private final Object REQUESTS_LOCK;
    @Nullable
    private Runnable myLastScrollRequest;
    @Nullable
    private Runnable myLastHtmlOrRefreshRequest;
    private volatile int myLastScrollOffset;
    @NotNull
    private String myLastRenderedHtml;
    private Editor mainEditor;

    public MarkdownPreviewFileEditor(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            MarkdownPreviewFileEditor.$$$reportNull$$$0(0);
        }
        if (file == null) {
            MarkdownPreviewFileEditor.$$$reportNull$$$0(1);
        }
        this.myLastPanelProviderInfo = null;
        this.myPooledAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);
        this.mySwingAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD, (Disposable)this);
        this.REQUESTS_LOCK = new Object();
        this.myLastScrollRequest = null;
        this.myLastHtmlOrRefreshRequest = null;
        this.myLastRenderedHtml = "";
        this.myProject = project;
        this.myFile = file;
        this.myDocument = FileDocumentManager.getInstance().getDocument(this.myFile);
        if (this.myDocument != null) {
            this.myDocument.addDocumentListener(new DocumentListener(){

                public void beforeDocumentChange(@NotNull DocumentEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    MarkdownPreviewFileEditor.this.myPooledAlarm.cancelAllRequests();
                }

                public void documentChanged(@NotNull DocumentEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    MarkdownPreviewFileEditor.this.myPooledAlarm.addRequest(() -> MarkdownPreviewFileEditor.this.updateHtml(), 50L);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "e";
                    objectArray2[1] = "org/intellij/plugins/markdown/ui/preview/MarkdownPreviewFileEditor$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "beforeDocumentChange";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "documentChanged";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }, (Disposable)this);
        }
        this.myHtmlPanelWrapper = new JPanel(new BorderLayout());
        this.myHtmlPanelWrapper.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                MarkdownPreviewFileEditor.this.mySwingAlarm.addRequest(() -> {
                    if (MarkdownPreviewFileEditor.this.myPanel == null) {
                        MarkdownPreviewFileEditor.this.attachHtmlPanel();
                    }
                }, 0, ModalityState.stateForComponent((Component)MarkdownPreviewFileEditor.this.getComponent()));
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                MarkdownPreviewFileEditor.this.mySwingAlarm.addRequest(() -> {
                    if (MarkdownPreviewFileEditor.this.myPanel != null) {
                        MarkdownPreviewFileEditor.this.detachHtmlPanel();
                    }
                }, 0, ModalityState.stateForComponent((Component)MarkdownPreviewFileEditor.this.getComponent()));
            }
        });
        if (MarkdownPreviewFileEditor.isPreviewShown(project, file)) {
            this.attachHtmlPanel();
        }
        MessageBusConnection messageBusConnection = this.myProject.getMessageBus().connect((Disposable)this);
        MyUpdatePanelOnSettingsChangedListener settingsChangedListener = new MyUpdatePanelOnSettingsChangedListener();
        messageBusConnection.subscribe(MarkdownSettings.ChangeListener.TOPIC, (Object)settingsChangedListener);
        messageBusConnection.subscribe(MarkdownExtensionsSettings.ChangeListener.TOPIC, fromSettingsDialog -> {
            if (!fromSettingsDialog) {
                this.mySwingAlarm.addRequest(() -> {
                    if (this.myPanel != null) {
                        this.myPanel.reloadWithOffset(this.mainEditor.getCaretModel().getOffset());
                    }
                }, 0, ModalityState.stateForComponent((Component)this.getComponent()));
            }
        });
    }

    private void setupScrollHelper() {
        EditorImpl actualEditor;
        EditorImpl editorImpl = actualEditor = this.mainEditor instanceof EditorImpl ? (EditorImpl)this.mainEditor : null;
        if (actualEditor == null) {
            return;
        }
        JScrollPane scrollPane = actualEditor.getScrollPane();
        PreciseVerticalScrollHelper helper = new PreciseVerticalScrollHelper(actualEditor, () -> this.myPanel instanceof MarkdownHtmlPanelEx ? (MarkdownHtmlPanelEx)this.myPanel : null);
        scrollPane.addMouseWheelListener(helper);
    }

    public void setMainEditor(Editor editor2) {
        this.mainEditor = editor2;
        if (Registry.is((String)"markdown.experimental.boundary.precise.scroll.enable")) {
            this.setupScrollHelper();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scrollToSrcOffset(int offset) {
        if (this.myPanel == null) {
            return;
        }
        if (!this.myPooledAlarm.isEmpty()) {
            this.myLastScrollOffset = offset;
            return;
        }
        Object object = this.REQUESTS_LOCK;
        synchronized (object) {
            if (this.myLastScrollRequest != null) {
                this.mySwingAlarm.cancelRequest(this.myLastScrollRequest);
            }
            this.myLastScrollRequest = () -> {
                if (this.myPanel != null) {
                    this.myLastScrollOffset = offset;
                    this.myPanel.scrollToMarkdownSrcOffset(this.myLastScrollOffset, true);
                    Object object = this.REQUESTS_LOCK;
                    synchronized (object) {
                        this.myLastScrollRequest = null;
                    }
                }
            };
            this.mySwingAlarm.addRequest(this.myLastScrollRequest, 20L, ModalityState.stateForComponent((Component)this.getComponent()));
        }
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myHtmlPanelWrapper;
        if (jPanel == null) {
            MarkdownPreviewFileEditor.$$$reportNull$$$0(2);
        }
        return jPanel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myPanel != null ? this.myPanel.getComponent() : null;
    }

    @NotNull
    public String getName() {
        String string = MarkdownBundle.message("markdown.editor.preview.name", new Object[0]);
        if (string == null) {
            MarkdownPreviewFileEditor.$$$reportNull$$$0(3);
        }
        return string;
    }

    public void setState(@NotNull FileEditorState state) {
        if (state == null) {
            MarkdownPreviewFileEditor.$$$reportNull$$$0(4);
        }
    }

    public boolean isModified() {
        return false;
    }

    public boolean isValid() {
        return true;
    }

    public void selectNotify() {
        if (this.myPanel != null) {
            this.updateHtmlPooled();
        }
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            MarkdownPreviewFileEditor.$$$reportNull$$$0(5);
        }
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            MarkdownPreviewFileEditor.$$$reportNull$$$0(6);
        }
    }

    @Nullable
    public FileEditorLocation getCurrentLocation() {
        return null;
    }

    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile = this.myFile;
        if (virtualFile == null) {
            MarkdownPreviewFileEditor.$$$reportNull$$$0(7);
        }
        return virtualFile;
    }

    public void dispose() {
        if (this.myPanel != null) {
            Disposer.dispose((Disposable)this.myPanel);
        }
    }

    @Nullable
    public MarkdownHtmlPanelProvider.ProviderInfo getLastPanelProviderInfo() {
        return this.myLastPanelProviderInfo;
    }

    @NotNull
    private MarkdownHtmlPanelProvider retrievePanelProvider(@NotNull MarkdownSettings settings) {
        MarkdownHtmlPanelProvider.ProviderInfo providerInfo;
        MarkdownHtmlPanelProvider provider;
        if (settings == null) {
            MarkdownPreviewFileEditor.$$$reportNull$$$0(8);
        }
        if ((provider = MarkdownHtmlPanelProvider.createFromInfo(providerInfo = settings.getPreviewPanelProviderInfo())).isAvailable() != MarkdownHtmlPanelProvider.AvailabilityInfo.AVAILABLE) {
            MarkdownHtmlPanelProvider defaultProvider = MarkdownHtmlPanelProvider.createFromInfo(MarkdownSettings.getDefaultProviderInfo());
            Messages.showMessageDialog((Component)this.myHtmlPanelWrapper, (String)MarkdownBundle.message("dialog.message.tried.to.use.preview.panel.provider", providerInfo.getName()), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
            MarkdownSettings.getInstance(this.myProject).setPreviewPanelProviderInfo(defaultProvider.getProviderInfo());
            provider = Objects.requireNonNull((MarkdownHtmlPanelProvider)ContainerUtil.find((Object[])MarkdownHtmlPanelProvider.getProviders(), p -> p.isAvailable() == MarkdownHtmlPanelProvider.AvailabilityInfo.AVAILABLE));
        }
        this.myLastPanelProviderInfo = settings.getPreviewPanelProviderInfo();
        MarkdownHtmlPanelProvider markdownHtmlPanelProvider = provider;
        if (markdownHtmlPanelProvider == null) {
            MarkdownPreviewFileEditor.$$$reportNull$$$0(9);
        }
        return markdownHtmlPanelProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateHtml() {
        if (this.myPanel == null || this.myDocument == null || !this.myFile.isValid() || Disposer.isDisposed((Disposable)this)) {
            return;
        }
        String html2 = MarkdownUtil.INSTANCE.generateMarkdownHtml(this.myFile, this.myDocument.getText(), this.myProject);
        if (!this.myFile.isValid() || Disposer.isDisposed((Disposable)this)) {
            return;
        }
        Object object = this.REQUESTS_LOCK;
        synchronized (object) {
            if (this.myLastHtmlOrRefreshRequest != null) {
                this.mySwingAlarm.cancelRequest(this.myLastHtmlOrRefreshRequest);
            }
            this.myLastHtmlOrRefreshRequest = () -> {
                if (this.myPanel == null) {
                    return;
                }
                String currentHtml = "<html><head></head>" + html2 + "</html>";
                if (!currentHtml.equals(this.myLastRenderedHtml)) {
                    this.myLastRenderedHtml = currentHtml;
                    VirtualFileSystem fileSystem = this.myFile.getFileSystem();
                    this.myPanel.setHtml(this.myLastRenderedHtml, this.mainEditor.getCaretModel().getOffset(), fileSystem.getNioPath(this.myFile));
                }
                Object object = this.REQUESTS_LOCK;
                synchronized (object) {
                    this.myLastHtmlOrRefreshRequest = null;
                }
            };
            this.mySwingAlarm.addRequest(this.myLastHtmlOrRefreshRequest, 20L, ModalityState.stateForComponent((Component)this.getComponent()));
        }
    }

    private void detachHtmlPanel() {
        if (this.myPanel != null) {
            this.myHtmlPanelWrapper.remove(this.myPanel.getComponent());
            Disposer.dispose((Disposable)this.myPanel);
            this.myPanel = null;
            this.putUserData(PREVIEW_BROWSER, null);
        }
    }

    private void attachHtmlPanel() {
        MarkdownSettings settings = MarkdownSettings.getInstance(this.myProject);
        this.myPanel = this.retrievePanelProvider(settings).createHtmlPanel(this.myProject, this.myFile);
        this.myHtmlPanelWrapper.add((Component)this.myPanel.getComponent(), "Center");
        if (this.myHtmlPanelWrapper.isShowing()) {
            this.myHtmlPanelWrapper.validate();
        }
        this.myHtmlPanelWrapper.repaint();
        this.myLastRenderedHtml = "";
        this.putUserData(PREVIEW_BROWSER, this.myPanel);
        this.updateHtmlPooled();
    }

    private void updateHtmlPooled() {
        this.myPooledAlarm.cancelAllRequests();
        this.myPooledAlarm.addRequest(() -> this.updateHtml(), 0);
    }

    private static boolean isPreviewShown(@NotNull Project project, @NotNull VirtualFile file) {
        MarkdownSplitEditorProvider provider;
        if (project == null) {
            MarkdownPreviewFileEditor.$$$reportNull$$$0(10);
        }
        if (file == null) {
            MarkdownPreviewFileEditor.$$$reportNull$$$0(11);
        }
        if ((provider = (MarkdownSplitEditorProvider)FileEditorProvider.EP_FILE_EDITOR_PROVIDER.findExtension(MarkdownSplitEditorProvider.class)) == null) {
            return true;
        }
        FileEditorState state = EditorHistoryManager.getInstance((Project)project).getState(file, (FileEditorProvider)provider);
        if (!(state instanceof SplitFileEditor.MyFileEditorState)) {
            return true;
        }
        String layout = ((SplitFileEditor.MyFileEditorState)state).getSplitLayout();
        return layout == null || !layout.equals("FIRST");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/plugins/markdown/ui/preview/MarkdownPreviewFileEditor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/plugins/markdown/ui/preview/MarkdownPreviewFileEditor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "retrievePanelProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 9: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setState";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addPropertyChangeListener";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "removePropertyChangeListener";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "retrievePanelProvider";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isPreviewShown";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class PreciseVerticalScrollHelper
    extends MouseAdapter {
        @NotNull
        private final EditorImpl editor;
        @NotNull
        private final Supplier<MarkdownHtmlPanelEx> htmlPanelSupplier;
        private int lastOffset;

        private PreciseVerticalScrollHelper(@NotNull EditorImpl editor2, @NotNull Supplier<MarkdownHtmlPanelEx> htmlPanelSupplier) {
            if (editor2 == null) {
                PreciseVerticalScrollHelper.$$$reportNull$$$0(0);
            }
            if (htmlPanelSupplier == null) {
                PreciseVerticalScrollHelper.$$$reportNull$$$0(1);
            }
            this.lastOffset = 0;
            this.editor = editor2;
            this.htmlPanelSupplier = htmlPanelSupplier;
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent event) {
            int currentOffset = this.editor.getScrollingModel().getVerticalScrollOffset();
            if (this.lastOffset == currentOffset) {
                this.boundaryReached(event);
            } else {
                this.lastOffset = currentOffset;
            }
        }

        private void boundaryReached(MouseWheelEvent event) {
            MarkdownHtmlPanelEx actualPanel = this.htmlPanelSupplier.get();
            if (actualPanel == null) {
                return;
            }
            if (event.getScrollType() == 0) {
                int multiplier = Registry.intValue((String)"ide.browser.jcef.osr.wheelRotation.factor", (int)1);
                int amount = event.getScrollAmount() * event.getWheelRotation() * multiplier;
                actualPanel.scrollBy(0, amount);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "editor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "htmlPanelSupplier";
                    break;
                }
            }
            objectArray[1] = "org/intellij/plugins/markdown/ui/preview/MarkdownPreviewFileEditor$PreciseVerticalScrollHelper";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyUpdatePanelOnSettingsChangedListener
    implements MarkdownSettings.ChangeListener {
        private MyUpdatePanelOnSettingsChangedListener() {
        }

        @Override
        public void beforeSettingsChanged(@NotNull MarkdownSettings settings) {
            if (settings == null) {
                MyUpdatePanelOnSettingsChangedListener.$$$reportNull$$$0(0);
            }
        }

        @Override
        public void settingsChanged(@NotNull MarkdownSettings settings) {
            if (settings == null) {
                MyUpdatePanelOnSettingsChangedListener.$$$reportNull$$$0(1);
            }
            MarkdownPreviewFileEditor.this.mySwingAlarm.addRequest(() -> {
                if (settings.getSplitLayout() != TextEditorWithPreview.Layout.SHOW_EDITOR) {
                    if (MarkdownPreviewFileEditor.this.myPanel == null) {
                        MarkdownPreviewFileEditor.this.attachHtmlPanel();
                    } else if (MarkdownPreviewFileEditor.this.myLastPanelProviderInfo == null || MarkdownHtmlPanelProvider.createFromInfo(MarkdownPreviewFileEditor.this.myLastPanelProviderInfo).equals(MarkdownPreviewFileEditor.this.retrievePanelProvider(settings))) {
                        MarkdownPreviewFileEditor.this.detachHtmlPanel();
                        MarkdownPreviewFileEditor.this.attachHtmlPanel();
                    }
                }
                if (MarkdownPreviewFileEditor.this.myPanel != null) {
                    MarkdownPreviewFileEditor.this.myPanel.reloadWithOffset(MarkdownPreviewFileEditor.this.mainEditor.getCaretModel().getOffset());
                }
            }, 0, ModalityState.stateForComponent((Component)MarkdownPreviewFileEditor.this.getComponent()));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "settings";
            objectArray2[1] = "org/intellij/plugins/markdown/ui/preview/MarkdownPreviewFileEditor$MyUpdatePanelOnSettingsChangedListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeSettingsChanged";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "settingsChanged";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

