/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit.codeInsight;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.execution.JUnitBundle;
import com.intellij.execution.junit.codeInsight.JUnit5MalformedParameterizedInspectionKt;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lcom/intellij/execution/junit/codeInsight/CsvChecker;", "", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "(Lcom/intellij/codeInspection/ProblemsHolder;)V", "getHolder", "()Lcom/intellij/codeInspection/ProblemsHolder;", "checkFileSource", "", "methodSource", "Lcom/intellij/psi/PsiAnnotation;", "intellij.junit"})
final class CsvChecker {
    @NotNull
    private final ProblemsHolder holder;

    public final void checkFileSource(@NotNull PsiAnnotation methodSource) {
        Intrinsics.checkNotNullParameter((Object)methodSource, (String)"methodSource");
        PsiAnnotationMemberValue annotationMemberValue = methodSource.findDeclaredAttributeValue("resources");
        JUnit5MalformedParameterizedInspectionKt.access$processArrayInAnnotationParameter(annotationMemberValue, (Function1)new Function1<PsiAnnotationMemberValue, Unit>(this){
            final /* synthetic */ CsvChecker this$0;

            public final void invoke(@NotNull PsiAnnotationMemberValue attributeValue) {
                Intrinsics.checkNotNullParameter((Object)attributeValue, (String)"attributeValue");
                PsiReference[] psiReferenceArray = attributeValue.getReferences();
                int n = psiReferenceArray.length;
                for (int i = 0; i < n; ++i) {
                    ResolveResult[] resolveResultArray;
                    PsiReference ref;
                    PsiReference psiReference = ref = psiReferenceArray[i];
                    Intrinsics.checkNotNullExpressionValue((Object)psiReference, (String)"ref");
                    if (psiReference.isSoft() || !(ref instanceof FileReference)) continue;
                    Intrinsics.checkNotNullExpressionValue((Object)((FileReference)ref).multiResolve(false), (String)"ref.multiResolve(false)");
                    if (!(resolveResultArray.length == 0)) continue;
                    LocalQuickFix[] localQuickFixArray = ((FileReference)ref).getQuickFixes();
                    this.this$0.getHolder().registerProblem(((FileReference)ref).getElement(), ((FileReference)ref).getRangeInElement(), JUnitBundle.message("junit5.malformed.parameterized.inspection.description.file.source", attributeValue.getText()), Arrays.copyOf(localQuickFixArray, localQuickFixArray.length));
                }
            }
            {
                this.this$0 = csvChecker;
                super(1);
            }
        });
    }

    @NotNull
    public final ProblemsHolder getHolder() {
        return this.holder;
    }

    public CsvChecker(@NotNull ProblemsHolder holder) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        this.holder = holder;
    }
}

