/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit.codeInsight;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.IntentionWrapper;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.execution.JUnitBundle;
import com.intellij.lang.jvm.DefaultJvmElementVisitor;
import com.intellij.lang.jvm.JvmElementVisitor;
import com.intellij.lang.jvm.JvmField;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.lang.jvm.JvmModifiersOwner;
import com.intellij.lang.jvm.actions.ChangeModifierRequest;
import com.intellij.lang.jvm.actions.JvmElementActionFactories;
import com.intellij.lang.jvm.actions.MemberRequestsKt;
import com.intellij.lang.jvm.inspection.JvmLocalInspection;
import com.intellij.lang.jvm.types.JvmType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import java.util.Arrays;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005H\u0014\u00a8\u0006\u000b"}, d2={"Lcom/intellij/execution/junit/codeInsight/JUnit5MalformedExtensionsInspection;", "Lcom/intellij/lang/jvm/inspection/JvmLocalInspection;", "()V", "buildVisitor", "Lcom/intellij/lang/jvm/JvmElementVisitor;", "", "project", "Lcom/intellij/openapi/project/Project;", "sink", "Lcom/intellij/lang/jvm/inspection/JvmLocalInspection$HighlightSink;", "isOnTheFly", "intellij.junit"})
public final class JUnit5MalformedExtensionsInspection
extends JvmLocalInspection {
    @NotNull
    protected JvmElementVisitor<Boolean> buildVisitor(@NotNull Project project, @NotNull JvmLocalInspection.HighlightSink sink, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        return (JvmElementVisitor)new DefaultJvmElementVisitor<Boolean>(sink){
            final /* synthetic */ JvmLocalInspection.HighlightSink $sink;

            @NotNull
            public Boolean visitField(@NotNull JvmField field) {
                Intrinsics.checkNotNullParameter((Object)field, (String)"field");
                if (field.hasAnnotation("org.junit.jupiter.api.extension.RegisterExtension") && field.getType() instanceof PsiType) {
                    JvmType jvmType = field.getType();
                    if (jvmType == null) {
                        throw new NullPointerException("null cannot be cast to non-null type com.intellij.psi.PsiType");
                    }
                    PsiType psiType = (PsiType)jvmType;
                    if (!InheritanceUtil.isInheritor((PsiType)psiType, (String)"org.junit.jupiter.api.extension.Extension")) {
                        this.$sink.highlight(JUnitBundle.message("junit5.malformed.extension.registration.message", psiType.getCanonicalText(), "org.junit.jupiter.api.extension.Extension"), new LocalQuickFix[0]);
                    } else if (!field.hasModifier(JvmModifier.STATIC) && (InheritanceUtil.isInheritor((PsiType)psiType, (String)"org.junit.jupiter.api.extension.BeforeAllCallback") || InheritanceUtil.isInheritor((PsiType)psiType, (String)"org.junit.jupiter.api.extension.AfterAllCallback"))) {
                        Collection $this$toTypedArray$iv = JvmElementActionFactories.createModifierActions((JvmModifiersOwner)((JvmModifiersOwner)field), (ChangeModifierRequest)MemberRequestsKt.modifierRequest((JvmModifier)JvmModifier.STATIC, (boolean)true));
                        boolean $i$f$toTypedArray = false;
                        Collection thisCollection$iv = $this$toTypedArray$iv;
                        IntentionAction[] intentionActionArray = thisCollection$iv.toArray(new IntentionAction[0]);
                        if (intentionActionArray == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
                        }
                        IntentionAction[] fixes = intentionActionArray;
                        String string = JUnitBundle.message("junit5.malformed.extension.class.level.message", psiType.getPresentableText());
                        PsiElement psiElement = field.getSourceElement();
                        Intrinsics.checkNotNull((Object)psiElement);
                        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"field.sourceElement!!");
                        LocalQuickFix[] localQuickFixArray = IntentionWrapper.wrapToQuickFixes((IntentionAction[])fixes, (PsiFile)psiElement.getContainingFile());
                        this.$sink.highlight(string, Arrays.copyOf(localQuickFixArray, localQuickFixArray.length));
                    }
                }
                return true;
            }
            {
                this.$sink = $captured_local_variable$0;
            }
        };
    }
}

