/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit.codeInsight;

import com.intellij.codeInsight.MetaAnnotationUtil;
import com.intellij.execution.junit.codeInsight.JUnit5MalformedParameterizedInspection;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.uast.UMethod;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u00006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\"\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\tH\u0002\u001a5\u0010\n\u001a\u00020\u000b2\b\u0010\u0002\u001a\u0004\u0018\u00010\f2!\u0010\r\u001a\u001d\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0011\u0012\u0004\u0012\u00020\u000b0\u000eH\u0002\u00a8\u0006\u0012"}, d2={"getElementToHighlight", "Lcom/intellij/psi/PsiElement;", "attributeValue", "method", "Lorg/jetbrains/uast/UMethod;", "default", "Lcom/intellij/psi/PsiNameIdentifierOwner;", "hasMultipleParameters", "", "Lcom/intellij/psi/PsiMethod;", "processArrayInAnnotationParameter", "", "Lcom/intellij/psi/PsiAnnotationMemberValue;", "checker", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "value", "intellij.junit"})
public final class JUnit5MalformedParameterizedInspectionKt {
    private static final void processArrayInAnnotationParameter(PsiAnnotationMemberValue attributeValue, Function1<? super PsiAnnotationMemberValue, Unit> checker) {
        if (attributeValue instanceof PsiLiteral || attributeValue instanceof PsiClassObjectAccessExpression) {
            checker.invoke((Object)attributeValue);
        } else if (attributeValue instanceof PsiArrayInitializerMemberValue) {
            for (PsiAnnotationMemberValue memberValue : ((PsiArrayInitializerMemberValue)attributeValue).getInitializers()) {
                JUnit5MalformedParameterizedInspectionKt.processArrayInAnnotationParameter(memberValue, checker);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean hasMultipleParameters(PsiMethod method) {
        PsiClass containingClass = method.getContainingClass();
        if (containingClass == null) return false;
        PsiParameterList psiParameterList = method.getParameterList();
        Intrinsics.checkNotNullExpressionValue((Object)psiParameterList, (String)"method.parameterList");
        PsiParameter[] psiParameterArray = psiParameterList.getParameters();
        Intrinsics.checkNotNullExpressionValue((Object)psiParameterArray, (String)"method.parameterList.parameters");
        PsiParameter[] $this$count$iv = psiParameterArray;
        boolean $i$f$count = false;
        int count$iv = 0;
        for (PsiParameter element$iv : $this$count$iv) {
            PsiParameter it = element$iv;
            boolean bl = false;
            PsiParameter psiParameter = it;
            Intrinsics.checkNotNullExpressionValue((Object)psiParameter, (String)"it");
            if (!(!InheritanceUtil.isInheritor((PsiType)psiParameter.getType(), (String)"org.junit.jupiter.api.TestInfo") && !InheritanceUtil.isInheritor((PsiType)it.getType(), (String)"org.junit.jupiter.api.TestReporter"))) continue;
            ++count$iv;
        }
        if (count$iv <= true) return false;
        if (MetaAnnotationUtil.isMetaAnnotated((PsiModifierListOwner)((PsiModifierListOwner)method), (Collection)JUnit5MalformedParameterizedInspection.Annotations.INSTANCE.getEXTENDS_WITH())) return false;
        if (MetaAnnotationUtil.isMetaAnnotatedInHierarchy((PsiModifierListOwner)((PsiModifierListOwner)containingClass), (Collection)JUnit5MalformedParameterizedInspection.Annotations.INSTANCE.getEXTENDS_WITH())) return false;
        return true;
    }

    private static final PsiElement getElementToHighlight(PsiElement attributeValue, UMethod method, PsiNameIdentifierOwner psiNameIdentifierOwner) {
        PsiElement psiElement;
        if (PsiTreeUtilKt.isAncestor((PsiElement)((PsiElement)method.getJavaPsi()), (PsiElement)attributeValue, (boolean)true)) {
            psiElement = attributeValue;
        } else {
            PsiElement psiElement2 = psiNameIdentifierOwner.getNameIdentifier();
            if (psiElement2 == null) {
                psiElement2 = (PsiElement)psiNameIdentifierOwner;
            }
            psiElement = psiElement2;
            Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"default.nameIdentifier ?: default");
        }
        return psiElement;
    }

    static /* synthetic */ PsiElement getElementToHighlight$default(PsiElement psiElement, UMethod uMethod, PsiNameIdentifierOwner psiNameIdentifierOwner, int n, Object object) {
        if ((n & 4) != 0) {
            psiNameIdentifierOwner = (PsiNameIdentifierOwner)uMethod.getJavaPsi();
        }
        return JUnit5MalformedParameterizedInspectionKt.getElementToHighlight(psiElement, uMethod, psiNameIdentifierOwner);
    }

    public static final /* synthetic */ boolean access$hasMultipleParameters(PsiMethod method) {
        return JUnit5MalformedParameterizedInspectionKt.hasMultipleParameters(method);
    }

    public static final /* synthetic */ void access$processArrayInAnnotationParameter(PsiAnnotationMemberValue attributeValue, Function1 checker) {
        JUnit5MalformedParameterizedInspectionKt.processArrayInAnnotationParameter(attributeValue, (Function1<? super PsiAnnotationMemberValue, Unit>)checker);
    }

    public static final /* synthetic */ PsiElement access$getElementToHighlight(PsiElement attributeValue, UMethod method, PsiNameIdentifierOwner psiNameIdentifierOwner) {
        return JUnit5MalformedParameterizedInspectionKt.getElementToHighlight(attributeValue, method, psiNameIdentifierOwner);
    }
}

