/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit.codeInsight;

import com.intellij.codeInsight.daemon.impl.analysis.JavaGenericsUtil;
import com.intellij.codeInspection.AnalysisUastUtilKt;
import com.intellij.codeInspection.IntentionWrapper;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.execution.JUnitBundle;
import com.intellij.execution.junit.codeInsight.JUnit5MalformedParameterizedInspectionKt;
import com.intellij.execution.junit.codeInsight.references.MethodSourceReference;
import com.intellij.lang.jvm.JvmClass;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.lang.jvm.JvmModifiersOwner;
import com.intellij.lang.jvm.JvmParameter;
import com.intellij.lang.jvm.actions.AnnotationAttributeRequest;
import com.intellij.lang.jvm.actions.AnnotationAttributeValueRequestKt;
import com.intellij.lang.jvm.actions.AnnotationRequest;
import com.intellij.lang.jvm.actions.AnnotationRequestsKt;
import com.intellij.lang.jvm.actions.CreateMethodRequest;
import com.intellij.lang.jvm.actions.JvmElementActionFactories;
import com.intellij.lang.jvm.actions.MethodRequestsKt;
import com.intellij.lang.jvm.types.JvmType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.tree.java.PsiNameValuePairImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Query;
import com.intellij.util.SmartList;
import com.siyeh.ig.psiutils.TestUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastContextKt;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ*\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\n2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\nH\u0002J\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00142\u0006\u0010\t\u001a\u00020\u0016H\u0002J(\u0010\u0017\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001c"}, d2={"Lcom/intellij/execution/junit/codeInsight/MethodSourceChecker;", "", "problemsHolder", "Lcom/intellij/codeInspection/ProblemsHolder;", "(Lcom/intellij/codeInspection/ProblemsHolder;)V", "getProblemsHolder", "()Lcom/intellij/codeInspection/ProblemsHolder;", "checkMethodSource", "", "method", "Lorg/jetbrains/uast/UMethod;", "methodSource", "Lcom/intellij/psi/PsiAnnotation;", "doCheckSourceProvider", "sourceProvider", "containingClass", "Lcom/intellij/psi/PsiClass;", "attributeValue", "Lcom/intellij/psi/PsiElement;", "getComponentType", "Lcom/intellij/psi/PsiType;", "returnType", "Lcom/intellij/psi/PsiMethod;", "highlightAbsentSourceProvider", "sourceProviderName", "", "implementationsTestInstanceAnnotated", "", "intellij.junit"})
final class MethodSourceChecker {
    @NotNull
    private final ProblemsHolder problemsHolder;

    public final void checkMethodSource(@NotNull UMethod method, @NotNull PsiAnnotation methodSource) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)methodSource, (String)"methodSource");
        PsiMethod psiMethod = method.getJavaPsi();
        PsiClass psiClass = psiMethod.getContainingClass();
        if (psiClass == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiClass, (String)"psiMethod.containingClass ?: return");
        PsiClass containingClass = psiClass;
        PsiAnnotationMemberValue annotationMemberValue = methodSource.findDeclaredAttributeValue("value");
        if (annotationMemberValue == null) {
            PsiMethod psiMethod2;
            block8: {
                if (methodSource.findAttributeValue("value") == null) {
                    return;
                }
                PsiMethod[] psiMethodArray = containingClass.findMethodsByName(method.getName(), true);
                Intrinsics.checkNotNullExpressionValue((Object)psiMethodArray, (String)"containingClass.findMeth\u2026ByName(method.name, true)");
                PsiMethod[] $this$singleOrNull$iv = psiMethodArray;
                boolean $i$f$singleOrNull = false;
                PsiMethod single$iv = null;
                boolean found$iv = false;
                for (PsiMethod element$iv : $this$singleOrNull$iv) {
                    JvmParameter[] jvmParameterArray;
                    PsiMethod it = element$iv;
                    boolean bl = false;
                    PsiMethod psiMethod3 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)psiMethod3, (String)"it");
                    Intrinsics.checkNotNullExpressionValue((Object)psiMethod3.getParameters(), (String)"it.parameters");
                    if (!(jvmParameterArray.length == 0)) continue;
                    if (found$iv) {
                        psiMethod2 = null;
                        break block8;
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                psiMethod2 = !found$iv ? null : single$iv;
            }
            PsiMethod foundMethod = psiMethod2;
            PsiElement $this$toUElementOfType$iv = (PsiElement)foundMethod;
            boolean $i$f$toUElementOfType = false;
            UMethod uFoundMethod = (UMethod)UastContextKt.toUElement((PsiElement)$this$toUElementOfType$iv, UMethod.class);
            if (uFoundMethod != null) {
                this.doCheckSourceProvider(uFoundMethod, containingClass, (PsiElement)methodSource, method);
            } else {
                this.highlightAbsentSourceProvider(containingClass, (PsiElement)methodSource, method.getName(), method);
            }
        } else {
            JUnit5MalformedParameterizedInspectionKt.access$processArrayInAnnotationParameter(annotationMemberValue, (Function1)new Function1<PsiAnnotationMemberValue, Unit>(this, containingClass, method){
                final /* synthetic */ MethodSourceChecker this$0;
                final /* synthetic */ PsiClass $containingClass;
                final /* synthetic */ UMethod $method;

                public final void invoke(@NotNull PsiAnnotationMemberValue attributeValue) {
                    Intrinsics.checkNotNullParameter((Object)attributeValue, (String)"attributeValue");
                    for (PsiReference reference : attributeValue.getReferences()) {
                        if (!(reference instanceof MethodSourceReference)) continue;
                        PsiElement resolve = reference.resolve();
                        if (!(resolve instanceof PsiMethod)) {
                            PsiElement psiElement = (PsiElement)attributeValue;
                            String string = ((MethodSourceReference)reference).getValue();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"reference.value");
                            MethodSourceChecker.access$highlightAbsentSourceProvider(this.this$0, this.$containingClass, psiElement, string, this.$method);
                            continue;
                        }
                        PsiMethod sourceProvider = (PsiMethod)resolve;
                        PsiElement $this$toUElementOfType$iv = (PsiElement)sourceProvider;
                        boolean $i$f$toUElementOfType = false;
                        UMethod uSourceProvider = (UMethod)UastContextKt.toUElement((PsiElement)$this$toUElementOfType$iv, UMethod.class);
                        if (uSourceProvider == null) continue;
                        MethodSourceChecker.access$doCheckSourceProvider(this.this$0, uSourceProvider, this.$containingClass, (PsiElement)attributeValue, this.$method);
                    }
                }
                {
                    this.this$0 = methodSourceChecker;
                    this.$containingClass = psiClass;
                    this.$method = uMethod;
                    super(1);
                }
            });
        }
    }

    private final boolean implementationsTestInstanceAnnotated(PsiClass containingClass) {
        Object v1;
        block1: {
            Query query = ClassInheritorsSearch.search((PsiClass)containingClass, (SearchScope)((SearchScope)containingClass.getResolveScope()), (boolean)true);
            Intrinsics.checkNotNullExpressionValue((Object)query, (String)"ClassInheritorsSearch.se\u2026Class.resolveScope, true)");
            Iterable $this$firstOrNull$iv = (Iterable)query;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PsiClass it = (PsiClass)element$iv;
                boolean bl = false;
                if (!TestUtils.testInstancePerClass((PsiClass)it)) continue;
                v1 = element$iv;
                break block1;
            }
            v1 = null;
        }
        PsiClass implementations = v1;
        return implementations != null;
    }

    private final PsiType getComponentType(PsiType returnType, PsiMethod method) {
        PsiType collectionItemType = JavaGenericsUtil.getCollectionItemType((PsiType)returnType, (GlobalSearchScope)method.getResolveScope());
        if (collectionItemType != null) {
            return collectionItemType;
        }
        if (InheritanceUtil.isInheritor((PsiType)returnType, (String)"java.util.stream.IntStream")) {
            return (PsiType)PsiType.INT;
        }
        if (InheritanceUtil.isInheritor((PsiType)returnType, (String)"java.util.stream.LongStream")) {
            return (PsiType)PsiType.LONG;
        }
        if (InheritanceUtil.isInheritor((PsiType)returnType, (String)"java.util.stream.DoubleStream")) {
            return (PsiType)PsiType.DOUBLE;
        }
        PsiType streamItemType = PsiUtil.substituteTypeParameter((PsiType)returnType, (String)"java.util.stream.Stream", (int)0, (boolean)true);
        if (streamItemType != null) {
            return streamItemType;
        }
        return PsiUtil.substituteTypeParameter((PsiType)returnType, (String)"java.util.Iterator", (int)0, (boolean)true);
    }

    private final void doCheckSourceProvider(UMethod sourceProvider, PsiClass containingClass, PsiElement attributeValue, UMethod method) {
        UElement uElement = UastContextKt.toUElement((PsiElement)JUnit5MalformedParameterizedInspectionKt.getElementToHighlight$default(attributeValue, method, null, 4, null));
        if (uElement == null || (uElement = uElement.getSourcePsi()) == null) {
            return;
        }
        UElement sourcePsi = uElement;
        String providerName = sourceProvider.getName();
        if (!(sourceProvider.isStatic() || containingClass == null || TestUtils.testInstancePerClass((PsiClass)containingClass) || this.implementationsTestInstanceAnnotated(containingClass))) {
            PsiAnnotation psiAnnotation = JavaPsiFacade.getElementFactory((Project)containingClass.getProject()).createAnnotationFromText("@org.junit.jupiter.api.TestInstance(TestInstance.Lifecycle.PER_CLASS)", (PsiElement)containingClass);
            Intrinsics.checkNotNullExpressionValue((Object)psiAnnotation, (String)"JavaPsiFacade.getElement\u2026R_CLASS, containingClass)");
            PsiAnnotation annotation = psiAnnotation;
            SmartList actions = new SmartList();
            Object e = annotation.getAttributes().get(0);
            if (e == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.psi.impl.source.tree.java.PsiNameValuePairImpl");
            }
            PsiAnnotationMemberValue value = ((PsiNameValuePairImpl)e).getValue();
            if (value != null) {
                JvmModifiersOwner jvmModifiersOwner = (JvmModifiersOwner)containingClass;
                AnnotationAttributeRequest[] annotationAttributeRequestArray = new AnnotationAttributeRequest[1];
                String string = value.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"value.text");
                annotationAttributeRequestArray[0] = AnnotationAttributeValueRequestKt.constantAttribute((String)"value", (String)string);
                actions.addAll((Collection)JvmElementActionFactories.createAddAnnotationActions((JvmModifiersOwner)jvmModifiersOwner, (AnnotationRequest)AnnotationRequestsKt.annotationRequest((String)"org.junit.jupiter.api.TestInstance", (AnnotationAttributeRequest[])annotationAttributeRequestArray)));
            }
            actions.addAll((Collection)AnalysisUastUtilKt.createMakeStaticActions((UMethod)sourceProvider));
            List list = IntentionWrapper.wrapToQuickFixes((List)((List)actions), (PsiFile)sourceProvider.getJavaPsi().getContainingFile());
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"IntentionWrapper.wrapToQ\u2026r.javaPsi.containingFile)");
            Collection $this$toTypedArray$iv = list;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            LocalQuickFix[] localQuickFixArray = thisCollection$iv.toArray(new LocalQuickFix[0]);
            if (localQuickFixArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            }
            LocalQuickFix[] intention = localQuickFixArray;
            this.problemsHolder.registerProblem((PsiElement)sourcePsi, JUnitBundle.message("junit5.malformed.parameterized.inspection.description.method.source.static", providerName), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, Arrays.copyOf(intention, intention.length));
        } else {
            Collection annotation = sourceProvider.getUastParameters();
            if (!annotation.isEmpty()) {
                this.problemsHolder.registerProblem((PsiElement)sourcePsi, JUnitBundle.message("junit5.malformed.parameterized.inspection.description.method.source.no.params", providerName), new LocalQuickFix[0]);
            } else {
                PsiType componentType = this.getComponentType(sourceProvider.getReturnType(), method.getJavaPsi());
                if (componentType == null) {
                    this.problemsHolder.registerProblem((PsiElement)sourcePsi, JUnitBundle.message("junit5.malformed.parameterized.inspection.description.method.source.return.type", providerName), new LocalQuickFix[0]);
                } else if (JUnit5MalformedParameterizedInspectionKt.access$hasMultipleParameters(method.getJavaPsi()) && !InheritanceUtil.isInheritor((PsiType)componentType, (String)"org.junit.jupiter.params.provider.Arguments") && !componentType.equalsToText("java.lang.Object") && !componentType.getDeepComponentType().equalsToText("java.lang.Object")) {
                    this.problemsHolder.registerProblem((PsiElement)sourcePsi, JUnitBundle.message("junit5.malformed.parameterized.inspection.description.wrapped.in.arguments", new Object[0]), new LocalQuickFix[0]);
                }
            }
        }
    }

    private final void highlightAbsentSourceProvider(PsiClass containingClass, PsiElement attributeValue, String sourceProviderName, UMethod method) {
        PsiElement $this$toUElementOfType$iv = JUnit5MalformedParameterizedInspectionKt.getElementToHighlight$default(attributeValue, method, null, 4, null);
        boolean $i$f$toUElementOfType = false;
        UElement uElement = UastContextKt.toUElement((PsiElement)$this$toUElementOfType$iv, UElement.class);
        if (uElement == null) {
            return;
        }
        UElement elementToHighlight = uElement;
        PsiElement psiElement = elementToHighlight.getSourcePsi();
        if (psiElement == null) {
            return;
        }
        PsiElement sourcePsi = psiElement;
        if (this.problemsHolder.isOnTheFly()) {
            SmartList modifiers = new SmartList((Object)JvmModifier.PUBLIC);
            if (!TestUtils.testInstancePerClass((PsiClass)containingClass)) {
                modifiers.add((Object)JvmModifier.STATIC);
            }
            PsiType psiType = JavaPsiFacade.getElementFactory((Project)containingClass.getProject()).createTypeFromText("java.util.stream.Stream<org.junit.jupiter.params.provider.Arguments>", (PsiElement)containingClass);
            Intrinsics.checkNotNullExpressionValue((Object)psiType, (String)"JavaPsiFacade.getElement\u2026RN_TYPE, containingClass)");
            PsiType typeFromText = psiType;
            Project project = containingClass.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"containingClass.project");
            CreateMethodRequest request = MethodRequestsKt.methodRequest((Project)project, (String)sourceProviderName, (List)((List)modifiers), (JvmType)((JvmType)typeFromText));
            List actions = JvmElementActionFactories.createMethodActions((JvmClass)((JvmClass)containingClass), (CreateMethodRequest)request);
            List list = IntentionWrapper.wrapToQuickFixes((List)actions, (PsiFile)containingClass.getContainingFile());
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"IntentionWrapper.wrapToQ\u2026ningClass.containingFile)");
            Collection $this$toTypedArray$iv = list;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            LocalQuickFix[] localQuickFixArray = thisCollection$iv.toArray(new LocalQuickFix[0]);
            if (localQuickFixArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            }
            LocalQuickFix[] intention = localQuickFixArray;
            LocalQuickFix[] localQuickFixArray2 = intention;
            if (!(localQuickFixArray2.length == 0)) {
                this.problemsHolder.registerProblem(sourcePsi, JUnitBundle.message("junit5.malformed.parameterized.inspection.description.method.source.unresolved", sourceProviderName), new LocalQuickFix[]{intention[0]});
            }
        }
    }

    @NotNull
    public final ProblemsHolder getProblemsHolder() {
        return this.problemsHolder;
    }

    public MethodSourceChecker(@NotNull ProblemsHolder problemsHolder) {
        Intrinsics.checkNotNullParameter((Object)problemsHolder, (String)"problemsHolder");
        this.problemsHolder = problemsHolder;
    }

    public static final /* synthetic */ void access$highlightAbsentSourceProvider(MethodSourceChecker $this, PsiClass containingClass, PsiElement attributeValue, String sourceProviderName, UMethod method) {
        $this.highlightAbsentSourceProvider(containingClass, attributeValue, sourceProviderName, method);
    }

    public static final /* synthetic */ void access$doCheckSourceProvider(MethodSourceChecker $this, UMethod sourceProvider, PsiClass containingClass, PsiElement attributeValue, UMethod method) {
        $this.doCheckSourceProvider(sourceProvider, containingClass, attributeValue, method);
    }
}

