/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit.codeInsight;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.execution.JUnitBundle;
import com.intellij.execution.junit.codeInsight.JUnit5MalformedParameterizedInspectionKt;
import com.intellij.execution.junit.codeInsight.SingleParameterChecker;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UParameter;
import org.jetbrains.uast.UastContextKt;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0016\u0010\u000f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\nJ \u0010\u0010\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\fH\u0002J\u0016\u0010\u0014\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0016"}, d2={"Lcom/intellij/execution/junit/codeInsight/SingleParameterChecker;", "", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "(Lcom/intellij/codeInspection/ProblemsHolder;)V", "getHolder", "()Lcom/intellij/codeInspection/ProblemsHolder;", "checkEnumConstants", "", "enumSource", "Lcom/intellij/psi/PsiAnnotation;", "enumType", "Lcom/intellij/psi/PsiType;", "method", "Lorg/jetbrains/uast/UMethod;", "checkEnumSource", "checkSourceTypeAndParameterTypeAgree", "attributeValue", "Lcom/intellij/psi/PsiAnnotationMemberValue;", "componentType", "checkValuesSource", "valuesSource", "intellij.junit"})
final class SingleParameterChecker {
    @NotNull
    private final ProblemsHolder holder;

    public final void checkEnumSource(@NotNull UMethod method, @NotNull PsiAnnotation enumSource) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)enumSource, (String)"enumSource");
        PsiAnnotationMemberValue value = enumSource.findAttributeValue("value");
        if (value instanceof PsiClassObjectAccessExpression) {
            PsiTypeElement psiTypeElement = ((PsiClassObjectAccessExpression)value).getOperand();
            Intrinsics.checkNotNullExpressionValue((Object)psiTypeElement, (String)"value.operand");
            PsiType psiType = psiTypeElement.getType();
            Intrinsics.checkNotNullExpressionValue((Object)psiType, (String)"value.operand.type");
            PsiType enumType = psiType;
            this.checkSourceTypeAndParameterTypeAgree(method, value, enumType);
            this.checkEnumConstants(enumSource, enumType, method);
        }
    }

    public final void checkValuesSource(@NotNull UMethod method, @NotNull PsiAnnotation valuesSource) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)valuesSource, (String)"valuesSource");
        PsiMethod psiMethod = method.getJavaPsi();
        Map possibleValues = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"strings", (Object)PsiType.getJavaLangString((PsiManager)psiMethod.getManager(), (GlobalSearchScope)psiMethod.getResolveScope())), TuplesKt.to((Object)"ints", (Object)PsiType.INT), TuplesKt.to((Object)"longs", (Object)PsiType.LONG), TuplesKt.to((Object)"doubles", (Object)PsiType.DOUBLE), TuplesKt.to((Object)"shorts", (Object)PsiType.SHORT), TuplesKt.to((Object)"bytes", (Object)PsiType.BYTE), TuplesKt.to((Object)"floats", (Object)PsiType.FLOAT), TuplesKt.to((Object)"chars", (Object)PsiType.CHAR), TuplesKt.to((Object)"booleans", (Object)PsiType.BOOLEAN), TuplesKt.to((Object)"classes", (Object)PsiType.getJavaLangClass((PsiManager)psiMethod.getManager(), (GlobalSearchScope)psiMethod.getResolveScope()))});
        for (String valueKey : possibleValues.keySet()) {
            JUnit5MalformedParameterizedInspectionKt.access$processArrayInAnnotationParameter(valuesSource.findDeclaredAttributeValue(valueKey), (Function1)new Function1<PsiAnnotationMemberValue, Unit>(this, possibleValues, valueKey, method){
                final /* synthetic */ SingleParameterChecker this$0;
                final /* synthetic */ Map $possibleValues;
                final /* synthetic */ String $valueKey;
                final /* synthetic */ UMethod $method;

                public final void invoke(@NotNull PsiAnnotationMemberValue value) {
                    block0: {
                        PsiType psiType;
                        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                        PsiType psiType2 = (PsiType)this.$possibleValues.get(this.$valueKey);
                        if (psiType2 == null) break block0;
                        PsiType it = psiType = psiType2;
                        boolean bl = false;
                        SingleParameterChecker.access$checkSourceTypeAndParameterTypeAgree(this.this$0, this.$method, value, it);
                    }
                }
                {
                    this.this$0 = singleParameterChecker;
                    this.$possibleValues = map;
                    this.$valueKey = string;
                    this.$method = uMethod;
                    super(1);
                }
            });
        }
        PsiAnnotationParameterList psiAnnotationParameterList = valuesSource.getParameterList();
        Intrinsics.checkNotNullExpressionValue((Object)psiAnnotationParameterList, (String)"valuesSource.parameterList");
        int attributesNumber = psiAnnotationParameterList.getAttributes().length;
        PsiElement $this$toUElementOfType$iv = JUnit5MalformedParameterizedInspectionKt.getElementToHighlight$default((PsiElement)valuesSource, method, null, 4, null);
        boolean $i$f$toUElementOfType = false;
        UAnnotation uAnnotation = (UAnnotation)UastContextKt.toUElement((PsiElement)$this$toUElementOfType$iv, UAnnotation.class);
        if (uAnnotation == null || (uAnnotation = uAnnotation.getUastAnchor()) == null || (uAnnotation = uAnnotation.getSourcePsi()) == null) {
            return;
        }
        UAnnotation sourcePsi = uAnnotation;
        if (attributesNumber > 1) {
            this.holder.registerProblem((PsiElement)sourcePsi, JUnitBundle.message("junit5.malformed.parameterized.inspection.description.exactly.one.type.of.input.must.be.provided", new Object[0]), new LocalQuickFix[0]);
        } else if (attributesNumber == 0) {
            this.holder.registerProblem((PsiElement)sourcePsi, JUnitBundle.message("junit5.malformed.parameterized.inspection.description.no.value.source.is.defined", new Object[0]), new LocalQuickFix[0]);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkEnumConstants(PsiAnnotation enumSource, PsiType enumType, UMethod method) {
        PsiAnnotationMemberValue mode = enumSource.findAttributeValue("mode");
        if (mode instanceof PsiReferenceExpression && (Intrinsics.areEqual((Object)"INCLUDE", (Object)((PsiReferenceExpression)mode).getReferenceName()) || Intrinsics.areEqual((Object)"EXCLUDE", (Object)((PsiReferenceExpression)mode).getReferenceName()))) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv;
            List parameters;
            PsiField[] psiFieldArray;
            PsiType validType = enumType;
            if (Intrinsics.areEqual((Object)enumType.getCanonicalText(), (Object)"org.junit.jupiter.params.provider.NullEnum") && !(psiFieldArray = (PsiField[])(parameters = method.getUastParameters())).isEmpty()) {
                validType = ((UParameter)CollectionsKt.first((List)parameters)).getType();
            }
            PsiClass psiClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)validType);
            if (psiClass == null) {
                return;
            }
            Intrinsics.checkNotNullExpressionValue((Object)psiClass, (String)"(PsiUtil.resolveClassInC\u2026nly(validType) ?: return)");
            PsiField[] psiFieldArray2 = psiClass.getFields();
            Intrinsics.checkNotNullExpressionValue((Object)psiFieldArray2, (String)"(PsiUtil.resolveClassInC\u2026idType) ?: return).fields");
            psiFieldArray = psiFieldArray2;
            boolean $i$f$filterIsInstance = false;
            void var9_9 = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof PsiEnumConstant)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterIsInstance$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterIsInstanceTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                PsiEnumConstant psiEnumConstant = (PsiEnumConstant)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String string = it.getName();
                collection.add(string);
            }
            Set allEnumConstants = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            Set definedConstants = new LinkedHashSet();
            JUnit5MalformedParameterizedInspectionKt.access$processArrayInAnnotationParameter(enumSource.findAttributeValue("names"), (Function1)new Function1<PsiAnnotationMemberValue, Unit>(this, method, allEnumConstants, definedConstants){
                final /* synthetic */ SingleParameterChecker this$0;
                final /* synthetic */ UMethod $method;
                final /* synthetic */ Set $allEnumConstants;
                final /* synthetic */ Set $definedConstants;

                public final void invoke(@NotNull PsiAnnotationMemberValue name) {
                    Object value;
                    Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                    if (name instanceof PsiLiteralExpression && (value = ((PsiLiteralExpression)name).getValue()) instanceof String) {
                        UElement uElement = UastContextKt.toUElement((PsiElement)JUnit5MalformedParameterizedInspectionKt.getElementToHighlight$default((PsiElement)name, this.$method, null, 4, null));
                        if (uElement == null || (uElement = uElement.getSourcePsi()) == null) {
                            return;
                        }
                        UElement sourcePsi = uElement;
                        if (!this.$allEnumConstants.contains(value)) {
                            this.this$0.getHolder().registerProblem((PsiElement)sourcePsi, JUnitBundle.message("junit5.malformed.parameterized.inspection.description.unresolved.enum", new Object[0]), new LocalQuickFix[0]);
                        } else if (!this.$definedConstants.add(value)) {
                            this.this$0.getHolder().registerProblem((PsiElement)sourcePsi, JUnitBundle.message("junit5.malformed.parameterized.inspection.description.duplicated.enum", new Object[0]), new LocalQuickFix[0]);
                        }
                    }
                }
                {
                    this.this$0 = singleParameterChecker;
                    this.$method = uMethod;
                    this.$allEnumConstants = set;
                    this.$definedConstants = set2;
                    super(1);
                }
            });
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final void checkSourceTypeAndParameterTypeAgree(UMethod method, PsiAnnotationMemberValue attributeValue, PsiType componentType) {
        block19: {
            block21: {
                block20: {
                    block18: {
                        parameters = method.getUastParameters();
                        if (parameters.size() != 1 || (paramType = ((UParameter)parameters.get(0)).getType()).isAssignableFrom(componentType) || InheritanceUtil.isInheritor((PsiType)componentType, (String)"org.junit.jupiter.params.provider.Arguments")) break block19;
                        if (!componentType.equalsToText("java.lang.String")) break block20;
                        if (TypeConversionUtil.isPrimitiveAndNotNullOrWrapper((PsiType)paramType)) {
                            return;
                        }
                        psiClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)paramType);
                        if (psiClass == null) break block21;
                        if (psiClass.isEnum()) {
                            v0 = attributeValue;
                            if (v0 == null) {
                                throw new NullPointerException("null cannot be cast to non-null type com.intellij.psi.PsiLiteral");
                            }
                            if (psiClass.findFieldByName((String)((PsiLiteral)v0).getValue(), false) != null) {
                                return;
                            }
                        }
                        if ((qualifiedName = psiClass.getQualifiedName()) != null) {
                            if (StringsKt.startsWith$default((String)qualifiedName, (String)"java.time.", (boolean)false, (int)2, null)) {
                                return;
                            }
                            if (Intrinsics.areEqual((Object)qualifiedName, (Object)"java.nio.file.Path")) {
                                return;
                            }
                        }
                        factoryMethod = checkSourceTypeAndParameterTypeAgree.factoryMethod.1.INSTANCE;
                        if (!psiClass.hasModifier(JvmModifier.ABSTRACT)) {
                            block17: {
                                v1 = psiClass.getConstructors();
                                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"psiClass.constructors");
                                for (PsiMethod var14_14 : var10_10 = (var9_9 = v1)) {
                                    if (!((Boolean)factoryMethod.invoke((Object)var14_14)).booleanValue()) continue;
                                    v2 = var14_14;
                                    break block17;
                                }
                                v2 = null;
                            }
                            if (v2 != null) {
                                return;
                            }
                        }
                        v3 = psiClass.getMethods();
                        Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"psiClass.methods");
                        var11_11 = var10_10 = (var9_9 = v3);
                        var12_12 = 0;
                        var13_13 = var11_11.length;
                        while (var12_12 < var13_13) {
                            var14_14 = var11_11[var12_12];
                            ++var12_12;
                            it = var14_14;
                            $i$a$-find-SingleParameterChecker$checkSourceTypeAndParameterTypeAgree$1 = false;
                            if (!it.hasModifier(JvmModifier.STATIC)) ** GOTO lbl-1000
                            v4 = it;
                            Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"it");
                            if (((Boolean)factoryMethod.invoke((Object)v4)).booleanValue()) {
                                v5 = true;
                            } else lbl-1000:
                            // 2 sources

                            {
                                v5 = false;
                            }
                            if (!v5) continue;
                            v6 = var14_14;
                            break block18;
                        }
                        v6 = null;
                    }
                    if (v6 != null) {
                        return;
                    }
                    break block21;
                }
                if (componentType.equalsToText("org.junit.jupiter.params.provider.NullEnum") && (psiClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)paramType)) != null && psiClass.isEnum()) {
                    return;
                }
            }
            v7 = ((UParameter)parameters.get(0)).getSourcePsi();
            if (v7 == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.psi.PsiNameIdentifierOwner");
            }
            v8 = UastContextKt.toUElement((PsiElement)JUnit5MalformedParameterizedInspectionKt.access$getElementToHighlight((PsiElement)attributeValue, method, (PsiNameIdentifierOwner)v7));
            v9 /* !! */  = sourcePsi = v8 != null ? v8.getSourcePsi() : null;
            if (((UParameter)parameters.get(0)).findAnnotation("org.junit.jupiter.params.converter.ConvertWith") != null || sourcePsi == null) {
                return;
            }
            this.holder.registerProblem(sourcePsi, JUnitBundle.message("junit5.malformed.parameterized.inspection.description.method.source.assignable", new Object[]{componentType.getPresentableText(), paramType.getPresentableText()}), new LocalQuickFix[0]);
        }
    }

    @NotNull
    public final ProblemsHolder getHolder() {
        return this.holder;
    }

    public SingleParameterChecker(@NotNull ProblemsHolder holder) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        this.holder = holder;
    }

    public static final /* synthetic */ void access$checkSourceTypeAndParameterTypeAgree(SingleParameterChecker $this, UMethod method, PsiAnnotationMemberValue attributeValue, PsiType componentType) {
        $this.checkSourceTypeAndParameterTypeAgree(method, attributeValue, componentType);
    }
}

