/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.ResourceBundle;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.rules.Categories;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.SuggestionWithMessage;
import org.languagetool.tools.StringTools;

public abstract class AbstractSimpleReplaceRule2
extends Rule {
    private final Language language;
    protected boolean subRuleSpecificIds;
    private static final LoadingCache<PathsAndLanguage, List<Map<String, SuggestionWithMessage>>> cache = CacheBuilder.newBuilder().expireAfterWrite(30L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<PathsAndLanguage, List<Map<String, SuggestionWithMessage>>>(){

        public List<Map<String, SuggestionWithMessage>> load(@NotNull PathsAndLanguage lap) throws IOException {
            ArrayList<Map<String, SuggestionWithMessage>> maps = new ArrayList<Map<String, SuggestionWithMessage>>();
            for (String path : lap.paths) {
                List l = AbstractSimpleReplaceRule2.loadWords(path, lap.lang, lap.caseSensitive, lap.checkingCase);
                maps.addAll(l);
            }
            return maps;
        }
    });

    public abstract List<String> getFileNames();

    @Override
    public abstract String getId();

    @Override
    public abstract String getDescription();

    public abstract String getShort();

    public abstract String getMessage();

    public String getSuggestionsSeparator() {
        return ", ";
    }

    public abstract Locale getLocale();

    public AbstractSimpleReplaceRule2(ResourceBundle messages, Language language) {
        super(messages);
        this.language = Objects.requireNonNull(language);
        super.setCategory(Categories.MISC.getCategory(messages));
    }

    public void useSubRuleSpecificIds() {
        this.subRuleSpecificIds = true;
    }

    public boolean isCaseSensitive() {
        return false;
    }

    public List<Map<String, SuggestionWithMessage>> getWrongWords(boolean checkingCase) {
        try {
            return (List)cache.get((Object)new PathsAndLanguage(this.getFileNames(), this.language, this.isCaseSensitive(), checkingCase));
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static List<Map<String, SuggestionWithMessage>> loadWords(String filename, Language lang, boolean caseSensitive, boolean checkingCase) throws IOException {
        ArrayList list = new ArrayList();
        InputStream stream = JLanguageTool.getDataBroker().getFromRulesDirAsStream(filename);
        try (InputStreamReader isr = new InputStreamReader(stream, StandardCharsets.UTF_8);
             BufferedReader br2 = new BufferedReader(isr);){
            String string;
            while ((string = br2.readLine()) != null) {
                String[] wrongForms;
                void var8_9;
                String[] parts;
                String string2 = string.trim();
                if (string2.isEmpty() || string2.charAt(0) == '#') continue;
                if (checkingCase) {
                    parts = string2.split("=");
                    String string3 = parts[0].toLowerCase().trim() + "=" + parts[0].trim();
                    if (parts.length == 2) {
                        String string4 = string3 + "\t" + parts[1].trim();
                    }
                }
                if ((parts = var8_9.split("=")).length != 2) {
                    throw new IOException("Format error in file " + JLanguageTool.getDataBroker().getFromRulesDirAsUrl(filename) + ". Expected exactly 1 '=' character. Line: " + (String)var8_9);
                }
                for (String wrongForm : wrongForms = parts[0].split("\\|")) {
                    SuggestionWithMessage sugg;
                    int wordCount = 0;
                    List<String> tokens = lang.getWordTokenizer().tokenize(wrongForm);
                    for (String token : tokens) {
                        if (StringTools.isWhitespace(token)) continue;
                        ++wordCount;
                    }
                    for (int i2 = list.size(); i2 < wordCount; ++i2) {
                        list.add(new HashMap());
                    }
                    if (parts[1].contains("\t")) {
                        String[] suggestionParts = parts[1].split("\t");
                        if (suggestionParts.length != 2) {
                            throw new IOException("Invalid format - use only one tab character to separate suggestion from the message: " + (String)var8_9);
                        }
                        sugg = new SuggestionWithMessage(suggestionParts[0], suggestionParts[1]);
                    } else {
                        sugg = new SuggestionWithMessage(parts[1]);
                    }
                    ((Map)list.get(wordCount - 1)).put(caseSensitive ? wrongForm : wrongForm.toLowerCase(), sugg);
                }
            }
        }
        ArrayList result = new ArrayList();
        for (Map map2 : list) {
            result.add(Collections.unmodifiableMap(map2));
        }
        return Collections.unmodifiableList(result);
    }

    protected void addToQueue(AnalyzedTokenReadings token, Queue<AnalyzedTokenReadings> prevTokens) {
        boolean inserted = prevTokens.offer(token);
        if (!inserted) {
            prevTokens.poll();
            prevTokens.offer(token);
        }
    }

    public String getDescription(String details2) {
        return null;
    }

    @Override
    public RuleMatch[] match(AnalyzedSentence sentence) {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        AnalyzedTokenReadings[] tokens = sentence.getTokensWithoutWhitespace();
        List<Map<String, SuggestionWithMessage>> wrongWords = this.getWrongWords(false);
        if (wrongWords.size() == 0) {
            return this.toRuleMatchArray(ruleMatches);
        }
        ArrayBlockingQueue<AnalyzedTokenReadings> prevTokens = new ArrayBlockingQueue<AnalyzedTokenReadings>(wrongWords.size());
        block0: for (int i2 = 1; i2 < tokens.length; ++i2) {
            this.addToQueue(tokens[i2], prevTokens);
            StringBuilder sb = new StringBuilder();
            ArrayList<String> variants = new ArrayList<String>();
            List<AnalyzedTokenReadings> prevTokensList = Arrays.asList(prevTokens.toArray(new AnalyzedTokenReadings[0]));
            for (int j = prevTokensList.size() - 1; j >= 0; --j) {
                if (j != prevTokensList.size() - 1 && prevTokensList.get(j + 1).isWhitespaceBefore()) {
                    sb.insert(0, " ");
                }
                sb.insert(0, prevTokensList.get(j).getToken());
                variants.add(0, sb.toString());
            }
            if (this.isTokenException(tokens[i2])) continue;
            int len = variants.size();
            for (int j = 0; j < len; ++j) {
                RuleMatch lastRuleMatch;
                SuggestionWithMessage crtMatch;
                String crt = (String)variants.get(j);
                int crtWordCount = len - j;
                SuggestionWithMessage suggestionWithMessage = crtMatch = this.isCaseSensitive() ? wrongWords.get(crtWordCount - 1).get(crt) : wrongWords.get(crtWordCount - 1).get(crt.toLowerCase(this.getLocale()));
                if (crtMatch == null) continue;
                List<String> replacements = Arrays.asList(crtMatch.getSuggestion().split("\\|"));
                String msgSuggestions = "";
                for (int k = 0; k < replacements.size(); ++k) {
                    if (k > 0) {
                        msgSuggestions = msgSuggestions + (k == replacements.size() - 1 ? this.getSuggestionsSeparator() : ", ");
                    }
                    msgSuggestions = msgSuggestions + "<suggestion>" + replacements.get(k) + "</suggestion>";
                }
                String msg = this.getMessage().replaceFirst("\\$match", crt).replaceFirst("\\$suggestions", msgSuggestions);
                if (crtMatch.getMessage() != null) {
                    msg = crtMatch.getMessage();
                }
                int startPos = prevTokensList.get(len - crtWordCount).getStartPos();
                int endPos = prevTokensList.get(len - 1).getEndPos();
                RuleMatch ruleMatch = new RuleMatch(this, sentence, startPos, endPos, msg, this.getShort());
                if (this.subRuleSpecificIds) {
                    ruleMatch.setSpecificRuleId(StringTools.toId(this.getId() + "_" + crt));
                }
                if (!this.isCaseSensitive() && StringTools.startsWithUppercase(crt)) {
                    for (int k = 0; k < replacements.size(); ++k) {
                        replacements.set(k, StringTools.uppercaseFirstChar(replacements.get(k)));
                    }
                }
                ruleMatch.setSuggestedReplacements(replacements);
                if (this.isException(sentence.getText().substring(startPos, endPos))) continue block0;
                if (ruleMatches.size() > 0 && (lastRuleMatch = (RuleMatch)ruleMatches.get(ruleMatches.size() - 1)).getFromPos() == ruleMatch.getFromPos() && lastRuleMatch.getToPos() < ruleMatch.getToPos()) {
                    ruleMatches.remove(ruleMatches.size() - 1);
                }
                ruleMatches.add(ruleMatch);
                continue block0;
            }
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    protected boolean isException(String matchedText) {
        return false;
    }

    protected boolean isTokenException(AnalyzedTokenReadings atr) {
        return false;
    }

    static class PathsAndLanguage {
        final List<String> paths;
        final Language lang;
        final boolean caseSensitive;
        final boolean checkingCase;

        PathsAndLanguage(List<String> fileNames, Language language, boolean caseSensitive, boolean checkingCase) {
            this.paths = Objects.requireNonNull(fileNames);
            this.lang = Objects.requireNonNull(language);
            this.caseSensitive = caseSensitive;
            this.checkingCase = checkingCase;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PathsAndLanguage that = (PathsAndLanguage)o;
            return this.paths.equals(that.paths) && this.lang.equals(that.lang) && this.caseSensitive == that.caseSensitive;
        }

        public int hashCode() {
            return Objects.hash(this.paths, this.lang, this.caseSensitive);
        }
    }
}

