/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.patterns;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.patterns.AbstractTokenBasedRule;
import org.languagetool.rules.patterns.PatternRuleId;
import org.languagetool.rules.patterns.PatternRuleMatcher;
import org.languagetool.rules.patterns.PatternRuleXmlCreator;
import org.languagetool.rules.patterns.PatternToken;
import org.languagetool.rules.patterns.RuleMatcher;
import org.languagetool.tagging.disambiguation.rules.DisambiguationPatternRule;
import org.languagetool.tools.StringTools;

public class PatternRule
extends AbstractTokenBasedRule {
    private final String shortMessage;
    private final List<Integer> elementNo;
    private final boolean useList;
    private boolean interpretPosTagsPreDisambiguation;
    private boolean isMemberOfDisjunctiveSet;

    public PatternRule(String id, Language language, List<PatternToken> patternTokens, String description, String message, String shortMessage, String suggestionsOutMsg) {
        super(id, description, language, patternTokens, false);
        this.message = Objects.requireNonNull(message);
        this.shortMessage = Objects.requireNonNull(shortMessage);
        this.elementNo = new ArrayList<Integer>(0);
        Objects.requireNonNull(suggestionsOutMsg);
        this.suggestionsOutMsg = suggestionsOutMsg.isEmpty() ? "" : suggestionsOutMsg;
        String prevName = "";
        int cnt = 0;
        int loopCnt = 0;
        boolean tempUseList = false;
        for (PatternToken pToken : patternTokens) {
            if (pToken.isPartOfPhrase()) {
                String curName = pToken.getPhraseName();
                if (StringTools.isEmpty(prevName) || prevName.equals(curName)) {
                    ++cnt;
                    tempUseList = true;
                } else {
                    this.elementNo.add(cnt);
                    curName = "";
                    cnt = 0;
                }
                prevName = curName;
                if (++loopCnt != this.patternTokens.size() || StringTools.isEmpty(prevName)) continue;
                this.elementNo.add(cnt);
                continue;
            }
            if (cnt > 0) {
                this.elementNo.add(cnt);
            }
            this.elementNo.add(1);
            ++loopCnt;
        }
        this.useList = tempUseList;
    }

    public PatternRule(String id, Language language, List<PatternToken> patternTokens, String description, String message, String shortMessage) {
        this(id, language, patternTokens, description, message, shortMessage, "");
    }

    public PatternRule(String id, Language language, List<PatternToken> patternTokens, String description, String message, String shortMessage, String suggestionsOutMsg, boolean isMember) {
        this(id, language, patternTokens, description, message, shortMessage, suggestionsOutMsg, isMember, false);
    }

    public PatternRule(String id, Language language, List<PatternToken> patternTokens, String description, String message, String shortMessage, String suggestionsOutMsg, boolean isMember, boolean interpretPosTagsPreDisambiguation) {
        this(id, language, patternTokens, description, message, shortMessage, suggestionsOutMsg);
        this.isMemberOfDisjunctiveSet = isMember;
        this.interpretPosTagsPreDisambiguation = interpretPosTagsPreDisambiguation;
    }

    @Override
    public int estimateContextForSureMatch() {
        int extendAfterMarker = 0;
        boolean markerSeen = false;
        for (PatternToken pToken : this.patternTokens) {
            if (markerSeen && !pToken.isInsideMarker()) {
                ++extendAfterMarker;
            }
            if ("SENT_END".equals(pToken.getPOStag())) {
                ++extendAfterMarker;
            }
            if (pToken.isInsideMarker()) {
                markerSeen = true;
            }
            if (pToken.getSkipNext() == -1) {
                return -1;
            }
            extendAfterMarker += pToken.getSkipNext();
        }
        List antiPatternLengths = this.getAntiPatterns().stream().map(p2 -> p2.patternTokens.size()).collect(Collectors.toList());
        int longestAntiPattern = antiPatternLengths.stream().max(Comparator.comparing(i2 -> i2)).orElse(0);
        int longestSkip = 0;
        for (DisambiguationPatternRule antiPattern : this.getAntiPatterns()) {
            for (PatternToken token : antiPattern.getPatternTokens()) {
                if (token.getSkipNext() == -1) {
                    return -1;
                }
                if (token.getSkipNext() <= longestSkip) continue;
                longestSkip = token.getSkipNext();
            }
        }
        return extendAfterMarker + Math.max(longestAntiPattern, longestAntiPattern + longestSkip);
    }

    boolean isInterpretPosTagsPreDisambiguation() {
        return this.interpretPosTagsPreDisambiguation;
    }

    final boolean isWithComplexPhrase() {
        return this.isMemberOfDisjunctiveSet;
    }

    final void notComplexPhrase() {
        this.isMemberOfDisjunctiveSet = false;
    }

    public final String toPatternString() {
        ArrayList<String> strList = new ArrayList<String>();
        for (PatternToken patternPatternToken : this.patternTokens) {
            strList.add(patternPatternToken.toString());
        }
        return String.join((CharSequence)", ", strList);
    }

    public final String toXML() {
        return new PatternRuleXmlCreator().toXML(new PatternRuleId(this.getId(), this.getSubId()), this.getLanguage());
    }

    @Override
    public final RuleMatch[] match(AnalyzedSentence sentence) throws IOException {
        if (this.canBeIgnoredFor(sentence)) {
            return RuleMatch.EMPTY_ARRAY;
        }
        PatternRuleMatcher matcher = new PatternRuleMatcher((AbstractTokenBasedRule)this, this.useList);
        return this.checkForAntiPatterns(sentence, matcher, matcher.match(sentence));
    }

    private RuleMatch[] checkForAntiPatterns(AnalyzedSentence sentence, RuleMatcher matcher, RuleMatch[] matches) throws IOException {
        AnalyzedSentence immunized;
        if (matches != null && matches.length > 0 && !this.getAntiPatterns().isEmpty() && Arrays.stream((immunized = this.getSentenceWithImmunization(sentence)).getTokens()).anyMatch(AnalyzedTokenReadings::isImmunized)) {
            return matcher.match(immunized);
        }
        return matches;
    }

    List<Integer> getElementNo() {
        return this.elementNo;
    }

    @Override
    public String getShortMessage() {
        return this.shortMessage;
    }
}

