/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tools;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.languagetool.CheckResults;
import org.languagetool.DetectedLanguage;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.Premium;
import org.languagetool.Range;
import org.languagetool.Tag;
import org.languagetool.markup.AnnotatedText;
import org.languagetool.markup.AnnotatedTextBuilder;
import org.languagetool.rules.Category;
import org.languagetool.rules.CategoryId;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.SuggestedReplacement;
import org.languagetool.rules.patterns.AbstractPatternRule;
import org.languagetool.tools.ContextTools;

public class RuleMatchesAsJsonSerializer {
    private static final int API_VERSION = 1;
    private static final String STATUS = "";
    private static final String PREMIUM_HINT = "You might be missing errors only the Premium version can find. Contact us at support<at>languagetoolplus.com.";
    private static final String START_MARKER = "__languagetool_start_marker";
    private static final JsonFactory factory = new JsonFactory();
    private final int compactMode;
    private final Language lang;

    public RuleMatchesAsJsonSerializer() {
        this(0, null);
    }

    public RuleMatchesAsJsonSerializer(int compactMode) {
        this(compactMode, null);
    }

    public RuleMatchesAsJsonSerializer(int compactMode, Language lang) {
        this.compactMode = compactMode;
        this.lang = lang;
    }

    public String ruleMatchesToJson(List<RuleMatch> matches, String text2, int contextSize, DetectedLanguage detectedLang) {
        return this.ruleMatchesToJson(matches, new ArrayList<RuleMatch>(), text2, contextSize, detectedLang, null);
    }

    public String ruleMatchesToJson(List<RuleMatch> matches, List<RuleMatch> hiddenMatches, String text2, int contextSize, DetectedLanguage detectedLang, String incompleteResultsReason) {
        return this.ruleMatchesToJson(matches, hiddenMatches, new AnnotatedTextBuilder().addText(text2).build(), contextSize, detectedLang, incompleteResultsReason, false);
    }

    public String ruleMatchesToJson(List<RuleMatch> matches, List<RuleMatch> hiddenMatches, AnnotatedText text2, int contextSize, DetectedLanguage detectedLang, String incompleteResultsReason, boolean showPremiumHint) {
        return this.ruleMatchesToJson2(Collections.singletonList(new CheckResults(matches, Collections.emptyList())), hiddenMatches, text2, contextSize, detectedLang, incompleteResultsReason, showPremiumHint);
    }

    public String ruleMatchesToJson2(List<CheckResults> res, List<RuleMatch> hiddenMatches, AnnotatedText text2, int contextSize, DetectedLanguage detectedLang, String incompleteResultsReason, boolean showPremiumHint) {
        ContextTools contextTools = new ContextTools();
        contextTools.setEscapeHtml(false);
        contextTools.setContextSize(contextSize);
        contextTools.setErrorMarker(START_MARKER, STATUS);
        StringWriter sw = new StringWriter();
        try (JsonGenerator g = factory.createGenerator((Writer)sw);){
            g.writeStartObject();
            this.writeSoftwareSection(g, showPremiumHint);
            this.writeWarningsSection(g, incompleteResultsReason);
            this.writeLanguageSection(g, detectedLang);
            this.writeMatchesSection("matches", g, res, text2, contextTools);
            if (hiddenMatches != null && hiddenMatches.size() > 0) {
                this.writeMatchesSection("hiddenMatches", g, Collections.singletonList(new CheckResults(hiddenMatches, Collections.emptyList())), text2, contextTools);
            }
            this.writeIgnoreRanges(g, res);
            g.writeEndObject();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return sw.toString();
    }

    private void writeSoftwareSection(JsonGenerator g, boolean showPremiumHint) throws IOException {
        if (this.compactMode == 1) {
            return;
        }
        g.writeObjectFieldStart("software");
        g.writeStringField("name", "LanguageTool");
        g.writeStringField("version", "5.6.2-grz");
        g.writeStringField("buildDate", JLanguageTool.BUILD_DATE);
        g.writeNumberField("apiVersion", 1);
        g.writeBooleanField("premium", Premium.isPremiumVersion());
        if (showPremiumHint) {
            g.writeStringField("premiumHint", PREMIUM_HINT);
        }
        g.writeStringField("status", STATUS);
        g.writeEndObject();
    }

    private void writeWarningsSection(JsonGenerator g, String incompleteResultsReason) throws IOException {
        if (this.compactMode == 1 && incompleteResultsReason == null) {
            return;
        }
        g.writeObjectFieldStart("warnings");
        if (incompleteResultsReason != null) {
            g.writeBooleanField("incompleteResults", true);
            g.writeStringField("incompleteResultsReason", incompleteResultsReason);
        } else {
            g.writeBooleanField("incompleteResults", false);
        }
        g.writeEndObject();
    }

    private void writeLanguageSection(JsonGenerator g, DetectedLanguage detectedLang) throws IOException {
        g.writeObjectFieldStart("language");
        g.writeStringField("name", detectedLang.getGivenLanguage().getName());
        g.writeStringField("code", detectedLang.getGivenLanguage().getShortCodeWithCountryAndVariant());
        if (detectedLang.getGivenLanguage().isSpellcheckOnlyLanguage()) {
            g.writeBooleanField("spellCheckOnly", true);
        }
        g.writeObjectFieldStart("detectedLanguage");
        g.writeStringField("name", detectedLang.getDetectedLanguage().getName());
        g.writeStringField("code", detectedLang.getDetectedLanguage().getShortCodeWithCountryAndVariant());
        g.writeNumberField("confidence", detectedLang.getDetectionConfidence());
        if (detectedLang.getDetectedLanguage().isSpellcheckOnlyLanguage()) {
            g.writeBooleanField("spellCheckOnly", true);
        }
        g.writeEndObject();
        g.writeEndObject();
    }

    private void writeMatchesSection(String sectionName, JsonGenerator g, List<CheckResults> res, AnnotatedText text2, ContextTools contextTools) throws IOException {
        g.writeArrayFieldStart(sectionName);
        for (CheckResults r : res) {
            for (RuleMatch match : r.getRuleMatches()) {
                g.writeStartObject();
                g.writeStringField("message", this.cleanSuggestion(match.getMessage()));
                if (match.getShortMessage() != null) {
                    g.writeStringField("shortMessage", this.cleanSuggestion(match.getShortMessage()));
                }
                this.writeReplacements(g, match);
                g.writeNumberField("offset", match.getFromPos());
                g.writeNumberField("length", match.getToPos() - match.getFromPos());
                this.writeContext(g, match, text2, contextTools);
                g.writeObjectFieldStart("type");
                g.writeStringField("typeName", match.getType().toString());
                g.writeEndObject();
                this.writeRule(g, match);
                int contextEstimate = match.getRule().estimateContextForSureMatch();
                g.writeBooleanField("ignoreForIncompleteSentence", contextEstimate == -1 || contextEstimate > 3);
                g.writeNumberField("contextForSureMatch", contextEstimate);
                g.writeEndObject();
            }
        }
        g.writeEndArray();
    }

    private void writeIgnoreRanges(JsonGenerator g, List<CheckResults> res) throws IOException {
        if (res.stream().allMatch(k -> k.getIgnoredRanges().size() == 0)) {
            return;
        }
        g.writeArrayFieldStart("ignoreRanges");
        for (CheckResults r : res) {
            for (Range range : r.getIgnoredRanges()) {
                g.writeStartObject();
                g.writeNumberField("from", range.getFromPos());
                g.writeNumberField("to", range.getToPos());
                g.writeObjectFieldStart("language");
                g.writeStringField("code", range.getLang());
                g.writeEndObject();
                g.writeEndObject();
            }
        }
        g.writeEndArray();
    }

    private String cleanSuggestion(String s) {
        if (this.lang != null) {
            return this.lang.toAdvancedTypography(s);
        }
        return s.replace("<suggestion>", "\"").replace("</suggestion>", "\"");
    }

    private void writeReplacements(JsonGenerator g, RuleMatch match) throws IOException {
        g.writeArrayFieldStart("replacements");
        boolean autoCorrect = match.isAutoCorrect();
        int i2 = 0;
        for (SuggestedReplacement replacement : match.getSuggestedReplacementObjects()) {
            if (this.compactMode == 1 && ++i2 > 5) break;
            g.writeStartObject();
            g.writeStringField("value", replacement.getReplacement());
            if (replacement.getShortDescription() != null) {
                g.writeStringField("shortDescription", replacement.getShortDescription());
            }
            if (replacement.getSuffix() != null) {
                g.writeStringField("suffix", replacement.getSuffix());
            }
            if (replacement.getType() != SuggestedReplacement.SuggestionType.Default) {
                g.writeStringField("type", replacement.getType().name());
            }
            if (autoCorrect) {
                g.writeBooleanField("autoCorrect", true);
                autoCorrect = false;
            }
            if (replacement.getConfidence() != null) {
                g.writeNumberField("confidence", replacement.getConfidence().floatValue());
            }
            g.writeEndObject();
        }
        g.writeEndArray();
    }

    private void writeContext(JsonGenerator g, RuleMatch match, AnnotatedText text2, ContextTools contextTools) throws IOException {
        String context = contextTools.getContext(match.getFromPos(), match.getToPos(), text2.getTextWithMarkup());
        int contextOffset = context.indexOf(START_MARKER);
        context = context.replaceFirst(START_MARKER, STATUS);
        if (this.compactMode != 1) {
            g.writeObjectFieldStart("context");
            g.writeStringField("text", context);
            g.writeNumberField("offset", contextOffset);
            g.writeNumberField("length", match.getToPos() - match.getFromPos());
            g.writeEndObject();
            if (match.getSentence() != null) {
                g.writeStringField("sentence", match.getSentence().getText().trim());
            }
        }
    }

    private void writeRule(JsonGenerator g, RuleMatch match) throws IOException {
        g.writeObjectFieldStart("rule");
        Rule rule = match.getRule();
        g.writeStringField("id", match.getSpecificRuleId());
        if (rule instanceof AbstractPatternRule) {
            AbstractPatternRule pRule = (AbstractPatternRule)rule;
            if (pRule.getSubId() != null) {
                g.writeStringField("subId", pRule.getSubId());
            }
            if (pRule.getSourceFile() != null && this.compactMode != 1) {
                g.writeStringField("sourceFile", pRule.getSourceFile().replaceFirst(".*/", STATUS));
            }
        }
        g.writeStringField("description", rule.getDescription());
        g.writeStringField("issueType", rule.getLocQualityIssueType().toString());
        if (rule.isDefaultTempOff()) {
            g.writeBooleanField("tempOff", true);
        }
        if (match.getUrl() != null || rule.getUrl() != null) {
            g.writeArrayFieldStart("urls");
            g.writeStartObject();
            if (match.getUrl() != null) {
                g.writeStringField("value", match.getUrl().toString());
            } else if (rule.getUrl() != null) {
                g.writeStringField("value", rule.getUrl().toString());
            }
            g.writeEndObject();
            g.writeEndArray();
        }
        this.writeCategory(g, rule.getCategory());
        if (Premium.isPremiumVersion()) {
            g.writeBooleanField("isPremium", Premium.get().isPremiumRule(rule));
        }
        if (rule.getTags().size() > 0) {
            g.writeArrayFieldStart("tags");
            for (Tag tag : rule.getTags()) {
                g.writeString(tag.name());
            }
            g.writeEndArray();
        }
        g.writeEndObject();
    }

    private void writeCategory(JsonGenerator g, Category category) throws IOException {
        g.writeObjectFieldStart("category");
        CategoryId catId = category.getId();
        g.writeStringField("id", catId.toString());
        g.writeStringField("name", category.getName());
        g.writeEndObject();
    }
}

