/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.packagesearch.intellij.plugin.rest;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.stream.JsonWriter;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.AppUIExecutor;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.util.io.NettyKt;
import com.intellij.util.net.NetUtils;
import com.intellij.util.text.StringKt;
import com.jetbrains.packagesearch.intellij.plugin.PackageSearchBundle;
import com.jetbrains.packagesearch.intellij.plugin.rest.InstallPackageRequest;
import com.jetbrains.packagesearch.intellij.plugin.rest.PackageSearchRestService;
import com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.PackageSearchToolWindowFactory;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.RestService;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\u0004H\u0014J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0014J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J\u0018\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u001a\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u00182\b\b\u0001\u0010\u0019\u001a\u00020\u0004H\u0002\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/packagesearch/intellij/plugin/rest/PackageSearchRestService;", "Lorg/jetbrains/ide/RestService;", "()V", "execute", "", "urlDecoder", "Lio/netty/handler/codec/http/QueryStringDecoder;", "request", "Lio/netty/handler/codec/http/FullHttpRequest;", "context", "Lio/netty/channel/ChannelHandlerContext;", "getServiceName", "installPackage", "", "isAccessible", "", "Lio/netty/handler/codec/http/HttpRequest;", "isHostTrusted", "isMethodSupported", "method", "Lio/netty/handler/codec/http/HttpMethod;", "listProjects", "notify", "project", "Lcom/intellij/openapi/project/Project;", "pkg", "intellij.packageSearch"})
public final class PackageSearchRestService
extends RestService {
    @NotNull
    protected String getServiceName() {
        return "packageSearch";
    }

    protected boolean isMethodSupported(@NotNull HttpMethod method) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        return method == HttpMethod.GET || method == HttpMethod.POST;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    public String execute(@NotNull QueryStringDecoder urlDecoder, @NotNull FullHttpRequest request, @NotNull ChannelHandlerContext context) {
        Intrinsics.checkNotNullParameter((Object)urlDecoder, (String)"urlDecoder");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String string = RestService.Companion.getStringParameter("action", urlDecoder);
        if (string != null) {
            switch (string) {
                case "projects": {
                    this.listProjects(request, context);
                    return null;
                }
                case "install": {
                    this.installPackage(request, context);
                    return null;
                }
            }
        }
        HttpResponseStatus httpResponseStatus = HttpResponseStatus.NOT_FOUND;
        Intrinsics.checkNotNullExpressionValue((Object)httpResponseStatus, (String)"HttpResponseStatus.NOT_FOUND");
        boolean bl = HttpUtil.isKeepAlive((HttpMessage)((HttpMessage)request));
        Channel channel = context.channel();
        Intrinsics.checkNotNullExpressionValue((Object)channel, (String)"context.channel()");
        RestService.Companion.sendStatus(httpResponseStatus, bl, channel);
        return null;
    }

    private final void listProjects(FullHttpRequest request, ChannelHandlerContext context) {
        JsonWriter jsonWriter;
        BufferExposingByteArrayOutputStream out = new BufferExposingByteArrayOutputStream();
        ApplicationNamesInfo applicationNamesInfo = ApplicationNamesInfo.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)applicationNamesInfo, (String)"ApplicationNamesInfo.getInstance()");
        String name = applicationNamesInfo.getProductName();
        ApplicationInfo applicationInfo = ApplicationInfo.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)applicationInfo, (String)"ApplicationInfo.getInstance()");
        BuildNumber buildNumber = applicationInfo.getBuild();
        Intrinsics.checkNotNullExpressionValue((Object)buildNumber, (String)"ApplicationInfo.getInstance().build");
        BuildNumber build2 = buildNumber;
        JsonWriter $this$apply = jsonWriter = RestService.Companion.createJsonWriter((OutputStream)out);
        boolean bl = false;
        $this$apply.beginObject();
        $this$apply.name("name").value(name);
        $this$apply.name("buildNumber").value(build2.asString());
        $this$apply.name("projects");
        $this$apply.beginArray();
        ProjectManager projectManager = ProjectManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)projectManager, (String)"ProjectManager.getInstance()");
        Project[] projectArray = projectManager.getOpenProjects();
        Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"ProjectManager.getInstance().openProjects");
        Project[] $this$forEach$iv = projectArray;
        boolean $i$f$forEach = false;
        for (Project element$iv : $this$forEach$iv) {
            Project it = element$iv;
            boolean bl2 = false;
            Project project = it;
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"it");
            $this$apply.value(project.getName());
        }
        $this$apply.endArray();
        $this$apply.endObject();
        $this$apply.close();
        RestService.Companion.send(out, (HttpRequest)request, context);
    }

    private final void installPackage(FullHttpRequest request, ChannelHandlerContext context) {
        Project project;
        InstallPackageRequest data;
        block2: {
            Project[] projectArray;
            Project[] projectArray2;
            Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
            data = (InstallPackageRequest)gson.fromJson(RestService.Companion.createJsonReader(request), (Type)((Object)InstallPackageRequest.class));
            ProjectManager projectManager = ProjectManager.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)projectManager, (String)"ProjectManager.getInstance()");
            Project[] projectArray3 = projectManager.getOpenProjects();
            Intrinsics.checkNotNullExpressionValue((Object)projectArray3, (String)"ProjectManager.getInstance().openProjects");
            for (Project project2 : projectArray2 = (projectArray = projectArray3)) {
                Project it = project2;
                boolean bl = false;
                Project project3 = it;
                Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"it");
                if (!StringsKt.equals((String)project3.getName(), (String)data.getProject(), (boolean)true)) continue;
                project = project2;
                break block2;
            }
            project = null;
        }
        Project project4 = project;
        String pkg = data.getPackage();
        String query = StringKt.nullize((String)data.getQuery(), (boolean)true);
        if (project4 == null || pkg == null) {
            HttpResponseStatus httpResponseStatus = HttpResponseStatus.BAD_REQUEST;
            Intrinsics.checkNotNullExpressionValue((Object)httpResponseStatus, (String)"HttpResponseStatus.BAD_REQUEST");
            boolean bl = HttpUtil.isKeepAlive((HttpMessage)((HttpMessage)request));
            Channel channel = context.channel();
            Intrinsics.checkNotNullExpressionValue((Object)channel, (String)"context.channel()");
            RestService.Companion.sendStatus(httpResponseStatus, bl, channel);
            return;
        }
        AppUIExecutor.onUiThread().execute(new Runnable(this, project4, pkg){
            final /* synthetic */ PackageSearchRestService this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ String $pkg;

            public final void run() {
                ProjectUtil.focusProjectWindow((Project)this.$project, (boolean)true);
                PackageSearchToolWindowFactory.Companion.activateToolWindow(this.$project, (Function0<Unit>)((Function0)new Function0<Unit>(this){
                    final /* synthetic */ installPackage.1 this$0;

                    public final void invoke() {
                        PackageSearchRestService.access$notify(this.this$0.this$0, this.this$0.$project, this.this$0.$pkg);
                    }
                    {
                        this.this$0 = var1_1;
                        super(0);
                    }
                }));
            }
            {
                this.this$0 = packageSearchRestService;
                this.$project = project;
                this.$pkg = string;
            }
        });
        RestService.Companion.sendOk(request, context);
    }

    public boolean isAccessible(@NotNull HttpRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return true;
    }

    protected boolean isHostTrusted(@NotNull FullHttpRequest request, @NotNull QueryStringDecoder urlDecoder) {
        boolean bl;
        String originHost;
        String string;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)urlDecoder, (String)"urlDecoder");
        String origin = NettyKt.getOrigin((HttpRequest)((HttpRequest)request));
        try {
            string = origin == null ? null : StringKt.nullize$default((String)new URI(origin).getHost(), (boolean)false, (int)1, null);
        }
        catch (URISyntaxException ignored) {
            return false;
        }
        String string2 = originHost = string;
        if (string2 != null) {
            String string3;
            String it = string3 = string2;
            boolean bl2 = false;
            bl = Intrinsics.areEqual((Object)it, (Object)"package-search.jetbrains.com") || StringsKt.endsWith$default((String)it, (String)"package-search.services.jetbrains.com", (boolean)false, (int)2, null) || NetUtils.isLocalhost((String)it);
        } else {
            bl = false;
        }
        boolean isTrusted = bl;
        return isTrusted || super.isHostTrusted(request, urlDecoder);
    }

    private final void notify(Project project, @Nls String pkg) {
        NotificationGroupManager.getInstance().getNotificationGroup("packagesearch.notification").createNotification(PackageSearchBundle.INSTANCE.message("packagesearch.title", new Object[0]), PackageSearchBundle.INSTANCE.message("packagesearch.restService.readyForInstallation", new Object[0]), NotificationType.INFORMATION).setSubtitle(pkg).notify(project);
    }

    public static final /* synthetic */ void access$notify(PackageSearchRestService $this, Project project, String pkg) {
        $this.notify(project, pkg);
    }
}

