/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.provider.annotate;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.annotate.AnnotationTooltipBuilder;
import com.intellij.openapi.vcs.annotate.DefaultLineModificationDetailsProvider;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vcs.annotate.LineAnnotationAspect;
import com.intellij.openapi.vcs.annotate.LineAnnotationAspectAdapter;
import com.intellij.openapi.vcs.annotate.ShowAllAffectedGenericAction;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgBundle;
import org.zmlx.hg4idea.HgFile;
import org.zmlx.hg4idea.HgFileRevision;
import org.zmlx.hg4idea.HgVcs;
import org.zmlx.hg4idea.provider.annotate.HgAnnotationLine;

public class HgAnnotation
extends FileAnnotation {
    private StringBuilder myContentBuffer;
    private final HgLineAnnotationAspect dateAnnotationAspect;
    private final HgLineAnnotationAspect userAnnotationAspect;
    private final HgLineAnnotationAspect revisionAnnotationAspect;
    @NotNull
    private final Project myProject;
    @NotNull
    private final List<? extends HgAnnotationLine> myLines;
    @NotNull
    private final List<? extends HgFileRevision> myFileRevisions;
    @NotNull
    private final HgFile myFile;
    private final VcsRevisionNumber myCurrentRevision;

    public HgAnnotation(@NotNull Project project, @NotNull HgFile hgFile, @NotNull List<? extends HgAnnotationLine> lines, @NotNull List<? extends HgFileRevision> vcsFileRevisions, VcsRevisionNumber revision) {
        if (project == null) {
            HgAnnotation.$$$reportNull$$$0(0);
        }
        if (hgFile == null) {
            HgAnnotation.$$$reportNull$$$0(1);
        }
        if (lines == null) {
            HgAnnotation.$$$reportNull$$$0(2);
        }
        if (vcsFileRevisions == null) {
            HgAnnotation.$$$reportNull$$$0(3);
        }
        super(project);
        this.dateAnnotationAspect = new HgLineAnnotationAspect(FIELD.DATE);
        this.userAnnotationAspect = new HgLineAnnotationAspect(FIELD.USER);
        this.revisionAnnotationAspect = new HgLineAnnotationAspect(FIELD.REVISION);
        this.myProject = project;
        this.myLines = lines;
        this.myFileRevisions = vcsFileRevisions;
        this.myFile = hgFile;
        this.myCurrentRevision = revision;
    }

    public int getLineCount() {
        return this.myLines.size();
    }

    public void dispose() {
    }

    public LineAnnotationAspect[] getAspects() {
        return new LineAnnotationAspect[]{this.revisionAnnotationAspect, this.dateAnnotationAspect, this.userAnnotationAspect};
    }

    @Nullable
    public String getToolTip(int lineNumber) {
        return this.getToolTip(lineNumber, false);
    }

    @Nullable
    public String getHtmlToolTip(int lineNumber) {
        return this.getToolTip(lineNumber, true);
    }

    @Nls
    @Nullable
    private String getToolTip(int lineNumber, boolean asHtml) {
        if (this.myLines.size() <= lineNumber || lineNumber < 0) {
            return null;
        }
        HgAnnotationLine info = this.myLines.get(lineNumber);
        if (info == null) {
            return null;
        }
        HgFileRevision revision = (HgFileRevision)ContainerUtil.find(this.myFileRevisions, it -> it.getRevisionNumber().equals(info.getVcsRevisionNumber()));
        if (revision == null) {
            return null;
        }
        AnnotationTooltipBuilder atb = new AnnotationTooltipBuilder(this.myProject, asHtml);
        atb.appendRevisionLine((VcsRevisionNumber)revision.getRevisionNumber(), null);
        atb.appendLine(HgBundle.message("hg4idea.annotation.author", revision.getAuthor()));
        atb.appendLine(HgBundle.message("hg4idea.annotation.date", revision.getRevisionDate()));
        String message = revision.getCommitMessage();
        if (message != null) {
            atb.appendCommitMessageBlock(message);
        }
        return atb.toString();
    }

    public String getAnnotatedContent() {
        if (this.myContentBuffer == null) {
            this.myContentBuffer = new StringBuilder();
            for (int i = 0; i < this.myLines.size(); ++i) {
                HgAnnotationLine line = this.myLines.get(i);
                if (i > 0) {
                    this.myContentBuffer.append("\n");
                }
                this.myContentBuffer.append(line.get(FIELD.CONTENT));
            }
        }
        return this.myContentBuffer.toString();
    }

    @Nullable
    public VcsRevisionNumber getLineRevisionNumber(int lineNumber) {
        if (lineNumber >= this.myLines.size() || lineNumber < 0) {
            return null;
        }
        HgAnnotationLine annotationLine = this.myLines.get(lineNumber);
        return annotationLine.getVcsRevisionNumber();
    }

    @Nullable
    public Date getLineDate(int lineNumber) {
        return null;
    }

    @Nullable
    public List<VcsFileRevision> getRevisions() {
        LinkedList<VcsFileRevision> result = new LinkedList<VcsFileRevision>();
        result.addAll(this.myFileRevisions);
        return result;
    }

    @Nullable
    private static String id(FIELD field) {
        switch (field) {
            case USER: {
                return "Author";
            }
            case REVISION: {
                return "Revision";
            }
            case DATE: {
                return "Date";
            }
        }
        return null;
    }

    @NlsContexts.ListItem
    @Nullable
    private static String displayName(FIELD field) {
        switch (field) {
            case USER: {
                return VcsBundle.message((String)"line.annotation.aspect.author", (Object[])new Object[0]);
            }
            case REVISION: {
                return VcsBundle.message((String)"line.annotation.aspect.revision", (Object[])new Object[0]);
            }
            case DATE: {
                return VcsBundle.message((String)"line.annotation.aspect.date", (Object[])new Object[0]);
            }
        }
        return null;
    }

    private static boolean isShowByDefault(FIELD aspectType) {
        return aspectType == FIELD.DATE || aspectType == FIELD.USER;
    }

    @Nullable
    public VcsRevisionNumber getCurrentRevision() {
        return this.myCurrentRevision;
    }

    public VcsKey getVcsKey() {
        return HgVcs.getKey();
    }

    public VirtualFile getFile() {
        return LocalFileSystem.getInstance().refreshAndFindFileByIoFile(this.myFile.getFile());
    }

    @Nullable
    public FileAnnotation.LineModificationDetailsProvider getLineModificationDetailsProvider() {
        return DefaultLineModificationDetailsProvider.create((FileAnnotation)this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "hgFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "lines";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "vcsFileRevisions";
                break;
            }
        }
        objectArray[1] = "org/zmlx/hg4idea/provider/annotate/HgAnnotation";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class HgLineAnnotationAspect
    extends LineAnnotationAspectAdapter {
        private final FIELD myAspectType;

        HgLineAnnotationAspect(FIELD aspectType) {
            super(HgAnnotation.id(aspectType), HgAnnotation.displayName(aspectType), HgAnnotation.isShowByDefault(aspectType));
            this.myAspectType = aspectType;
        }

        public String getValue(int lineNumber) {
            if (lineNumber >= HgAnnotation.this.myLines.size() || lineNumber < 0) {
                return "";
            }
            HgAnnotationLine annotationLine = HgAnnotation.this.myLines.get(lineNumber);
            return this.myAspectType == FIELD.REVISION ? annotationLine.getVcsRevisionNumber().asString() : annotationLine.get(this.myAspectType).toString();
        }

        protected void showAffectedPaths(int lineNum) {
            if (lineNum >= 0 && lineNum < HgAnnotation.this.myLines.size()) {
                HgAnnotationLine line = HgAnnotation.this.myLines.get(lineNum);
                VirtualFile file = HgAnnotation.this.myFile.toFilePath().getVirtualFile();
                if (line != null && file != null) {
                    ShowAllAffectedGenericAction.showSubmittedFiles((Project)HgAnnotation.this.myProject, (VcsRevisionNumber)line.getVcsRevisionNumber(), (VirtualFile)file, (VcsKey)HgVcs.getKey());
                }
            }
        }
    }

    public static enum FIELD {
        USER,
        REVISION,
        DATE,
        LINE,
        CONTENT;

    }
}

