/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.util.io.PathKt;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.eclipse.jgit.transport.URIish;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.settingsRepository.IcsBundleKt;
import org.jetbrains.settingsRepository.git.GitExKt;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J!\u0010\u0002\u001a\t\u0018\u00010\u0003\u00a2\u0006\u0002\b\u00042\u0006\u0010\u0005\u001a\u00020\u00032\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0002J#\u0010\b\u001a\t\u0018\u00010\u0003\u00a2\u0006\u0002\b\u00042\u0006\u0010\t\u001a\u00020\u00032\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH&\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/settingsRepository/RepositoryService;", "", "checkFileRepo", "", "Lcom/intellij/openapi/util/NlsContexts$DialogMessage;", "url", "project", "Lcom/intellij/openapi/project/Project;", "checkUrl", "uriString", "isValidRepository", "", "file", "Ljava/nio/file/Path;", "intellij.settingsRepository"})
public interface RepositoryService {
    @Nullable
    public String checkUrl(@NotNull String var1, @Nullable Project var2);

    public boolean isValidRepository(@NotNull Path var1);

    @Metadata(mv={1, 5, 1}, k=3)
    public static final class DefaultImpls {
        @Nullable
        public static String checkUrl(@NotNull RepositoryService $this, @NotNull String uriString, @Nullable Project project) {
            Intrinsics.checkNotNullParameter((Object)uriString, (String)"uriString");
            URIish uri = new URIish(uriString);
            boolean isFile = Intrinsics.areEqual((Object)uri.getScheme(), (Object)"file") || uri.getScheme() == null && uri.getHost() == null;
            return isFile ? DefaultImpls.checkFileRepo($this, uriString, project) : null;
        }

        public static /* synthetic */ String checkUrl$default(RepositoryService repositoryService, String string, Project project, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: checkUrl");
            }
            if ((n & 2) != 0) {
                project = null;
            }
            return repositoryService.checkUrl(string, project);
        }

        private static String checkFileRepo(RepositoryService $this, String url, Project project) {
            block13: {
                Path file;
                String string;
                String string2;
                String suffix = "/.git";
                if (StringsKt.endsWith$default((String)url, (String)suffix, (boolean)false, (int)2, null)) {
                    string2 = url;
                    int n = 0;
                    int n2 = url.length() - suffix.length();
                    String string3 = string2.substring(n, n2);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    string = string3;
                } else {
                    string = url;
                }
                Path path = file = Paths.get(string, new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"file");
                if (PathKt.exists((Path)path)) {
                    if (!PathKt.isDirectory((Path)file)) {
                        return IcsBundleKt.icsMessage("dialog.message.path.is.not.directory", new Object[0]);
                    }
                    if ($this.isValidRepository(file)) {
                        return null;
                    }
                } else if (!file.isAbsolute()) {
                    return IcsBundleKt.icsMessage("specify.absolute.path.dialog.message", new Object[0]);
                }
                if (!((MessageDialogBuilder.YesNo)MessageDialogBuilder.Companion.yesNo(IcsBundleKt.icsMessage("init.dialog.title", new Object[0]), IcsBundleKt.icsMessage("init.dialog.message", file)).yesText(IcsBundleKt.icsMessage("init.dialog.create.button", new Object[0]))).ask(project)) break block13;
                try {
                    GitExKt.createBareRepository(file);
                    string2 = null;
                }
                catch (IOException e) {
                    String string4;
                    block15: {
                        block14: {
                            String string5;
                            string4 = e.getMessage();
                            if (string4 == null) break block14;
                            String it = string5 = string4;
                            boolean bl = false;
                            string4 = IcsBundleKt.icsMessage("init.failed.message", it);
                            if (string4 != null) break block15;
                        }
                        string4 = IcsBundleKt.icsMessage("init.failed.message.without.details", new Object[0]);
                    }
                    string2 = string4;
                }
                return string2;
            }
            return "";
        }
    }
}

