/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.chart.statechart.StateChart;
import com.android.tools.adtui.chart.statechart.StateChartColorProvider;
import com.android.tools.adtui.chart.statechart.StateChartTextConverter;
import com.android.tools.adtui.model.StateChartModel;
import com.android.tools.adtui.model.formatter.TimeFormatter;
import com.android.tools.profilers.FeatureConfig;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.ProfilerLayout;
import com.android.tools.profilers.cpu.CpuCellRenderer;
import com.android.tools.profilers.cpu.systemtrace.CpuFramesModel;
import com.android.tools.profilers.cpu.systemtrace.SystemTraceFrame;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBUI;
import icons.StudioIcons;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import org.jetbrains.annotations.NotNull;

public class CpuFramesCellRenderer
extends CpuCellRenderer<CpuFramesModel.FrameState, SystemTraceFrame> {
    private final boolean myDebugRenderingEnabled;
    private SystemTraceFrame myHighlightedFrame;
    private JList<CpuFramesModel.FrameState> myCpuStates;

    public CpuFramesCellRenderer(@NotNull FeatureConfig featureConfig, @NotNull JList<CpuFramesModel.FrameState> cpuStateList) {
        if (featureConfig == null) {
            CpuFramesCellRenderer.$$$reportNull$$$0(0);
        }
        if (cpuStateList == null) {
            CpuFramesCellRenderer.$$$reportNull$$$0(1);
        }
        super(cpuStateList);
        this.myHighlightedFrame = SystemTraceFrame.EMPTY;
        this.myCpuStates = cpuStateList;
        this.myDebugRenderingEnabled = featureConfig.isPerformanceMonitoringEnabled();
    }

    @Override
    @NotNull
    StateChart<SystemTraceFrame> getChartForModel(@NotNull CpuFramesModel.FrameState model) {
        if (model == null) {
            CpuFramesCellRenderer.$$$reportNull$$$0(2);
        }
        StateChart stateChart = ((CpuCellRenderer.StateChartData)this.myStateCharts.get(model.getModel().hashCode())).getChart();
        if (stateChart == null) {
            CpuFramesCellRenderer.$$$reportNull$$$0(3);
        }
        return stateChart;
    }

    @Override
    public Component getListCellRendererComponent(JList<? extends CpuFramesModel.FrameState> list, CpuFramesModel.FrameState value, int index, boolean isSelected, boolean cellHasFocus) {
        JPanel panel = new JPanel((LayoutManager)new TabularLayout("150px,*", "*"));
        panel.setBorder(ProfilerLayout.CPU_THREADS_BORDER);
        panel.setPreferredSize((Dimension)JBDimension.create((Dimension)panel.getPreferredSize()).withHeight(21));
        panel.setBackground(list.getBackground());
        this.myLabel.setText(value.getThreadName());
        this.myLabel.setBackground(ProfilerColors.THREAD_LABEL_BACKGROUND);
        this.myLabel.setForeground(ProfilerColors.THREAD_LABEL_TEXT);
        JBEmptyBorder iconIndent = JBUI.Borders.emptyLeft((int)(StudioIcons.LayoutEditor.Menu.MENU.getIconWidth() + this.myLabel.getIconTextGap()));
        this.myLabel.setBorder(new CompoundBorder((Border)iconIndent, ProfilerLayout.CPU_THREADS_RIGHT_BORDER));
        StateChartModel<SystemTraceFrame> model = value.getModel();
        StateChart<SystemTraceFrame> stateChart = this.getOrCreateStateChart(model);
        stateChart.setDrawDebugInfo(this.myDebugRenderingEnabled);
        stateChart.setOpaque(true);
        panel.add((Component)this.myLabel, new TabularLayout.Constraint(0, 0));
        panel.add((Component)stateChart, new TabularLayout.Constraint(0, 0, 2));
        return panel;
    }

    private void repaint() {
        this.myCpuStates.repaint();
    }

    void setHighlightedFrame(@NotNull SystemTraceFrame frame) {
        if (frame == null) {
            CpuFramesCellRenderer.$$$reportNull$$$0(4);
        }
        if (this.myHighlightedFrame != frame) {
            this.myHighlightedFrame = frame;
            this.repaint();
        }
    }

    private boolean isFrameHighlighted(@NotNull SystemTraceFrame frame) {
        if (frame == null) {
            CpuFramesCellRenderer.$$$reportNull$$$0(5);
        }
        if (this.myHighlightedFrame == SystemTraceFrame.EMPTY) {
            return false;
        }
        return frame == this.myHighlightedFrame || frame == this.myHighlightedFrame.getAssociatedFrame();
    }

    private StateChart<SystemTraceFrame> getOrCreateStateChart(StateChartModel<SystemTraceFrame> model) {
        if (this.myStateCharts.containsKey(model.hashCode()) && ((CpuCellRenderer.StateChartData)this.myStateCharts.get(model.hashCode())).getModel().equals(model)) {
            return ((CpuCellRenderer.StateChartData)this.myStateCharts.get(model.hashCode())).getChart();
        }
        StateChart stateChart = new StateChart(model, (StateChartColorProvider)new StateChartColorProvider<SystemTraceFrame>(){

            @NotNull
            public Color getColor(boolean isMouseOver, @NotNull SystemTraceFrame value) {
                if (value == null) {
                    1.$$$reportNull$$$0(0);
                }
                boolean isHighlighted = CpuFramesCellRenderer.this.isFrameHighlighted(value);
                switch (value.getTotalPerfClass()) {
                    case BAD: {
                        Color color = isHighlighted ? ProfilerColors.SLOW_FRAME_COLOR_HIGHLIGHTED : ProfilerColors.SLOW_FRAME_COLOR;
                        if (color == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        return color;
                    }
                    case GOOD: {
                        Color color = isHighlighted ? ProfilerColors.NORMAL_FRAME_COLOR_HIGHLIGHTED : ProfilerColors.NORMAL_FRAME_COLOR;
                        if (color == null) {
                            1.$$$reportNull$$$0(2);
                        }
                        return color;
                    }
                }
                Color color = ProfilerColors.DEFAULT_STAGE_BACKGROUND;
                if (color == null) {
                    1.$$$reportNull$$$0(3);
                }
                return color;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "value";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/android/tools/profilers/cpu/CpuFramesCellRenderer$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/android/tools/profilers/cpu/CpuFramesCellRenderer$1";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getColor";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getColor";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }, (StateChartTextConverter)new StateChartTextConverter<SystemTraceFrame>(){

            @NotNull
            public String convertToString(@NotNull SystemTraceFrame value) {
                if (value == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (value.getTotalPerfClass() == SystemTraceFrame.PerfClass.BAD) {
                    String string = TimeFormatter.getSingleUnitDurationString((long)value.getDurationUs());
                    if (string == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    return string;
                }
                return "";
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "value";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/android/tools/profilers/cpu/CpuFramesCellRenderer$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/android/tools/profilers/cpu/CpuFramesCellRenderer$2";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "convertToString";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "convertToString";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
        stateChart.setRenderMode(StateChart.RenderMode.TEXT);
        CpuCellRenderer.StateChartData<SystemTraceFrame> data = new CpuCellRenderer.StateChartData<SystemTraceFrame>(stateChart, model);
        stateChart.setHeightGap(0.0f);
        this.myStateCharts.put(model.hashCode(), data);
        return stateChart;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "featureConfig";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cpuStateList";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/cpu/CpuFramesCellRenderer";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/cpu/CpuFramesCellRenderer";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getChartForModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getChartForModel";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setHighlightedFrame";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isFrameHighlighted";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

