/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.profilers.Notification;
import org.jetbrains.annotations.NotNull;

final class CpuProfilerNotifications {
    @NotNull
    static final Notification CAPTURE_START_FAILURE = CpuProfilerNotifications.createError("Recording failed to start", "Try recording again, or ", true);
    @NotNull
    static final Notification CAPTURE_STOP_FAILURE = CpuProfilerNotifications.createError("Recording failed to stop", "Try recording another method trace, or ", true);
    @NotNull
    static final Notification PARSING_FAILURE = CpuProfilerNotifications.createError("Trace data was not recorded", "The profiler was unable to parse the method trace data. Try recording another method trace, or ", true);
    @NotNull
    static final Notification PREPROCESS_FAILURE = CpuProfilerNotifications.createError("Trace data was not recorded", "The profiler was unable to pre-process the method trace data. Try recording another method trace, or ", true);
    @NotNull
    static final Notification PARSING_ABORTED = CpuProfilerNotifications.createError("Parsing trace file aborted", "The CPU profiler was closed before the recorded trace file could be parsed. Please record another trace.", false);
    @NotNull
    static final Notification IMPORT_TRACE_PARSING_FAILURE = CpuProfilerNotifications.createError("Trace file was not parsed", "The profiler was unable to parse the trace file. Please make sure the file selected is a valid trace. Alternatively, try importing another file, or ", true);
    @NotNull
    static final Notification IMPORT_TRACE_PARSING_ABORTED = CpuProfilerNotifications.createError("Parsing trace file aborted", "The profiler changed to a different session before the imported trace file could be parsed. Please try importing your trace file again.", false);
    @NotNull
    static final Notification ATRACE_BUFFER_OVERFLOW = CpuProfilerNotifications.createWarning("System Trace Buffer Overflow Detected", "Your capture exceeded the buffer limit, some data may be missing. Consider recording a shorter trace.", false);

    CpuProfilerNotifications() {
    }

    @NotNull
    private static Notification createNotification(@NotNull Notification.Severity severity, @NotNull String title, @NotNull String text, boolean reportBug) {
        if (severity == null) {
            CpuProfilerNotifications.$$$reportNull$$$0(0);
        }
        if (title == null) {
            CpuProfilerNotifications.$$$reportNull$$$0(1);
        }
        if (text == null) {
            CpuProfilerNotifications.$$$reportNull$$$0(2);
        }
        Notification.Builder builder = new Notification.Builder(title, text).setSeverity(severity);
        if (reportBug) {
            builder.setUrl("https://issuetracker.google.com/issues/new?component=192708", "report a bug");
        }
        Notification notification = builder.build();
        if (notification == null) {
            CpuProfilerNotifications.$$$reportNull$$$0(3);
        }
        return notification;
    }

    @NotNull
    private static Notification createWarning(@NotNull String title, @NotNull String text, boolean reportBug) {
        if (title == null) {
            CpuProfilerNotifications.$$$reportNull$$$0(4);
        }
        if (text == null) {
            CpuProfilerNotifications.$$$reportNull$$$0(5);
        }
        return CpuProfilerNotifications.createNotification(Notification.Severity.WARNING, title, text, reportBug);
    }

    @NotNull
    private static Notification createError(@NotNull String title, @NotNull String text, boolean reportBug) {
        if (title == null) {
            CpuProfilerNotifications.$$$reportNull$$$0(6);
        }
        if (text == null) {
            CpuProfilerNotifications.$$$reportNull$$$0(7);
        }
        return CpuProfilerNotifications.createNotification(Notification.Severity.ERROR, title, text, reportBug);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "severity";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 2: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/cpu/CpuProfilerNotifications";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/cpu/CpuProfilerNotifications";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createNotification";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createNotification";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createWarning";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createError";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

