/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.model.AspectModel;
import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.DurationDataModel;
import com.android.tools.adtui.model.EaseOutModel;
import com.android.tools.adtui.model.Interpolatable;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.RangeSelectionListener;
import com.android.tools.adtui.model.RangeSelectionModel;
import com.android.tools.adtui.model.RangedSeries;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.adtui.model.axis.AxisComponentModel;
import com.android.tools.adtui.model.axis.ClampedAxisComponentModel;
import com.android.tools.adtui.model.axis.ResizingAxisComponentModel;
import com.android.tools.adtui.model.filter.Filter;
import com.android.tools.adtui.model.filter.FilterResult;
import com.android.tools.adtui.model.formatter.BaseAxisFormatter;
import com.android.tools.adtui.model.formatter.SingleUnitAxisFormatter;
import com.android.tools.adtui.model.formatter.TimeAxisFormatter;
import com.android.tools.adtui.model.legend.Legend;
import com.android.tools.adtui.model.legend.LegendComponentModel;
import com.android.tools.adtui.model.legend.SeriesLegend;
import com.android.tools.adtui.model.updater.Updatable;
import com.android.tools.adtui.model.updater.UpdatableManager;
import com.android.tools.idea.transport.poller.TransportEventListener;
import com.android.tools.inspectors.common.api.stacktrace.CodeLocation;
import com.android.tools.inspectors.common.api.stacktrace.CodeNavigator;
import com.android.tools.perflib.vmtrace.ClockType;
import com.android.tools.profiler.proto.Commands;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Cpu;
import com.android.tools.profiler.proto.CpuProfiler;
import com.android.tools.profiler.proto.CpuServiceGrpc;
import com.android.tools.profiler.proto.Transport;
import com.android.tools.profilers.ProfilerAspect;
import com.android.tools.profilers.ProfilerMode;
import com.android.tools.profilers.RecordingOption;
import com.android.tools.profilers.RecordingOptionsModel;
import com.android.tools.profilers.StreamingStage;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.analytics.FeatureTracker;
import com.android.tools.profilers.analytics.FilterMetadata;
import com.android.tools.profilers.cpu.CpuCapture;
import com.android.tools.profilers.cpu.CpuCaptureMetadata;
import com.android.tools.profilers.cpu.CpuCaptureParser;
import com.android.tools.profilers.cpu.CpuCaptureStage;
import com.android.tools.profilers.cpu.CpuProfiler;
import com.android.tools.profilers.cpu.CpuProfilerAspect;
import com.android.tools.profilers.cpu.CpuProfilerNotifications;
import com.android.tools.profilers.cpu.CpuThreadsModel;
import com.android.tools.profilers.cpu.CpuTraceInfo;
import com.android.tools.profilers.cpu.DetailedCpuUsage;
import com.android.tools.profilers.cpu.ProfilingTechnology;
import com.android.tools.profilers.cpu.TraceIdsIterator;
import com.android.tools.profilers.cpu.capturedetails.CaptureDetails;
import com.android.tools.profilers.cpu.capturedetails.CaptureModel;
import com.android.tools.profilers.cpu.config.ArtInstrumentedConfiguration;
import com.android.tools.profilers.cpu.config.CpuProfilerConfigModel;
import com.android.tools.profilers.cpu.config.ProfilingConfiguration;
import com.android.tools.profilers.cpu.systemtrace.CpuFramesModel;
import com.android.tools.profilers.cpu.systemtrace.CpuKernelModel;
import com.android.tools.profilers.event.EventMonitor;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.wireless.android.sdk.stats.AndroidProfilerEvent;
import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CpuProfilerStage
extends StreamingStage
implements CodeNavigator.Listener {
    private static final String HAS_USED_CPU_CAPTURE = "cpu.used.capture";
    private static final SingleUnitAxisFormatter CPU_USAGE_FORMATTER = new SingleUnitAxisFormatter(1, 5, 10, "%");
    private static final SingleUnitAxisFormatter NUM_THREADS_AXIS = new SingleUnitAxisFormatter(1, 5, 1, "");
    public static final int CPU_ART_STOP_TIMEOUT_SEC = Math.max(5, Math.min(Integer.getInteger("profiler.cpu.art.stop.timeout.sec", 120), 300));
    static final double IMPORTED_TRACE_VIEW_EXPAND_PERCENTAGE = 0.1;
    private static final CaptureDetails.Type DEFAULT_CAPTURE_DETAILS = CaptureDetails.Type.CALL_CHART;
    private final CpuThreadsModel myThreadsStates;
    private final CpuKernelModel myCpuKernelModel;
    private final ClampedAxisComponentModel myCpuUsageAxis;
    private final ClampedAxisComponentModel myThreadCountAxis;
    private final ResizingAxisComponentModel myTimeAxisGuide;
    private final DetailedCpuUsage myCpuUsage;
    private final CpuStageLegends myLegends;
    private final DurationDataModel<CpuTraceInfo> myTraceDurations;
    private final EventMonitor myEventMonitor;
    private final RangeSelectionModel myRangeSelectionModel;
    private final EaseOutModel myInstructionsEaseOutModel;
    private final CpuProfilerConfigModel myProfilerConfigModel;
    private final CpuFramesModel myFramesModel;
    @NotNull
    private final CpuTraceDataSeries myCpuTraceDataSeries;
    private final AspectModel<CpuProfilerAspect> myAspect;
    @NotNull
    private final CaptureModel myCaptureModel;
    @NotNull
    private final RecordingOptionsModel myRecordingOptionsModel;
    @NotNull
    private CaptureState myCaptureState;
    private long myCaptureStartTimeNs;
    private long myCaptureStopTimeNs;
    private final InProgressTraceHandler myInProgressTraceHandler;
    @NotNull
    private Cpu.CpuTraceInfo myInProgressTraceInfo;
    @NotNull
    private final UpdatableManager myUpdatableManager;
    private final CpuCaptureParser myCaptureParser;
    @NotNull
    private final TraceIdsIterator myTraceIdsIterator;
    @NotNull
    private final Common.Session mySession;
    private final Map<Long, CpuTraceInfo> myCompletedTraceIdToInfoMap;

    public CpuProfilerStage(@NotNull StudioProfilers profilers) {
        if (profilers == null) {
            CpuProfilerStage.$$$reportNull$$$0(0);
        }
        this(profilers, new CpuCaptureParser(profilers.getIdeServices()));
    }

    @VisibleForTesting
    CpuProfilerStage(@NotNull StudioProfilers profilers, @NotNull CpuCaptureParser captureParser) {
        if (profilers == null) {
            CpuProfilerStage.$$$reportNull$$$0(1);
        }
        if (captureParser == null) {
            CpuProfilerStage.$$$reportNull$$$0(2);
        }
        super(profilers);
        this.myAspect = new AspectModel();
        this.myInProgressTraceInfo = Cpu.CpuTraceInfo.getDefaultInstance();
        this.myCompletedTraceIdToInfoMap = new HashMap<Long, CpuTraceInfo>();
        this.mySession = profilers.getSession();
        this.myCpuTraceDataSeries = new CpuTraceDataSeries();
        this.myProfilerConfigModel = new CpuProfilerConfigModel(profilers, this);
        this.myRecordingOptionsModel = new RecordingOptionsModel();
        Range viewRange = this.getTimeline().getViewRange();
        Range dataRange = this.getTimeline().getDataRange();
        Range selectionRange = this.getTimeline().getSelectionRange();
        this.myCpuUsage = new DetailedCpuUsage(profilers);
        this.myCpuUsageAxis = new ClampedAxisComponentModel.Builder(this.myCpuUsage.getCpuRange(), (BaseAxisFormatter)CPU_USAGE_FORMATTER).build();
        this.myThreadCountAxis = new ClampedAxisComponentModel.Builder(this.myCpuUsage.getThreadRange(), (BaseAxisFormatter)NUM_THREADS_AXIS).build();
        this.myTimeAxisGuide = new ResizingAxisComponentModel.Builder(viewRange, (BaseAxisFormatter)TimeAxisFormatter.DEFAULT_WITHOUT_MINOR_TICKS).setGlobalRange(dataRange).build();
        this.myLegends = new CpuStageLegends(this.myCpuUsage, dataRange);
        this.myTraceDurations = new DurationDataModel(new RangedSeries(viewRange, (DataSeries)this.getCpuTraceDataSeries()));
        this.myThreadsStates = new CpuThreadsModel(viewRange, profilers, this.mySession);
        this.myCpuKernelModel = new CpuKernelModel(viewRange, this);
        this.myFramesModel = new CpuFramesModel(viewRange, this);
        this.myEventMonitor = new EventMonitor(profilers);
        this.myRangeSelectionModel = this.buildRangeSelectionModel(selectionRange, viewRange);
        this.myInstructionsEaseOutModel = new EaseOutModel(profilers.getUpdater(), PROFILING_INSTRUCTIONS_EASE_OUT_NS);
        this.myCaptureState = CaptureState.IDLE;
        this.myCaptureModel = new CaptureModel(this);
        this.myUpdatableManager = new UpdatableManager(this.getStudioProfilers().getUpdater());
        this.myCaptureParser = captureParser;
        List<Cpu.CpuTraceInfo> existingCompletedTraceInfoList = CpuProfiler.getTraceInfoFromSession(this.getStudioProfilers().getClient(), this.mySession, this.getStudioProfilers().getIdeServices().getFeatureConfig().isUnifiedPipelineEnabled()).stream().filter(info -> info.getToTimestamp() != -1L).collect(Collectors.toList());
        existingCompletedTraceInfoList.forEach(info -> this.myCompletedTraceIdToInfoMap.put(info.getTraceId(), new CpuTraceInfo((Cpu.CpuTraceInfo)info)));
        this.myTraceIdsIterator = new TraceIdsIterator(this, existingCompletedTraceInfoList);
        this.myInProgressTraceHandler = new InProgressTraceHandler();
    }

    private static Logger getLogger() {
        return Logger.getInstance(CpuProfilerStage.class);
    }

    private RangeSelectionModel buildRangeSelectionModel(@NotNull Range selectionRange, @NotNull Range viewRange) {
        if (selectionRange == null) {
            CpuProfilerStage.$$$reportNull$$$0(3);
        }
        if (viewRange == null) {
            CpuProfilerStage.$$$reportNull$$$0(4);
        }
        RangeSelectionModel rangeSelectionModel = new RangeSelectionModel(selectionRange, viewRange);
        rangeSelectionModel.addConstraint(this.myTraceDurations);
        rangeSelectionModel.addListener(new RangeSelectionListener(){

            public void selectionCreated() {
                CpuProfilerStage.this.getStudioProfilers().getIdeServices().getFeatureTracker().trackSelectRange();
                CpuProfilerStage.this.selectionChanged();
            }

            public void selectionCleared() {
                CpuProfilerStage.this.selectionChanged();
            }

            public void selectionCreationFailure() {
                CpuProfilerStage.this.selectionChanged();
            }
        });
        return rangeSelectionModel;
    }

    public boolean hasUserUsedCpuCapture() {
        return this.getStudioProfilers().getIdeServices().getTemporaryProfilerPreferences().getBoolean(HAS_USED_CPU_CAPTURE, false);
    }

    @NotNull
    public RangeSelectionModel getRangeSelectionModel() {
        RangeSelectionModel rangeSelectionModel = this.myRangeSelectionModel;
        if (rangeSelectionModel == null) {
            CpuProfilerStage.$$$reportNull$$$0(5);
        }
        return rangeSelectionModel;
    }

    @NotNull
    public EaseOutModel getInstructionsEaseOutModel() {
        EaseOutModel easeOutModel = this.myInstructionsEaseOutModel;
        if (easeOutModel == null) {
            CpuProfilerStage.$$$reportNull$$$0(6);
        }
        return easeOutModel;
    }

    public AxisComponentModel getCpuUsageAxis() {
        return this.myCpuUsageAxis;
    }

    public AxisComponentModel getThreadCountAxis() {
        return this.myThreadCountAxis;
    }

    public AxisComponentModel getTimeAxisGuide() {
        return this.myTimeAxisGuide;
    }

    public DetailedCpuUsage getCpuUsage() {
        return this.myCpuUsage;
    }

    public CpuStageLegends getLegends() {
        return this.myLegends;
    }

    public DurationDataModel<CpuTraceInfo> getTraceDurations() {
        return this.myTraceDurations;
    }

    public String getName() {
        return "CPU";
    }

    public EventMonitor getEventMonitor() {
        return this.myEventMonitor;
    }

    public RecordingOptionsModel getRecordingModel() {
        return this.myRecordingOptionsModel;
    }

    @NotNull
    public CpuProfilerConfigModel getProfilerConfigModel() {
        CpuProfilerConfigModel cpuProfilerConfigModel = this.myProfilerConfigModel;
        if (cpuProfilerConfigModel == null) {
            CpuProfilerStage.$$$reportNull$$$0(7);
        }
        return cpuProfilerConfigModel;
    }

    @Override
    public void enter() {
        this.myEventMonitor.enter();
        this.getStudioProfilers().getUpdater().register((Updatable)this.myCpuUsage);
        this.getStudioProfilers().getUpdater().register(this.myTraceDurations);
        this.getStudioProfilers().getUpdater().register((Updatable)this.myInProgressTraceHandler);
        this.getStudioProfilers().getUpdater().register((Updatable)this.myCpuUsageAxis);
        this.getStudioProfilers().getUpdater().register((Updatable)this.myThreadCountAxis);
        CodeNavigator navigator = this.getStudioProfilers().getIdeServices().getCodeNavigator();
        navigator.addListener((CodeNavigator.Listener)this);
        this.getStudioProfilers().getIdeServices().getFeatureTracker().trackEnterStage(this.getStageType());
        this.getStudioProfilers().addDependency(this).onChange((Enum)ProfilerAspect.PROCESSES, this.myProfilerConfigModel::updateProfilingConfigurations);
        this.myProfilerConfigModel.updateProfilingConfigurations();
        this.setupRecordingOptions();
        if (this.getStudioProfilers().getIdeServices().getFeatureConfig().isCpuNewRecordingWorkflowEnabled()) {
            this.setProfilerMode(ProfilerMode.EXPANDED);
        }
    }

    @Override
    public void exit() {
        this.myEventMonitor.exit();
        this.getStudioProfilers().getUpdater().unregister((Updatable)this.myCpuUsage);
        this.getStudioProfilers().getUpdater().unregister(this.myTraceDurations);
        this.getStudioProfilers().getUpdater().unregister((Updatable)this.myInProgressTraceHandler);
        this.getStudioProfilers().getUpdater().unregister((Updatable)this.myCpuUsageAxis);
        this.getStudioProfilers().getUpdater().unregister((Updatable)this.myThreadCountAxis);
        this.getStudioProfilers().getIdeServices().getCodeNavigator().removeListener((CodeNavigator.Listener)this);
        this.getStudioProfilers().removeDependencies(this);
        this.myCaptureParser.abortParsing();
        this.myRangeSelectionModel.clearListeners();
        this.myUpdatableManager.releaseAll();
    }

    @Override
    public AndroidProfilerEvent.Stage getStageType() {
        return AndroidProfilerEvent.Stage.CPU_STAGE;
    }

    @NotNull
    public UpdatableManager getUpdatableManager() {
        UpdatableManager updatableManager = this.myUpdatableManager;
        if (updatableManager == null) {
            CpuProfilerStage.$$$reportNull$$$0(8);
        }
        return updatableManager;
    }

    public AspectModel<CpuProfilerAspect> getAspect() {
        return this.myAspect;
    }

    public void toggleCapturing() {
        if (this.myCaptureState == CaptureState.CAPTURING) {
            this.stopCapturing();
        } else {
            this.startCapturing();
        }
    }

    public void startCapturing() {
        ProfilingConfiguration config = this.myProfilerConfigModel.getProfilingConfiguration();
        assert (this.getStudioProfilers().getProcess() != null);
        Common.Process process = this.getStudioProfilers().getProcess();
        String traceFilePath = String.format("%s/%s-%d.trace", "/data/local/tmp/perfd", process.getName(), System.nanoTime());
        this.setCaptureState(CaptureState.STARTING);
        Cpu.CpuTraceConfiguration configuration = Cpu.CpuTraceConfiguration.newBuilder().setAppName(process.getName()).setAbiCpuArch(process.getAbiCpuArch()).setInitiationType(Cpu.TraceInitiationType.INITIATED_BY_UI).setTempPath(traceFilePath).setUserOptions(config.toProto()).addAllSymbolDirs(this.getStudioProfilers().getIdeServices().getNativeSymbolsDirectories()).build();
        Executor poolExecutor = this.getStudioProfilers().getIdeServices().getPoolExecutor();
        if (this.getStudioProfilers().getIdeServices().getFeatureConfig().isUnifiedPipelineEnabled()) {
            Commands.Command startCommand = Commands.Command.newBuilder().setStreamId(this.mySession.getStreamId()).setPid(this.mySession.getPid()).setType(Commands.Command.CommandType.START_CPU_TRACE).setStartCpuTrace(Cpu.StartCpuTrace.newBuilder().setConfiguration(configuration).build()).build();
            this.getStudioProfilers().getClient().executeAsync(startCommand, poolExecutor).thenAcceptAsync(response -> {
                TransportEventListener statusListener2 = new TransportEventListener(Common.Event.Kind.CPU_TRACE_STATUS, this.getStudioProfilers().getIdeServices().getMainExecutor(), event -> event.getCommandId() == response.getCommandId(), () -> this.mySession.getStreamId(), () -> this.mySession.getPid(), event -> {
                    this.startCapturingCallback(event.getCpuTraceStatus().getTraceStartStatus());
                    return true;
                });
                this.getStudioProfilers().getTransportPoller().registerListener(statusListener2);
            }, poolExecutor);
        } else {
            CpuProfiler.CpuProfilingAppStartRequest request = CpuProfiler.CpuProfilingAppStartRequest.newBuilder().setSession(this.mySession).setConfiguration(configuration).build();
            CompletableFuture.supplyAsync(() -> this.getCpuClient().startProfilingApp(request), poolExecutor).thenAcceptAsync(response -> this.startCapturingCallback(response.getStatus()), this.getStudioProfilers().getIdeServices().getMainExecutor());
        }
        this.getStudioProfilers().getIdeServices().getTemporaryProfilerPreferences().setBoolean(HAS_USED_CPU_CAPTURE, true);
        this.myInstructionsEaseOutModel.setCurrentPercentage(1.0f);
    }

    private void startCapturingCallback(@NotNull Cpu.TraceStartStatus status) {
        if (status == null) {
            CpuProfilerStage.$$$reportNull$$$0(9);
        }
        if (status.getStatus().equals((Object)Cpu.TraceStartStatus.Status.SUCCESS)) {
            this.myCaptureStartTimeNs = this.currentTimeNs();
            this.setCaptureState(CaptureState.CAPTURING);
            this.getTimeline().setStreaming(true);
        } else {
            CpuProfilerStage.getLogger().warn("Unable to start tracing: " + status.getStatus());
            CpuProfilerStage.getLogger().warn(status.getErrorMessage());
            this.getStudioProfilers().getIdeServices().showNotification(CpuProfilerNotifications.CAPTURE_START_FAILURE);
            this.setCaptureState(CaptureState.IDLE);
            this.setCapture(null);
        }
    }

    @VisibleForTesting
    void stopCapturing() {
        if (Cpu.CpuTraceInfo.getDefaultInstance().equals((Object)this.myInProgressTraceInfo)) {
            return;
        }
        this.myCaptureStopTimeNs = this.currentTimeNs();
        this.setCaptureState(CaptureState.STOPPING);
        CpuProfiler.stopTracing(this.getStudioProfilers(), this.mySession, this.myInProgressTraceInfo.getConfiguration(), this::stopCapturingCallback);
    }

    public long getCaptureStartTimeNs() {
        return this.myCaptureStartTimeNs;
    }

    public long getCaptureStopTimeNs() {
        return this.myCaptureStopTimeNs;
    }

    @NotNull
    public TraceIdsIterator getTraceIdsIterator() {
        TraceIdsIterator traceIdsIterator = this.myTraceIdsIterator;
        if (traceIdsIterator == null) {
            CpuProfilerStage.$$$reportNull$$$0(10);
        }
        return traceIdsIterator;
    }

    void navigateNext() {
        this.handleCaptureNavigation(this.myTraceIdsIterator.next());
    }

    void navigatePrevious() {
        this.handleCaptureNavigation(this.myTraceIdsIterator.previous());
    }

    private void handleCaptureNavigation(long traceId) {
        if (traceId == -1L) {
            return;
        }
        this.setAndSelectCapture(traceId);
    }

    private void stopCapturingCallback(@NotNull Cpu.TraceStopStatus status) {
        if (status == null) {
            CpuProfilerStage.$$$reportNull$$$0(11);
        }
        if (!status.getStatus().equals((Object)Cpu.TraceStopStatus.Status.UNSPECIFIED) && !status.getStatus().equals((Object)Cpu.TraceStopStatus.Status.SUCCESS)) {
            this.trackAndLogTraceStopFailures(status);
            this.setCaptureState(CaptureState.IDLE);
            this.setCapture(null);
        }
    }

    private void trackAndLogTraceStopFailures(@NotNull Cpu.TraceStopStatus status) {
        if (status == null) {
            CpuProfilerStage.$$$reportNull$$$0(12);
        }
        CpuCaptureMetadata captureMetadata = new CpuCaptureMetadata(this.myProfilerConfigModel.getProfilingConfiguration());
        long estimateDurationMs = TimeUnit.NANOSECONDS.toMillis(this.currentTimeNs() - this.myCaptureStartTimeNs);
        captureMetadata.setCaptureDurationMs(estimateDurationMs);
        captureMetadata.setStoppingTimeMs((int)TimeUnit.NANOSECONDS.toMillis(status.getStoppingTimeNs()));
        captureMetadata.setStatus(CpuCaptureMetadata.CaptureStatus.fromStopStatus(status.getStatus()));
        this.getStudioProfilers().getIdeServices().getFeatureTracker().trackCaptureTrace(captureMetadata);
        CpuProfilerStage.getLogger().warn("Unable to stop tracing: " + status.getStatus());
        CpuProfilerStage.getLogger().warn(status.getErrorMessage());
        this.getStudioProfilers().getIdeServices().showNotification(CpuProfilerNotifications.CAPTURE_STOP_FAILURE);
    }

    private void goToCaptureStage(long traceId) {
        CpuCaptureStage stage;
        if (this.myCompletedTraceIdToInfoMap.containsKey(traceId) && (stage = CpuCaptureStage.create(this.getStudioProfilers(), ProfilingConfiguration.fromProto(this.myCompletedTraceIdToInfoMap.get(traceId).getTraceInfo().getConfiguration().getUserOptions()), traceId)) != null) {
            this.getStudioProfilers().getIdeServices().getMainExecutor().execute(() -> this.getStudioProfilers().setStage(stage));
            return;
        }
        this.getStudioProfilers().getIdeServices().showNotification(CpuProfilerNotifications.IMPORT_TRACE_PARSING_FAILURE);
    }

    @NotNull
    public CpuCaptureParser getCaptureParser() {
        CpuCaptureParser cpuCaptureParser = this.myCaptureParser;
        if (cpuCaptureParser == null) {
            CpuProfilerStage.$$$reportNull$$$0(13);
        }
        return cpuCaptureParser;
    }

    @NotNull
    private CpuServiceGrpc.CpuServiceBlockingStub getCpuClient() {
        CpuServiceGrpc.CpuServiceBlockingStub cpuServiceBlockingStub = this.getStudioProfilers().getClient().getCpuClient();
        if (cpuServiceBlockingStub == null) {
            CpuProfilerStage.$$$reportNull$$$0(14);
        }
        return cpuServiceBlockingStub;
    }

    private void selectionChanged() {
        CpuTraceInfo intersectingTraceInfo = this.getIntersectingTraceInfo(this.getTimeline().getSelectionRange());
        if (intersectingTraceInfo == null) {
            this.setCapture(null);
        } else {
            this.setCapture(intersectingTraceInfo.getTraceId());
        }
    }

    @Nullable
    CpuTraceInfo getIntersectingTraceInfo(Range range) {
        List infoList = this.getTraceDurations().getSeries().getSeriesForRange(range);
        for (SeriesData info : infoList) {
            Range captureRange = ((CpuTraceInfo)info.value).getRange();
            if (!captureRange.intersectsWith(range)) continue;
            return (CpuTraceInfo)info.value;
        }
        return null;
    }

    public long currentTimeNs() {
        return TimeUnit.MICROSECONDS.toNanos((long)this.getTimeline().getDataRange().getMax());
    }

    @VisibleForTesting
    public void setCapture(@Nullable CpuCapture capture) {
        if (!this.myCaptureModel.setCapture(capture)) {
            return;
        }
        if (capture != null) {
            this.setProfilerMode(ProfilerMode.EXPANDED);
            this.onCaptureSelection();
        }
    }

    private void onCaptureSelection() {
        CpuCapture capture = this.getCapture();
        if (capture == null) {
            return;
        }
        if (this.getCaptureState() == CaptureState.IDLE || this.getCaptureState() == CaptureState.CAPTURING) {
            this.ensureCaptureInViewRange();
            if (capture.getSystemTraceData() != null && capture.getSystemTraceData().isMissingData()) {
                this.getStudioProfilers().getIdeServices().showNotification(CpuProfilerNotifications.ATRACE_BUFFER_OVERFLOW);
            }
        }
    }

    private void ensureCaptureInViewRange() {
        CpuCapture capture = this.getCapture();
        assert (capture != null);
        double padding = this.getTimeline().getViewRange().getLength() * 0.05;
        this.getTimeline().adjustRangeCloseToMiddleView(new Range(capture.getRange().getMin() - padding, capture.getRange().getMax() + padding));
    }

    private void setCapture(long traceId) {
        CompletableFuture<CpuCapture> future = this.getCaptureFuture(traceId);
        if (future != null) {
            future.handleAsync((capture, exception) -> {
                this.setCaptureState(this.myInProgressTraceInfo.equals((Object)Cpu.CpuTraceInfo.getDefaultInstance()) ? CaptureState.IDLE : CaptureState.CAPTURING);
                this.setCapture((CpuCapture)capture);
                return capture;
            }, this.getStudioProfilers().getIdeServices().getMainExecutor());
        }
    }

    public void setAndSelectCapture(long traceId) {
        if (this.getStudioProfilers().getIdeServices().getFeatureConfig().isCpuCaptureStageEnabled()) {
            this.goToCaptureStage(traceId);
        } else {
            CompletableFuture<CpuCapture> future = this.getCaptureFuture(traceId);
            if (future == null) {
                this.setCaptureState(this.myInProgressTraceInfo.equals((Object)Cpu.CpuTraceInfo.getDefaultInstance()) ? CaptureState.IDLE : CaptureState.CAPTURING);
            } else {
                future.handleAsync((capture, exception) -> {
                    this.setCaptureState(this.myInProgressTraceInfo.equals((Object)Cpu.CpuTraceInfo.getDefaultInstance()) ? CaptureState.IDLE : CaptureState.CAPTURING);
                    if (capture != null) {
                        this.setAndSelectCapture((CpuCapture)capture);
                        this.setCaptureDetails(DEFAULT_CAPTURE_DETAILS);
                    }
                    return capture;
                }, this.getStudioProfilers().getIdeServices().getMainExecutor());
            }
        }
    }

    @VisibleForTesting
    public void setAndSelectCapture(@NotNull CpuCapture capture) {
        if (capture == null) {
            CpuProfilerStage.$$$reportNull$$$0(15);
        }
        this.myThreadsStates.updateTraceThreadsForCapture(capture);
        this.getTimeline().getSelectionRange().set(capture.getRange());
        this.setCapture(capture);
    }

    public int getSelectedThread() {
        return this.myCaptureModel.getThread();
    }

    public void setSelectedThread(int id) {
        this.myCaptureModel.setThread(id);
        Range range = this.getTimeline().getSelectionRange();
        if (range.isEmpty()) {
            this.myAspect.changed((Enum)CpuProfilerAspect.SELECTED_THREADS);
            this.setProfilerMode(ProfilerMode.EXPANDED);
        }
    }

    @NotNull
    public List<ClockType> getClockTypes() {
        ImmutableList immutableList = ImmutableList.of((Object)ClockType.GLOBAL, (Object)ClockType.THREAD);
        if (immutableList == null) {
            CpuProfilerStage.$$$reportNull$$$0(16);
        }
        return immutableList;
    }

    @NotNull
    public ClockType getClockType() {
        ClockType clockType = this.myCaptureModel.getClockType();
        if (clockType == null) {
            CpuProfilerStage.$$$reportNull$$$0(17);
        }
        return clockType;
    }

    public void setClockType(@NotNull ClockType clockType) {
        if (clockType == null) {
            CpuProfilerStage.$$$reportNull$$$0(18);
        }
        this.myCaptureModel.setClockType(clockType);
    }

    @Nullable
    public CpuCapture getCapture() {
        return this.myCaptureModel.getCapture();
    }

    @NotNull
    public CaptureState getCaptureState() {
        CaptureState captureState = this.myCaptureState;
        if (captureState == null) {
            CpuProfilerStage.$$$reportNull$$$0(19);
        }
        return captureState;
    }

    @NotNull
    public Cpu.TraceInitiationType getCaptureInitiationType() {
        Cpu.TraceInitiationType traceInitiationType = this.myInProgressTraceInfo.getConfiguration().getInitiationType();
        if (traceInitiationType == null) {
            CpuProfilerStage.$$$reportNull$$$0(20);
        }
        return traceInitiationType;
    }

    public void setCaptureState(@NotNull CaptureState captureState) {
        if (captureState == null) {
            CpuProfilerStage.$$$reportNull$$$0(21);
        }
        if (!this.myCaptureState.equals((Object)captureState)) {
            this.myCaptureState = captureState;
            this.myAspect.changed((Enum)CpuProfilerAspect.CAPTURE_STATE);
            if (captureState == CaptureState.CAPTURING) {
                this.setProfilerMode(ProfilerMode.EXPANDED);
                this.myRecordingOptionsModel.setRecording();
            }
        }
    }

    @NotNull
    public FilterResult applyCaptureFilter(@NotNull Filter filter) {
        if (filter == null) {
            CpuProfilerStage.$$$reportNull$$$0(22);
        }
        FilterResult filterResult = this.myCaptureModel.applyFilter(filter);
        this.trackFilterUsage(filter, filterResult);
        FilterResult filterResult2 = filterResult;
        if (filterResult2 == null) {
            CpuProfilerStage.$$$reportNull$$$0(23);
        }
        return filterResult2;
    }

    private void trackFilterUsage(@NotNull Filter filter, @NotNull FilterResult filterResult) {
        CaptureDetails details;
        if (filter == null) {
            CpuProfilerStage.$$$reportNull$$$0(24);
        }
        if (filterResult == null) {
            CpuProfilerStage.$$$reportNull$$$0(25);
        }
        if ((details = this.getCaptureDetails()) == null) {
            return;
        }
        FilterMetadata filterMetadata = new FilterMetadata();
        FeatureTracker featureTracker = this.getStudioProfilers().getIdeServices().getFeatureTracker();
        switch (details.getType()) {
            case TOP_DOWN: {
                filterMetadata.setView(FilterMetadata.View.CPU_TOP_DOWN);
                break;
            }
            case BOTTOM_UP: {
                filterMetadata.setView(FilterMetadata.View.CPU_BOTTOM_UP);
                break;
            }
            case CALL_CHART: {
                filterMetadata.setView(FilterMetadata.View.CPU_CALL_CHART);
                break;
            }
            case FLAME_CHART: {
                filterMetadata.setView(FilterMetadata.View.CPU_FLAME_CHART);
            }
        }
        filterMetadata.setFeaturesUsed(filter.isMatchCase(), filter.isRegex());
        filterMetadata.setMatchedElementCount(filterResult.getMatchCount());
        filterMetadata.setTotalElementCount(filterResult.getTotalCount());
        filterMetadata.setFilterTextLength(filter.isEmpty() ? 0 : filter.getFilterString().length());
        featureTracker.trackFilterMetadata(filterMetadata);
    }

    @NotNull
    private String getProcessCaptureNameHint(long traceId) {
        String string = CpuProfiler.getTraceInfoFromId(this.getStudioProfilers(), traceId).getConfiguration().getAppName();
        if (string == null) {
            CpuProfilerStage.$$$reportNull$$$0(26);
        }
        return string;
    }

    public boolean isApiInitiatedTracingInProgress() {
        return this.myCaptureState == CaptureState.CAPTURING && this.getCaptureInitiationType().equals((Object)Cpu.TraceInitiationType.INITIATED_BY_API);
    }

    @NotNull
    public CpuTraceDataSeries getCpuTraceDataSeries() {
        CpuTraceDataSeries cpuTraceDataSeries = this.myCpuTraceDataSeries;
        if (cpuTraceDataSeries == null) {
            CpuProfilerStage.$$$reportNull$$$0(27);
        }
        return cpuTraceDataSeries;
    }

    @NotNull
    public CpuThreadsModel getThreadStates() {
        CpuThreadsModel cpuThreadsModel = this.myThreadsStates;
        if (cpuThreadsModel == null) {
            CpuProfilerStage.$$$reportNull$$$0(28);
        }
        return cpuThreadsModel;
    }

    @NotNull
    public CpuKernelModel getCpuKernelModel() {
        CpuKernelModel cpuKernelModel = this.myCpuKernelModel;
        if (cpuKernelModel == null) {
            CpuProfilerStage.$$$reportNull$$$0(29);
        }
        return cpuKernelModel;
    }

    @NotNull
    public CpuFramesModel getFramesModel() {
        CpuFramesModel cpuFramesModel = this.myFramesModel;
        if (cpuFramesModel == null) {
            CpuProfilerStage.$$$reportNull$$$0(30);
        }
        return cpuFramesModel;
    }

    @NotNull
    public CaptureModel getCaptureModel() {
        CaptureModel captureModel = this.myCaptureModel;
        if (captureModel == null) {
            CpuProfilerStage.$$$reportNull$$$0(31);
        }
        return captureModel;
    }

    @VisibleForTesting
    @Nullable
    CompletableFuture<CpuCapture> getCaptureFuture(long traceId) {
        CompletableFuture<CpuCapture> capture = this.myCaptureParser.getCapture(traceId);
        if (capture == null) {
            this.setProfilerMode(ProfilerMode.EXPANDED);
            Transport.BytesRequest traceRequest = Transport.BytesRequest.newBuilder().setStreamId(this.mySession.getStreamId()).setId(String.valueOf(traceId)).build();
            Transport.BytesResponse traceResponse = this.getStudioProfilers().getClient().getTransportClient().getBytes(traceRequest);
            if (!traceResponse.getContents().isEmpty()) {
                File traceFile = CpuCaptureStage.saveCapture(traceId, traceResponse.getContents());
                capture = this.myCaptureParser.parse(traceFile, traceId, this.myCompletedTraceIdToInfoMap.get(traceId).getTraceType(), this.mySession.getPid(), this.getProcessCaptureNameHint(traceId));
            }
        }
        return capture;
    }

    public void setCaptureDetails(@Nullable CaptureDetails.Type type) {
        this.myCaptureModel.setDetails(type);
    }

    @Nullable
    public CaptureDetails getCaptureDetails() {
        return this.myCaptureModel.getDetails();
    }

    public void onNavigated(@NotNull CodeLocation location) {
        if (location == null) {
            CpuProfilerStage.$$$reportNull$$$0(32);
        }
        this.setProfilerMode(ProfilerMode.NORMAL);
    }

    public void refreshRecordingConfigurations() {
        this.myRecordingOptionsModel.clearConfigurations();
        for (ProfilingConfiguration configuration : this.myProfilerConfigModel.getCustomProfilingConfigurationsDeviceFiltered()) {
            this.myRecordingOptionsModel.addConfigurations(new RecordingOption(configuration.getName(), "", () -> this.startRecordingConfig(configuration), this::stopCapturing));
        }
    }

    private void startRecordingConfig(ProfilingConfiguration config) {
        this.myProfilerConfigModel.setProfilingConfiguration(config);
        this.startCapturing();
    }

    private void setupRecordingOptions() {
        for (ProfilingConfiguration configuration : this.myProfilerConfigModel.getDefaultProfilingConfigurations()) {
            ProfilingTechnology tech = ProfilingTechnology.fromConfig(configuration);
            this.myRecordingOptionsModel.addBuiltInOptions(new RecordingOption(tech.getName(), tech.getDescription(), () -> this.startRecordingConfig(configuration), this::stopCapturing));
        }
        this.refreshRecordingConfigurations();
        this.myRecordingOptionsModel.selectBuiltInOption(this.myRecordingOptionsModel.getBuiltInOptions().get(0));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 23: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 23: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profilers";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "captureParser";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectionRange";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewRange";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 23: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/cpu/CpuProfilerStage";
                break;
            }
            case 9: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "status";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "capture";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clockType";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "captureState";
                break;
            }
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filterResult";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/cpu/CpuProfilerStage";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeSelectionModel";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstructionsEaseOutModel";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getProfilerConfigModel";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getUpdatableManager";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getTraceIdsIterator";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getCaptureParser";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getCpuClient";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getClockTypes";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getClockType";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getCaptureState";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getCaptureInitiationType";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "applyCaptureFilter";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessCaptureNameHint";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getCpuTraceDataSeries";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getThreadStates";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getCpuKernelModel";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getFramesModel";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getCaptureModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "buildRangeSelectionModel";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 23: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "startCapturingCallback";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "stopCapturingCallback";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "trackAndLogTraceStopFailures";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setAndSelectCapture";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "setClockType";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "setCaptureState";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "applyCaptureFilter";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "trackFilterUsage";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "onNavigated";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 23: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class CpuStageLegends
    extends LegendComponentModel {
        @NotNull
        private final SeriesLegend myCpuLegend;
        @NotNull
        private final SeriesLegend myOthersLegend;
        @NotNull
        private final SeriesLegend myThreadsLegend;

        public CpuStageLegends(@NotNull DetailedCpuUsage cpuUsage, @NotNull Range dataRange) {
            if (cpuUsage == null) {
                CpuStageLegends.$$$reportNull$$$0(0);
            }
            if (dataRange == null) {
                CpuStageLegends.$$$reportNull$$$0(1);
            }
            super(dataRange);
            this.myCpuLegend = new SeriesLegend(cpuUsage.getCpuSeries(), (BaseAxisFormatter)CPU_USAGE_FORMATTER, dataRange);
            this.myOthersLegend = new SeriesLegend(cpuUsage.getOtherCpuSeries(), (BaseAxisFormatter)CPU_USAGE_FORMATTER, dataRange);
            this.myThreadsLegend = new SeriesLegend(cpuUsage.getThreadsCountSeries(), (BaseAxisFormatter)NUM_THREADS_AXIS, dataRange, Interpolatable.SteppedLineInterpolator);
            this.myCpuLegend.setCachingLastValue(true);
            this.myOthersLegend.setCachingLastValue(true);
            this.add((Legend)this.myCpuLegend);
            this.add((Legend)this.myOthersLegend);
            this.add((Legend)this.myThreadsLegend);
        }

        @NotNull
        public SeriesLegend getCpuLegend() {
            SeriesLegend seriesLegend = this.myCpuLegend;
            if (seriesLegend == null) {
                CpuStageLegends.$$$reportNull$$$0(2);
            }
            return seriesLegend;
        }

        @NotNull
        public SeriesLegend getOthersLegend() {
            SeriesLegend seriesLegend = this.myOthersLegend;
            if (seriesLegend == null) {
                CpuStageLegends.$$$reportNull$$$0(3);
            }
            return seriesLegend;
        }

        @NotNull
        public SeriesLegend getThreadsLegend() {
            SeriesLegend seriesLegend = this.myThreadsLegend;
            if (seriesLegend == null) {
                CpuStageLegends.$$$reportNull$$$0(4);
            }
            return seriesLegend;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cpuUsage";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataRange";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/profilers/cpu/CpuProfilerStage$CpuStageLegends";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/profilers/cpu/CpuProfilerStage$CpuStageLegends";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCpuLegend";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOthersLegend";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getThreadsLegend";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    @VisibleForTesting
    class CpuTraceDataSeries
    implements DataSeries<CpuTraceInfo> {
        CpuTraceDataSeries() {
        }

        public List<SeriesData<CpuTraceInfo>> getDataForRange(Range range) {
            List<Cpu.CpuTraceInfo> traceInfos = CpuProfiler.getTraceInfoFromRange(CpuProfilerStage.this.getStudioProfilers().getClient(), CpuProfilerStage.this.mySession, range, CpuProfilerStage.this.getStudioProfilers().getIdeServices().getFeatureConfig().isUnifiedPipelineEnabled());
            ArrayList<SeriesData<CpuTraceInfo>> seriesData = new ArrayList<SeriesData<CpuTraceInfo>>();
            for (Cpu.CpuTraceInfo protoTraceInfo : traceInfos) {
                CpuTraceInfo info = new CpuTraceInfo(protoTraceInfo);
                seriesData.add((SeriesData<CpuTraceInfo>)new SeriesData((long)info.getRange().getMin(), (Object)info));
            }
            return seriesData;
        }
    }

    private class InProgressTraceHandler
    implements Updatable {
        private InProgressTraceHandler() {
        }

        public void update(long elapsedNs) {
            if (CpuProfilerStage.this.getCaptureParser().isParsing()) {
                CpuProfilerStage.this.myAspect.changed((Enum)CpuProfilerAspect.CAPTURE_ELAPSED_TIME);
                return;
            }
            Cpu.CpuTraceInfo finishedTraceToSelect = null;
            Range dataRange = CpuProfilerStage.this.getTimeline().getDataRange();
            List<Cpu.CpuTraceInfo> traceInfoList = CpuProfiler.getTraceInfoFromRange(CpuProfilerStage.this.getStudioProfilers().getClient(), CpuProfilerStage.this.mySession, dataRange, CpuProfilerStage.this.getStudioProfilers().getIdeServices().getFeatureConfig().isUnifiedPipelineEnabled());
            for (int i = 0; i < traceInfoList.size(); ++i) {
                Cpu.CpuTraceInfo trace = traceInfoList.get(i);
                if (trace.getToTimestamp() == -1L) {
                    assert (i == traceInfoList.size() - 1);
                    finishedTraceToSelect = null;
                    this.handleInProgressTrace(trace);
                    break;
                }
                if (CpuProfilerStage.this.myTraceIdsIterator.contains(trace.getTraceId())) continue;
                CpuProfilerStage.this.myTraceIdsIterator.addTrace(trace.getTraceId());
                CpuProfilerStage.this.myCompletedTraceIdToInfoMap.put(trace.getTraceId(), new CpuTraceInfo(trace));
                finishedTraceToSelect = trace;
                if (trace.getConfiguration().getInitiationType().equals((Object)Cpu.TraceInitiationType.INITIATED_BY_API)) {
                    CpuCaptureMetadata metadata = new CpuCaptureMetadata(new ArtInstrumentedConfiguration("API tracing"));
                    CpuProfilerStage.this.myCaptureParser.trackCaptureMetadata(trace.getTraceId(), metadata);
                    CpuProfilerStage.this.getStudioProfilers().getIdeServices().getFeatureTracker().trackCpuApiTracing(false, true, -1, -1, -1);
                }
                if (trace.getStopStatus().getStatus().equals((Object)Cpu.TraceStopStatus.Status.SUCCESS)) {
                    CpuCaptureMetadata captureMetadata = new CpuCaptureMetadata(ProfilingConfiguration.fromProto(finishedTraceToSelect.getConfiguration().getUserOptions()));
                    captureMetadata.setCaptureDurationMs(TimeUnit.NANOSECONDS.toMillis(trace.getToTimestamp() - trace.getFromTimestamp()));
                    captureMetadata.setStoppingTimeMs((int)TimeUnit.NANOSECONDS.toMillis(trace.getStopStatus().getStoppingTimeNs()));
                    CpuProfilerStage.this.myCaptureParser.trackCaptureMetadata(trace.getTraceId(), captureMetadata);
                    continue;
                }
                CpuProfilerStage.this.trackAndLogTraceStopFailures(trace.getStopStatus());
            }
            if (finishedTraceToSelect != null) {
                CpuProfilerStage.this.myInProgressTraceInfo = Cpu.CpuTraceInfo.getDefaultInstance();
                if (finishedTraceToSelect.getStopStatus().getStatus() == Cpu.TraceStopStatus.Status.SUCCESS) {
                    CpuProfilerStage.this.setAndSelectCapture(finishedTraceToSelect.getTraceId());
                } else {
                    CpuProfilerStage.this.setCaptureState(CaptureState.IDLE);
                }
                CpuProfilerStage.this.myAspect.changed((Enum)CpuProfilerAspect.PROFILING_CONFIGURATION);
            }
        }

        private void handleInProgressTrace(@NotNull Cpu.CpuTraceInfo traceInfo) {
            if (traceInfo == null) {
                InProgressTraceHandler.$$$reportNull$$$0(0);
            }
            if (traceInfo.equals((Object)CpuProfilerStage.this.myInProgressTraceInfo)) {
                CpuProfilerStage.this.myAspect.changed((Enum)CpuProfilerAspect.CAPTURE_ELAPSED_TIME);
                return;
            }
            CpuProfilerStage.this.myInProgressTraceInfo = traceInfo;
            CaptureState state = CaptureState.CAPTURING;
            CpuProfilerStage.this.myCaptureStartTimeNs = CpuProfilerStage.this.myInProgressTraceInfo.getFromTimestamp();
            Common.Event statusEvent = CpuProfiler.getTraceStatusEventFromId(CpuProfilerStage.this.getStudioProfilers(), CpuProfilerStage.this.myInProgressTraceInfo.getTraceId());
            if (statusEvent.getKind() == Common.Event.Kind.CPU_TRACE_STATUS && statusEvent.getCpuTraceStatus().hasTraceStopStatus()) {
                state = CaptureState.STOPPING;
                CpuProfilerStage.this.myCaptureStopTimeNs = statusEvent.getTimestamp();
            }
            CpuProfilerStage.this.setCaptureState(state);
            CpuProfilerStage.this.getTimeline().setStreaming(true);
            if (CpuProfilerStage.this.myInProgressTraceInfo.getConfiguration().getInitiationType() == Cpu.TraceInitiationType.INITIATED_BY_API) {
                CpuProfilerStage.this.myAspect.changed((Enum)CpuProfilerAspect.PROFILING_CONFIGURATION);
            } else {
                CpuProfilerStage.this.myProfilerConfigModel.setProfilingConfiguration(ProfilingConfiguration.fromProto(traceInfo.getConfiguration().getUserOptions()));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "traceInfo", "com/android/tools/profilers/cpu/CpuProfilerStage$InProgressTraceHandler", "handleInProgressTrace"));
        }
    }

    public static enum CaptureState {
        IDLE,
        CAPTURING,
        STARTING,
        STOPPING;

    }
}

