/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.DragAndDropListModel;
import com.android.tools.adtui.model.DragAndDropModelListElement;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.RangedSeries;
import com.android.tools.adtui.model.StateChartModel;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Cpu;
import com.android.tools.profiler.proto.CpuProfiler;
import com.android.tools.profiler.proto.CpuServiceGrpc;
import com.android.tools.profiler.proto.Transport;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.cpu.CpuCapture;
import com.android.tools.profilers.cpu.CpuThreadInfo;
import com.android.tools.profilers.cpu.CpuThreadStateDataSeries;
import com.android.tools.profilers.cpu.LazyDataSeries;
import com.android.tools.profilers.cpu.LegacyCpuThreadStateDataSeries;
import com.android.tools.profilers.cpu.MergeCaptureDataSeries;
import com.android.tools.profilers.cpu.ThreadState;
import com.google.common.annotations.VisibleForTesting;
import java.util.Arrays;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CpuThreadsModel
extends DragAndDropListModel<RangedCpuThread> {
    @NotNull
    private final StudioProfilers myProfilers;
    @NotNull
    private final Common.Session mySession;
    @NotNull
    private final Range myRange;
    @NotNull
    private final AspectObserver myAspectObserver;
    @VisibleForTesting
    protected final HashMap<Integer, RangedCpuThread> myThreadIdToCpuThread;

    public CpuThreadsModel(@NotNull Range range, @NotNull StudioProfilers profilers, @NotNull Common.Session session) {
        if (range == null) {
            CpuThreadsModel.$$$reportNull$$$0(0);
        }
        if (profilers == null) {
            CpuThreadsModel.$$$reportNull$$$0(1);
        }
        if (session == null) {
            CpuThreadsModel.$$$reportNull$$$0(2);
        }
        this.myRange = range;
        this.myProfilers = profilers;
        this.mySession = session;
        this.myAspectObserver = new AspectObserver();
        this.myThreadIdToCpuThread = new HashMap();
        this.myRange.addDependency(this.myAspectObserver).onChange((Enum)Range.Aspect.RANGE, this::nonImportRangeChanged);
        this.nonImportRangeChanged();
        this.sortElements();
    }

    private void nonImportRangeChanged() {
        long minNs = TimeUnit.MICROSECONDS.toNanos((long)this.myRange.getMin());
        long maxNs = TimeUnit.MICROSECONDS.toNanos((long)this.myRange.getMax());
        HashMap<Integer, RangedCpuThread> requestedThreadsRangedCpuThreads = new HashMap<Integer, RangedCpuThread>();
        if (this.myProfilers.getIdeServices().getFeatureConfig().isUnifiedPipelineEnabled()) {
            Transport.GetEventGroupsResponse response = this.myProfilers.getClient().getTransportClient().getEventGroups(Transport.GetEventGroupsRequest.newBuilder().setStreamId(this.mySession.getStreamId()).setPid(this.mySession.getPid()).setKind(Common.Event.Kind.CPU_THREAD).setFromTimestamp(minNs).setToTimestamp(maxNs).build());
            for (Transport.EventGroup eventGroup : response.getGroupsList()) {
                if (eventGroup.getEventsCount() <= 0) continue;
                Cpu.CpuThreadData threadData = eventGroup.getEvents(0).getCpuThread();
                requestedThreadsRangedCpuThreads.put(threadData.getTid(), this.myThreadIdToCpuThread.computeIfAbsent(threadData.getTid(), id -> new RangedCpuThread(this.myRange, threadData.getTid(), threadData.getName())));
            }
        } else {
            CpuProfiler.GetThreadsRequest.Builder request = CpuProfiler.GetThreadsRequest.newBuilder().setSession(this.mySession).setStartTimestamp(minNs).setEndTimestamp(maxNs);
            CpuServiceGrpc.CpuServiceBlockingStub client = this.myProfilers.getClient().getCpuClient();
            CpuProfiler.GetThreadsResponse response = client.getThreads(request.build());
            for (CpuProfiler.GetThreadsResponse.Thread newThread : response.getThreadsList()) {
                RangedCpuThread cpuThread = this.myThreadIdToCpuThread.computeIfAbsent(newThread.getTid(), id -> new RangedCpuThread(this.myRange, newThread.getTid(), newThread.getName()));
                requestedThreadsRangedCpuThreads.put(newThread.getTid(), cpuThread);
            }
        }
        for (int i = 0; i < this.getSize(); ++i) {
            RangedCpuThread element = (RangedCpuThread)this.getElementAt(i);
            if (requestedThreadsRangedCpuThreads.containsKey(element.getThreadId())) {
                requestedThreadsRangedCpuThreads.remove(element.getThreadId());
                continue;
            }
            this.removeOrderedElement(element);
            --i;
        }
        for (RangedCpuThread element : requestedThreadsRangedCpuThreads.values()) {
            this.insertOrderedElement(element);
        }
        this.contentsChanged();
    }

    private void sortElements() {
        Object[] elements = new RangedCpuThread[this.getSize()];
        for (int i = 0; i < this.getSize(); ++i) {
            elements[i] = (RangedCpuThread)this.get(i);
        }
        this.clearOrderedElements();
        Arrays.sort(elements);
        for (Object element : elements) {
            this.insertOrderedElement((DragAndDropModelListElement)element);
        }
    }

    void updateTraceThreadsForCapture(@NotNull CpuCapture capture) {
        if (capture == null) {
            CpuThreadsModel.$$$reportNull$$$0(3);
        }
        this.myThreadIdToCpuThread.forEach((key, value) -> value.applyCapture((int)key, capture));
    }

    private void contentsChanged() {
        this.fireContentsChanged((Object)this, 0, this.size());
    }

    protected static ThreadState getState(Cpu.CpuThreadData.State state, boolean captured) {
        switch (state) {
            case RUNNING: {
                return captured ? ThreadState.RUNNING_CAPTURED : ThreadState.RUNNING;
            }
            case DEAD: {
                return captured ? ThreadState.DEAD_CAPTURED : ThreadState.DEAD;
            }
            case SLEEPING: {
                return captured ? ThreadState.SLEEPING_CAPTURED : ThreadState.SLEEPING;
            }
            case WAITING: {
                return captured ? ThreadState.WAITING_CAPTURED : ThreadState.WAITING;
            }
        }
        return ThreadState.UNKNOWN;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profilers";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "capture";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/profilers/cpu/CpuThreadsModel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "updateTraceThreadsForCapture";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public class RangedCpuThread
    implements DragAndDropModelListElement,
    Comparable<RangedCpuThread> {
        @NotNull
        private final CpuThreadInfo myThreadInfo;
        private final Range myRange;
        private final StateChartModel<ThreadState> myModel;
        private DataSeries<ThreadState> mySeries;

        public RangedCpuThread(Range range, int threadId, String name) {
            this(range, threadId, name, null);
        }

        public RangedCpuThread(Range range, int threadId, @Nullable String name, CpuCapture capture) {
            this.myRange = range;
            this.myModel = new StateChartModel();
            boolean isMainThread = this.applyCapture(threadId, capture);
            this.myThreadInfo = new CpuThreadInfo(threadId, name, isMainThread);
        }

        private boolean applyCapture(int threadId, @Nullable CpuCapture capture) {
            Object object = this.mySeries = CpuThreadsModel.this.myProfilers.getIdeServices().getFeatureConfig().isUnifiedPipelineEnabled() ? new CpuThreadStateDataSeries(CpuThreadsModel.this.myProfilers.getClient().getTransportClient(), CpuThreadsModel.this.mySession.getStreamId(), CpuThreadsModel.this.mySession.getPid(), threadId, capture) : new LegacyCpuThreadStateDataSeries(CpuThreadsModel.this.myProfilers.getClient().getCpuClient(), CpuThreadsModel.this.mySession, threadId, capture);
            if (capture != null && capture.getSystemTraceData() != null) {
                this.mySeries = new MergeCaptureDataSeries<ThreadState>(capture, this.mySeries, new LazyDataSeries(() -> capture.getSystemTraceData().getThreadStatesForThread(threadId)));
            }
            boolean isMainThread = threadId == CpuThreadsModel.this.mySession.getPid();
            this.myModel.addSeries(new RangedSeries(this.myRange, this.mySeries));
            return isMainThread;
        }

        public int getThreadId() {
            return this.myThreadInfo.getId();
        }

        @NotNull
        public String getName() {
            String string = this.myThreadInfo.getName();
            if (string == null) {
                RangedCpuThread.$$$reportNull$$$0(0);
            }
            return string;
        }

        public StateChartModel<ThreadState> getModel() {
            return this.myModel;
        }

        public DataSeries<ThreadState> getStateSeries() {
            return this.mySeries;
        }

        public int getId() {
            return this.getThreadId();
        }

        @Override
        public int compareTo(@NotNull RangedCpuThread o) {
            if (o == null) {
                RangedCpuThread.$$$reportNull$$$0(1);
            }
            return this.myThreadInfo.compareTo(o.myThreadInfo);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/profilers/cpu/CpuThreadsModel$RangedCpuThread";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "o";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/profilers/cpu/CpuThreadsModel$RangedCpuThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "compareTo";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

