/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.capturedetails;

import com.android.tools.adtui.model.Range;
import com.android.tools.perflib.vmtrace.ClockType;
import com.android.tools.profilers.cpu.CaptureNode;
import com.android.tools.profilers.cpu.capturedetails.CpuTreeNode;
import com.android.tools.profilers.cpu.nodemodel.CaptureNodeModel;
import com.android.tools.profilers.cpu.nodemodel.SingleNameModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;
import org.jetbrains.annotations.NotNull;

public class BottomUpNode
extends CpuTreeNode<BottomUpNode> {
    private final List<CaptureNode> myPathNodes;
    private final boolean myIsRoot;
    private boolean myChildrenBuilt;

    private BottomUpNode(String id) {
        super(id);
        this.myPathNodes = new ArrayList<CaptureNode>();
        this.myIsRoot = false;
        this.myChildrenBuilt = false;
    }

    public BottomUpNode(@NotNull CaptureNode node) {
        if (node == null) {
            BottomUpNode.$$$reportNull$$$0(0);
        }
        super("Root");
        this.myPathNodes = new ArrayList<CaptureNode>();
        this.myIsRoot = true;
        this.myChildrenBuilt = true;
        HashMap<String, BottomUpNode> children2 = new HashMap<String, BottomUpNode>();
        HashMap<String, BottomUpNode> unmatchedChildren = new HashMap<String, BottomUpNode>();
        Stack<CaptureNode> stack = new Stack<CaptureNode>();
        stack.add(node);
        while (!stack.isEmpty()) {
            BottomUpNode child;
            CaptureNode curNode = (CaptureNode)stack.pop();
            for (int i = curNode.getChildren().size() - 1; i >= 0; --i) {
                stack.add(curNode.getChildren().get(i));
            }
            if (curNode.getData().getId().isEmpty()) continue;
            String curId = curNode.getData().getId();
            BottomUpNode bottomUpNode = child = curNode.isUnmatched() ? (BottomUpNode)unmatchedChildren.get(curId) : (BottomUpNode)children2.get(curId);
            if (child == null) {
                child = new BottomUpNode(curId);
                if (curNode.isUnmatched()) {
                    unmatchedChildren.put(curId, child);
                } else {
                    children2.put(curId, child);
                }
                this.addChild(child);
            }
            child.addPathNode(curNode);
            child.addNode(curNode);
        }
        this.addNode(node);
        for (BottomUpNode child : this.getChildren()) {
            child.buildChildren();
        }
    }

    private void addPathNode(@NotNull CaptureNode node) {
        if (node == null) {
            BottomUpNode.$$$reportNull$$$0(1);
        }
        this.myPathNodes.add(node);
    }

    public boolean buildChildren() {
        if (this.myChildrenBuilt) {
            return false;
        }
        HashMap<String, BottomUpNode> children2 = new HashMap<String, BottomUpNode>();
        HashMap<String, BottomUpNode> unmatchedChildren = new HashMap<String, BottomUpNode>();
        assert (this.myPathNodes.size() == this.getNodes().size());
        for (int i = 0; i < this.myPathNodes.size(); ++i) {
            BottomUpNode child;
            CaptureNode parent = this.myPathNodes.get(i).getParent();
            if (parent == null) continue;
            String parentId = parent.getData().getId();
            BottomUpNode bottomUpNode = child = parent.isUnmatched() ? (BottomUpNode)unmatchedChildren.get(parentId) : (BottomUpNode)children2.get(parentId);
            if (child == null) {
                child = new BottomUpNode(parentId);
                if (parent.isUnmatched()) {
                    unmatchedChildren.put(parentId, child);
                } else {
                    children2.put(parentId, child);
                }
                this.addChild(child);
            }
            child.addPathNode(parent);
            child.addNode(this.getNodes().get(i));
        }
        this.myChildrenBuilt = true;
        return true;
    }

    @Override
    public void update(@NotNull Range range) {
        if (range == null) {
            BottomUpNode.$$$reportNull$$$0(2);
        }
        this.myGlobalTotal = 0.0;
        double self = 0.0;
        HashMap<CaptureNode, CaptureNode> outerSoFarByParent = new HashMap<CaptureNode, CaptureNode>();
        for (CaptureNode node : this.myNodes) {
            CaptureNode root = node.findRootNode();
            CaptureNode outerSoFar = outerSoFarByParent.getOrDefault(root, null);
            if (outerSoFar == null || node.getEnd() > outerSoFar.getEnd()) {
                if (outerSoFar != null) {
                    this.myGlobalTotal += BottomUpNode.getIntersection(range, outerSoFar, ClockType.GLOBAL);
                }
                outerSoFarByParent.put(root, node);
            }
            self += BottomUpNode.getIntersection(range, node, ClockType.GLOBAL);
            for (CaptureNode child : node.getChildren()) {
                self -= BottomUpNode.getIntersection(range, child, ClockType.GLOBAL);
            }
        }
        for (CaptureNode outerSoFar : outerSoFarByParent.values()) {
            this.myGlobalTotal += BottomUpNode.getIntersection(range, outerSoFar, ClockType.GLOBAL);
        }
        this.myGlobalChildrenTotal = this.myGlobalTotal - self;
    }

    @Override
    @NotNull
    public CaptureNodeModel getMethodModel() {
        if (this.myIsRoot) {
            return new SingleNameModel("");
        }
        CaptureNodeModel captureNodeModel = this.myPathNodes.get(0).getData();
        if (captureNodeModel == null) {
            BottomUpNode.$$$reportNull$$$0(3);
        }
        return captureNodeModel;
    }

    @Override
    public CaptureNode.FilterType getFilterType() {
        if (this.myIsRoot) {
            return CaptureNode.FilterType.MATCH;
        }
        return this.myPathNodes.get(0).getFilterType();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/cpu/capturedetails/BottomUpNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/cpu/capturedetails/BottomUpNode";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethodModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addPathNode";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

