/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.capturedetails;

import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.Range;
import com.android.tools.profilers.cpu.CpuProfilerAspect;
import com.android.tools.profilers.cpu.CpuProfilerStage;
import com.android.tools.profilers.cpu.CpuProfilerStageView;
import com.android.tools.profilers.cpu.ProfilingTechnology;
import com.android.tools.profilers.cpu.StatusPanel;
import com.android.tools.profilers.cpu.StatusPanelModel;
import com.android.tools.profilers.cpu.capturedetails.CapturePane;
import com.android.tools.profilers.cpu.capturedetails.DetailsCapturePane;
import com.android.tools.profilers.cpu.capturedetails.RecordingInitiatorPane;
import com.google.common.annotations.VisibleForTesting;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.concurrent.TimeUnit;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class CpuCaptureView {
    @NotNull
    private final CpuProfilerStageView myStageView;
    @NotNull
    private final CpuProfilerStage myStage;
    @NotNull
    private final JPanel myPanel;
    @NotNull
    private CapturePane myCapturePane;
    @NotNull
    private final AspectObserver myObserver;

    public CpuCaptureView(@NotNull CpuProfilerStageView stageView) {
        if (stageView == null) {
            CpuCaptureView.$$$reportNull$$$0(0);
        }
        this.myStageView = stageView;
        this.myStage = (CpuProfilerStage)((Object)stageView.getStage());
        this.myPanel = new JPanel(new BorderLayout());
        this.myObserver = new AspectObserver();
        this.myCapturePane = this.createCapturePane();
        this.myStage.getAspect().addDependency(this.myObserver).onChange((Enum)CpuProfilerAspect.CAPTURE_DETAILS, this::updateCaptureDetails).onChange((Enum)CpuProfilerAspect.CAPTURE_STATE, this::onCaptureStateChanged).onChange((Enum)CpuProfilerAspect.CAPTURE_SELECTION, this::updateCapturePane);
        this.myStage.getCaptureParser().getAspect().addDependency(this.myObserver).onChange((Enum)CpuProfilerAspect.CAPTURE_PARSING, this::updateCapturePane);
        this.updateCapturePane();
    }

    private void updateCaptureDetails() {
        this.myCapturePane.updateView();
    }

    private void onCaptureStateChanged() {
        if (this.myStage.getCaptureState() == CpuProfilerStage.CaptureState.STARTING) {
            return;
        }
        this.updateCapturePane();
    }

    private void updateCapturePane() {
        this.myPanel.removeAll();
        this.myCapturePane = this.createCapturePane();
        this.myPanel.add((Component)this.myCapturePane, "Center");
        this.myPanel.revalidate();
    }

    @NotNull
    private CapturePane createCapturePane() {
        if (this.myStage.getCaptureParser().isParsing()) {
            return new ParsingPane(this.myStageView);
        }
        if (this.myStage.getCaptureState() == CpuProfilerStage.CaptureState.STOPPING) {
            return new StoppingPane(this.myStageView);
        }
        if (this.myStage.getCaptureState() == CpuProfilerStage.CaptureState.CAPTURING) {
            return new RecordingPane(this.myStageView);
        }
        if (this.myStage.getCapture() == null) {
            return new RecordingInitiatorPane(this.myStageView);
        }
        return new DetailsCapturePane(this.myStageView);
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            CpuCaptureView.$$$reportNull$$$0(1);
        }
        return jPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stageView";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/cpu/capturedetails/CpuCaptureView";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/cpu/capturedetails/CpuCaptureView";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class CpuCaptureViewStatusModel
    implements StatusPanelModel {
        protected Range myRange = new Range(0.0, 0.0);
        protected CpuProfilerStage myStage;
        private AspectObserver myObserver = new AspectObserver();
        private long myStartTimeNs;

        CpuCaptureViewStatusModel(CpuProfilerStage stage, long durationStartTimeNs) {
            this.myStage = stage;
            this.myStartTimeNs = durationStartTimeNs;
            this.myStage.getAspect().addDependency(this.myObserver).onChange((Enum)CpuProfilerAspect.CAPTURE_ELAPSED_TIME, this::updateDuration);
        }

        @Override
        @NotNull
        public String getConfigurationText() {
            String string = ProfilingTechnology.fromConfig(this.myStage.getProfilerConfigModel().getProfilingConfiguration()).getName();
            if (string == null) {
                CpuCaptureViewStatusModel.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        @NotNull
        public Range getRange() {
            Range range = this.myRange;
            if (range == null) {
                CpuCaptureViewStatusModel.$$$reportNull$$$0(1);
            }
            return range;
        }

        @Override
        public void abort() {
            this.myStage.toggleCapturing();
        }

        protected void updateDuration() {
            this.myRange.setMax((double)(this.myStage.currentTimeNs() - this.myStartTimeNs));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/android/tools/profilers/cpu/capturedetails/CpuCaptureView$CpuCaptureViewStatusModel";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getConfigurationText";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRange";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    static class CpuParsingViewStatusModel
    extends CpuCaptureViewStatusModel {
        CpuParsingViewStatusModel(CpuProfilerStage stage) {
            super(stage, -1L);
        }

        @Override
        public void abort() {
            this.myStage.getCaptureParser().abortParsing();
            this.myStage.setCaptureState(CpuProfilerStage.CaptureState.IDLE);
        }

        @Override
        protected void updateDuration() {
            this.myRange.setMax((double)TimeUnit.MILLISECONDS.toNanos(this.myStage.getCaptureParser().getParsingElapsedTimeMs()));
        }
    }

    @VisibleForTesting
    static class ParsingPane
    extends CapturePane {
        static final String ABORT_BUTTON_TEXT = "Abort";

        ParsingPane(@NotNull CpuProfilerStageView stageView) {
            if (stageView == null) {
                ParsingPane.$$$reportNull$$$0(0);
            }
            super(stageView);
            this.disableInteraction();
            this.updateView();
        }

        @Override
        void populateContent(@NotNull JPanel panel) {
            if (panel == null) {
                ParsingPane.$$$reportNull$$$0(1);
            }
            panel.add((Component)new StatusPanel(new CpuParsingViewStatusModel((CpuProfilerStage)((Object)this.myStageView.getStage())), "Parsing", ABORT_BUTTON_TEXT), "Center");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "stageView";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "panel";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/profilers/cpu/capturedetails/CpuCaptureView$ParsingPane";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "populateContent";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    @VisibleForTesting
    static class StoppingPane
    extends CapturePane {
        static final String STATUS_TEXT = "Waiting for the recording to stop";
        private final StatusPanel myPanel;

        StoppingPane(@NotNull CpuProfilerStageView stageView) {
            if (stageView == null) {
                StoppingPane.$$$reportNull$$$0(0);
            }
            super(stageView);
            this.myPanel = new StatusPanel(new CpuCaptureViewStatusModel((CpuProfilerStage)((Object)stageView.getStage()), ((CpuProfilerStage)((Object)stageView.getStage())).getCaptureStopTimeNs()), STATUS_TEXT, null);
            this.disableInteraction();
            this.updateView();
        }

        @Override
        void populateContent(@NotNull JPanel panel) {
            if (panel == null) {
                StoppingPane.$$$reportNull$$$0(1);
            }
            panel.add((Component)this.myPanel, "Center");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "stageView";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "panel";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/profilers/cpu/capturedetails/CpuCaptureView$StoppingPane";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "populateContent";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    @VisibleForTesting
    static class RecordingPane
    extends CapturePane {
        private final StatusPanel myPanel;
        private final AspectObserver myObserver;

        RecordingPane(@NotNull CpuProfilerStageView stageView) {
            if (stageView == null) {
                RecordingPane.$$$reportNull$$$0(0);
            }
            super(stageView);
            this.myObserver = new AspectObserver();
            this.myPanel = new StatusPanel(new CpuCaptureViewStatusModel((CpuProfilerStage)((Object)stageView.getStage()), ((CpuProfilerStage)((Object)stageView.getStage())).getCaptureStartTimeNs()), "Recording", "Stop");
            this.myPanel.setAbortButtonEnabled(!((CpuProfilerStage)((Object)stageView.getStage())).isApiInitiatedTracingInProgress());
            ((CpuProfilerStage)((Object)stageView.getStage())).getAspect().addDependency(this.myObserver).onChange((Enum)CpuProfilerAspect.CAPTURE_STATE, () -> this.myPanel.setAbortButtonEnabled(false));
            this.disableInteraction();
            this.updateView();
        }

        @Override
        void populateContent(@NotNull JPanel panel) {
            if (panel == null) {
                RecordingPane.$$$reportNull$$$0(1);
            }
            panel.add((Component)this.myPanel, "Center");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "stageView";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "panel";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/profilers/cpu/capturedetails/CpuCaptureView$RecordingPane";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "populateContent";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

