/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.capturedetails;

import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.instructions.InstructionsPanel;
import com.android.tools.adtui.instructions.NewRowInstruction;
import com.android.tools.adtui.instructions.RenderInstruction;
import com.android.tools.adtui.instructions.TextInstruction;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.stdui.StandardColors;
import com.android.tools.profilers.ProfilerFonts;
import com.android.tools.profilers.cpu.CpuProfilerAspect;
import com.android.tools.profilers.cpu.CpuProfilerStage;
import com.android.tools.profilers.cpu.CpuProfilerStageView;
import com.android.tools.profilers.cpu.ProfilingTechnology;
import com.android.tools.profilers.cpu.capturedetails.CapturePane;
import com.android.tools.profilers.cpu.config.CpuProfilingConfigurationView;
import com.android.tools.profilers.cpu.config.ProfilingConfiguration;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.JBColor;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.UIUtilities;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.LayoutManager;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

class RecordingInitiatorPane
extends CapturePane {
    @VisibleForTesting
    static final String HELP_TIP_TITLE = "Thread details unavailable";
    static final String RECORD_TEXT = "Record";
    static final String STOP_TEXT = "Stop";
    @VisibleForTesting
    static final String LEARN_MORE_MESSAGE = "Learn more";
    private static final String CONFIGURATIONS_URL = "https://d.android.com/r/studio-ui/profiler/cpu-recording-mode";
    @NotNull
    private final CpuProfilingConfigurationView myConfigsView;
    @NotNull
    private final JButton myRecordButton;
    @NotNull
    private final AspectObserver myObserver;

    RecordingInitiatorPane(@NotNull CpuProfilerStageView stageView) {
        if (stageView == null) {
            RecordingInitiatorPane.$$$reportNull$$$0(0);
        }
        super(stageView);
        this.myConfigsView = new CpuProfilingConfigurationView((CpuProfilerStage)((Object)stageView.getStage()), stageView.getIdeComponents());
        this.myRecordButton = new JButton(RECORD_TEXT);
        this.myRecordButton.setEnabled(((CpuProfilerStage)((Object)stageView.getStage())).getStudioProfilers().getSessionsManager().isSessionAlive());
        this.myRecordButton.addActionListener(event -> ((CpuProfilerStage)((Object)((Object)stageView.getStage()))).toggleCapturing());
        this.disableInteraction();
        this.updateView();
        this.myObserver = new AspectObserver();
        ((CpuProfilerStage)((Object)stageView.getStage())).getAspect().addDependency(this.myObserver).onChange((Enum)CpuProfilerAspect.PROFILING_CONFIGURATION, this::updateView);
    }

    @Override
    void populateContent(@NotNull JPanel panel) {
        if (panel == null) {
            RecordingInitiatorPane.$$$reportNull$$$0(1);
        }
        if (!((CpuProfilerStage)((Object)this.myStageView.getStage())).getStudioProfilers().getIdeServices().getFeatureConfig().isCpuNewRecordingWorkflowEnabled()) {
            panel.add((Component)this.createHelpTipInstructions(), "Center");
            return;
        }
        JPanel content = new JPanel((LayoutManager)new TabularLayout("*,Fit,Fit,*", "*,Fit,Fit,Fit,Fit,*").setVGap(JBUIScale.scale((int)10)));
        JLabel label = new JLabel("Select CPU Profiling mode");
        label.setFont(ProfilerFonts.H2_FONT);
        label.setForeground(StandardColors.TEXT_COLOR);
        HyperlinkLabel technologyDescription = new HyperlinkLabel();
        ProfilingConfiguration config = ((CpuProfilerStage)((Object)this.myStageView.getStage())).getProfilerConfigModel().getProfilingConfiguration();
        technologyDescription.setHyperlinkText(ProfilingTechnology.fromConfig(config).getDescription(), "", "");
        technologyDescription.setForeground(StandardColors.TEXT_COLOR);
        HyperlinkLabel learnMore = new HyperlinkLabel();
        learnMore.setHyperlinkText(LEARN_MORE_MESSAGE);
        learnMore.setHyperlinkTarget(CONFIGURATIONS_URL);
        JPanel learnMoreCell = new JPanel((LayoutManager)new TabularLayout("Fit,*", "Fit").setVGap(JBUIScale.scale((int)10)));
        learnMoreCell.add((Component)learnMore, new TabularLayout.Constraint(0, 0));
        content.add((Component)label, new TabularLayout.Constraint(1, 1));
        content.add((Component)this.myConfigsView.getComponent(), new TabularLayout.Constraint(2, 1));
        content.add((Component)this.myRecordButton, new TabularLayout.Constraint(2, 2));
        content.add((Component)technologyDescription, new TabularLayout.Constraint(3, 1, 3));
        content.add((Component)learnMoreCell, new TabularLayout.Constraint(4, 1));
        panel.add((Component)content, "Center");
    }

    @NotNull
    private JComponent createHelpTipInstructions() {
        FontMetrics headerMetrics = UIUtilities.getFontMetrics((JComponent)this, (Font)ProfilerFonts.H3_FONT);
        FontMetrics bodyMetrics = UIUtilities.getFontMetrics((JComponent)this, (Font)ProfilerFonts.STANDARD_FONT);
        InstructionsPanel instructionsPanel = new InstructionsPanel.Builder(new RenderInstruction[]{new TextInstruction(headerMetrics, HELP_TIP_TITLE), new NewRowInstruction(NewRowInstruction.DEFAULT_ROW_MARGIN), new TextInstruction(bodyMetrics, "Click Record to start capturing CPU activity"), new NewRowInstruction(NewRowInstruction.DEFAULT_ROW_MARGIN), new TextInstruction(bodyMetrics, "or select a capture in the timeline.")}).setColors(JBColor.foreground(), null).build();
        if (instructionsPanel == null) {
            RecordingInitiatorPane.$$$reportNull$$$0(2);
        }
        return instructionsPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stageView";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/cpu/capturedetails/RecordingInitiatorPane";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/cpu/capturedetails/RecordingInitiatorPane";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createHelpTipInstructions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "populateContent";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

