/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.systemtrace;

import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.RangedSeries;
import com.android.tools.adtui.model.StateChartModel;
import com.android.tools.profilers.cpu.CpuCapture;
import com.android.tools.profilers.cpu.CpuProfilerAspect;
import com.android.tools.profilers.cpu.CpuProfilerStage;
import com.android.tools.profilers.cpu.LazyDataSeries;
import com.android.tools.profilers.cpu.systemtrace.CpuSystemTraceData;
import com.android.tools.profilers.cpu.systemtrace.SystemTraceFrame;
import java.util.concurrent.TimeUnit;
import javax.swing.DefaultListModel;
import org.jetbrains.annotations.NotNull;

public class CpuFramesModel
extends DefaultListModel<FrameState> {
    @NotNull
    private final CpuProfilerStage myStage;
    @NotNull
    private final Range myRange;
    @NotNull
    private final AspectObserver myAspectObserver;
    public static final long SLOW_FRAME_RATE_US = TimeUnit.MILLISECONDS.toMicros(17L);

    public CpuFramesModel(@NotNull Range range, @NotNull CpuProfilerStage stage) {
        if (range == null) {
            CpuFramesModel.$$$reportNull$$$0(0);
        }
        if (stage == null) {
            CpuFramesModel.$$$reportNull$$$0(1);
        }
        this.myRange = range;
        this.myStage = stage;
        this.myAspectObserver = new AspectObserver();
        this.myStage.getAspect().addDependency(this.myAspectObserver).onChange((Enum)CpuProfilerAspect.CAPTURE_SELECTION, this::captureStateChanged);
        range.addDependency(this.myAspectObserver).onChange((Enum)Range.Aspect.RANGE, this::contentsChanged);
    }

    private void captureStateChanged() {
        this.removeAllElements();
        CpuCapture capture = this.myStage.getCapture();
        if (capture != null && capture.getSystemTraceData() != null) {
            this.addElement(new FrameState("Main", capture.getMainThreadId(), SystemTraceFrame.FrameThread.MAIN, capture.getSystemTraceData(), this.myRange));
            this.addElement(new FrameState("Render", capture.getSystemTraceData().getRenderThreadId(), SystemTraceFrame.FrameThread.RENDER, capture.getSystemTraceData(), this.myRange));
        }
        this.contentsChanged();
    }

    private void contentsChanged() {
        this.fireContentsChanged(this, 0, this.getSize());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "range";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "stage";
                break;
            }
        }
        objectArray[1] = "com/android/tools/profilers/cpu/systemtrace/CpuFramesModel";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class FrameState {
        @NotNull
        private final DataSeries<SystemTraceFrame> myFrameDataSeries;
        @NotNull
        private final StateChartModel<SystemTraceFrame> myModel;
        private final String myThreadName;
        private final int myThreadId;

        public FrameState(String threadName, int threadId, @NotNull SystemTraceFrame.FrameThread threadType, @NotNull CpuSystemTraceData systemTraceData, @NotNull Range range) {
            if (threadType == null) {
                FrameState.$$$reportNull$$$0(0);
            }
            if (systemTraceData == null) {
                FrameState.$$$reportNull$$$0(1);
            }
            if (range == null) {
                FrameState.$$$reportNull$$$0(2);
            }
            this.myModel = new StateChartModel();
            this.myThreadName = threadName;
            this.myThreadId = threadId;
            this.myFrameDataSeries = new LazyDataSeries<SystemTraceFrame>(() -> systemTraceData.getFrames(threadType));
            this.myModel.addSeries(new RangedSeries(range, this.myFrameDataSeries));
        }

        public String getThreadName() {
            return this.myThreadName;
        }

        public int getThreadId() {
            return this.myThreadId;
        }

        @NotNull
        public DataSeries<SystemTraceFrame> getSeries() {
            DataSeries<SystemTraceFrame> dataSeries = this.myFrameDataSeries;
            if (dataSeries == null) {
                FrameState.$$$reportNull$$$0(3);
            }
            return dataSeries;
        }

        @NotNull
        public StateChartModel<SystemTraceFrame> getModel() {
            StateChartModel<SystemTraceFrame> stateChartModel = this.myModel;
            if (stateChartModel == null) {
                FrameState.$$$reportNull$$$0(4);
            }
            return stateChartModel;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "threadType";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "systemTraceData";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "range";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/profilers/cpu/systemtrace/CpuFramesModel$FrameState";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/profilers/cpu/systemtrace/CpuFramesModel$FrameState";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSeries";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getModel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

