/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory;

import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.formatter.TimeFormatter;
import com.android.tools.idea.protobuf.GeneratedMessageV3;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.memory.MainMemoryProfilerStage;
import com.android.tools.profilers.sessions.SessionArtifact;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public abstract class MemorySessionArtifact<T extends GeneratedMessageV3>
implements SessionArtifact<T> {
    @NotNull
    private final StudioProfilers myProfilers;
    @NotNull
    private final Common.Session mySession;
    @NotNull
    private final Common.SessionMetaData mySessionMetaData;
    @NotNull
    private final T myInfo;
    @NotNull
    private final String myName;

    public MemorySessionArtifact(@NotNull StudioProfilers profilers, @NotNull Common.Session session, @NotNull Common.SessionMetaData sessionMetaData, @NotNull T info, @NotNull String name) {
        if (profilers == null) {
            MemorySessionArtifact.$$$reportNull$$$0(0);
        }
        if (session == null) {
            MemorySessionArtifact.$$$reportNull$$$0(1);
        }
        if (sessionMetaData == null) {
            MemorySessionArtifact.$$$reportNull$$$0(2);
        }
        if (info == null) {
            MemorySessionArtifact.$$$reportNull$$$0(3);
        }
        if (name == null) {
            MemorySessionArtifact.$$$reportNull$$$0(4);
        }
        this.myProfilers = profilers;
        this.mySession = session;
        this.mySessionMetaData = sessionMetaData;
        this.myInfo = info;
        this.myName = name;
    }

    @Override
    @NotNull
    public T getArtifactProto() {
        T t = this.myInfo;
        if (t == null) {
            MemorySessionArtifact.$$$reportNull$$$0(5);
        }
        return t;
    }

    @Override
    @NotNull
    public StudioProfilers getProfilers() {
        StudioProfilers studioProfilers = this.myProfilers;
        if (studioProfilers == null) {
            MemorySessionArtifact.$$$reportNull$$$0(6);
        }
        return studioProfilers;
    }

    @Override
    @NotNull
    public Common.Session getSession() {
        Common.Session session = this.mySession;
        if (session == null) {
            MemorySessionArtifact.$$$reportNull$$$0(7);
        }
        return session;
    }

    @Override
    @NotNull
    public Common.SessionMetaData getSessionMetaData() {
        Common.SessionMetaData sessionMetaData = this.mySessionMetaData;
        if (sessionMetaData == null) {
            MemorySessionArtifact.$$$reportNull$$$0(8);
        }
        return sessionMetaData;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            MemorySessionArtifact.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    public String getSubtitle() {
        if (this.mySessionMetaData.getType() == Common.SessionMetaData.SessionType.MEMORY_CAPTURE) {
            String string = TimeFormatter.getLocalizedDateTime((long)TimeUnit.NANOSECONDS.toMillis(this.mySession.getStartTimestamp()));
            if (string == null) {
                MemorySessionArtifact.$$$reportNull$$$0(10);
            }
            return string;
        }
        String string = this.isOngoing() ? "Recording..." : TimeFormatter.getFullClockString((long)TimeUnit.NANOSECONDS.toMicros(this.getTimestampNs()));
        if (string == null) {
            MemorySessionArtifact.$$$reportNull$$$0(11);
        }
        return string;
    }

    protected abstract long getStartTime();

    protected abstract long getEndTime();

    @Override
    public long getTimestampNs() {
        return this.getStartTime() - this.mySession.getStartTimestamp();
    }

    @Override
    public boolean isOngoing() {
        return this.getEndTime() == Long.MAX_VALUE;
    }

    @Override
    public boolean canExport() {
        return !this.isOngoing();
    }

    @Override
    public void onSelect() {
        boolean needsToOpenMemoryProfiler;
        boolean needsToChangeSession;
        boolean bl = needsToChangeSession = this.mySession != this.myProfilers.getSession();
        if (needsToChangeSession) {
            this.myProfilers.getSessionsManager().setSession(this.mySession);
        }
        boolean bl2 = needsToOpenMemoryProfiler = !(this.myProfilers.getStage() instanceof MainMemoryProfilerStage);
        if (needsToOpenMemoryProfiler) {
            this.myProfilers.setStage(new MainMemoryProfilerStage(this.myProfilers));
        }
        long startTimestamp = TimeUnit.NANOSECONDS.toMicros(this.getStartTime());
        long endTimestamp = TimeUnit.NANOSECONDS.toMicros(this.getEndTime());
        if (this.isOngoing()) {
            SessionArtifact.navigateTimelineToOngoingCapture(this.myProfilers.getTimeline(), startTimestamp);
        } else {
            assert (this.myProfilers.getStage() instanceof MainMemoryProfilerStage);
            MainMemoryProfilerStage stage = (MainMemoryProfilerStage)this.myProfilers.getStage();
            Range captureRange = new Range((double)startTimestamp, (double)endTimestamp);
            this.myProfilers.getTimeline().adjustRangeCloseToMiddleView(captureRange);
            stage.getRangeSelectionModel().set(captureRange.getMin(), captureRange.getMax());
        }
        this.myProfilers.getIdeServices().getFeatureTracker().trackSessionArtifactSelected(this, this.myProfilers.getSessionsManager().isSessionAlive());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profilers";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sessionMetaData";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/memory/MemorySessionArtifact";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/memory/MemorySessionArtifact";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getArtifactProto";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getProfilers";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSession";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSessionMetaData";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubtitle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

