/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.io.usethesource.capsule.core.trie;

import java.util.Iterator;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.IntFunction;
import org.gradle.internal.impldep.io.usethesource.capsule.core.trie.Node;

public class BottomUpImmutableNodeTransformer<SN extends Node, DN extends Node> {
    private static final int MAX_DEPTH = 7;
    private final BiFunction<SN, DN[], DN> nodeMapper;
    private final AtomicReference<Thread> mutator;
    private final DN dstRootNode;
    private final IntFunction<DN[]> arrayConstructor;
    private int stackIndex = -1;
    private final SN[] srcNodeStack = (Node[])new Object[7];
    private final int[] srcNodeCursorsAndLengths = new int[14];
    private final Stack<DN> mappedNodesStack = new Stack();
    private final DN[] EMPTY_DN_ARRAY = (Node[])new Object[0];

    static final <SN extends Node, DN extends Node> DN applyNodeTransformation(SN rootNode, BiFunction<SN, DN[], DN> nodeMapper, IntFunction<DN[]> arrayConstructor) {
        BottomUpImmutableNodeTransformer<SN, DN> transformer = new BottomUpImmutableNodeTransformer<SN, DN>(rootNode, nodeMapper, arrayConstructor);
        super.processStack();
        return (DN)((Node)transformer.mappedNodesStack.peek());
    }

    public BottomUpImmutableNodeTransformer(SN srcRootNode, BiFunction<SN, DN[], DN> nodeMapper, IntFunction<DN[]> arrayConstructor) {
        this.mappedNodesStack.ensureCapacity(128);
        this.nodeMapper = nodeMapper;
        this.arrayConstructor = arrayConstructor;
        this.mutator = new AtomicReference<Thread>(Thread.currentThread());
        this.dstRootNode = null;
        Iterator srcIterator = srcRootNode.nodeArray().iterator();
        if (srcIterator.hasNext()) {
            this.pushOnStack(srcRootNode);
        } else {
            this.mappedNodesStack.push(nodeMapper.apply(srcRootNode, (Node[])this.EMPTY_DN_ARRAY));
        }
    }

    public final DN apply() {
        if (!this.isStackEmpty()) {
            this.processStack();
        }
        this.mutator.set(null);
        return this.dstRootNode;
    }

    private final boolean isStackEmpty() {
        return this.stackIndex == -1;
    }

    private final void pushOnStack(SN srcNode) {
        int nextIndex = ++this.stackIndex;
        this.srcNodeStack[nextIndex] = srcNode;
        this.srcNodeCursorsAndLengths[2 * nextIndex + 0] = 0;
        this.srcNodeCursorsAndLengths[2 * nextIndex + 1] = srcNode.nodeArray().size();
    }

    private final void dropFromStack() {
        int previousIndex = this.stackIndex--;
        this.srcNodeStack[previousIndex] = null;
        this.srcNodeCursorsAndLengths[2 * previousIndex + 0] = 0;
        this.srcNodeCursorsAndLengths[2 * previousIndex + 1] = 0;
    }

    private final void processStack() {
        while (!this.isStackEmpty()) {
            int currentCursorIndex = this.stackIndex * 2;
            int currentLengthIndex = currentCursorIndex + 1;
            int childNodeCursor = this.srcNodeCursorsAndLengths[currentCursorIndex];
            int childNodeLength = this.srcNodeCursorsAndLengths[currentLengthIndex];
            boolean stackModified = false;
            while (!stackModified) {
                if (childNodeCursor < childNodeLength) {
                    Node src = this.srcNodeStack[this.stackIndex].nodeArray().get(childNodeCursor);
                    int n = currentCursorIndex;
                    this.srcNodeCursorsAndLengths[n] = this.srcNodeCursorsAndLengths[n] + 1;
                    Iterator nextSrcIterator = src.nodeArray().iterator();
                    if (nextSrcIterator.hasNext()) {
                        this.pushOnStack(src);
                        stackModified = true;
                        continue;
                    }
                    this.mappedNodesStack.push(this.nodeMapper.apply(src, (Node[])this.EMPTY_DN_ARRAY));
                    continue;
                }
                assert (childNodeLength != 0);
                Node[] newChildren = (Node[])this.arrayConstructor.apply(childNodeLength);
                for (int i = childNodeLength - 1; i >= 0; --i) {
                    newChildren[i] = (Node)this.mappedNodesStack.pop();
                }
                this.mappedNodesStack.push(this.nodeMapper.apply(this.srcNodeStack[this.stackIndex], newChildren));
                this.dropFromStack();
                stackModified = true;
            }
        }
    }
}

