/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/ExternalFunChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "frontend.java"})
public final class ExternalFunChecker
implements DeclarationChecker {
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!(descriptor2 instanceof MemberDescriptor) || !((MemberDescriptor)descriptor2).isExternal()) {
            return;
        }
        BindingTrace trace = context.getTrace();
        if (!(descriptor2 instanceof FunctionDescriptor)) {
            String target;
            DeclarationDescriptor declarationDescriptor = descriptor2;
            String string = target = declarationDescriptor instanceof PropertyDescriptor ? "property" : (declarationDescriptor instanceof ClassDescriptor ? "class" : "non-function declaration");
            KtModifierList ktModifierList = declaration.getModifierList();
            if (ktModifierList != null && (ktModifierList = ktModifierList.getModifier(KtTokens.EXTERNAL_KEYWORD)) != null) {
                KtModifierList it = ktModifierList;
                boolean bl = false;
                trace.report((Diagnostic)Errors.WRONG_MODIFIER_TARGET.on((PsiElement)it, (Object)KtTokens.EXTERNAL_KEYWORD, (Object)target));
            }
            return;
        }
        if (DescriptorUtils.isInterface((DeclarationDescriptor)((FunctionDescriptor)descriptor2).getContainingDeclaration())) {
            trace.report((Diagnostic)ErrorsJvm.EXTERNAL_DECLARATION_IN_INTERFACE.on((PsiElement)declaration));
        } else if (((FunctionDescriptor)descriptor2).getModality() == Modality.ABSTRACT) {
            if (declaration instanceof KtPropertyAccessor) {
                trace.report((Diagnostic)ErrorsJvm.EXTERNAL_DECLARATION_CANNOT_BE_ABSTRACT.on((PsiElement)((KtPropertyAccessor)declaration).getProperty()));
            } else {
                trace.report((Diagnostic)ErrorsJvm.EXTERNAL_DECLARATION_CANNOT_BE_ABSTRACT.on((PsiElement)declaration));
            }
        }
        if (!(descriptor2 instanceof ConstructorDescriptor) && declaration instanceof KtDeclarationWithBody && ((KtDeclarationWithBody)declaration).hasBody()) {
            trace.report((Diagnostic)ErrorsJvm.EXTERNAL_DECLARATION_CANNOT_HAVE_BODY.on((PsiElement)declaration));
        }
        if (InlineUtil.isInline((DeclarationDescriptor)descriptor2)) {
            trace.report((Diagnostic)ErrorsJvm.EXTERNAL_DECLARATION_CANNOT_BE_INLINED.on((PsiElement)declaration));
        }
    }
}

