/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.fonts;

import com.android.ide.common.fonts.FontFamily;
import com.android.ide.common.fonts.FontProvider;
import com.android.ide.common.fonts.FontSource;
import com.android.ide.common.fonts.MutableFontDetail;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0010\u001a\u00020\r2\b\u0010\u0011\u001a\u0004\u0018\u00010\rH\u0002J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\rH\u0016J\u001a\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\r2\u0006\u0010\u001a\u001a\u00020\u0018H\u0002J\u0010\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\rJ(\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020 H\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/android/ide/common/fonts/DirectoryHandler;", "Lorg/xml/sax/helpers/DefaultHandler;", "provider", "Lcom/android/ide/common/fonts/FontProvider;", "(Lcom/android/ide/common/fonts/FontProvider;)V", "fontDetails", "Ljava/util/ArrayList;", "Lcom/android/ide/common/fonts/MutableFontDetail;", "fontFamilies", "Lcom/android/ide/common/fonts/FontFamily;", "getFontFamilies", "()Ljava/util/ArrayList;", "fontMenu", "", "fontMenuName", "fontName", "addProtocol", "url", "endElement", "", "uri", "localName", "name", "parseInt", "", "intAsString", "defaultValue", "parseItalics", "", "italics", "startElement", "attributes", "Lorg/xml/sax/Attributes;", "android.sdktools.sdk-common"})
public final class DirectoryHandler
extends DefaultHandler {
    @NotNull
    private final FontProvider provider;
    @NotNull
    private final ArrayList<MutableFontDetail> fontDetails;
    @NotNull
    private String fontName;
    @NotNull
    private String fontMenu;
    @NotNull
    private String fontMenuName;
    @NotNull
    private final ArrayList<FontFamily> fontFamilies;

    public DirectoryHandler(@NotNull FontProvider provider) {
        Intrinsics.checkParameterIsNotNull((Object)provider, (String)"provider");
        this.provider = provider;
        this.fontDetails = new ArrayList();
        this.fontName = "";
        this.fontMenu = "";
        this.fontMenuName = "";
        this.fontFamilies = new ArrayList();
    }

    @NotNull
    public final ArrayList<FontFamily> getFontFamilies() {
        return this.fontFamilies;
    }

    @Override
    public void startElement(@NotNull String uri, @NotNull String localName, @NotNull String name, @NotNull Attributes attributes) throws SAXException {
        Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
        Intrinsics.checkParameterIsNotNull((Object)localName, (String)"localName");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)attributes, (String)"attributes");
        String string = name;
        if (Intrinsics.areEqual((Object)string, (Object)"family")) {
            String string2 = attributes.getValue("name");
            this.fontName = string2 == null ? "" : string2;
            this.fontMenu = this.addProtocol(attributes.getValue("menu"));
            string2 = attributes.getValue("menuName");
            this.fontMenuName = string2 == null ? "" : string2;
        } else if (Intrinsics.areEqual((Object)string, (Object)"font")) {
            MutableFontDetail font = new MutableFontDetail();
            font.setWeight(this.parseInt(attributes.getValue("weight"), 400));
            font.setWidth(this.parseInt(attributes.getValue("width"), 100));
            font.setItalics(this.parseItalics(attributes.getValue("italic")));
            font.setFontUrl(this.addProtocol(attributes.getValue("url")));
            CharSequence charSequence = attributes.getValue("styleName");
            font.setStyleName((String)(charSequence == null ? "" : charSequence));
            if (font.getWeight() > 0 && font.getWidth() > 0) {
                charSequence = font.getFontUrl();
                boolean bl = false;
                if (charSequence.length() > 0) {
                    this.fontDetails.add(font);
                }
            }
        }
    }

    @Override
    public void endElement(@NotNull String uri, @NotNull String localName, @NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
        Intrinsics.checkParameterIsNotNull((Object)localName, (String)"localName");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        if (Intrinsics.areEqual((Object)name, (Object)"family")) {
            CharSequence charSequence = this.fontName;
            boolean bl = false;
            if (charSequence.length() > 0) {
                charSequence = this.fontMenu;
                bl = false;
                if (charSequence.length() > 0) {
                    this.fontFamilies.add(new FontFamily(this.provider, FontSource.DOWNLOADABLE, this.fontName, this.fontMenu, this.fontMenuName, (List<MutableFontDetail>)this.fontDetails));
                }
            }
            this.fontDetails.clear();
        }
    }

    private final int parseInt(String intAsString, int defaultValue) {
        int n;
        if (intAsString == null) {
            return defaultValue;
        }
        try {
            n = Math.round(Float.parseFloat(intAsString));
        }
        catch (NumberFormatException ex) {
            n = defaultValue;
        }
        return n;
    }

    public final boolean parseItalics(@Nullable String italics) {
        return italics != null && StringsKt.startsWith$default((String)italics, (String)"1", (boolean)false, (int)2, null);
    }

    private final String addProtocol(String url) {
        if (url == null) {
            return "";
        }
        if (StringsKt.startsWith$default((String)url, (String)"//", (boolean)false, (int)2, null)) {
            String string = url;
            int n = 2;
            boolean bl = false;
            String string2 = string.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
            return Intrinsics.stringPlus((String)"https://", (Object)string2);
        }
        return url;
    }
}

