/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.settingsSync;

import com.intellij.configurationStore.ComponentStoreImpl;
import com.intellij.configurationStore.ExportSettingsActionKt;
import com.intellij.configurationStore.StateStorageManager;
import com.intellij.configurationStore.StreamProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServiceKt;
import com.intellij.openapi.components.impl.stores.IComponentStore;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.settingsSync.CloudConfigServerCommunicator;
import com.intellij.settingsSync.GitSettingsLog;
import com.intellij.settingsSync.LocalDirSettingsSyncRemoteCommunicator;
import com.intellij.settingsSync.ServerState;
import com.intellij.settingsSync.SettingsChangeListener;
import com.intellij.settingsSync.SettingsSyncBridge;
import com.intellij.settingsSync.SettingsSyncIdeCommunicator;
import com.intellij.settingsSync.SettingsSyncMainKt;
import com.intellij.settingsSync.SettingsSyncRemoteCommunicator;
import com.intellij.settingsSync.SettingsSyncUpdateChecker;
import com.intellij.settingsSync.SyncSettingsEvent;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000 \u00122\u00020\u0001:\u0002\u0012\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\t\u001a\u00020\nJ\b\u0010\u000b\u001a\u00020\nH\u0016J\u0006\u0010\f\u001a\u00020\nJ\r\u0010\r\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b\u000fJ\r\u0010\u0010\u001a\u00020\nH\u0001\u00a2\u0006\u0002\b\u0011R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0014"}, d2={"Lcom/intellij/settingsSync/SettingsSyncMain;", "Lcom/intellij/openapi/Disposable;", "()V", "componentStore", "Lcom/intellij/configurationStore/ComponentStoreImpl;", "controls", "Lcom/intellij/settingsSync/SettingsSyncMain$SettingsSyncControls;", "getControls$intellij_settingsSync", "()Lcom/intellij/settingsSync/SettingsSyncMain$SettingsSyncControls;", "disableSyncing", "", "dispose", "enableSyncing", "getRemoteCommunicator", "Lcom/intellij/settingsSync/SettingsSyncRemoteCommunicator;", "getRemoteCommunicator$intellij_settingsSync", "syncSettings", "syncSettings$intellij_settingsSync", "Companion", "SettingsSyncControls", "intellij.settingsSync"})
public final class SettingsSyncMain
implements Disposable {
    @NotNull
    private final SettingsSyncControls controls;
    private final ComponentStoreImpl componentStore;
    private static final Logger LOG;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public final SettingsSyncControls getControls$intellij_settingsSync() {
        return this.controls;
    }

    public void dispose() {
    }

    @NotNull
    public final SettingsSyncRemoteCommunicator getRemoteCommunicator$intellij_settingsSync() {
        return this.controls.getRemoteCommunicator();
    }

    @RequiresBackgroundThread
    public final void syncSettings$intellij_settingsSync() {
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        Object object = application.getMessageBus().syncPublisher(SettingsSyncMainKt.getSETTINGS_CHANGED_TOPIC());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ApplicationManager.getAp\u2026r(SETTINGS_CHANGED_TOPIC)");
        SettingsChangeListener publisher = (SettingsChangeListener)object;
        ServerState serverState = this.controls.getRemoteCommunicator().checkServerState();
        if (serverState instanceof ServerState.UpdateNeeded) {
            LOG.info("Updating from server");
            this.controls.getUpdateChecker().scheduleUpdateFromServer();
        } else if (Intrinsics.areEqual((Object)serverState, (Object)ServerState.FileNotExists.INSTANCE)) {
            LOG.info("No file on server, we must push");
            publisher.settingChanged(SyncSettingsEvent.MustPushRequest.INSTANCE);
        } else if (Intrinsics.areEqual((Object)serverState, (Object)ServerState.UpToDate.INSTANCE)) {
            LOG.info("Updating settings is not needed, will check if push is needed");
            publisher.settingChanged(SyncSettingsEvent.PushIfNeededRequest.INSTANCE);
        } else if (!(serverState instanceof ServerState.Error)) {
            // empty if block
        }
    }

    public final void enableSyncing() {
        this.componentStore.getStorageManager().addStreamProvider(this.controls.getStreamProvider(), true);
    }

    public final void disableSyncing() {
        this.componentStore.getStorageManager().removeStreamProvider(this.controls.getStreamProvider().getClass());
    }

    public SettingsSyncMain() {
        SettingsSyncRemoteCommunicator settingsSyncRemoteCommunicator;
        Application application = ApplicationManager.getApplication();
        Path path = PathManager.getConfigDir();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"PathManager.getConfigDir()");
        Path appConfigPath = path;
        Path settingsSyncStorage = appConfigPath.resolve("settingsSync");
        if (System.getProperty("idea.settings.sync.local.server.path") != null) {
            Path path2 = settingsSyncStorage;
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"settingsSyncStorage");
            settingsSyncRemoteCommunicator = new LocalDirSettingsSyncRemoteCommunicator(path2);
        } else {
            settingsSyncRemoteCommunicator = new CloudConfigServerCommunicator();
        }
        SettingsSyncRemoteCommunicator remoteCommunicator = settingsSyncRemoteCommunicator;
        Application application2 = application;
        Intrinsics.checkNotNullExpressionValue((Object)application2, (String)"application");
        IComponentStore iComponentStore = ServiceKt.getStateStore((ComponentManager)((ComponentManager)application2));
        if (iComponentStore == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.configurationStore.ComponentStoreImpl");
        }
        this.componentStore = (ComponentStoreImpl)iComponentStore;
        Disposable disposable = this;
        Path path3 = settingsSyncStorage;
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"settingsSyncStorage");
        this.controls = Companion.init$intellij_settingsSync(application, disposable, path3, appConfigPath, this.componentStore, remoteCommunicator);
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(SettingsSyncMain.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lcom/intellij/settingsSync/SettingsSyncMain$SettingsSyncControls;", "", "streamProvider", "Lcom/intellij/configurationStore/StreamProvider;", "updateChecker", "Lcom/intellij/settingsSync/SettingsSyncUpdateChecker;", "bridge", "Lcom/intellij/settingsSync/SettingsSyncBridge;", "remoteCommunicator", "Lcom/intellij/settingsSync/SettingsSyncRemoteCommunicator;", "(Lcom/intellij/configurationStore/StreamProvider;Lcom/intellij/settingsSync/SettingsSyncUpdateChecker;Lcom/intellij/settingsSync/SettingsSyncBridge;Lcom/intellij/settingsSync/SettingsSyncRemoteCommunicator;)V", "getBridge", "()Lcom/intellij/settingsSync/SettingsSyncBridge;", "getRemoteCommunicator", "()Lcom/intellij/settingsSync/SettingsSyncRemoteCommunicator;", "getStreamProvider", "()Lcom/intellij/configurationStore/StreamProvider;", "getUpdateChecker", "()Lcom/intellij/settingsSync/SettingsSyncUpdateChecker;", "intellij.settingsSync"})
    public static final class SettingsSyncControls {
        @NotNull
        private final StreamProvider streamProvider;
        @NotNull
        private final SettingsSyncUpdateChecker updateChecker;
        @NotNull
        private final SettingsSyncBridge bridge;
        @NotNull
        private final SettingsSyncRemoteCommunicator remoteCommunicator;

        @NotNull
        public final StreamProvider getStreamProvider() {
            return this.streamProvider;
        }

        @NotNull
        public final SettingsSyncUpdateChecker getUpdateChecker() {
            return this.updateChecker;
        }

        @NotNull
        public final SettingsSyncBridge getBridge() {
            return this.bridge;
        }

        @NotNull
        public final SettingsSyncRemoteCommunicator getRemoteCommunicator() {
            return this.remoteCommunicator;
        }

        public SettingsSyncControls(@NotNull StreamProvider streamProvider, @NotNull SettingsSyncUpdateChecker updateChecker, @NotNull SettingsSyncBridge bridge, @NotNull SettingsSyncRemoteCommunicator remoteCommunicator) {
            Intrinsics.checkNotNullParameter((Object)streamProvider, (String)"streamProvider");
            Intrinsics.checkNotNullParameter((Object)updateChecker, (String)"updateChecker");
            Intrinsics.checkNotNullParameter((Object)bridge, (String)"bridge");
            Intrinsics.checkNotNullParameter((Object)remoteCommunicator, (String)"remoteCommunicator");
            this.streamProvider = streamProvider;
            this.updateChecker = updateChecker;
            this.bridge = bridge;
            this.remoteCommunicator = remoteCommunicator;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0006\u001a\u00020\u0007J=\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b\u0015J\u0006\u0010\u0016\u001a\u00020\u0017R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/settingsSync/SettingsSyncMain$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getInstance", "Lcom/intellij/settingsSync/SettingsSyncMain;", "init", "Lcom/intellij/settingsSync/SettingsSyncMain$SettingsSyncControls;", "application", "Lcom/intellij/openapi/application/Application;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "settingsSyncStorage", "Ljava/nio/file/Path;", "appConfigPath", "componentStore", "Lcom/intellij/configurationStore/ComponentStoreImpl;", "remoteCommunicator", "Lcom/intellij/settingsSync/SettingsSyncRemoteCommunicator;", "init$intellij_settingsSync", "isAvailable", "", "intellij.settingsSync"})
    public static final class Companion {
        public final boolean isAvailable() {
            return ApplicationManager.getApplication().getServiceIfCreated(SettingsSyncMain.class) != null;
        }

        @NotNull
        public final SettingsSyncMain getInstance() {
            Object object = ApplicationManager.getApplication().getService(SettingsSyncMain.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ApplicationManager.getAp\u2026ingsSyncMain::class.java)");
            return (SettingsSyncMain)object;
        }

        @NotNull
        public final SettingsSyncControls init$intellij_settingsSync(@NotNull Application application, @NotNull Disposable parentDisposable, @NotNull Path settingsSyncStorage, @NotNull Path appConfigPath, @NotNull ComponentStoreImpl componentStore, @NotNull SettingsSyncRemoteCommunicator remoteCommunicator) {
            Intrinsics.checkNotNullParameter((Object)application, (String)"application");
            Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
            Intrinsics.checkNotNullParameter((Object)settingsSyncStorage, (String)"settingsSyncStorage");
            Intrinsics.checkNotNullParameter((Object)appConfigPath, (String)"appConfigPath");
            Intrinsics.checkNotNullParameter((Object)componentStore, (String)"componentStore");
            Intrinsics.checkNotNullParameter((Object)remoteCommunicator, (String)"remoteCommunicator");
            GitSettingsLog settingsLog2 = new GitSettingsLog(settingsSyncStorage, appConfigPath, parentDisposable, (Function0<? extends Collection<? extends Path>>)((Function0)new Function0<Collection<? extends Path>>(componentStore){
                final /* synthetic */ ComponentStoreImpl $componentStore;

                @NotNull
                public final Collection<Path> invoke() {
                    return ExportSettingsActionKt.getExportableItemsFromLocalStorage((Map)ExportSettingsActionKt.getExportableComponentsMap$default((boolean)false, null, (boolean)false, (int)6, null), (StateStorageManager)this.$componentStore.getStorageManager()).keySet();
                }
                {
                    this.$componentStore = componentStoreImpl;
                    super(0);
                }
            }));
            SettingsSyncIdeCommunicator ideUpdater = new SettingsSyncIdeCommunicator(application, componentStore, appConfigPath);
            SettingsSyncUpdateChecker updateChecker = new SettingsSyncUpdateChecker(application, remoteCommunicator);
            SettingsSyncBridge bridge = new SettingsSyncBridge(application, parentDisposable, settingsLog2, ideUpdater, remoteCommunicator, updateChecker);
            componentStore.getStorageManager().addStreamProvider((StreamProvider)ideUpdater, true);
            return new SettingsSyncControls(ideUpdater, updateChecker, bridge, remoteCommunicator);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

