/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.settingsSync.config;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.settingsSync.ServerState;
import com.intellij.settingsSync.SettingsChangeListener;
import com.intellij.settingsSync.SettingsSyncBundle;
import com.intellij.settingsSync.SettingsSyncMain;
import com.intellij.settingsSync.SettingsSyncMainKt;
import com.intellij.settingsSync.SettingsSyncRemoteCommunicator;
import com.intellij.settingsSync.SettingsSyncUpdateChecker;
import com.intellij.settingsSync.SyncSettingsEvent;
import com.intellij.settingsSync.UpdateResult;
import com.intellij.util.EventDispatcher;
import java.util.EventListener;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001:\u0002\u000e\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005J\u0006\u0010\u000b\u001a\u00020\tJ\u0006\u0010\f\u001a\u00020\tJ\u0006\u0010\r\u001a\u00020\tR!\u0010\u0003\u001a\u0015\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/settingsSync/config/SettingsSyncEnabler;", "", "()V", "eventDispatcher", "Lcom/intellij/util/EventDispatcher;", "Lcom/intellij/settingsSync/config/SettingsSyncEnabler$Listener;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "addListener", "", "listener", "checkServerState", "getSettingsFromServer", "pushSettingsToServer", "Listener", "State", "intellij.settingsSync"})
public final class SettingsSyncEnabler {
    private final EventDispatcher<Listener> eventDispatcher;

    public final void checkServerState() {
        ((Listener)this.eventDispatcher.getMulticaster()).serverStateCheckStarted();
        SettingsSyncRemoteCommunicator communicator = SettingsSyncMain.Companion.getInstance().getRemoteCommunicator$intellij_settingsSync();
        new Task.Modal(this, communicator, null, SettingsSyncBundle.INSTANCE.message("enable.sync.check.server.data.progress", new Object[0]), true){
            private ServerState serverState;
            final /* synthetic */ SettingsSyncEnabler this$0;
            final /* synthetic */ SettingsSyncRemoteCommunicator $communicator;

            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                this.serverState = this.$communicator.checkServerState();
            }

            public void onCancel() {
                this.serverState = State.INSTANCE.getCANCELLED();
            }

            public void onFinished() {
                Listener listener = (Listener)SettingsSyncEnabler.access$getEventDispatcher$p(this.this$0).getMulticaster();
                ServerState serverState = this.serverState;
                if (serverState == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"serverState");
                }
                listener.serverStateCheckFinished(serverState);
            }
            {
                this.this$0 = this$0;
                this.$communicator = $captured_local_variable$1;
                super($super_call_param$2, $super_call_param$3, $super_call_param$4);
            }
        }.queue();
    }

    public final void getSettingsFromServer() {
        ((Listener)this.eventDispatcher.getMulticaster()).updateFromServerStarted();
        SettingsSyncUpdateChecker updateChecker = SettingsSyncMain.Companion.getInstance().getControls$intellij_settingsSync().getUpdateChecker();
        new Task.Modal(this, updateChecker, null, SettingsSyncBundle.INSTANCE.message("enable.sync.get.from.server.progress", new Object[0]), false){
            private UpdateResult updateResult;
            final /* synthetic */ SettingsSyncEnabler this$0;
            final /* synthetic */ SettingsSyncUpdateChecker $updateChecker;

            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                this.updateResult = this.$updateChecker.scheduleUpdateFromServer();
            }

            public void onFinished() {
                Listener listener = (Listener)SettingsSyncEnabler.access$getEventDispatcher$p(this.this$0).getMulticaster();
                UpdateResult updateResult = this.updateResult;
                if (updateResult == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"updateResult");
                }
                listener.updateFromServerFinished(updateResult);
            }
            {
                this.this$0 = this$0;
                this.$updateChecker = $captured_local_variable$1;
                super($super_call_param$2, $super_call_param$3, $super_call_param$4);
            }
        }.queue();
    }

    public final void pushSettingsToServer() {
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        ((SettingsChangeListener)application.getMessageBus().syncPublisher(SettingsSyncMainKt.getSETTINGS_CHANGED_TOPIC())).settingChanged(SyncSettingsEvent.MustPushRequest.INSTANCE);
    }

    public final void addListener(@NotNull Listener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.eventDispatcher.addListener((EventListener)listener);
    }

    public SettingsSyncEnabler() {
        EventDispatcher eventDispatcher = EventDispatcher.create(Listener.class);
        Intrinsics.checkNotNullExpressionValue((Object)eventDispatcher, (String)"EventDispatcher.create(Listener::class.java)");
        this.eventDispatcher = eventDispatcher;
    }

    public static final /* synthetic */ EventDispatcher access$getEventDispatcher$p(SettingsSyncEnabler $this) {
        return $this.eventDispatcher;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/settingsSync/config/SettingsSyncEnabler$State;", "", "()V", "CANCELLED", "Lcom/intellij/settingsSync/ServerState$Error;", "getCANCELLED", "()Lcom/intellij/settingsSync/ServerState$Error;", "intellij.settingsSync"})
    public static final class State {
        @NotNull
        private static final ServerState.Error CANCELLED;
        @NotNull
        public static final State INSTANCE;

        @NotNull
        public final ServerState.Error getCANCELLED() {
            return CANCELLED;
        }

        private State() {
        }

        static {
            State state;
            INSTANCE = state = new State();
            CANCELLED = new ServerState.Error("Cancelled");
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H\u0016J\b\u0010\u0004\u001a\u00020\u0003H\u0016J\u0010\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0003H\u0016J\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u0003H\u0016\u00a8\u0006\r"}, d2={"Lcom/intellij/settingsSync/config/SettingsSyncEnabler$Listener;", "Ljava/util/EventListener;", "serverRequestFinished", "", "serverRequestStarted", "serverStateCheckFinished", "state", "Lcom/intellij/settingsSync/ServerState;", "serverStateCheckStarted", "updateFromServerFinished", "result", "Lcom/intellij/settingsSync/UpdateResult;", "updateFromServerStarted", "intellij.settingsSync"})
    public static interface Listener
    extends EventListener {
        public void serverStateCheckStarted();

        public void serverStateCheckFinished(@NotNull ServerState var1);

        public void updateFromServerStarted();

        public void updateFromServerFinished(@NotNull UpdateResult var1);

        public void serverRequestStarted();

        public void serverRequestFinished();

        @Metadata(mv={1, 5, 1}, k=3)
        public static final class DefaultImpls {
            public static void serverStateCheckStarted(@NotNull Listener $this) {
                $this.serverRequestStarted();
            }

            public static void serverStateCheckFinished(@NotNull Listener $this, @NotNull ServerState state) {
                Intrinsics.checkNotNullParameter((Object)state, (String)"state");
                $this.serverRequestFinished();
            }

            public static void updateFromServerStarted(@NotNull Listener $this) {
                $this.serverRequestStarted();
            }

            public static void updateFromServerFinished(@NotNull Listener $this, @NotNull UpdateResult result2) {
                Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
                $this.serverRequestFinished();
            }

            public static void serverRequestStarted(@NotNull Listener $this) {
            }

            public static void serverRequestFinished(@NotNull Listener $this) {
            }
        }
    }
}

