/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.devkit.actions;

import com.google.gson.GsonBuilder;
import com.intellij.icons.AllIcons;
import com.intellij.ide.scratch.ScratchRootType;
import com.intellij.idea.ActionsBundle;
import com.intellij.internal.statistic.devkit.StatisticsDevKitUtil;
import com.intellij.internal.statistic.eventLog.events.scheme.EventsSchemeBuilder;
import com.intellij.internal.statistic.utils.StatisticsRecorderUtil;
import com.intellij.json.JsonLanguage;
import com.intellij.lang.Language;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/internal/statistic/devkit/actions/GenerateEventsScheme;", "Lcom/intellij/openapi/project/DumbAwareAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "intellij.platform.statistics.devkit"})
public final class GenerateEventsScheme
extends DumbAwareAction {
    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Presentation presentation = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"e.presentation");
        presentation.setEnabled(StatisticsRecorderUtil.isTestModeEnabled((String)"FUS") && e.getProject() != null);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"e.project ?: return");
        Project project2 = project;
        List eventsScheme = EventsSchemeBuilder.buildEventsScheme();
        String text = new GsonBuilder().setPrettyPrinting().create().toJson((Object)eventsScheme);
        VirtualFile scratchFile = ScratchRootType.getInstance().createScratchFile(project2, "statistics_events_scheme.json", (Language)JsonLanguage.INSTANCE, text);
        if (scratchFile == null) {
            StatisticsDevKitUtil.INSTANCE.showNotification(project2, NotificationType.ERROR, "Scratch file creation failed for unknown reasons");
            return;
        }
        FileEditorManager.getInstance((Project)project2).openFile(scratchFile, true);
    }

    public GenerateEventsScheme() {
        super(ActionsBundle.message((String)"action.GenerateEventsScheme.text", (Object[])new Object[0]), ActionsBundle.message((String)"action.GenerateEventsScheme.description", (Object[])new Object[0]), AllIcons.FileTypes.Json);
    }
}

