/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.devkit.actions;

import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import com.intellij.icons.AllIcons;
import com.intellij.idea.ActionsBundle;
import com.intellij.internal.statistic.StatisticsBundle;
import com.intellij.internal.statistic.devkit.StatisticsDevKitUtil;
import com.intellij.internal.statistic.devkit.actions.FusStatesRecorder;
import com.intellij.internal.statistic.devkit.actions.RecordStateStatisticsEventLogAction;
import com.intellij.internal.statistic.devkit.actions.ShowChangedStateEventsAction$actionPerformed$;
import com.intellij.internal.statistic.devkit.toolwindow.ChangedStateEventsPanel;
import com.intellij.internal.statistic.eventLog.fus.FeatureUsageLogger;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.jetbrains.fus.reporting.model.lion3.LogEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u001e\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002J\u0010\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/internal/statistic/devkit/actions/ShowChangedStateEventsAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "recorderId", "", "(Ljava/lang/String;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "showResults", "project", "Lcom/intellij/openapi/project/Project;", "difference", "", "Lcom/jetbrains/fus/reporting/model/lion3/LogEvent;", "update", "event", "Companion", "intellij.platform.statistics.devkit"})
public final class ShowChangedStateEventsAction
extends DumbAwareAction {
    private final String recorderId;
    private static final String[] SYSTEM_FIELDS;
    @NotNull
    public static final Companion Companion;

    /*
     * WARNING - void declaration
     */
    public void actionPerformed(@NotNull AnActionEvent e) {
        void title$iv;
        String message;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"e.project ?: return");
        Project project2 = project;
        if (!RecordStateStatisticsEventLogAction.Companion.checkLogRecordingEnabled(project2, this.recorderId)) {
            return;
        }
        String string = message = StatisticsBundle.message((String)"stats.collecting.feature.usages.in.event.log", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message");
        String string2 = string;
        boolean cancellable$iv = false;
        boolean $i$f$runBackgroundableTask = false;
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project2, (String)title$iv, cancellable$iv, project2, (String)title$iv, cancellable$iv, this, project2){
            final /* synthetic */ Project $project;
            final /* synthetic */ String $title;
            final /* synthetic */ boolean $cancellable;
            final /* synthetic */ ShowChangedStateEventsAction this$0;
            final /* synthetic */ Project $project$inlined;
            {
                this.$project = $captured_local_variable$1;
                this.$title = $captured_local_variable$2;
                this.$cancellable = $captured_local_variable$3;
                this.this$0 = showChangedStateEventsAction;
                this.$project$inlined = project;
                super($super_call_param$4, $super_call_param$5, $super_call_param$6);
            }

            /*
             * WARNING - void declaration
             */
            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                ProgressIndicator indicator2 = indicator;
                boolean bl = false;
                FeatureUsageLogger.INSTANCE.rollOver();
                List<LogEvent> oldState = FusStatesRecorder.INSTANCE.getCurrentState();
                List<LogEvent> newState = FusStatesRecorder.INSTANCE.recordStateAndWait(this.$project$inlined, indicator2);
                if (newState == null) {
                    String string = StatisticsBundle.message((String)"stats.failed.recording.state", (Object[])new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StatisticsBundle.message\u2026.failed.recording.state\")");
                    StatisticsDevKitUtil.INSTANCE.showNotification(this.$project$inlined, NotificationType.ERROR, string);
                } else {
                    void $this$filterTo$iv$iv;
                    Iterable $this$filter$iv = newState;
                    boolean $i$f$filter = false;
                    Iterable iterable = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$filterTo = false;
                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                        boolean bl2;
                        block6: {
                            LogEvent newEvent = (LogEvent)element$iv$iv;
                            boolean bl3 = false;
                            Iterable $this$all$iv = oldState;
                            boolean $i$f$all = false;
                            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                                bl2 = true;
                            } else {
                                for (T element$iv : $this$all$iv) {
                                    LogEvent it = (LogEvent)element$iv;
                                    boolean bl4 = false;
                                    if (!ShowChangedStateEventsAction.Companion.isEventsEquals(newEvent, it)) continue;
                                    bl2 = false;
                                    break block6;
                                }
                                bl2 = true;
                            }
                        }
                        if (!bl2) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    List difference = (List)destination$iv$iv;
                    ApplicationManager.getApplication().invokeLater(new Runnable(difference, this){
                        final /* synthetic */ List $difference;
                        final /* synthetic */ actionPerformed$$inlined$runBackgroundableTask$1 this$0;
                        {
                            this.$difference = list;
                            this.this$0 = var2_2;
                        }

                        public final void run() {
                            ShowChangedStateEventsAction.access$showResults(this.this$0.this$0, this.this$0.$project$inlined, this.$difference);
                        }
                    });
                }
            }
        });
    }

    private final void showResults(Project project, Collection<? extends LogEvent> difference) {
        if (difference.isEmpty()) {
            String string = StatisticsBundle.message((String)"stats.no.changed.events", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StatisticsBundle.message\u2026stats.no.changed.events\")");
            StatisticsDevKitUtil.INSTANCE.showNotification(project, NotificationType.INFORMATION, string);
            return;
        }
        ToolWindow toolWindow = ToolWindowManager.Companion.getInstance(project).getToolWindow("Statistics Event Log");
        if (toolWindow == null) {
            return;
        }
        ToolWindow toolWindow2 = toolWindow;
        String displayName = "Changed events: " + this.recorderId;
        Disposable disposable = toolWindow2.getDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"toolWindow.disposable");
        JComponent changedEventsComponent = new ChangedStateEventsPanel(project, disposable, difference, this.recorderId).getComponent();
        Content content = ContentFactory.SERVICE.getInstance().createContent(changedEventsComponent, displayName, true);
        Intrinsics.checkNotNullExpressionValue((Object)content, (String)"ContentFactory.SERVICE.g\u2026onent, displayName, true)");
        Content content2 = content;
        content2.setPreferredFocusableComponent(changedEventsComponent);
        ContentManager contentManager = toolWindow2.getContentManager();
        Intrinsics.checkNotNullExpressionValue((Object)contentManager, (String)"toolWindow.contentManager");
        ContentManager contentManager2 = contentManager;
        contentManager2.addContent(content2);
        contentManager2.setSelectedContent(content2);
    }

    public void update(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        super.update(event);
        Presentation presentation = event.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"event.presentation");
        presentation.setEnabled(Intrinsics.areEqual((Object)this.recorderId, (Object)"FUS") && FusStatesRecorder.INSTANCE.isComparisonAvailable());
    }

    public ShowChangedStateEventsAction(@NotNull String recorderId) {
        Intrinsics.checkNotNullParameter((Object)recorderId, (String)"recorderId");
        super(ActionsBundle.message((String)"action.ShowChangedStateStatisticsAction.text", (Object[])new Object[0]), ActionsBundle.message((String)"action.ShowChangedStateStatisticsAction.description", (Object[])new Object[0]), AllIcons.Actions.Diff);
        this.recorderId = recorderId;
    }

    static {
        Companion = new Companion(null);
        SYSTEM_FIELDS = new String[]{"created", "last", "system_event_id", "system_headless"};
    }

    public static final /* synthetic */ void access$showResults(ShowChangedStateEventsAction $this, Project project, Collection difference) {
        $this.showResults(project, difference);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nR\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006\u00a8\u0006\f"}, d2={"Lcom/intellij/internal/statistic/devkit/actions/ShowChangedStateEventsAction$Companion;", "", "()V", "SYSTEM_FIELDS", "", "", "[Ljava/lang/String;", "isEventsEquals", "", "newEvent", "Lcom/jetbrains/fus/reporting/model/lion3/LogEvent;", "oldEvent", "intellij.platform.statistics.devkit"})
    public static final class Companion {
        public final boolean isEventsEquals(@NotNull LogEvent newEvent, @NotNull LogEvent oldEvent) {
            Intrinsics.checkNotNullParameter((Object)newEvent, (String)"newEvent");
            Intrinsics.checkNotNullParameter((Object)oldEvent, (String)"oldEvent");
            if (Intrinsics.areEqual((Object)newEvent, (Object)oldEvent)) {
                return true;
            }
            if (Intrinsics.areEqual((Object)newEvent.getGroup(), (Object)oldEvent.getGroup()) ^ true) {
                return false;
            }
            if (Intrinsics.areEqual((Object)newEvent.getEvent().getId(), (Object)oldEvent.getEvent().getId()) ^ true) {
                return false;
            }
            if (newEvent.getEvent().getData().size() != oldEvent.getEvent().getData().size()) {
                return false;
            }
            MapDifference difference = Maps.difference((Map)newEvent.getEvent().getData(), (Map)oldEvent.getEvent().getData());
            for (String key : difference.entriesDiffering().keySet()) {
                if (Intrinsics.areEqual((Object)newEvent.getGroup().getId(), (Object)"settings") && Intrinsics.areEqual((Object)key, (Object)"id") || ArraysKt.contains((Object[])SYSTEM_FIELDS, (Object)key)) continue;
                return false;
            }
            return true;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

