/*
 * Decompiled with CFR 0.152.
 */
package circlet.client.api;

import circlet.client.api.ProjectIdentifier;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcirclet/client/api/ProjectIdentifierResolver;", "", "()V", "idPrefix", "", "keyPrefix", "resolve", "Lcirclet/client/api/ProjectIdentifier;", "projectAsString", "client-api"})
public final class ProjectIdentifierResolver {
    @NotNull
    public static final ProjectIdentifierResolver INSTANCE = new ProjectIdentifierResolver();
    @NotNull
    private static final String keyPrefix = Intrinsics.stringPlus((String)"key", (Object)":");
    @NotNull
    private static final String idPrefix = Intrinsics.stringPlus((String)"id", (Object)":");

    private ProjectIdentifierResolver() {
    }

    @NotNull
    public final ProjectIdentifier resolve(@NotNull String projectAsString) {
        ProjectIdentifier projectIdentifier2;
        Intrinsics.checkNotNullParameter((Object)projectAsString, (String)"projectAsString");
        if (StringsKt.startsWith((String)projectAsString, (String)keyPrefix, (boolean)true)) {
            String string2 = projectAsString.substring(keyPrefix.length());
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
            projectIdentifier2 = new ProjectIdentifier.Key(string2);
        } else if (StringsKt.startsWith((String)projectAsString, (String)idPrefix, (boolean)true)) {
            String string3 = projectAsString.substring(idPrefix.length());
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).substring(startIndex)");
            projectIdentifier2 = new ProjectIdentifier.Id(string3);
        } else {
            projectIdentifier2 = new ProjectIdentifier.Id(projectAsString);
        }
        return projectIdentifier2;
    }
}

