/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.joda.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.StreamReadCapability;
import com.fasterxml.jackson.core.io.NumberInput;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.datatype.joda.cfg.FormatConfig;
import com.fasterxml.jackson.datatype.joda.cfg.JacksonJodaDateFormat;
import com.fasterxml.jackson.datatype.joda.deser.JodaDateDeserializerBase;
import java.io.IOException;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;

public class DateTimeDeserializer
extends JodaDateDeserializerBase<ReadableInstant> {
    private static final long serialVersionUID = 1L;

    public DateTimeDeserializer(Class<?> cls, JacksonJodaDateFormat format2) {
        super(cls, format2);
    }

    public static <T extends ReadableInstant> JsonDeserializer<T> forType(Class<T> cls) {
        return new DateTimeDeserializer(cls, FormatConfig.DEFAULT_DATETIME_PARSER);
    }

    @Override
    public JodaDateDeserializerBase<?> withFormat(JacksonJodaDateFormat format2) {
        return new DateTimeDeserializer(this._valueClass, format2);
    }

    public ReadableInstant deserialize(JsonParser p2, DeserializationContext ctxt) throws IOException {
        switch (p2.currentTokenId()) {
            case 7: {
                return this._fromTimestamp(ctxt, p2.getLongValue());
            }
            case 6: {
                return this._fromString(p2, ctxt, p2.getText());
            }
            case 1: {
                return this._fromString(p2, ctxt, ctxt.extractScalarFromObject(p2, (JsonDeserializer)this, this.handledType()));
            }
        }
        return (ReadableInstant)this._handleNotNumberOrString(p2, ctxt);
    }

    protected ReadableInstant _fromString(JsonParser p2, DeserializationContext ctxt, String value2) throws IOException {
        if ((value2 = value2.trim()).isEmpty()) {
            return (ReadableInstant)this._fromEmptyString(p2, ctxt, value2);
        }
        int ix = value2.indexOf(91);
        if (ix > 0) {
            DateTimeZone tz;
            int ix2 = value2.lastIndexOf(93);
            String tzId = ix2 < ix ? value2.substring(ix + 1) : value2.substring(ix + 1, ix2);
            try {
                tz = DateTimeZone.forID(tzId);
            }
            catch (IllegalArgumentException e) {
                ctxt.reportInputMismatch(this.handledType(), "Unknown DateTimeZone id '%s'", new Object[]{tzId});
                tz = null;
            }
            value2 = value2.substring(0, ix);
            DateTime result2 = this._format.createParser(ctxt).withZone(tz).parseDateTime(value2);
            if (this._format.shouldAdjustToContextTimeZone(ctxt)) {
                result2 = result2.withZone(this._format.getTimeZone());
            }
            return result2;
        }
        if (ctxt.isEnabled(StreamReadCapability.UNTYPED_SCALARS) && this._isValidTimestampString(value2)) {
            return this._fromTimestamp(ctxt, NumberInput.parseLong((String)value2));
        }
        return this._format.createParser(ctxt).parseDateTime(value2);
    }

    protected DateTime _fromTimestamp(DeserializationContext ctxt, long ts) {
        DateTimeZone tz = this._format.isTimezoneExplicit() ? this._format.getTimeZone() : DateTimeZone.forTimeZone(ctxt.getTimeZone());
        return new DateTime(ts, tz);
    }
}

