/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.space.gateway.rd.list;

import circlet.platform.api.KDateTime;
import circlet.rd.api.IdeType;
import circlet.rd.api.RdWorkspaceState;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.space.SpaceIcons;
import com.intellij.space.gateway.client.data.RdWorkspaceKt;
import com.intellij.space.gateway.messages.SpaceGatewayBundle;
import com.intellij.space.gateway.rd.SpaceGatewayRdUiParams;
import com.intellij.space.gateway.rd.SpaceIdeTypeMapping;
import com.intellij.space.gateway.rd.list.SpaceGatewayRdWorkspaceComponentVm;
import com.intellij.space.gateway.rd.list.SpaceGatewayRdWorkspaceConnectionComponentFactory;
import com.intellij.space.gateway.rd.list.SpaceGatewayWorkspaceComponentFactory;
import com.intellij.space.gateway.rd.list.SpaceGatewayWorkspaceComponentFactory$WhenMappings;
import com.intellij.space.ui.Mouse;
import com.intellij.space.ui.UtilitiesKt;
import com.intellij.space.ui.panel.SpaceComponentWrapper;
import com.intellij.space.utils.DateUtilitiesKt;
import com.intellij.ui.AnimatedIcon;
import com.intellij.ui.components.ActionLink;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.jetbrains.gateway.ssh.IntelliJPlatformProduct;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import libraries.coroutines.extra.Lifetime;
import org.jetbrains.annotations.NotNull;
import runtime.reactive.CellableKt;
import runtime.reactive.MutableProperty;
import runtime.reactive.Property;
import runtime.reactive.XTrackableLifetimed;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001!B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\f\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001e\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002J\u0018\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001c\u0010\u0014\u001a\u00020\u00042\u0012\u0010\u0015\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u00160\u0011H\u0002J\u0018\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001e\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0011H\u0002J\u0011\u0010\u001c\u001a\u00070\u001d\u00a2\u0006\u0002\b\u001e*\u00020\u000eH\u0002J\f\u0010\u001f\u001a\u00020 *\u00020\u0017H\u0002\u00a8\u0006\""}, d2={"Lcom/intellij/space/gateway/rd/list/SpaceGatewayWorkspaceComponentFactory;", "", "()V", "create", "Ljavax/swing/JComponent;", "lifetime", "Llibraries/coroutines/extra/Lifetime;", "workspaceComponentVm", "Lcom/intellij/space/gateway/rd/list/SpaceGatewayRdWorkspaceComponentVm;", "createActionOnHoverComponent", "actionOnHover", "Lcom/intellij/space/gateway/rd/list/SpaceGatewayRdWorkspaceComponentVm$ChangeStateAction;", "createErrorStateComponent", "state", "Lcirclet/rd/api/RdWorkspaceState;", "createIdeIcon", "ide", "Lruntime/reactive/Property;", "Lcirclet/rd/api/IdeType;", "createLeftPartComponent", "createMoreActionsComponent", "additionalActions", "", "Lcom/intellij/space/gateway/rd/list/SpaceGatewayRdWorkspaceComponentVm$AdditionalAction;", "createRightPartComponent", "createRightSideInfoComponent", "createStatusIcon", "status", "getLocalizedText", "", "Lorg/jetbrains/annotations/Nls;", "toAnAction", "Lcom/intellij/openapi/actionSystem/AnAction;", "RdWorkspaceHoverWrapper", "intellij.space.gateway"})
public final class SpaceGatewayWorkspaceComponentFactory {
    @NotNull
    public static final SpaceGatewayWorkspaceComponentFactory INSTANCE;

    @NotNull
    public final JComponent create(@NotNull Lifetime lifetime, @NotNull SpaceGatewayRdWorkspaceComponentVm workspaceComponentVm) {
        RdWorkspaceHoverWrapper rdWorkspaceHoverWrapper;
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)workspaceComponentVm, (String)"workspaceComponentVm");
        NonOpaquePanel contentPanel2 = UtilitiesKt.horizontalPanel$default(15, 0, 2, null);
        JComponent leftPart = this.createLeftPartComponent(lifetime, workspaceComponentVm);
        JComponent rightPart = this.createRightPartComponent(lifetime, workspaceComponentVm);
        contentPanel2.add((Component)leftPart, (Object)"LEFT");
        contentPanel2.add((Component)rightPart, (Object)"RIGHT");
        MutableProperty<Boolean> isHovered = workspaceComponentVm.isHovered();
        RdWorkspaceHoverWrapper $this$apply = rdWorkspaceHoverWrapper = new RdWorkspaceHoverWrapper((JComponent)contentPanel2, (Property<Boolean>)isHovered);
        boolean bl = false;
        Mouse.INSTANCE.addMouseHoveringListener((JComponent)((Object)$this$apply), (Function1<? super Boolean, Unit>)((Function1)new Function1<Boolean, Unit>(isHovered, lifetime){
            final /* synthetic */ MutableProperty $isHovered$inlined;
            final /* synthetic */ Lifetime $lifetime$inlined;
            {
                this.$isHovered$inlined = mutableProperty2;
                this.$lifetime$inlined = lifetime;
                super(1);
            }

            public final void invoke(boolean it) {
                this.$isHovered$inlined.setValue(it);
            }
        }));
        isHovered.forEach(lifetime, (Function1<Boolean, Unit>)((Function1)new Function1<Boolean, Unit>($this$apply){
            final /* synthetic */ RdWorkspaceHoverWrapper $this_apply;

            public final void invoke(boolean it) {
                this.$this_apply.repaint();
            }
            {
                this.$this_apply = rdWorkspaceHoverWrapper;
                super(1);
            }
        }));
        return (JComponent)((Object)rdWorkspaceHoverWrapper);
    }

    private final JComponent createLeftPartComponent(Lifetime lifetime, SpaceGatewayRdWorkspaceComponentVm workspaceComponentVm) {
        NonOpaquePanel nonOpaquePanel;
        NonOpaquePanel component2 = UtilitiesKt.horizontalPanel$default(5, 0, 2, null);
        JComponent statusIcon = this.createStatusIcon(lifetime, workspaceComponentVm.getState());
        JComponent ideIcon = this.createIdeIcon(lifetime, workspaceComponentVm.getIde());
        JComponent connectionComponent = SpaceGatewayRdWorkspaceConnectionComponentFactory.INSTANCE.create(lifetime, workspaceComponentVm.getConnectVm());
        NonOpaquePanel $this$apply = nonOpaquePanel = component2;
        boolean bl = false;
        $this$apply.add((Component)statusIcon);
        $this$apply.add((Component)ideIcon);
        $this$apply.add((Component)connectionComponent);
        return (JComponent)nonOpaquePanel;
    }

    private final JComponent createIdeIcon(Lifetime lifetime, Property<IdeType> ide2) {
        JLabel ideIconLabel = new JLabel();
        ide2.forEach(lifetime, (Function1<IdeType, Unit>)((Function1)new Function1<IdeType, Unit>(ideIconLabel){
            final /* synthetic */ JLabel $ideIconLabel;

            public final void invoke(@NotNull IdeType ideType) {
                Intrinsics.checkNotNullParameter((Object)ideType, (String)"ideType");
                IntelliJPlatformProduct mappedIdeType = SpaceIdeTypeMapping.Companion.getPlatformProduct(ideType);
                Object object = mappedIdeType;
                if (object == null || (object = object.getIcon()) == null) {
                    object = EmptyIcon.ICON_16;
                }
                Object productIcon = object;
                this.$ideIconLabel.setIcon((Icon)productIcon);
            }
            {
                this.$ideIconLabel = jLabel;
                super(1);
            }
        }));
        return ideIconLabel;
    }

    private final JComponent createStatusIcon(Lifetime lifetime, Property<? extends RdWorkspaceState> status2) {
        JLabel statusIconLabel = new JLabel();
        status2.forEach(lifetime, (Function1<? extends RdWorkspaceState, Unit>)((Function1)new Function1<RdWorkspaceState, Unit>(statusIconLabel){
            final /* synthetic */ JLabel $statusIconLabel;

            public final void invoke(@NotNull RdWorkspaceState it) {
                Icon icon2;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                switch (SpaceGatewayWorkspaceComponentFactory$WhenMappings.$EnumSwitchMapping$0[it.ordinal()]) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        icon2 = (Icon)AnimatedIcon.Default.INSTANCE;
                        break;
                    }
                    case 8: {
                        icon2 = SpaceIcons.Active;
                        break;
                    }
                    case 9: {
                        icon2 = SpaceIcons.Hibernated;
                        break;
                    }
                    case 10: 
                    case 11: 
                    case 12: {
                        icon2 = SpaceIcons.Error;
                        break;
                    }
                    case 13: {
                        icon2 = (Icon)AnimatedIcon.Default.INSTANCE;
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                this.$statusIconLabel.setIcon(icon2);
            }
            {
                this.$statusIconLabel = jLabel;
                super(1);
            }
        }));
        return statusIconLabel;
    }

    private final JComponent createRightPartComponent(Lifetime lifetime, SpaceGatewayRdWorkspaceComponentVm workspaceComponentVm) {
        NonOpaquePanel nonOpaquePanel;
        NonOpaquePanel component2 = UtilitiesKt.horizontalPanel$default(5, 0, 2, null);
        JComponent updatedLabel = this.createRightSideInfoComponent(lifetime, workspaceComponentVm);
        JComponent moreActionsComponent = this.createMoreActionsComponent(workspaceComponentVm.getAdditionalActions());
        NonOpaquePanel $this$apply = nonOpaquePanel = component2;
        boolean bl = false;
        $this$apply.add((Component)updatedLabel);
        $this$apply.add((Component)moreActionsComponent);
        return (JComponent)nonOpaquePanel;
    }

    private final JComponent createMoreActionsComponent(Property<? extends List<SpaceGatewayRdWorkspaceComponentVm.AdditionalAction>> additionalActions) {
        SpaceComponentWrapper spaceComponentWrapper;
        SpaceComponentWrapper buttonWrapper = new SpaceComponentWrapper(null, null, 3, null);
        Icon icon2 = AllIcons.Actions.More;
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"AllIcons.Actions.More");
        Icon moreIcon = icon2;
        AnAction moreAction2 = new AnAction(additionalActions, buttonWrapper, moreIcon, moreIcon){
            final /* synthetic */ Property $additionalActions;
            final /* synthetic */ SpaceComponentWrapper $buttonWrapper;
            final /* synthetic */ Icon $moreIcon;

            /*
             * WARNING - void declaration
             */
            public void actionPerformed(@NotNull AnActionEvent e) {
                Collection<AnAction> collection;
                void $this$mapTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Iterable $this$map$iv = (Iterable)this.$additionalActions.getValue();
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    SpaceGatewayRdWorkspaceComponentVm.AdditionalAction additionalAction = (SpaceGatewayRdWorkspaceComponentVm.AdditionalAction)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    AnAction anAction = SpaceGatewayWorkspaceComponentFactory.access$toAnAction(SpaceGatewayWorkspaceComponentFactory.INSTANCE, (SpaceGatewayRdWorkspaceComponentVm.AdditionalAction)it);
                    collection.add(anAction);
                }
                collection = (List)destination$iv$iv;
                List list2 = collection;
                DefaultActionGroup group = new DefaultActionGroup(list2);
                DataContext dataContext = DataManager.getInstance().getDataContext((Component)((Object)this.$buttonWrapper));
                Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"DataManager.getInstance(\u2026ataContext(buttonWrapper)");
                DataContext dataContext2 = dataContext;
                JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)group, dataContext2, JBPopupFactory.ActionSelectionAid.MNEMONICS, false).showUnderneathOf((Component)((Object)this.$buttonWrapper));
            }
            {
                this.$additionalActions = $captured_local_variable$0;
                this.$buttonWrapper = $captured_local_variable$1;
                this.$moreIcon = $captured_local_variable$2;
                super($super_call_param$3);
            }
        };
        ActionButton moreActionButton = new ActionButton(moreAction2, moreAction2.getTemplatePresentation(), "unknown", ActionToolbar.NAVBAR_MINIMUM_BUTTON_SIZE);
        SpaceComponentWrapper $this$apply = spaceComponentWrapper = buttonWrapper;
        boolean bl = false;
        $this$apply.setContent((JComponent)moreActionButton);
        return (JComponent)((Object)spaceComponentWrapper);
    }

    private final AnAction toAnAction(SpaceGatewayRdWorkspaceComponentVm.AdditionalAction $this$toAnAction) {
        return new AnAction($this$toAnAction, $this$toAnAction.getName()){
            final /* synthetic */ SpaceGatewayRdWorkspaceComponentVm.AdditionalAction $this_toAnAction;

            public void actionPerformed(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$this_toAnAction.getAction().invoke();
            }
            {
                this.$this_toAnAction = $receiver;
                super($super_call_param$1);
            }
        };
    }

    private final String getLocalizedText(RdWorkspaceState $this$getLocalizedText) {
        return RdWorkspaceKt.convertToWorkspaceStatus($this$getLocalizedText.name()).getVisibleString();
    }

    private final JComponent createErrorStateComponent(SpaceGatewayRdWorkspaceComponentVm workspaceComponentVm, RdWorkspaceState state2) {
        ActionLink actionLink2;
        JLabel jLabel;
        NonOpaquePanel contentPanel2 = UtilitiesKt.horizontalPanel$default(5, 0, 2, null);
        JLabel $this$apply = jLabel = new JLabel(this.getLocalizedText(state2));
        boolean bl = false;
        $this$apply.setForeground(UIUtil.getErrorForeground());
        $this$apply.setFont((Font)JBFont.small());
        JLabel errorLabel = jLabel;
        String string2 = SpaceGatewayBundle.message("rd.list.failed.learn.why", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"SpaceGatewayBundle.messa\u2026d.list.failed.learn.why\")");
        ActionLink $this$apply2 = actionLink2 = new ActionLink(string2, (Function1)new Function1<ActionEvent, Unit>(workspaceComponentVm){
            final /* synthetic */ SpaceGatewayRdWorkspaceComponentVm $workspaceComponentVm;

            public final void invoke(@NotNull ActionEvent $noName_0) {
                Intrinsics.checkNotNullParameter((Object)$noName_0, (String)"<anonymous parameter 0>");
                this.$workspaceComponentVm.openInWeb();
            }
            {
                this.$workspaceComponentVm = spaceGatewayRdWorkspaceComponentVm;
                super(1);
            }
        });
        boolean bl2 = false;
        $this$apply2.setFont((Font)JBFont.small());
        ActionLink learnWhyLink2 = actionLink2;
        contentPanel2.add((Component)errorLabel);
        contentPanel2.add((Component)learnWhyLink2);
        return (JComponent)contentPanel2;
    }

    private final JComponent createActionOnHoverComponent(SpaceGatewayRdWorkspaceComponentVm.ChangeStateAction actionOnHover) {
        ActionLink actionLink2;
        ActionLink $this$apply = actionLink2 = new ActionLink(actionOnHover.getName(), (Function1)new Function1<ActionEvent, Unit>(actionOnHover){
            final /* synthetic */ SpaceGatewayRdWorkspaceComponentVm.ChangeStateAction $actionOnHover;

            public final void invoke(@NotNull ActionEvent $noName_0) {
                Intrinsics.checkNotNullParameter((Object)$noName_0, (String)"<anonymous parameter 0>");
                this.$actionOnHover.getAction().invoke();
            }
            {
                this.$actionOnHover = changeStateAction2;
                super(1);
            }
        });
        boolean bl = false;
        $this$apply.setFont((Font)JBFont.small());
        ActionLink actionLink3 = actionLink2;
        return (JComponent)actionLink3;
    }

    private final JComponent createRightSideInfoComponent(Lifetime lifetime, SpaceGatewayRdWorkspaceComponentVm workspaceComponentVm) {
        SpaceComponentWrapper wrapper = new SpaceComponentWrapper(null, null, 3, null);
        Property x2 = CellableKt.derived$default(lifetime, false, (Function1)new Function1<XTrackableLifetimed, Unit>(workspaceComponentVm, wrapper){
            final /* synthetic */ SpaceGatewayRdWorkspaceComponentVm $workspaceComponentVm;
            final /* synthetic */ SpaceComponentWrapper $wrapper;

            public final void invoke(@NotNull XTrackableLifetimed $this$derived) {
                JLabel jLabel;
                Intrinsics.checkNotNullParameter((Object)$this$derived, (String)"$receiver");
                RdWorkspaceState errorState2 = $this$derived.getLive(this.$workspaceComponentVm.getErrorState());
                if (errorState2 != null) {
                    this.$wrapper.setContent(SpaceGatewayWorkspaceComponentFactory.access$createErrorStateComponent(SpaceGatewayWorkspaceComponentFactory.INSTANCE, this.$workspaceComponentVm, errorState2));
                    return;
                }
                boolean isHovered = (Boolean)$this$derived.getLive((Property)this.$workspaceComponentVm.isHovered());
                SpaceGatewayRdWorkspaceComponentVm.ChangeStateAction actionOnHover = $this$derived.getLive(this.$workspaceComponentVm.getChangeStateAction());
                if (isHovered && actionOnHover != null) {
                    this.$wrapper.setContent(SpaceGatewayWorkspaceComponentFactory.access$createActionOnHoverComponent(SpaceGatewayWorkspaceComponentFactory.INSTANCE, actionOnHover));
                    return;
                }
                RdWorkspaceState state2 = $this$derived.getLive(this.$workspaceComponentVm.getState());
                JLabel $this$apply = jLabel = new JLabel();
                boolean bl = false;
                $this$apply.setForeground(UIUtil.getContextHelpForeground());
                $this$apply.setFont((Font)JBFont.small());
                JLabel statusLabel = jLabel;
                this.$wrapper.setContent(statusLabel);
                switch (SpaceGatewayWorkspaceComponentFactory$WhenMappings.$EnumSwitchMapping$1[state2.ordinal()]) {
                    case 1: 
                    case 2: {
                        KDateTime updatedTime = $this$derived.getLive(this.$workspaceComponentVm.getUpdated());
                        statusLabel.setText(SpaceGatewayBundle.message("rd.list.workspace.updated.text", DateUtilitiesKt.formatPrettyDateTime(updatedTime)));
                        break;
                    }
                    default: {
                        statusLabel.setText(SpaceGatewayWorkspaceComponentFactory.access$getLocalizedText(SpaceGatewayWorkspaceComponentFactory.INSTANCE, state2));
                    }
                }
            }
            {
                this.$workspaceComponentVm = spaceGatewayRdWorkspaceComponentVm;
                this.$wrapper = spaceComponentWrapper;
                super(1);
            }
        }, 1, null);
        x2.forEach(lifetime, createRightSideInfoComponent.1.INSTANCE);
        return (JComponent)((Object)wrapper);
    }

    private SpaceGatewayWorkspaceComponentFactory() {
    }

    static {
        SpaceGatewayWorkspaceComponentFactory spaceGatewayWorkspaceComponentFactory;
        INSTANCE = spaceGatewayWorkspaceComponentFactory = new SpaceGatewayWorkspaceComponentFactory();
    }

    public static final /* synthetic */ AnAction access$toAnAction(SpaceGatewayWorkspaceComponentFactory $this, SpaceGatewayRdWorkspaceComponentVm.AdditionalAction $this$access_u24toAnAction) {
        return $this.toAnAction($this$access_u24toAnAction);
    }

    public static final /* synthetic */ JComponent access$createErrorStateComponent(SpaceGatewayWorkspaceComponentFactory $this, SpaceGatewayRdWorkspaceComponentVm workspaceComponentVm, RdWorkspaceState state2) {
        return $this.createErrorStateComponent(workspaceComponentVm, state2);
    }

    public static final /* synthetic */ JComponent access$createActionOnHoverComponent(SpaceGatewayWorkspaceComponentFactory $this, SpaceGatewayRdWorkspaceComponentVm.ChangeStateAction actionOnHover) {
        return $this.createActionOnHoverComponent(actionOnHover);
    }

    public static final /* synthetic */ String access$getLocalizedText(SpaceGatewayWorkspaceComponentFactory $this, RdWorkspaceState $this$access_u24getLocalizedText) {
        return $this.getLocalizedText($this$access_u24getLocalizedText);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014R\u0014\u0010\b\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000bR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/space/gateway/rd/list/SpaceGatewayWorkspaceComponentFactory$RdWorkspaceHoverWrapper;", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "rdWorkspaceComponent", "Ljavax/swing/JComponent;", "isHovered", "Lruntime/reactive/Property;", "", "(Ljavax/swing/JComponent;Lruntime/reactive/Property;)V", "backgroundColor", "Ljava/awt/Color;", "getBackgroundColor", "()Ljava/awt/Color;", "hoverColor", "getHoverColor", "paintComponent", "", "g", "Ljava/awt/Graphics;", "intellij.space.gateway"})
    private static final class RdWorkspaceHoverWrapper
    extends BorderLayoutPanel {
        private final Property<Boolean> isHovered;

        private final Color getBackgroundColor() {
            return SpaceGatewayRdUiParams.Colors.INSTANCE.getBackgroundColor();
        }

        private final Color getHoverColor() {
            return SpaceGatewayRdUiParams.Colors.INSTANCE.getListHoverBackground();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void paintComponent(@NotNull Graphics g) {
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            super.paintComponent(g);
            Graphics graphics = ((Graphics2D)g).create();
            if (graphics == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.awt.Graphics2D");
            }
            Graphics2D g2 = (Graphics2D)graphics;
            try {
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                Color color = this.isHovered.getValue() != false ? this.getHoverColor() : this.getBackgroundColor();
                g2.setColor(color);
                int arcSize = 8;
                g2.fillRoundRect(0, 0, this.getWidth(), this.getHeight(), arcSize, arcSize);
            }
            finally {
                g2.dispose();
            }
        }

        public RdWorkspaceHoverWrapper(@NotNull JComponent rdWorkspaceComponent, @NotNull Property<Boolean> isHovered) {
            Intrinsics.checkNotNullParameter((Object)rdWorkspaceComponent, (String)"rdWorkspaceComponent");
            Intrinsics.checkNotNullParameter(isHovered, (String)"isHovered");
            this.isHovered = isHovered;
            this.setOpaque(true);
            this.setBackground(this.getBackgroundColor());
            this.setBorder((Border)JBUI.Borders.empty((int)5, (int)2));
            this.addToCenter(rdWorkspaceComponent);
            this.addPropertyChangeListener("UI", new PropertyChangeListener(){

                @Override
                public final void propertyChange(PropertyChangeEvent it) {
                    this.setBackground(this.getBackgroundColor());
                }
            });
        }
    }
}

